#include "StdAfx.h"
#include <params/MParameterFactory.h>

#include <params/MVector3KeyParameter.h>
#include <params/MFloatKeyParameter.h>

namespace Aztec {

  MBooleanParameterPtr MParameterFactory::createBoolean(
    const MStr &shortName, 
    const MStr &longName, 
    const MStr &friendlyName,
    bool inputParameter) 
  {
    MBooleanParameterImpl *param = new MBooleanParameterImpl(shortName, longName, friendlyName);
    param->setInputParameter(inputParameter);
    return param;
  }

  MChoiceParameterPtr MParameterFactory::createChoice(
    const MStr &shortName, 
    const MStr &longName, 
    const MStr &friendlyName,
    bool inputParameter) 
  {
    MChoiceParameterImpl *param = new MChoiceParameterImpl(shortName, longName, friendlyName);
    param->setInputParameter(inputParameter);
    return param;
  }

  MVector3ParameterPtr MParameterFactory::createColour(
    const MStr &shortName, 
    const MStr &longName, 
    const MStr &friendlyName,
    bool inputParameter) 
  {
    MVector3KeyParameterImpl *param = new MVector3KeyParameterImpl(shortName, longName, friendlyName, MParameterObject::MEANING_COLOUR);
    param->setInputParameter(inputParameter);
    return param;
  }

  MStringParameterPtr MParameterFactory::createFilename(
    const MStr &shortName, 
    const MStr &longName, 
    const MStr &friendlyName,
    bool inputParameter) 
  {
    MStringParameterImpl *param = new MStringParameterImpl(shortName, longName, friendlyName, MParameterObject::MEANING_FILENAME);
    param->setInputParameter(inputParameter);
    return param;
  }

  MFloatKeyParameterPtr MParameterFactory::createFloat(
    const MStr &shortName, 
    const MStr &longName, 
    const MStr &friendlyName,
    bool inputParameter) 
  {
    MFloatKeyParameterImpl *param = new MFloatKeyParameterImpl(shortName, longName, friendlyName);
    param->setInputParameter(inputParameter);
    return param;
  }

  MStringParameterPtr MParameterFactory::createImageFilename(
    const MStr &shortName, 
    const MStr &longName, 
    const MStr &friendlyName,
    bool inputParameter) 
  {
    MStringParameterImpl *param = new MStringParameterImpl(shortName, longName, friendlyName, MParameterObject::MEANING_IMAGE_FILENAME);
    param->setInputParameter(inputParameter);
    return param;
  }

  MIntParameterPtr MParameterFactory::createInteger(
    const MStr &shortName, 
    const MStr &longName, 
    const MStr &friendlyName,
    bool inputParameter) 
  {
    MIntParameterImpl *param = new MIntParameterImpl(shortName, longName, friendlyName);
    param->setInputParameter(inputParameter);
    return param;
  }

  MObjectParameterPtr MParameterFactory::createObject(
    const MStr &shortName, 
    const MStr &longName, 
    const MStr &friendlyName, 
    bool inputParameter) 
  {
    MRefCountedPtr<MObjectParameterImpl> param = new MObjectParameterImpl(shortName, longName, friendlyName);

    // we have to do the nasty cast here to stop the compiler getting confused about which overload to call.
    ((MParameterObjectImpl*)&*param)->setInputParameter(inputParameter);
    return param;
  }

  MObjectListParameterPtr MParameterFactory::createObjectList(
    const MStr &shortName, 
    const MStr &longName, 
    const MStr &friendlyName,
    bool inputParameter) 
  {
    MObjectListParameterImpl *param = new MObjectListParameterImpl(shortName, longName, friendlyName);
    param->setInputParameter(inputParameter);
    return param;
  }

  MStringParameterPtr MParameterFactory::createString(
    const MStr &shortName, 
    const MStr &longName, 
    const MStr &friendlyName,
    bool inputParameter) 
  {
    MStringParameterImpl *param = new MStringParameterImpl(shortName, longName, friendlyName);
    param->setInputParameter(inputParameter);
    return param;
  }

  MVector3ParameterPtr MParameterFactory::createVector3(
    const MStr &shortName, 
    const MStr &longName, 
    const MStr &friendlyName,
    bool inputParameter) 
  {
    MVector3KeyParameterImpl *param = new MVector3KeyParameterImpl(shortName, longName, friendlyName);
    param->setInputParameter(inputParameter);
    return param;
  }

  MVector3ParameterPtr MParameterFactory::createStaticVector3(
    const MStr &shortName, 
    const MStr &longName, 
    const MStr &friendlyName, 
    bool inputParameter)
  {
    MVector3ParameterImpl *param = new MVector3ParameterImpl(shortName, longName, friendlyName);
    param->setInputParameter(inputParameter);
    return param;
  }
  MMatrix4ParameterPtr MParameterFactory::createMatrix(
    const MStr &shortName, 
    const MStr &longName, 
    const MStr &friendlyName, 
    bool inputParameter)
  {
    MMatrix4ParameterImpl *param = new MMatrix4ParameterImpl(shortName, longName, friendlyName);
    param->setInputParameter(inputParameter);
    return param;
  }


}

