#include "StdAfx.h"

#include "params/MParentObjectParameter.h"
#include "MSystemManager.h"
#include "MDAGraph.h"

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

  //-------------------------
  //  MParentObjectParameter
  //-------------------------
  MParentObjectParameter::MParentObjectParameter( 
        MSceneObject *owner,
        const MStr &shortName, 
        const MStr &longName, 
        const MStr &friendlyName) 
    : MObjectParameterImpl(shortName, longName, friendlyName) 
  {
    thisSceneObject = owner;
  }

  MParentObjectParameter::~MParentObjectParameter() {
  }

  void MParentObjectParameter::setValue(MNamedObjectPtr value) {
    MObjectParameterImpl::setValue(value);

    updateParentInfo();
  }

  MNamedObjectPtr MParentObjectParameter::getValue() {
    if (m_Object != NULL || m_ObjectName.GetLength() == 0) {
      updateObject();
      if (m_Object != NULL) {
        m_Object->updateObject();
      }
      updateParentInfo();
      return m_Object;
    }

    m_Object = AZTEC_CAST(MNamedObject, MSystemManager::getInstance()->getScene()->getObjectList()->findObject(m_ObjectName));
    updateParentInfo();

    connectParameter();

    return m_Object;
  }

  bool MParentObjectParameter::isInputParameter() {
    return true;
  }

  bool MParentObjectParameter::createKeyAt(long time) {
    return false;
  }

  bool MParentObjectParameter::setFromParameter(MParameterObjectPtr src) {
    MObjectParameterImpl::setFromParameter(src);

    MParentObjectParameterPtr param = AZTEC_CAST(MParentObjectParameter, src);

    if (param == NULL) {
      return false;
    }

    disconnectParameter();
    m_Object = param->m_Object;
    m_ObjectName = param->m_ObjectName;

    updateParentInfo();

    // do a get value to force it to search for the object.
    getValue();
    
    return true;
  }

  MParameterObjectPtr MParentObjectParameter::createCopy() {
    // now we only create a MObjectParameter here because we want
    // to store an in memory copy, not an actual ParentObjectParameter.
    // If we did use a ParentObjectPArameter, it would attempt to calculate
    // the parent information each time, which is not something we want.
    return new MObjectParameterImpl(getShortName(), getLongName(), getFriendlyName());
  }

  void MParentObjectParameter::updateParentInfo() {
    MScenePtr scene = MSystemManager::getInstance()->getScene();
    MBaseObjectTreePtr tree = scene->getObjectList();
    MTreeObjectNodePtr child;
    MTreeObjectNodePtr parent;

    child = tree->findObject(thisSceneObject);
    parent = tree->findObject(m_Object);
    tree->setParent(child, parent);
  }

}
