#include "StdAfx.h"

#include <stdlib.h>
#include "scripting/ScriptFuncs.h"

#ifndef WIN32
  #include <strings.h>
  #define stricmp strcasecmp
#endif

#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

namespace Aztec {

// Given a jsval, turn it into a double.  Basic types are promoted and
// strings are run through atof().  Objects are not valid and false
// will be returned.
bool
getDoubleVal(JSContext *cx, jsval v, double &t)
{
	if (JSVAL_IS_INT(v)) {
		t = (double)JSVAL_TO_INT(v);
	} else if (JSVAL_IS_DOUBLE(v)) {
		t = *JSVAL_TO_DOUBLE(v);
	} else if (JSVAL_IS_BOOLEAN(v)) {
		t = (JSVAL_TO_BOOLEAN(v) ? 1.0f : 0.0f);
	} else if (JSVAL_IS_STRING(v)) {
		char *valStr = JS_GetStringBytes(JS_ValueToString(cx, v));
		t = atof(valStr);
	} else {
		return false;
	}

	return true;
}

// Given a jsval, turn it into a double.  Basic types are promoted and
// strings are run through atof().  Objects are not valid and false
// will be returned.
bool
getIntegerVal(JSContext *cx, jsval v, int &t)
{
	if (JSVAL_IS_INT(v)) {
		t = JSVAL_TO_INT(v);
	} else if (JSVAL_IS_DOUBLE(v)) {
		t = (int)(*JSVAL_TO_DOUBLE(v));
	} else if (JSVAL_IS_BOOLEAN(v)) {
		t = (JSVAL_TO_BOOLEAN(v) ? 1 : 0);
	} else if (JSVAL_IS_STRING(v)) {
		char *valStr = JS_GetStringBytes(JS_ValueToString(cx, v));
		t = atoi(valStr);
	} else {
		return false;
	}

	return true;
}

// Given a jsval, turn it into a double.  Basic types are promoted and
// strings are run through atof().  Objects are not valid and false
// will be returned.
bool
getBooleanVal(JSContext *cx, jsval v, bool &t)
{
	if (JSVAL_IS_INT(v)) {
		t = (JSVAL_TO_INT(v) != 0 ? true : false);
	} else if (JSVAL_IS_DOUBLE(v)) {
		t = ((int)(*JSVAL_TO_DOUBLE(v)) != 0 ? true : false);
	} else if (JSVAL_IS_BOOLEAN(v)) {
		t = (JSVAL_TO_BOOLEAN(v) ? true : false);
	} else if (JSVAL_IS_STRING(v)) {
		char *valStr = JS_GetStringBytes(JS_ValueToString(cx, v));
		if (!stricmp(valStr, "true")) return true;
		if (!stricmp(valStr, "false")) return false;
		// Not a known boolean string - treat it as a number...
		int i = atoi(valStr);
		t = (i != 0 ? true : false);
	} else {
		return false;
	}

	return true;
}

}
