#ifndef MParameterGroup_Header
#define MParameterGroup_Header

namespace AztecGUI {

  class MParameterGroup : public CWnd
  {
  public:

    MParameterGroup(const std::string &groupName);
	  ~MParameterGroup();

    void addParameter(const Aztec::MParameterObjectPtr &param);
    int getPreferredHeight();
    const std::string& getName();

    /**
     * This sets the values of the parameters from what is currently in each 
     * of the controls. If the index is specified, we only update that 
     * parameter. If the index is -1, we update all the parameters.
     *
     * @param index The index of the parameter to update, or we update all 
     *              the parameters if the index is -1.
     */
    void setParameterValues(int index = -1);

  // Overrides
	  // ClassWizard generated virtual function overrides
	  //{{AFX_VIRTUAL(CTimeScroller)
	  protected:
//	  virtual LRESULT WindowProc(UINT message, WPARAM wParam, LPARAM lParam);
//    virtual BOOL OnCommand( WPARAM wParam, LPARAM lParam );
	  //}}AFX_VIRTUAL

	  // Generated message map functions
  protected:
    class ParameterGUI : public Aztec::MRefCountedObject {
    public:
      ParameterGUI(const Aztec::MParameterObjectPtr &param, CWnd *wndParent);
      ~ParameterGUI();

      void moveTo(int X, int Y);
      int getPreferredHeight();

      DWORD getUniqueID();

      const Aztec::MParameterObjectPtr& getParameter();
      virtual void setParameterFromControl();

    private:
      static CWnd* createControlFor(const Aztec::MParameterObjectPtr &param, CWnd *parent, DWORD id);

      Aztec::MParameterObjectPtr parameter;
      CWnd *parent;
      CWnd *label;
      CWnd *editor;

      static DWORD uniqueID;
    };

    typedef Aztec::MRefCountedPtr<ParameterGUI> ParameterGUIPtr;
    typedef std::vector<ParameterGUIPtr> ParamList;

    std::string name;
    ParamList parameters;

    int lastYPos;

	  //{{AFX_MSG(CTimeScroller)
	  afx_msg void OnPaint();
    afx_msg void OnSize( UINT nType, int cx, int cy );
    afx_msg void OnDestroy();
	  afx_msg LRESULT OnPopupMenu(WPARAM wParam, LPARAM lParam);
	  //}}AFX_MSG
	  DECLARE_MESSAGE_MAP()
  };

}

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_TIMESCROLLER_H__2C259AD6_11AE_11D3_8452_0040332C7B2F__INCLUDED_)
