#ifndef PROGSET_H
#define PROGSET_H

#include "MStr.h"
#include "MdlConst.h"

#include "inifile.h"

//----------------------------------------------------------------------------------------
//  MProgramSettings
//----------------------------------------------------------------------------------------
class MProgramSettings
{
protected:
	CIniFile iniFile;
public:
   MStr m_EXEPath, m_CFGFile, m_KEYFile, m_PrefsPath;
   MShiftState    m_PanOrbitKey, m_PanTrackKey, m_PanZoomKey, m_ManipGrabKey, m_SelectKey, m_ContextKey;
   

   MProgramSettings();
   ~MProgramSettings();

   void LoadDefaults();
   int SaveToRegistry(char *RegPath);
   int LoadFromRegistry(char *RegPath);

   MParameterObjectPtr GetToolParameter(const MStr &ToolName, const MStr &ParamName);

   int SetToolParameter(const MStr &ToolName, const MStr &ParamName, const MStr &Value);
   int SetToolParameters(const MStr &ToolName, const MStr *ParamName, const MStr *Value, int NumParams);

   int ShowToolParameterEditWindow(const MStr &ToolName);
};


#endif