// TopToolDlg.cpp : implementation file
//

#include <AztecMainPCH.h>
#include "resource.h"
#include "TopToolDlg.h"

#include "MDlGlobs.h"

#include "KeyFuncGeneral.h"

#include "MUIManager.h"
#include "DlgGlobs.h"
#include "MdlMsgs.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//----------------------------------------------------------------------------------------
//  CTopToolDlg
//----------------------------------------------------------------------------------------

CTopToolDlg::CTopToolDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTopToolDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTopToolDlg)
	//}}AFX_DATA_INIT
}

class CompModeListener : public MListener {
public:
  CompModeListener( CImageButton *objBut, 
                    CImageButton *pointBut, 
                    CImageButton *faceBut, 
                    CImageButton *edgeBut ) {
    m_ObjBut = objBut;
    m_PointBut = pointBut;
    m_FaceBut = faceBut;
    m_EdgeBut = edgeBut;
  }

  void onListen() {
    bool check[4] = {false,false,false,false};
    if (MUIManager::getComponentMode() == MComponentisedObject::OBJECT_TYPE) {
      check[0] = true;
    } else if (MUIManager::getComponentMode() == MComponentisedObject::POINT_TYPE) {
      check[1] = true;
    } else if (MUIManager::getComponentMode() == MComponentisedObject::FACET_TYPE) {
      check[2] = true;
    } else if (MUIManager::getComponentMode() == MComponentisedObject::EDGE_TYPE) {
      check[3] = true;
    }
    m_ObjBut->setChecked(check[0]);
    m_PointBut->setChecked(check[1]);
    m_FaceBut->setChecked(check[2]);
    m_EdgeBut->setChecked(check[3]);
  }


protected:
  CImageButton *m_ObjBut;
  CImageButton *m_PointBut;
  CImageButton *m_FaceBut;
  CImageButton *m_EdgeBut;
};

class SeparateAxisListener : public MListener {
public:
  SeparateAxisListener( CImageButton *but ) {
    m_But = but;
  }

  void onListen() {
    if (MUIManager::getSeparateAxisMode()) {
      m_But->SetImage(g_ProgSet.m_PrefsPath + "Buttons\\SeparateAxisOn.bmp");
    } else {
      m_But->SetImage(g_ProgSet.m_PrefsPath + "Buttons\\SeparateAxisOff.bmp");
    }
  }

protected:
  CImageButton *m_But;
};

void CTopToolDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTopToolDlg)
	DDX_Control(pDX, IDC_AXISCOMBO, m_AxisCombo);
	DDX_Control(pDX, IDC_LASTTOOLBUT, m_LastToolBut);
	DDX_Control(pDX, IDC_TABCTRL, m_TabCtrl);
	DDX_Control(pDX, IDC_ROTATETOOLBUT, m_RotateBut);
	DDX_Control(pDX, IDC_MOVETOOLBUT, m_MoveBut);
	DDX_Control(pDX, IDC_SCALETOOLBUT, m_ScaleBut);
	DDX_Control(pDX, IDC_SELECTTOOLBUT, m_SelectBut);
	DDX_Control(pDX, IDC_OBJECTMODEBUT, m_ObjectModeBut);
	DDX_Control(pDX, IDC_POINTMODEBUT, m_PointModeBut);
	DDX_Control(pDX, IDC_FACEMODEBUT, m_FaceModeBut);
	DDX_Control(pDX, IDC_EDGEMODEBUT, m_EdgeModeBut);
	DDX_Control(pDX, IDC_SEPARATEAXISBUT, m_SeparateAxisBut);

	//}}AFX_DATA_MAP

   m_SelectBut.SetImage(g_ProgSet.m_PrefsPath + "Buttons\\Select.bmp");
   m_MoveBut.SetImage(g_ProgSet.m_PrefsPath + "Buttons\\Move.bmp");
   m_RotateBut.SetImage(g_ProgSet.m_PrefsPath + "Buttons\\Rotate.bmp");
   m_ScaleBut.SetImage(g_ProgSet.m_PrefsPath + "Buttons\\Scale.bmp");

   m_SelectBut.SetActionName("KToolSelect");
   m_MoveBut.SetActionName("KToolMove");
   m_RotateBut.SetActionName("KToolRotate");
   m_ScaleBut.SetActionName("KToolScale");

   m_ObjectModeBut.SetImage(g_ProgSet.m_PrefsPath + "Buttons\\KModeObject_16.bmp");
   m_PointModeBut.SetImage(g_ProgSet.m_PrefsPath + "Buttons\\KModePoint_16.bmp");
   m_FaceModeBut.SetImage(g_ProgSet.m_PrefsPath + "Buttons\\KModeFace_16.bmp");
   m_EdgeModeBut.SetImage(g_ProgSet.m_PrefsPath + "Buttons\\KModeEdge_16.bmp");
   m_SeparateAxisBut.SetImage(g_ProgSet.m_PrefsPath + "Buttons\\SeparateAxisOff.bmp");

   m_ObjectModeBut.SetActionName("KModeObject");
   m_PointModeBut.SetActionName("KModePoint");
   m_FaceModeBut.SetActionName("KModeFace");
   m_EdgeModeBut.SetActionName("KModeEdge");
   m_SeparateAxisBut.SetActionName("separateAxisModeToggle");


   m_ObjectModeBut.setLeft(5);
   m_PointModeBut.setLeft(m_ObjectModeBut.getLeft() + m_ObjectModeBut.getWidth() + 2);
   m_FaceModeBut.setLeft(m_PointModeBut.getLeft() + m_PointModeBut.getWidth() + 2);
   m_EdgeModeBut.setLeft(m_FaceModeBut.getLeft() + m_FaceModeBut.getWidth() + 2);


   RECT rect;
   m_AxisCombo.GetWindowRect(&rect);
   ScreenToClient(&rect);
   m_AxisCombo.SetWindowPos(NULL, m_EdgeModeBut.getLeft() + m_EdgeModeBut.getWidth() + 8, rect.top, -1, -1, SWP_NOZORDER | SWP_NOSIZE);

   MUIManager::addListener(MUIManager::COMPONENT_MODE_LISTENER, 
                           new CompModeListener( &m_ObjectModeBut, 
                                                 &m_PointModeBut, 
                                                 &m_FaceModeBut, 
                                                 &m_EdgeModeBut) );

   MUIManager::addListener(MUIManager::SEPARATE_AXIS_LISTENER, 
                           new SeparateAxisListener( &m_SeparateAxisBut) );

   m_AxisCombo.SelectString(-1,"Object");
}


BEGIN_MESSAGE_MAP(CTopToolDlg, CDialog)
	//{{AFX_MSG_MAP(CTopToolDlg)
	ON_WM_WINDOWPOSCHANGED()
	ON_WM_DRAWITEM()
	ON_WM_CREATE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTopToolDlg message handlers

BOOL CTopToolDlg::OnCommand(WPARAM wParam, LPARAM lParam) 
{
  UINT     CmdID, Msg;
  HWND     hWnd;
  CWnd     *Parent;
  
  Parent = GetParentOwner();
  CmdID = LOWORD(wParam);
  Msg = HIWORD(wParam);
  hWnd = (HWND)lParam;
  
  if (Msg == BN_CLICKED) {
    switch(CmdID) {
/*    case IDC_OBJECTMODEBUT:
      m_ObjectModeBut.SetCheck(1);
      m_PointModeBut.SetCheck(0);
      m_FaceModeBut.SetCheck(0);
      m_PointModeBut.SetCheck(0);
      break;
    case IDC_POINTMODEBUT:
      m_ObjectModeBut.SetCheck(0);
      m_PointModeBut.SetCheck(0);
      m_FaceModeBut.SetCheck(0);
      m_PointModeBut.SetCheck(0);
      break;
    case IDC_FACEMODEBUT:
      m_ObjectModeBut.SetCheck(0);
      m_PointModeBut.SetCheck(0);
      m_FaceModeBut.SetCheck(1);
      m_PointModeBut.SetCheck(0);
      break;
    case IDC_EDGEMODEBUT:
      m_ObjectModeBut.SetCheck(0);
      m_PointModeBut.SetCheck(0);
      m_FaceModeBut.SetCheck(0);
      m_PointModeBut.SetCheck(1);
      break;*/
    }
  } else if (Msg == CBN_SELCHANGE) {
    int idComboBox = (int) LOWORD(wParam);
    if (idComboBox == IDC_AXISCOMBO) {
      CString str;
      m_AxisCombo.GetWindowText(str);
      if (str == "World") {
        MUIManager::setAxisMode(MUIManager::WORLD_AXIS);
      } if (str == "Local") {
        MUIManager::setAxisMode(MUIManager::LOCAL_AXIS);
      } if (str == "Parent") {
        MUIManager::setAxisMode(MUIManager::PARENT_AXIS);
      } if (str == "Screen") {
        MUIManager::setAxisMode(MUIManager::SCREEN_AXIS);
      } if (str == "Object") {
        MUIManager::setAxisMode(MUIManager::OBJECT_AXIS);
      }

      g_MainDlg->SendMessage(MM_UPDATEVIEWPORTS, MMC_UPDATE_ALL, 0);
    }
  }

	return CDialog::OnCommand(wParam, lParam);
}

BOOL CTopToolDlg::PreTranslateMessage(MSG* pMsg) 
{
   if (pMsg->message == WM_KEYDOWN || pMsg->message == WM_KEYUP)
   {
      LONG  WndStyle;

      WndStyle = GetWindowLong(pMsg->hwnd, GWL_STYLE);
      if (WndStyle & ES_AUTOHSCROLL)
      {
         // we have an edit box
         if (pMsg->message == WM_KEYDOWN)
         {
            if (pMsg->wParam == VK_ESCAPE || pMsg->wParam == VK_RETURN)
            {
               GetParentOwner()->SetFocus();
               return 1;
            }
         }
      }
      else
      return GetParentOwner()->PostMessage(pMsg->message, pMsg->wParam, pMsg->lParam);
   }
	
// Call CWnd::PreTranslate message so we do not get the special dialog message handling
	return CWnd::PreTranslateMessage(pMsg);
}

void CTopToolDlg::OnWindowPosChanged(WINDOWPOS FAR* lpwndpos) 
{
	CDialog::OnWindowPosChanged(lpwndpos);
	
   RECT  ClientRect, TabCtrlRect;

   GetClientRect(&ClientRect);

   m_TabCtrl.GetWindowRect(&TabCtrlRect);
   ScreenToClient(&TabCtrlRect);

   TabCtrlRect.right = ClientRect.right -3;

   m_TabCtrl.MoveWindow(&TabCtrlRect);
}


void CTopToolDlg::OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
	CDialog::OnDrawItem(nIDCtl, lpDrawItemStruct);
}

int CTopToolDlg::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;

	return 0;
}

BOOL CTopToolDlg::DestroyWindow() 
{

	
	return CDialog::DestroyWindow();
}
