#include <AztecMainPCH.h>
#include <MEdgeTurnTool.h>

// AztecLib includes
#include <MEditableMesh.h>
#include <MUIManager.h>

// AztecMain includes
#include <MDLGlobs.h>

//---------------------
//  MEdgeTurnToolType
//---------------------
MEdgeTurnToolType::MEdgeTurnToolType()
{
  setName("toolEdgeTurn");
}

int MEdgeTurnToolType::DrawTool(bool Select, MShiftState ShiftState, MBaseViewWndPtr View)
{
  return TOOLRESULT_DRAWALL;
}

int MEdgeTurnToolType::onMouseDown(int X, int Y, const MShiftState &Shift)
{
  MToolType::onMouseDown(X, Y, Shift);
  
  // Check to see if the mouse buttons are down.
  COpenGLWnd     *GLWnd;
  AztecFlags     OldMode;
  
  GLWnd = AZTEC_CAST(COpenGLWnd, g_CurView);
  
  if (GLWnd == NULL) {
    return TOOLRESULT_DRAWNONE;
  }
  
  bool        Changed = false;
  int         EdgeNum = -1;
  MVector3    EdgeCentre, EdgeDistance;
  MEditableMeshPtr EdgeMesh = NULL;
  
  // check to see if all the mouse buttons are up
  if (!Shift.m_Left) {
    return TOOLRESULT_DRAWNONE;
  }
  
  // select all the objects in the selection
  
  OldMode = MUIManager::getComponentMode();
  MUIManager::setComponentMode(MUIManager::EDGE_MODE);

  GLWnd->performSelection(X, Y, &m_InputList);
  
  MUIManager::setComponentMode(OldMode);
  
  // Go through and select the required objects
  MBaseObjectPtr Obj;
  
  for (int i = 0; i < m_InputList.size(); ++i) {
    MSelectionItem *SelItem = &m_InputList[i];
    
    if (SelItem->getNumComponents() != 0)
    {
      MSceneObjectPtr SelObj;
      MEditableMeshPtr MeshObj;
      
      SelObj = AZTEC_CAST(MSceneObject, SelItem->getObject());
      
      if (SelObj != NULL)
      {
        MeshObj = AZTEC_CAST(MEditableMesh, SelObj->getShapeObject()->convertToMesh());
        
        if (MeshObj == NULL)
          continue;
        
        MRay mouseRay;
        MMatrix4 objMatInv;

        g_Scene->getWorldTransformMatrix(g_Scene->getObjectList()->findObject(SelObj), objMatInv);
        objMatInv.inverse();
        mouseRay = objMatInv * m_DownRay;

        for (int n=0; n<SelItem->getNumComponents(); n++)
        {
          int   Num;
          AztecFlags Mode;
          
          int triangleIndex;
          int            TriEdge;
          
          SelItem->getComponent(n, Mode, Num);
          
          if (Mode != SELECTITEM_EDGE)
            continue;
          
          // Check to see if this is the closest one
          
          if (!MeshObj->getTriFromEdge(Num, triangleIndex, TriEdge))
            continue;
          
          int indexA, indexB;
          MVector3 A, B;
          MVector3 Centre, Distance;
          
          if (!MeshObj->getVertsFromEdge(Num, &indexA, &indexB))
            continue;
          
          A = MeshObj->getVertexPosition(indexA);
          B = MeshObj->getVertexPosition(indexB);
          // calculate the distance from the edge to the cursor
          Centre = 0.5*( B + A );
          Distance = Centre - mouseRay.Org;
          
          if (EdgeNum == -1 || Distance.length2() < EdgeDistance.length2() )
          {
            EdgeMesh = MeshObj;
            EdgeNum = Num;
            
            EdgeDistance = Distance;
            EdgeCentre = Centre;
          }
          
        }
      }
      
    }
  }
  
  if (EdgeMesh != NULL && EdgeNum != -1) {
    EdgeMesh->turnEdge(EdgeNum);
    Changed = true;
  }
  
  m_InputList.clear();
  return Changed;
}

