#include <AztecMainPCH.h>
#include <MGLMoveTool.h>

// AztecLib includes
#include <MUIManager.h>

// AztecMain includes
#include <MDLGlobs.h>

#include <math.h>

//-------------------
//  MGLMoveToolType
//-------------------
MGLMoveToolType::MGLMoveToolType()
{
  setName("KToolMove");
  m_RequiresSel = true;
  middleManipAxis = SCREEN;
}

int MGLMoveToolType::DrawTool(bool Select, MShiftState ShiftState, MBaseViewWndPtr View) {
  // Get the current viewport and cast it to a gl wnd.
  COpenGLWnd     *GLWnd;
  MVector3       PivotPoint;
  bool           DrawManips;
  
  
  GLWnd = AZTEC_CAST(COpenGLWnd, View);
  
  if (GLWnd == NULL) {
    return 0;
  }
  
  PivotPoint = g_Scene->getSelectionCentre();
  // we should not update our axis if we are dragging, otherwise
  // the axis would change as we move things!
  if (!m_Dragging) {
    getAxisMatrix(GLWnd);
  }
  
  glPushAttrib(GL_ENABLE_BIT);
  glDisable(GL_DEPTH_TEST);
  
  
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glLoadIdentity();
  
  // Perform the viewport transformation
  
  GLWnd->DoViewportTransform();
  glMatrixMode(GL_MODELVIEW);
  
  glPushMatrix();
  float ScaleFact = GLWnd->GetScaleFactor(PivotPoint);
  glTranslatef(PivotPoint.x, PivotPoint.y, PivotPoint.z);
  glMultMatrixf((float*)m_AxisTransform.m);
  
  glScalef(ScaleFact, ScaleFact, ScaleFact);
  
  if (RequiresSelection()) {
    DrawManips = g_Scene->anythingSelected();
  } else {
    DrawManips = true;
  }
  
  if (DrawManips) {
    switch (middleManipAxis) {
    case SCREEN:
      GLWnd->DrawAxisIcon(g_IconSize, 0.5f, 2.0f, Select, DRAWAXIS_ALLAXES | DRAWAXIS_ARROWS);
      break;
    case XAXIS:
      GLWnd->DrawAxisIcon(g_IconSize, 0.5f, 2.0f, Select, DRAWAXIS_ALLAXES | DRAWAXIS_ARROWS | DRAWAXIS_MIDDLE_NORMAL_X);
      break;
    case YAXIS:
      GLWnd->DrawAxisIcon(g_IconSize, 0.5f, 2.0f, Select, DRAWAXIS_ALLAXES | DRAWAXIS_ARROWS | DRAWAXIS_MIDDLE_NORMAL_Y);
      break;
    case ZAXIS:
      GLWnd->DrawAxisIcon(g_IconSize, 0.5f, 2.0f, Select, DRAWAXIS_ALLAXES | DRAWAXIS_ARROWS | DRAWAXIS_MIDDLE_NORMAL_Z);
      break;
    }
    
    if (m_Dragging) {
      glPopMatrix();
      glPushMatrix();
      ScaleFact = GLWnd->GetScaleFactor(m_MoveStart);
      glTranslatef(m_MoveStart.x, m_MoveStart.y, m_MoveStart.z);
      glScalef(ScaleFact, ScaleFact, ScaleFact);
      glMultMatrixf((float*)m_AxisTransform.m);
      GLWnd->DrawAxisIcon(g_IconSize, 0.2f, 2.0f, false, DRAWAXIS_ALLGRAY | DRAWAXIS_NORMAL | DRAWAXIS_ARROWS);
      
    }
  }
  
  glPopMatrix();
  glPopMatrix();
  
  glPopAttrib();
  
  return 1;
}

int MGLMoveToolType::onMouseDown(int X, int Y, const MShiftState &Shift)
{
  // if we are holding down control, that means we are adjusting our middle
  // manipulator axis
  if (Shift.m_Ctrl) {
    ManipAxis oldAxis = middleManipAxis;
    switch (m_PickedManip) {
    case 1:
      middleManipAxis = XAXIS;
      break;
    case 2:
      middleManipAxis = YAXIS;
      break;
    case 3:
      middleManipAxis = ZAXIS;
      break;
    case 4:
      middleManipAxis = SCREEN;
      break;
    }

  }


  
  MVector3    Orig, Dir, ViewNorm;
  MMatrix4    XFormMat;
  
  switch (middleManipAxis) {
  case SCREEN:
    GetPlaneParams(m_Constraint, m_AxisTransform);
    break;
  case XAXIS:
    GetPlaneParams(m_Constraint, m_AxisTransform, DRAWAXIS_MIDDLE_NORMAL_X);
    break;
  case YAXIS:
    GetPlaneParams(m_Constraint, m_AxisTransform, DRAWAXIS_MIDDLE_NORMAL_Y);
    break;
  case ZAXIS:
    GetPlaneParams(m_Constraint, m_AxisTransform, DRAWAXIS_MIDDLE_NORMAL_Z);
    break;
  }
  
  Dir.normalize();
  
  m_MoveStart = g_Scene->getSelectionCentre();

  MXYZToolType::onMouseDown(X, Y, Shift);

  return TOOLRESULT_DRAWALL;
}


int MGLMoveToolType::onMouseUp(int X, int Y, const MShiftState &Shift)
{
  MXYZToolType::onMouseUp(X, Y, Shift);
  

  if (m_PickedManip == 1) {
    UpdateKeys("Move", TRANSFORM_CHAN_TRANSX);
  } else if (m_PickedManip == 2) {
    UpdateKeys("Move", TRANSFORM_CHAN_TRANSY);
  } else if (m_PickedManip == 3) {
    UpdateKeys("Move", TRANSFORM_CHAN_TRANSZ);
  } else {
    UpdateKeys("Move", TRANSFORM_CHAN_TRANSLATE);
  } 
  
  return TOOLRESULT_DRAWALL;
}

int MGLMoveToolType::onMouseMove(int X, int Y, const MShiftState &Shift)
{
  MXYZToolType::onMouseMove(X, Y, Shift);
  
  if (!m_Dragging) {
    MUIManager::unsetWorldCoordinates();
    MUIManager::unsetDiffCoordinates();
    return TOOLRESULT_DRAWNONE;
  }
  
  MVector3 OfsVec;
  
  OfsVec = m_CurVec;
  OfsVec -= m_DownVec;
  
  MVector3 MoveVec;

  MUIManager::setWorldCoordinates(m_DownVec);
  MUIManager::setDiffCoordinates(OfsVec);

  // Go through the currently selected objects, and move their components.
  MBaseObjectPtr BaseObj;
  MSceneObjectPtr Obj;
  g_Scene->getObjectList()->beginIteration();
  while (( BaseObj = g_Scene->getObjectList()->getNext() ) != NULL )
  {
    Obj = AZTEC_CAST(MSceneObject, BaseObj);
    if (Obj == NULL)
      continue;
    
    MTreeObjectNodePtr ObjNode;
    MComponentisedObjectPtr compObj = Obj->getComponentObject();
    
    ObjNode = g_Scene->getObjectList()->getCurrentNode();
    
    if (compObj != NULL && compObj->isInComponentMode()) {
      MEditableComponentisedObjectPtr editableCompObj = Obj->getEditableComponentObject();
      if (editableCompObj != NULL && editableCompObj->isInComponentMode()) {
        // Move some vertices about the place
        {
          MTransformObjectPtr XForm;
        
          XForm = g_Scene->getTransform(ObjNode);
        
          OfsVec = m_CurVec - m_DownVec;
          if (XForm != NULL) {
            MoveVec = g_Scene->worldToObjectSpace(ObjNode, OfsVec);
            MoveVec -= g_Scene->worldToObjectSpace(ObjNode, MVector3(0,0,0));
  //          if (GetAsyncKeyState('X') >> 15 != 0) {
            if (MUIManager::getSnapMode() == MUIManager::SNAP_GRID) {
              MoveVec.x = floor(MoveVec.x);
              MoveVec.y = floor(MoveVec.y);
              MoveVec.z = floor(MoveVec.z);
            }
          }

        }
        float distance = OfsVec.length();
      
        MVector3 axisMoveVec;
      
        axisMoveVec = m_AxisTransformInv * (m_CurVec - m_DownVec);
        editableCompObj->restoreComponentPositions(editableCompObj->getComponentMode());

        bool doLocalTransform = MUIManager::getSeparateAxisMode() && MUIManager::getAxisMode() == MUIManager::LOCAL_AXIS;
        MMatrix4 transform;

        transform.identity();

        if (doLocalTransform) {
          transform.m[3][0] = axisMoveVec.x;
          transform.m[3][1] = axisMoveVec.y;
          transform.m[3][2] = axisMoveVec.z;
        } else {
          transform.m[3][0] = MoveVec.x;
          transform.m[3][1] = MoveVec.y;
          transform.m[3][2] = MoveVec.z;
        }

        editableCompObj->transformComponents(
          editableCompObj->getComponentMode(), 
          transform, 
          MComponentisedObject::COMPONENT_SELECTED,
          doLocalTransform);
      }
    } else if (Obj->isFlagged(OBJECTFLAG_SELECTED)) {
      {
        MTreeObjectNodePtr ParentNode;
        ParentNode = ObjNode->getParent();
        
        MoveVec = g_Scene->worldToObjectSpace(ParentNode, m_CurVec);
        MoveVec -= g_Scene->worldToObjectSpace(ParentNode, m_DownVec);
      }
      
      
      MTransformObjectPtr XForm;
      MVector3          Vec;
      
      XForm = Obj->getTransformObject();
      
      if (XForm != NULL) {
        MVector3       Vec;
        
        XForm->fetchValues();
        Vec = XForm->getTranslateVector(g_Scene->getTime());
        
        XForm->setTranslateVector(Vec + MoveVec);
        XForm->setParamByName("Tsl", (Vec+MoveVec).convertToString(), false);
      }
    }
  }         
  g_Scene->getObjectList()->endIteration();

  if (m_PickedManip == 1) {
    UpdateKeys("Move", TRANSFORM_CHAN_TRANSX, false);
  } else if (m_PickedManip == 2) {
    UpdateKeys("Move", TRANSFORM_CHAN_TRANSY, false);
  } else if (m_PickedManip == 3) {
    UpdateKeys("Move", TRANSFORM_CHAN_TRANSZ, false);
  } else {
    UpdateKeys("Move", TRANSFORM_CHAN_TRANSLATE, false);
  } 
  
  return TOOLRESULT_DRAWALL;
}


