#include <AztecMainPCH.h>
#include <MMovePivotTool.h>

// AztecMain includes
#include <MDLGlobs.h>

//----------------------
//  MMovePivotToolType
//----------------------
MMovePivotToolType::MMovePivotToolType()
{
  setName("KToolMove");
  m_RequiresSel = true;
}

int MMovePivotToolType::DrawTool(bool Select, MShiftState ShiftState, MBaseViewWndPtr View)
{
  // Get the current viewport and cast it to a gl wnd.
  COpenGLWnd     *GLWnd;
  MVector3       PivotPoint;
  bool           DrawManips;
  
  
  GLWnd = AZTEC_CAST(COpenGLWnd, View);
  
  if (GLWnd == NULL)
    return 0;
  
  PivotPoint = g_Scene->getSelectionCentre();
  // we should not update our axis if we are dragging, otherwise
  // the axis would change as we move things!
  if (!m_Dragging) {
    getAxisMatrix(GLWnd);
  }
  
  glPushAttrib(GL_ENABLE_BIT);
  glDisable(GL_DEPTH_TEST);
  
  
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glLoadIdentity();
  
  // Perform the viewport transformation
  
  GLWnd->DoViewportTransform();
  glMatrixMode(GL_MODELVIEW);
  
  glPushMatrix();
  float ScaleFact = GLWnd->GetScaleFactor(PivotPoint);
  glTranslatef(PivotPoint.x, PivotPoint.y, PivotPoint.z);
  
  glScalef(ScaleFact, ScaleFact, ScaleFact);
  
  if (RequiresSelection())
  {
    DrawManips = g_Scene->anythingSelected();
  }
  else
    DrawManips = true;
  
  if (DrawManips)
  {
    GLWnd->DrawAxisIcon(g_IconSize, 0.5f, 2.0f, Select, DRAWAXIS_ALLAXES);
    
    if (m_Dragging)
    {
      glPopMatrix();
      glPushMatrix();
      glTranslatef(m_MoveStart.x, m_MoveStart.y, m_MoveStart.z);
      glScalef(ScaleFact, ScaleFact, ScaleFact);
      GLWnd->DrawAxisIcon(g_IconSize, 0.2f, 2.0f, false, DRAWAXIS_ALLGRAY | DRAWAXIS_ALLAXES);
      
    }
  }
  
  glPopMatrix();
  glPopMatrix();
  
  glPopAttrib();
  
  return 1;
}

int MMovePivotToolType::onMouseDown(int X, int Y, const MShiftState &Shift)
{
  MVector3    Orig, Dir, ViewNorm;
  MMatrix4    XFormMat;
  
  GetPlaneParams(m_Constraint, m_AxisTransform);
  
  Dir.normalize();
  
  m_MoveStart = g_Scene->getSelectionCentre();
  
  MXYZToolType::onMouseDown(X, Y, Shift);
  
  return TOOLRESULT_DRAWALL;
}

int MMovePivotToolType::onMouseUp(int X, int Y, const MShiftState &Shift)
{
  MXYZToolType::onMouseUp(X, Y, Shift);
  
  UpdateKeys("Move", TRANSFORM_CHAN_TRANSLATE);
  
  return TOOLRESULT_DRAWALL;
}

int MMovePivotToolType::onMouseMove(int X, int Y, const MShiftState &Shift)
{
  MXYZToolType::onMouseMove(X, Y, Shift);
  
  if (!m_Dragging) {
    return TOOLRESULT_DRAWNONE;
  }
  
  MVector3  OfsVec, MoveVec;
  
  OfsVec = m_CurVec;
  OfsVec -= m_DownVec;
  
  // Go through the currently selected objects, and move their components.
  MBaseObjectPtr BaseObj;
  MSceneObjectPtr Obj;
  g_Scene->getObjectList()->beginIteration();
  while (( BaseObj = g_Scene->getObjectList()->getNext() ) != NULL ) {
    Obj = AZTEC_CAST(MSceneObject, BaseObj);
    if (Obj == NULL)
      continue;
    
    MTreeObjectNodePtr ObjNode;
    MComponentisedObjectPtr compObj = Obj->getComponentObject();
    
    ObjNode = g_Scene->getObjectList()->getCurrentNode();
    
    if (compObj == NULL || !compObj->isInComponentMode()) {
      {
        MTreeObjectNodePtr ParentNode;
        ParentNode = ObjNode->getParent();
        
        MoveVec = g_Scene->worldToObjectSpace(ParentNode, m_CurVec);
        MoveVec -= g_Scene->worldToObjectSpace(ParentNode, m_DownVec);
        
        MoveVec = OfsVec;
      }
      
      
      MTransformObjectPtr XForm;
      MVector3          Vec;
      
      XForm = g_Scene->getTransform(g_Scene->getObjectList()->getCurrentNode());
      
      if (XForm != NULL) {
        MVector3       Vec;
        
        Vec = XForm->getPivotPoint();
        
        Vec = m_MoveStart + MoveVec;
        
        Vec = g_Scene->worldToObjectSpace(ObjNode, Vec);
        XForm->setPivotPoint(Vec);
      }
    }
  }
  g_Scene->getObjectList()->endIteration();
  
  return TOOLRESULT_DRAWALL;
}

