#include <AztecMainPCH.h>
#include <MPolylineAddPointTool.h>

#include <MUIManager.h>


// AztecMain includes
#include <MDLGlobs.h>

//---------------------
//  MPolylineAddPointTool
//---------------------
MPolylineAddPointTool::MPolylineAddPointTool()
{
  setName("toolPolylineAddPoints");
  dragging = false;
}

int MPolylineAddPointTool::DrawTool(bool Select, MShiftState ShiftState, MBaseViewWndPtr View)
{
  MXYZToolType::DrawTool(Select, ShiftState, View);

  return TOOLRESULT_DRAWALL;
}

int MPolylineAddPointTool::onMouseDown(int X, int Y, const MShiftState &Shift)
{
  MXYZToolType::onMouseDown(X, Y, Shift);
  
  // check to see what component mode we are in. If we are not in point mode,
  // then do nothing
  if (MUIManager::getComponentMode() == MUIManager::POINT_MODE) {

    COpenGLWnd *glView = AZTEC_CAST(COpenGLWnd, g_CurView);
    
    if (glView == NULL) {
      return TOOLRESULT_DRAWNONE;
    }
    
    MVector3 newPoint = getPositionFromMouse(X,Y);
    
    if (Shift.m_Left) {
      dragging = true;
      getMeshObject();
      
      // deselect all the previous points.
      for (int index = 0; index < meshObj->getComponentCount(MComponentisedObject::POINT_TYPE); ++index) {
        meshObj->flagComponent(MComponentisedObject::POINT_TYPE, 
          index, 
          MComponentisedObject::COMPONENT_SELECTED,
          MComponentisedObject::atUnset);
      }
      
      meshObj->addVertex(newPoint);
      meshObj->flagComponent(MComponentisedObject::POINT_TYPE, 
        meshObj->getVertexCount() - 1, 
        MComponentisedObject::COMPONENT_SELECTED);
      
      // if we have more than one vertex, we can join them together with an edge
      if (meshObj->getVertexCount() > 1) {
        meshObj->addEdge(meshObj->getVertexCount()-2, meshObj->getVertexCount()-1);
      }
      
      return TOOLRESULT_DRAWALL;
      
    } else if (Shift.m_Mid) {
      dragging = true;
      getMeshObject();
      
      meshObj->setVertexPosition(meshObj->getVertexCount() - 1, newPoint);
      return TOOLRESULT_DRAWALL;
    }
    
  }
  return TOOLRESULT_DRAWNONE;
}

int MPolylineAddPointTool::onMouseMove(int X, int Y, const MShiftState &Shift) {
  if (dragging) {
    // if we are dragging it means we are adjusting the newly added point
    // so lets move it around.

    getMeshObject();

    MVector3 newPoint = getPositionFromMouse(X,Y);

    meshObj->setVertexPosition(meshObj->getVertexCount() - 1, newPoint);
    return TOOLRESULT_DRAWALL;
  }

  return TOOLRESULT_DRAWNONE;
}

int MPolylineAddPointTool::onMouseUp(int X, int Y, const MShiftState &Shift) {
  dragging = false;
  return TOOLRESULT_DRAWNONE;
}

void MPolylineAddPointTool::getMeshObject() {
  // if we already have a mesh object, then we don't need to go looking
  if (meshObj != NULL) {
    return;
  }

  // find our current selection, if any
  MBaseObjectTreePtr objects = g_Scene->getObjectList();
  MBaseObjectPtr object;

  objects->beginIteration();
  while ((object = objects->getNext()) != NULL) {
    // if the object isn't selected, it definitely cannot be ours.
    if (!object->isFlagged(OBJECTFLAG_SELECTED)) {
      continue;
    }

    sceneObj = AZTEC_CAST(MSceneObject, object);

    if (sceneObj == NULL) {
      continue;
    }

    shapeObj = AZTEC_CAST(MLineShape, sceneObj->getShapeObject());

    // use the first line shape we come across
    if (shapeObj != NULL) {
      break;
    }
  }
  objects->endIteration();

  // if we have no line shape at all, we must make one.
  if (shapeObj == NULL) {
    sceneObj = new Aztec::MSceneObject();
    shapeObj = new Aztec::MLineShape();
    meshObj = new Aztec::MLineMesh();

    shapeObj->setLineMesh(meshObj);
    sceneObj->setShapeObject(shapeObj);

    sceneObj->setName("line");
    shapeObj->setName("lineShape");
    meshObj->setName("lineMesh");

    g_Scene->addObject(sceneObj);
    g_Scene->addObject(shapeObj);

    g_Scene->selectObject(sceneObj);
  } else {
    meshObj = shapeObj->getLineMesh();
  }

  // change to point mode so we can see the points we are making
  g_KeyList.ExecuteAction("KModePoint");
}

MVector3 MPolylineAddPointTool::getPositionFromMouse(int x, int y) {
  COpenGLWnd *glView = AZTEC_CAST(COpenGLWnd, g_CurView);

  // add the new point in.
  MRay ray = glView->GetViewRay(x, y);
  MPlane plane = glView->getGridPlane();

  return ray.intersectWithPlane(plane);
}
