#include <AztecMainPCH.h>
#include "AztecMain.h"
#include "views/FormView.h"

#include "MdlGlobs.h"

//#include <AztecGUIMPluginManager.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


static const int BUTTON_BASE_ID = 6000;

MFormView::MFormView() {
  contentPane = NULL;
  buttonPane = NULL;

}

MFormView::~MFormView() {
  if (contentPane != NULL) {
    delete contentPane;
  }

  if (buttonPane != NULL) {
    delete buttonPane;
  }

  for (unsigned int i = 0; i < buttons.size(); ++i) {
    if (buttons[i] != NULL) {
      delete buttons[i];
      buttons[i] = NULL;
    }
  }

  buttons.clear();
}

CWnd* MFormView::getContentPane() {
  return contentPane;
}

void MFormView::addButton(const std::string &caption) {
  CButton *button = new CButton();
  button->Create(caption.c_str(), WS_VISIBLE, CRect(0,0,10,10), buttonPane, BUTTON_BASE_ID + buttons.size());
  buttons.push_back(button);
  button->SendMessage(WM_SETFONT, (UINT)GetStockObject(DEFAULT_GUI_FONT), 0);

  layoutButtons();
}

void MFormView::onFormAction(const std::string &action) {
  for (ListenerList::iterator it = listeners.begin(); it != listeners.end(); ++it) {
    (*it)->onAction(this, action);
  }

  if (action == "Ok" || action == "Cancel") {
    PostMessage(WM_CLOSE);
  }

}

static int getHeight(CWnd *wnd) {
  RECT rect;
  wnd->GetWindowRect(&rect);
  return rect.bottom - rect.top;
}

void MFormView::doLayout() {
  RECT clientRect;
  
  ::GetClientRect(m_hWnd, &clientRect);
  m_PopupRect = clientRect;
  
  int buttonPaneHeight = 30;

  buttonPane->SetWindowPos(NULL, clientRect.left, clientRect.bottom - buttonPaneHeight, clientRect.right - clientRect.left, buttonPaneHeight, SWP_NOZORDER);
  clientRect.bottom -= buttonPaneHeight;

  contentPane->SetWindowPos(NULL, clientRect.left, clientRect.top, clientRect.right - clientRect.left, clientRect.bottom - clientRect.top, SWP_NOZORDER);

  CWnd *child;

  child = contentPane->GetWindow(GW_CHILD);
  contentPane->GetClientRect(&clientRect);
  int yPos = 0;
  while (child != NULL) {
    int height = getHeight(child);
    clientRect.top += height;
    child = child->GetNextWindow();
  }

  // if it turns out that have gone past the content panes bottom, then we 
  // need to show a scroll bar and resize it all again.
  if (clientRect.top > clientRect.bottom) {
    contentPane->ShowScrollBar(SB_VERT);
  } else {
    contentPane->ShowScrollBar(SB_VERT, FALSE);
  }

  // now do the actual sizing of the children
  child = contentPane->GetWindow(GW_CHILD);
  contentPane->GetClientRect(&clientRect);
  yPos = 0;
  while (child != NULL) {
    int height = getHeight(child);
    RECT rect = clientRect;
    rect.bottom = rect.top + height;
    child->MoveWindow(&rect);
    clientRect.top += height;
    child = child->GetNextWindow();
  }


  layoutButtons();

  DrawView();
}

void MFormView::addActionListener(const MFormView::ActionListenerPtr &listener) {
  listeners.push_back(listener);
}

BEGIN_MESSAGE_MAP(MFormView, CWnd)
	//{{AFX_MSG_MAP(MFormView)
  ON_WM_DESTROY()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


MBaseObjectPtr MFormView::createNew()
{
   MFormView  *Wnd;

   Wnd = new MFormView;
   Wnd->setName(getName());

   return (MBaseObject*)Wnd;
}


void MFormView::ViewCreate()
{
  RECT clientRect;
  ::GetClientRect(m_hWnd, &clientRect);

  int buttonPaneHeight = 30;

  buttonPane = new CButtonPane(this);
  buttonPane->Create(NULL, "button pane", WS_CHILD | WS_VISIBLE, CRect(clientRect.left, clientRect.bottom - buttonPaneHeight, clientRect.right, clientRect.bottom), this, -1);

  clientRect.bottom -= buttonPaneHeight;

  contentPane = new CWnd();
  contentPane->Create(NULL, "content pane", WS_CHILD | WS_VISIBLE, clientRect, this, -1);


  HFONT    hFont;
  hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
  
//  hFont = ::CreateFont(10, 0, 0, 0, FontStyle, FALSE, FALSE, FALSE, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH, "MS Sans Serif");
//  tabbedCtrl->SendMessage(WM_SETFONT, (UINT)hFont, 0);

}

void MFormView::DrawView()
{
  MBaseViewWnd::DrawView();

  CDC *dc = GetDC();

  RECT clientRect;
  GetClientRect(&clientRect);

//  ::FillRect(dc->m_hDC, &clientRect, GetSysColorBrush(COLOR_3DFACE));

  ReleaseDC(dc);
}

DWORD MFormView::ViewPopupMenu(int x, int y)
{
   CMenu    Menu;
   CMenu    *Popup;
   DWORD    Choice;

   Menu.LoadMenu(IDR_SCENEOUTLINE_POPUP);
   Popup = Menu.GetSubMenu(0);
   InitPopupMenu(Popup);

   // Check the carious menu items depending on the current flags etc.

   Choice = Popup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_NONOTIFY | TPM_RETURNCMD, x, y, this);

   Popup->DestroyMenu();

   bool     Update;
   int      Result;

   Result = HandlePopupCommand(Choice);

   // The command was handled, but the view was changed, so we must return.
   if (Result == -1)
      return 1;
      
   if (Result == 1) {
      Update = true;
   } else {
      Update = false;
   }

   if (Update) {
      DrawView();
   }
   
   return Choice;
}

int MFormView::HandlePopupCommand(DWORD Cmd) {
   int Result;

   Result = MBaseViewWnd::HandlePopupCommand(Cmd);

   if (Result != 0) {
      return Result;
   }

   switch (Cmd) {
   }

   return 0;
}

void MFormView::layoutButtons() {
  if (buttons.size() == 0) {
    return;
  }

  RECT clientRect;
  buttonPane->GetClientRect(&clientRect);

  float buttonWidth = (float)(clientRect.right - clientRect.left) / buttons.size();

  for (int i = 0; i < buttons.size(); ++i) {
    RECT buttonRect;
    buttonRect.left = i * buttonWidth;
    buttonRect.right = (i+1) * buttonWidth;
    buttonRect.top = 0;
    buttonRect.bottom = clientRect.bottom;

    buttonRect.left += 2;
    buttonRect.right -= 2;
    buttonRect.top += 2;
    buttonRect.bottom -= 2;

    buttons[i]->MoveWindow(&buttonRect);
  }

}

template <class T>
void destroyWindow(T *&window) {
  if (window != NULL) {
    window->DestroyWindow();
    delete window;
    window = NULL;
  }
}

void MFormView::OnClose() {
  g_ViewList.DeleteView(this);
}

void MFormView::OnDestroy() {

  for (int i = 0; i < buttons.size(); ++i) {
    destroyWindow(buttons[i]);
  }

  destroyWindow(buttonPane);
  destroyWindow(contentPane);
 
  CWnd::OnDestroy();
}

void MFormView::OnSize(UINT nType, int cx, int cy) 
{
  doLayout();
}

BOOL MFormView::OnCommand(WPARAM wParam, LPARAM lParam) {
  int controlID = LOWORD(wParam);
  int message = HIWORD(wParam);
  HWND controlHWnd = (HWND)lParam;

  if (controlID >= BUTTON_BASE_ID && controlID < BUTTON_BASE_ID + buttons.size()) {
    CString text;
    buttons[controlID - BUTTON_BASE_ID]->GetWindowText(text);
    onFormAction((LPCTSTR)text);
  }

  return MBaseViewWnd::OnCommand(wParam, lParam);
}

MFormView::CButtonPane::CButtonPane(MFormView *parent) {
  this->parent = parent;
}

BOOL MFormView::CButtonPane::OnCommand(WPARAM wParam, LPARAM lParam) {
  return parent->OnCommand(wParam, lParam);
}

