#include <AztecMainPCH.h>
#include "AztecMain.h"
#include "ParameterViewWnd.h"

#include "MdlGlobs.h"

#include <AztecGUIMPluginManager.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#define TabContrl_ID 24000

CParameterViewWnd::ParamGUI::ParamGUI(CWnd *parent) : parentWnd(parent) 
{
}

CParameterViewWnd::ParamGUI::ParamGUI(const ParamGUI &src) 
  : parentWnd(src.parentWnd), childWindows(src.childWindows)
{
}

void CParameterViewWnd::ParamGUI::destroy() {
  PluginPairList::iterator it;
  for (it = childWindows.begin(); it != childWindows.end(); ++it) {
    it->second->destroyControls();
    it->first->DestroyWindow();
    delete it->first;
    it->first = NULL;
  }

  parentWnd->DestroyWindow();
  delete parentWnd;
  parentWnd = NULL;

  childWindows.clear();
}

void CParameterViewWnd::ParamGUI::addChildWindow(CWnd *child, const AztecGUI::MParameterPluginPtr &plugin) {
  childWindows.push_back(CWndPluginPair(child, plugin));
}



CParameterViewWnd::CParameterViewWnd()
{
  tabbedCtrl = NULL;
}

CParameterViewWnd::~CParameterViewWnd()
{
}


BEGIN_MESSAGE_MAP(CParameterViewWnd, CWnd)
	//{{AFX_MSG_MAP(CParameterViewWnd)
	ON_WM_LBUTTONDOWN()
	ON_WM_LBUTTONUP()
	ON_WM_MBUTTONDOWN()
	ON_WM_MBUTTONUP()
	ON_WM_RBUTTONDOWN()
	ON_WM_RBUTTONUP()
  ON_WM_DESTROY()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


MBaseObjectPtr CParameterViewWnd::createNew()
{
   CParameterViewWnd  *Wnd;

   Wnd = new CParameterViewWnd;
   Wnd->setName(getName());

   return (MBaseObject*)Wnd;
}


void CParameterViewWnd::ViewCreate()
{
  RECT clientRect;
  GetClientRect(&clientRect);
  tabbedCtrl = new CTabCtrl();
  tabbedCtrl->Create(TCS_TABS | TCS_SINGLELINE, clientRect, this, TabContrl_ID);

  HFONT    hFont;
  hFont = (HFONT)GetStockObject(DEFAULT_GUI_FONT);
  
//  hFont = ::CreateFont(10, 0, 0, 0, FontStyle, FALSE, FALSE, FALSE, ANSI_CHARSET, OUT_DEFAULT_PRECIS, CLIP_DEFAULT_PRECIS, DEFAULT_QUALITY, DEFAULT_PITCH, "MS Sans Serif");
  tabbedCtrl->SendMessage(WM_SETFONT, (UINT)hFont, 0);

  tabbedCtrl->ShowWindow(SW_SHOW);
}

void CParameterViewWnd::DrawView()
{
  MBaseViewWnd::DrawView();

  // we can't do anything if we don't have a tab control ready.
  if (tabbedCtrl == NULL) {
    return;
  }

  std::set<MNamedObjectPtr> selectedObjs;

  MBaseObjectTreePtr tree = g_Scene->getObjectList();
  MBaseObjectPtr baseObj;
  
  tree->beginIteration();
  while (( baseObj = tree->getNext() ) != NULL ) {
    MNamedObjectPtr obj = AZTEC_CAST(MNamedObject, baseObj);
    
    if (obj == NULL) {
      continue;
    }

    if (obj->isFlagged(OBJECTFLAG_SELECTED)) {
      selectedObjs.insert(obj);
    }
  }
  tree->endIteration();

  std::vector<MNamedObjectPtr> objsToRemove;

  // loop over the current Tabs, and for any that exists in the current
  // tabs, but not i nthe selectedObjs, we must remove.
  ObjTabMap::iterator tabIt;
  for (tabIt = objectTabs.begin(); tabIt != objectTabs.end(); ++tabIt) {
    if (selectedObjs.find(tabIt->first) == selectedObjs.end()) {
      objsToRemove.push_back(tabIt->first);
    }
  }

  bool tabVisiblityChanged = false;

  if (objsToRemove.size() != 0) {
    showTab(tabbedCtrl->GetCurSel(), SW_HIDE);
    tabVisiblityChanged = true;
  }

  for (int i = 0; i < objsToRemove.size(); ++i) {
    removeTabFor(objsToRemove[i]);
  }

  // loop over the new selection, and for any that does not exist 
  // in the current tabs, add it in
  std::set<MNamedObjectPtr>::iterator selObjIt;
  for (selObjIt = selectedObjs.begin(); selObjIt != selectedObjs.end(); ++selObjIt) {
    if (objectTabs.find(*selObjIt) == objectTabs.end()) {
      if (!tabVisiblityChanged) {
        showTab(tabbedCtrl->GetCurSel(), SW_HIDE);
        tabVisiblityChanged = true;
      }
      addTabFor(*selObjIt);
    }
  }

  if (tabVisiblityChanged) {
    showTab(tabbedCtrl->GetCurSel(), SW_SHOW);
  }

  ParamGUI gui = getParamGUIForTabIndex(tabbedCtrl->GetCurSel());
  if (gui.childWindows.size() > 0) {
    for (int i = 0; i < gui.childWindows.size(); ++i) {
      gui.childWindows[i].second->updateGUIValues(tabObjects.find(tabbedCtrl->GetCurSel())->second);
    }
  }
}

void CParameterViewWnd::addTabFor(const MNamedObjectPtr &obj) {
  ObjTabMap::iterator it = objectTabs.find(obj);

  if (it == objectTabs.end()) {
    int tabIndex = objectTabs.size();
    objectTabs.insert(ObjTabMap::value_type(obj, tabIndex));
    tabObjects.insert(TabObjMap::value_type(tabIndex, obj));
    tabbedCtrl->InsertItem(tabIndex, (LPCTSTR)obj->getName());
  }
}

void CParameterViewWnd::removeTabFor(const MNamedObjectPtr &obj) {
  removeWndFor(obj);

  ObjTabMap::iterator it = objectTabs.find(obj);

  if (it != objectTabs.end()) {
    // loop over the current tabs, and adjust their index.
    ObjTabMap::iterator objIt;
    for (objIt = objectTabs.begin(); objIt != objectTabs.end(); ++objIt) {
      if (objIt->second > it->second) {
        --objIt->second;
      }
    }

    tabbedCtrl->DeleteItem(it->second);

    tabObjects.erase(it->second);
    objectTabs.erase(it);

  }
}

RECT CParameterViewWnd::addControlsForObject(CWnd *parentWnd, MNamedObjectPtr obj, int startY, CWndMap::iterator wndMapIt) {
  AztecGUI::MPluginManager::ParameterPluginList plugins;
  AztecGUI::MPluginManager::getPluginsForObject(obj, plugins);
  
  RECT totalRect;
  RECT newWindowRect;

  parentWnd->GetClientRect(&totalRect);

  newWindowRect.left = 0;
  newWindowRect.right = 50;
  newWindowRect.top = startY;
  newWindowRect.bottom = newWindowRect.top + 100;

  AztecGUI::MPluginManager::ParameterPluginList::iterator pluginIt;
  for (pluginIt = plugins.begin(); pluginIt != plugins.end(); ++pluginIt) {

    CWnd *wnd = new CWnd();
    wnd->Create(NULL, "emptyWindow", WS_CHILD , newWindowRect, parentWnd, 0);
    (*pluginIt)->createControls(wnd->m_hWnd, obj);
    
    wndMapIt->second.addChildWindow(wnd, *pluginIt);
    wnd->SetWindowPos(NULL, 0, newWindowRect.top, 0, 0, SWP_NOSIZE | SWP_NOZORDER);

    RECT rect;
    wnd->GetClientRect(&rect);
    totalRect.bottom = newWindowRect.top + rect.bottom;

    if (newWindowRect.left + rect.right > totalRect.right) {
      totalRect.right = newWindowRect.left + rect.right;
    }
    wnd->ShowWindow(SW_SHOW);

    newWindowRect.top = totalRect.bottom + 2;
    newWindowRect.bottom = newWindowRect.top + 100;
  }
  return totalRect;
}

CWnd* CParameterViewWnd::getWndFor(const MNamedObjectPtr &obj) {
  CWndMap::iterator wndIt;
  CWnd *tabWindow = NULL;

  wndIt = windowList.find(obj);

  if (wndIt == windowList.end()) {
    // if we don't have a window already made. Create one, and populate it with the
    // custom windows

    // TODO: Make it so each plugin added is collapsable
    tabWindow = new CWnd();

    RECT rect;

    tabbedCtrl->GetClientRect(&rect);
    tabbedCtrl->AdjustRect(FALSE, &rect);

    tabWindow->Create(NULL, "emptyWindow", WS_CHILD, rect, tabbedCtrl, 0);
    CWndMap::iterator wndMapIt;
 
    wndMapIt = windowList.insert(CWndMap::value_type(obj, ParamGUI(tabWindow))).first;
  
    rect = addControlsForObject(tabWindow, obj, 0, wndMapIt);

    // Now we check to see if we have a scene object. If we do, then add the
    // GUI elements for the Shape for our scene object.
    MSceneObjectPtr sceneObj = AZTEC_CAST(MSceneObject, obj);
    if (sceneObj != NULL) {
      rect = addControlsForObject(tabWindow, sceneObj->getShapeObject(), rect.bottom+1, wndMapIt);
    }

  } else {
    tabWindow = wndIt->second.parentWnd;
  }

  return tabWindow;
}

void CParameterViewWnd::removeWndFor(const MNamedObjectPtr &obj) {
  CWndMap::iterator wndIt;
  CWnd *result = NULL;

  wndIt = windowList.find(obj);

  if (wndIt != windowList.end()) {
    wndIt->second.destroy();
    windowList.erase(wndIt);
  }
}



DWORD CParameterViewWnd::ViewPopupMenu(int x, int y)
{
   CMenu    Menu;
   CMenu    *Popup;
   DWORD    Choice;

   Menu.LoadMenu(IDR_SCENEOUTLINE_POPUP);
   Popup = Menu.GetSubMenu(0);
   InitPopupMenu(Popup);

   // Check the carious menu items depending on the current flags etc.

   Choice = Popup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON | TPM_NONOTIFY | TPM_RETURNCMD, x, y, this);

   Popup->DestroyMenu();

   bool     Update;
   int      Result;

   Result = HandlePopupCommand(Choice);

   // The command was handled, but the view was changed, so we must return.
   if (Result == -1)
      return 1;
      
   if (Result == 1) {
      Update = true;
   } else {
      Update = false;
   }

   if (Update) {
      DrawView();
   }
   
   return Choice;
}

int CParameterViewWnd::HandlePopupCommand(DWORD Cmd) {
   int Result;

   Result = MBaseViewWnd::HandlePopupCommand(Cmd);

   if (Result != 0) {
      return Result;
   }

   switch (Cmd) {
   }

   return 0;
}

void CParameterViewWnd::OnDestroy() {
  objectTabs.clear();
  tabObjects.clear();

  CWndMap::iterator wndIt;

  for (wndIt = windowList.begin(); wndIt != windowList.end(); ++wndIt) {
    wndIt->second.destroy();
  }
  windowList.clear();

  if (tabbedCtrl != NULL) {
    tabbedCtrl->DestroyWindow();
    delete tabbedCtrl;
    tabbedCtrl = NULL;
  }

 
  CWnd::OnDestroy();
}

void CParameterViewWnd::OnSize(UINT nType, int cx, int cy) 
{
  CWnd::OnSize(nType, cx, cy);
  
  RECT clientRect;
  
  GetClientRect(&clientRect);
  m_PopupRect = clientRect;
  
  if (tabbedCtrl != NULL) {
    tabbedCtrl->SetWindowPos(NULL, 0,0, clientRect.right, clientRect.bottom, SWP_NOZORDER | SWP_NOMOVE); 
    resizeToFitTab(getWndForTabIndex(tabbedCtrl->GetCurSel()));
  }

  DrawView();
  
}

void CParameterViewWnd::resizeToFitTab(CWnd *wnd) {
  if (wnd == NULL) {
    return;
  }

  RECT rect;
  
  tabbedCtrl->GetClientRect(&rect);
  tabbedCtrl->AdjustRect(FALSE, &rect);
  
  wnd->SetWindowPos(NULL, 
                    rect.left, rect.top, 
                    rect.right - rect.left, rect.bottom-rect.top,
                    SWP_NOZORDER | SWP_NOMOVE);
}


CWnd* CParameterViewWnd::getWndForTabIndex(int index) {
  TabObjMap::iterator tabIt = tabObjects.find(index);
  
  if (tabIt != tabObjects.end()) {
    return getWndFor(tabIt->second);
  }

  return NULL;
}

CParameterViewWnd::ParamGUI CParameterViewWnd::getParamGUIForTabIndex(int index) {
  TabObjMap::iterator tabIt = tabObjects.find(index);
  
  if (tabIt != tabObjects.end()) {
    CWndMap::iterator wndIt = windowList.find(tabIt->second);

    if (wndIt != windowList.end()) {
      return wndIt->second;
    }
  }

  return ParamGUI();
}

void CParameterViewWnd::showTab(int index, DWORD action) {
  CWnd *wnd = getWndForTabIndex(index);
    
  if (wnd != NULL) {
    if (action == SW_SHOW) {
      resizeToFitTab(wnd);
    }
    wnd->ShowWindow(action);
  }
}

BOOL CParameterViewWnd::OnNotify(WPARAM wParam, LPARAM lParam, LRESULT *pResult) {
  if (wParam == TabContrl_ID) {
    NMHDR *header = (NMHDR*)lParam;

    if (header->code == TCN_SELCHANGING) {
      showTab(tabbedCtrl->GetCurSel(), SW_HIDE);
      return TRUE;
    } else if (header->code == TCN_SELCHANGE) {
      showTab(tabbedCtrl->GetCurSel(), SW_SHOW);
      return TRUE;
    }
  }
  return FALSE;
}


