#include <BasicParamGUIPCH.h>

#include <LightShapePlugin.h>
#include <MMath.h>
#include <AztecGUIMPluginManager.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


LightShapePlugin::LightShapePlugin() {
  dlg = NULL;
}

LightShapePlugin::~LightShapePlugin() {
}


// MParameterPlugin methods
std::string LightShapePlugin::getFriendlyName() {
  return "Light Shape";
}

bool LightShapePlugin::isUIForObject(const Aztec::MBaseObjectPtr &obj) {
  return AZTEC_CAST(Aztec::MLight, obj) != NULL;
}

void LightShapePlugin::createControls(HWND parentWnd, const Aztec::MBaseObjectPtr &object) {
  lightShape = AZTEC_CAST(Aztec::MLight, object);

  // if we don't have a scene object, we shouldn't create anything.
  if (lightShape == NULL) {
    return;
  }

  CWnd *pWnd = CWnd::FromHandle(parentWnd);

  dlg = new CLightShapeDlg(pWnd);
  dlg->Create(CLightShapeDlg::IDD, pWnd);
  dlg->ShowWindow(SW_SHOW);

  RECT totalRect;
  dlg->GetClientRect(&totalRect);

  pWnd->SetWindowPos(NULL, 0, 0, totalRect.right, totalRect.bottom, SWP_NOZORDER | SWP_NOMOVE);
}

void LightShapePlugin::destroyControls() {
  if (dlg != NULL) {
    dlg->DestroyWindow();
    delete dlg;
    dlg = NULL;
  }
}

void LightShapePlugin::cancelChanges() {
}

void LightShapePlugin::updateGUIValues(const Aztec::MBaseObjectPtr &object) {
}

