// DomainEditDlg.cpp: implementation of the CDomainEditDlg class.
//
//////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "resource.h"

#include <stdlib.h>

#include "dialogs/DomainEditDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CDomainEditDlg::CDomainEditDlg() :
	x1(0.0f), y1(0.0f), z1(0.0f),
	x2(0.0f), y2(0.0f), z2(0.0f),
	x3(0.0f), y3(0.0f), z3(0.0f),
	r1(1.0f), r2(0.0f), stddev(1.0f),
	nx(0.0f), ny(1.0f), nz(0.0f)
{

}

CDomainEditDlg::~CDomainEditDlg()
{

}

void CDomainEditDlg::setEntriesFromParams(int startIndex, particleParamType &entries)
{
#if 0
	char buf[32];
	OutputDebugString("Params:\n");
	int j, numEntries = entries.size();
	for (j=startIndex;j<numEntries;j++) {
		sprintf(buf, "   %f\n", entries[j]);
		OutputDebugString(buf);
	}
#endif

	int i = startIndex;
	// TBD: write the code to enter dialog items from the parameters
	PDomainEnum domain = PDomainEnum((int)entries[i++]);
	m_Domain = domain;

	x1 = entries[i++]; y1 = entries[i++]; z1 = entries[i++];
	switch (domain) {
	case PDPoint:
		break;
	case PDLine:
		x2 = entries[i++]; y2 = entries[i++]; z2 = entries[i++];
		break;
	case PDTriangle:
		x2 = entries[i++]; y2 = entries[i++]; z2 = entries[i++];
		x3 = entries[i++]; y3 = entries[i++]; z3 = entries[i++];
		break;
	case PDPlane:
		nx = entries[i++]; ny = entries[i++]; nz = entries[i++];
		break;
	case PDBox:
		x2 = entries[i++]; y2 = entries[i++]; z2 = entries[i++];
		break;
	case PDSphere:
		r1 = entries[i++]; r2 = entries[i++];
		break;
	case PDCylinder:
		x2 = entries[i++]; y2 = entries[i++]; z2 = entries[i++];
		r1 = entries[i++]; r2 = entries[i++];
		break;
	case PDCone:
		x2 = entries[i++]; y2 = entries[i++]; z2 = entries[i++];
		r1 = entries[i++]; r2 = entries[i++];
		break;
	case PDBlob:
		stddev = entries[i++];
		break;
	case PDDisc:
		nx = entries[i++]; ny = entries[i++]; nz = entries[i++];
		r1 = entries[i++]; r2 = entries[i++];
		break;
	case PDRectangle:
		x2 = entries[i++]; y2 = entries[i++]; z2 = entries[i++];
		x3 = entries[i++]; y3 = entries[i++]; z3 = entries[i++];
		break;
	default:
		break;
	}

	// Put the member values into the edit controls
	setEditLayout(m_Domain);
}

void CDomainEditDlg::getParamsFromEntries(particleParamType &params)
{
	char buf[64];

	params.push_back((float)m_Domain);

	// Get first point/center
	GetDlgItemText(IDC_PARTICLE_X1_EDIT, buf, sizeof(buf));
	params.push_back((float)atof(buf));
	GetDlgItemText(IDC_PARTICLE_Y1_EDIT, buf, sizeof(buf));
	params.push_back((float)atof(buf));
	GetDlgItemText(IDC_PARTICLE_Z1_EDIT, buf, sizeof(buf));
	params.push_back((float)atof(buf));

	switch (m_Domain) {
	case PDPoint:
		break;
	case PDLine:
		GetDlgItemText(IDC_PARTICLE_X2_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_PARTICLE_Y2_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_PARTICLE_Z2_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		break;
	case PDTriangle:
		GetDlgItemText(IDC_PARTICLE_X2_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_PARTICLE_Y2_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_PARTICLE_Z2_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_PARTICLE_X3_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_PARTICLE_Y3_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_PARTICLE_Z3_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		break;
	case PDPlane:
		// Push normal
		GetDlgItemText(IDC_PARTICLE_X2_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_PARTICLE_Y2_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_PARTICLE_Z2_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		break;
	case PDBox:
		GetDlgItemText(IDC_PARTICLE_X2_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_PARTICLE_Y2_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_PARTICLE_Z2_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		break;
	case PDSphere:
		// Push Radii
		GetDlgItemText(IDC_PARTICLE_R1_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_PARTICLE_R2_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		break;
	case PDCylinder:
		GetDlgItemText(IDC_PARTICLE_X2_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_PARTICLE_Y2_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_PARTICLE_Z2_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		// Push Radii
		GetDlgItemText(IDC_PARTICLE_R1_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_PARTICLE_R2_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		break;
	case PDCone:
		// Push other endpoint
		GetDlgItemText(IDC_PARTICLE_X2_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_PARTICLE_Y2_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_PARTICLE_Z2_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		// Push Radii
		GetDlgItemText(IDC_PARTICLE_R1_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_PARTICLE_R2_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		break;
	case PDBlob:
		// Push standard deviation for blob
		GetDlgItemText(IDC_PARTICLE_R1_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		break;
	case PDDisc:
		// Push normal
		GetDlgItemText(IDC_PARTICLE_X2_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_PARTICLE_Y2_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_PARTICLE_Z2_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		// Push Radii
		GetDlgItemText(IDC_PARTICLE_R1_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_PARTICLE_R2_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		break;
	case PDRectangle:
		GetDlgItemText(IDC_PARTICLE_X2_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_PARTICLE_Y2_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_PARTICLE_Z2_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_PARTICLE_X3_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_PARTICLE_Y3_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_PARTICLE_Z3_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		break;
	default:
		OutputDebugString("Bad domain type in CDomainEditDlg\n");
		break;
	}
}

LRESULT CDomainEditDlg::OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	int index;

	index = SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_ADDSTRING, 0, (LPARAM)"Point");
	SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_SETITEMDATA, index, (LPARAM)PDPoint);
	index = SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_ADDSTRING, 0, (LPARAM)"Line");
	SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_SETITEMDATA, index, (LPARAM)PDLine);
	index = SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_ADDSTRING, 0, (LPARAM)"Triangle");
	SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_SETITEMDATA, index, (LPARAM)PDTriangle);
	index = SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_ADDSTRING, 0, (LPARAM)"Plane");
	SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_SETITEMDATA, index, (LPARAM)PDPlane);
	index = SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_ADDSTRING, 0, (LPARAM)"Box");
	SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_SETITEMDATA, index, (LPARAM)PDBox);
	index = SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_ADDSTRING, 0, (LPARAM)"Sphere");
	SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_SETITEMDATA, index, (LPARAM)PDSphere);
	index = SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_ADDSTRING, 0, (LPARAM)"Cylinder");
	SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_SETITEMDATA, index, (LPARAM)PDCylinder);
	index = SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_ADDSTRING, 0, (LPARAM)"Cone");
	SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_SETITEMDATA, index, (LPARAM)PDCone);
	index = SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_ADDSTRING, 0, (LPARAM)"Blob");
	SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_SETITEMDATA, index, (LPARAM)PDBlob);
	index = SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_ADDSTRING, 0, (LPARAM)"Disc");
	SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_SETITEMDATA, index, (LPARAM)PDDisc);
	index = SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_ADDSTRING, 0, (LPARAM)"Rectangle");
	SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_SETITEMDATA, index, (LPARAM)PDRectangle);

	SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_SELECTSTRING, -1, (LPARAM)"Point");
	m_Domain = PDPoint;

	// Hide the extra entries...
	::ShowWindow(GetDlgItem(IDC_SOURCE_EXTRA_GROUP), SW_HIDE);
	::ShowWindow(GetDlgItem(IDC_PARTICLE_KILL_INSIDE_CHECK), SW_HIDE);
	::ShowWindow(GetDlgItem(IDC_PARTICLE_EXTRA1_EDIT), SW_HIDE);
	::ShowWindow(GetDlgItem(IDC_PARTICLE_EXTRA2_EDIT), SW_HIDE);
	::ShowWindow(GetDlgItem(IDC_PARTICLE_EXTRA3_EDIT), SW_HIDE);

	// Untitle group boxes (except for the first point)
	SetDlgItemText(IDC_SOURCE_POINT2_GROUP, "Unused");
	SetDlgItemText(IDC_SOURCE_POINT3_GROUP, "Unused");
	SetDlgItemText(IDC_SOURCE_RADII_GROUP, "Unused");

	setEditLayout(m_Domain);

	return 0;
}

void CDomainEditDlg::setEditLayout(PDomainEnum domain)
{
	// Temp storage for building strings used in dialog fields.
	char buf[128];

	// Start by disabling everything except the first point (which is used for
	// all domain variations).
	// ::EnableWindow(GetDlgItem(IDC_ATTRIBUTE_SOURCE_COMBO), FALSE);
	// ::EnableWindow(GetDlgItem(IDC_PARTICLE_X1_EDIT), FALSE);
	// ::EnableWindow(GetDlgItem(IDC_PARTICLE_Y1_EDIT), FALSE);
	// ::EnableWindow(GetDlgItem(IDC_PARTICLE_Z1_EDIT), FALSE);
	::EnableWindow(GetDlgItem(IDC_PARTICLE_X2_EDIT), FALSE);
	::EnableWindow(GetDlgItem(IDC_PARTICLE_Y2_EDIT), FALSE);
	::EnableWindow(GetDlgItem(IDC_PARTICLE_Z2_EDIT), FALSE);
	::EnableWindow(GetDlgItem(IDC_PARTICLE_X3_EDIT), FALSE);
	::EnableWindow(GetDlgItem(IDC_PARTICLE_Y3_EDIT), FALSE);
	::EnableWindow(GetDlgItem(IDC_PARTICLE_Z3_EDIT), FALSE);
	::EnableWindow(GetDlgItem(IDC_PARTICLE_R1_EDIT), FALSE);
	::EnableWindow(GetDlgItem(IDC_PARTICLE_R2_EDIT), FALSE);

	// Clear out all numeric values
	SetDlgItemText(IDC_PARTICLE_X1_EDIT, "");
	SetDlgItemText(IDC_PARTICLE_Y1_EDIT, "");
	SetDlgItemText(IDC_PARTICLE_Z1_EDIT, "");
	SetDlgItemText(IDC_PARTICLE_X2_EDIT, "");
	SetDlgItemText(IDC_PARTICLE_Y2_EDIT, "");
	SetDlgItemText(IDC_PARTICLE_Z2_EDIT, "");
	SetDlgItemText(IDC_PARTICLE_X3_EDIT, "");
	SetDlgItemText(IDC_PARTICLE_Y3_EDIT, "");
	SetDlgItemText(IDC_PARTICLE_Z3_EDIT, "");
	SetDlgItemText(IDC_PARTICLE_R1_EDIT, "");
	SetDlgItemText(IDC_PARTICLE_R2_EDIT, "");

	// All variants use the first point so we just fill it in.
	SetDlgItemText(IDC_PARTICLE_X1_EDIT, _gcvt(x1, 7, buf));
	SetDlgItemText(IDC_PARTICLE_Y1_EDIT, _gcvt(y1, 7, buf));
	SetDlgItemText(IDC_PARTICLE_Z1_EDIT, _gcvt(z1, 7, buf));

	// Now enable based on what type of domain was chosen
	switch (domain) {
	case PDPoint: // Single point
		SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_SELECTSTRING, -1, (LPARAM)"Point");
		SetDlgItemText(IDC_SOURCE_POINT1_GROUP, "Point");
		break;
	case PDLine: // Line segment
		SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_SELECTSTRING, -1, (LPARAM)"Line");
		SetDlgItemText(IDC_SOURCE_POINT1_GROUP, "Point 1");
		SetDlgItemText(IDC_SOURCE_POINT2_GROUP, "Point 2");
		::EnableWindow(GetDlgItem(IDC_PARTICLE_X2_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_PARTICLE_Y2_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_PARTICLE_Z2_EDIT), TRUE);
		SetDlgItemText(IDC_PARTICLE_X2_EDIT, _gcvt(x2, 7, buf));
		SetDlgItemText(IDC_PARTICLE_Y2_EDIT, _gcvt(y2, 7, buf));
		SetDlgItemText(IDC_PARTICLE_Z2_EDIT, _gcvt(z2, 7, buf));
		break;
	case PDTriangle: // Triangle
		SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_SELECTSTRING, -1, (LPARAM)"Triangle");
		SetDlgItemText(IDC_SOURCE_POINT1_GROUP, "Point 1");
		SetDlgItemText(IDC_SOURCE_POINT2_GROUP, "Point 2");
		SetDlgItemText(IDC_SOURCE_POINT3_GROUP, "Point 3");
		::EnableWindow(GetDlgItem(IDC_PARTICLE_X2_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_PARTICLE_Y2_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_PARTICLE_Z2_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_PARTICLE_X3_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_PARTICLE_Y3_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_PARTICLE_Z3_EDIT), TRUE);
		SetDlgItemText(IDC_PARTICLE_X2_EDIT, _gcvt(x2, 7, buf));
		SetDlgItemText(IDC_PARTICLE_Y2_EDIT, _gcvt(y2, 7, buf));
		SetDlgItemText(IDC_PARTICLE_Z2_EDIT, _gcvt(z2, 7, buf));
		SetDlgItemText(IDC_PARTICLE_X3_EDIT, _gcvt(x3, 7, buf));
		SetDlgItemText(IDC_PARTICLE_Y3_EDIT, _gcvt(y3, 7, buf));
		SetDlgItemText(IDC_PARTICLE_Z3_EDIT, _gcvt(z3, 7, buf));
		break;
	case PDPlane: // Arbitrarily-oriented plane
		SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_SELECTSTRING, -1, (LPARAM)"Plane");
		SetDlgItemText(IDC_SOURCE_POINT1_GROUP, "Origin");
		SetDlgItemText(IDC_SOURCE_POINT2_GROUP, "Normal");
		::EnableWindow(GetDlgItem(IDC_PARTICLE_X2_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_PARTICLE_Y2_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_PARTICLE_Z2_EDIT), TRUE);
		SetDlgItemText(IDC_PARTICLE_X2_EDIT, _gcvt(nx, 7, buf));
		SetDlgItemText(IDC_PARTICLE_Y2_EDIT, _gcvt(ny, 7, buf));
		SetDlgItemText(IDC_PARTICLE_Z2_EDIT, _gcvt(nz, 7, buf));
		break;
	case PDBox: // Axis-aligned box
		SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_SELECTSTRING, -1, (LPARAM)"Box");
		SetDlgItemText(IDC_SOURCE_POINT1_GROUP, "Point 1");
		SetDlgItemText(IDC_SOURCE_POINT2_GROUP, "Point 2");
		::EnableWindow(GetDlgItem(IDC_PARTICLE_X2_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_PARTICLE_Y2_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_PARTICLE_Z2_EDIT), TRUE);
		SetDlgItemText(IDC_PARTICLE_X2_EDIT, _gcvt(x2, 7, buf));
		SetDlgItemText(IDC_PARTICLE_Y2_EDIT, _gcvt(y2, 7, buf));
		SetDlgItemText(IDC_PARTICLE_Z2_EDIT, _gcvt(z2, 7, buf));
		break;
	case PDSphere: // Sphere
		SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_SELECTSTRING, -1, (LPARAM)"Sphere");
		SetDlgItemText(IDC_SOURCE_POINT1_GROUP, "Center");
		SetDlgItemText(IDC_SOURCE_RADII_GROUP, "Radii");
		::EnableWindow(GetDlgItem(IDC_PARTICLE_R1_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_PARTICLE_R2_EDIT), TRUE);
		SetDlgItemText(IDC_PARTICLE_R1_EDIT, _gcvt(r1, 7, buf));
		SetDlgItemText(IDC_PARTICLE_R2_EDIT, _gcvt(r2, 7, buf));
		break;
	case PDCylinder: // Cylinder
		SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_SELECTSTRING, -1, (LPARAM)"Cylinder");
		SetDlgItemText(IDC_SOURCE_POINT1_GROUP, "Point 1");
		SetDlgItemText(IDC_SOURCE_POINT2_GROUP, "Point 2");
		SetDlgItemText(IDC_SOURCE_RADII_GROUP, "Radii");
		::EnableWindow(GetDlgItem(IDC_PARTICLE_X2_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_PARTICLE_Y2_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_PARTICLE_Z2_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_PARTICLE_R1_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_PARTICLE_R2_EDIT), TRUE);
		SetDlgItemText(IDC_PARTICLE_X2_EDIT, _gcvt(x2, 7, buf));
		SetDlgItemText(IDC_PARTICLE_Y2_EDIT, _gcvt(y2, 7, buf));
		SetDlgItemText(IDC_PARTICLE_Z2_EDIT, _gcvt(z2, 7, buf));
		SetDlgItemText(IDC_PARTICLE_R1_EDIT, _gcvt(r1, 7, buf));
		SetDlgItemText(IDC_PARTICLE_R2_EDIT, _gcvt(r2, 7, buf));
		break;
	case PDCone: // Cone
		SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_SELECTSTRING, -1, (LPARAM)"Cone");
		SetDlgItemText(IDC_SOURCE_POINT1_GROUP, "Point 1");
		SetDlgItemText(IDC_SOURCE_POINT2_GROUP, "Point 2");
		SetDlgItemText(IDC_SOURCE_RADII_GROUP, "Radii");
		::EnableWindow(GetDlgItem(IDC_PARTICLE_X2_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_PARTICLE_Y2_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_PARTICLE_Z2_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_PARTICLE_R1_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_PARTICLE_R2_EDIT), TRUE);
		SetDlgItemText(IDC_PARTICLE_X2_EDIT, _gcvt(x2, 7, buf));
		SetDlgItemText(IDC_PARTICLE_Y2_EDIT, _gcvt(y2, 7, buf));
		SetDlgItemText(IDC_PARTICLE_Z2_EDIT, _gcvt(z2, 7, buf));
		SetDlgItemText(IDC_PARTICLE_R1_EDIT, _gcvt(r1, 7, buf));
		SetDlgItemText(IDC_PARTICLE_R2_EDIT, _gcvt(r2, 7, buf));
		break;
	case PDBlob: // Gaussian blob
		SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_SELECTSTRING, -1, (LPARAM)"Blob");
		SetDlgItemText(IDC_SOURCE_POINT1_GROUP, "Center");
		SetDlgItemText(IDC_SOURCE_RADII_GROUP, "Standard Deviation");
		::EnableWindow(GetDlgItem(IDC_PARTICLE_R1_EDIT), TRUE);
		SetDlgItemText(IDC_PARTICLE_R1_EDIT, _gcvt(stddev, 7, buf));
		break;
	case PDDisc: // Arbitrarily-oriented disc
		SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_SELECTSTRING, -1, (LPARAM)"Disc");
		SetDlgItemText(IDC_SOURCE_POINT1_GROUP, "Center");
		SetDlgItemText(IDC_SOURCE_POINT2_GROUP, "Normal");
		SetDlgItemText(IDC_SOURCE_RADII_GROUP, "Radii");
		::EnableWindow(GetDlgItem(IDC_PARTICLE_X2_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_PARTICLE_Y2_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_PARTICLE_Z2_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_PARTICLE_R1_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_PARTICLE_R2_EDIT), TRUE);
		SetDlgItemText(IDC_PARTICLE_X2_EDIT, _gcvt(nx, 7, buf));
		SetDlgItemText(IDC_PARTICLE_Y2_EDIT, _gcvt(ny, 7, buf));
		SetDlgItemText(IDC_PARTICLE_Z2_EDIT, _gcvt(nz, 7, buf));
		SetDlgItemText(IDC_PARTICLE_R1_EDIT, _gcvt(r1, 7, buf));
		SetDlgItemText(IDC_PARTICLE_R2_EDIT, _gcvt(r2, 7, buf));
		break;
	case PDRectangle: // Rhombus-shaped planar region
		SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_SELECTSTRING, -1, (LPARAM)"Rectangle");
		SetDlgItemText(IDC_SOURCE_POINT1_GROUP, "Point 1");
		SetDlgItemText(IDC_SOURCE_POINT2_GROUP, "U Basis Vector");
		SetDlgItemText(IDC_SOURCE_POINT2_GROUP, "V Basis Vector");
		::EnableWindow(GetDlgItem(IDC_PARTICLE_X2_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_PARTICLE_Y2_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_PARTICLE_Z2_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_PARTICLE_X3_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_PARTICLE_Y3_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_PARTICLE_Z3_EDIT), TRUE);
		SetDlgItemText(IDC_PARTICLE_X2_EDIT, _gcvt(x2, 7, buf));
		SetDlgItemText(IDC_PARTICLE_Y2_EDIT, _gcvt(y2, 7, buf));
		SetDlgItemText(IDC_PARTICLE_Z2_EDIT, _gcvt(z2, 7, buf));
		SetDlgItemText(IDC_PARTICLE_X3_EDIT, _gcvt(x3, 7, buf));
		SetDlgItemText(IDC_PARTICLE_Y3_EDIT, _gcvt(y3, 7, buf));
		SetDlgItemText(IDC_PARTICLE_Z3_EDIT, _gcvt(z3, 7, buf));
		break;
	default:
		break;
	}
}

LRESULT CDomainEditDlg::OnComboChange(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
	int curSel = SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_GETCURSEL);

	// What is the desired shape? (We cached the appropriate enum values in the data part
	// of the combo box entries.)
	int dval = SendDlgItemMessage(IDC_ATTRIBUTE_SOURCE_COMBO, CB_GETITEMDATA, curSel, (LPARAM)0);

	m_Domain = (PDomainEnum)dval;

	setEditLayout(m_Domain);

	return 0;
}

