// ParticleBounceEditDlg.cpp: implementation of the CParticleBounceEditDlg class.
//
//////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "resource.h"

#include <stdlib.h>

#include "dialogs/ParticleBounceEditDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CParticleBounceEditDlg::CParticleBounceEditDlg() :
	CDomainEditDlg(),
	friction(-0.05f),
	resilience(0.35f),
	cutoff(0.0f)
{

}

CParticleBounceEditDlg::~CParticleBounceEditDlg()
{

}

void CParticleBounceEditDlg::setEntriesFromParams(int startIndex, particleParamType &entries)
{
#if 0
	char buf[32];
	OutputDebugString("Params:\n");
	int j, numEntries = entries.size();
	for (j=0;j<numEntries;j++) {
		sprintf(buf, "   %f\n", entries[j]);
		OutputDebugString(buf);
	}
#endif

	int i = 0;
	// Pull the bounce specific parameters
	friction = entries[i++];
	resilience = entries[i++];
	cutoff = entries[i++];

	CDomainEditDlg::setEntriesFromParams(i, entries);

	// Put the member values into the edit controls
	setEditLayout(m_Domain);
}

void CParticleBounceEditDlg::getParamsFromEntries(particleParamType &params)
{
	char buf[64];

	// Get the bounce specific parameters
	GetDlgItemText(IDC_PARTICLE_EXTRA1_EDIT, buf, sizeof(buf));
	params.push_back((float)atof(buf));
	GetDlgItemText(IDC_PARTICLE_EXTRA2_EDIT, buf, sizeof(buf));
	params.push_back((float)atof(buf));
	GetDlgItemText(IDC_PARTICLE_EXTRA3_EDIT, buf, sizeof(buf));
	params.push_back((float)atof(buf));

	// Get the generic domain parameters
	CDomainEditDlg::getParamsFromEntries(params);
}

LRESULT CParticleBounceEditDlg::OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	CDomainEditDlg::OnInitDialog(uMsg, wParam, lParam, bHandled);

	::ShowWindow(GetDlgItem(IDC_SOURCE_EXTRA_GROUP), SW_SHOW);
	SetDlgItemText(IDC_SOURCE_EXTRA_GROUP, "Friction/Resilience/Cutoff");
	::ShowWindow(GetDlgItem(IDC_PARTICLE_EXTRA1_EDIT), SW_SHOW);
	::ShowWindow(GetDlgItem(IDC_PARTICLE_EXTRA2_EDIT), SW_SHOW);
	::ShowWindow(GetDlgItem(IDC_PARTICLE_EXTRA3_EDIT), SW_SHOW);

	return 0;
}

void CParticleBounceEditDlg::setEditLayout(PDomainEnum domain)
{
	CDomainEditDlg::setEditLayout(domain);

	char buf[32];
	SetDlgItemText(IDC_PARTICLE_EXTRA1_EDIT, _gcvt(friction, 7, buf));
	SetDlgItemText(IDC_PARTICLE_EXTRA2_EDIT, _gcvt(resilience, 7, buf));
	SetDlgItemText(IDC_PARTICLE_EXTRA3_EDIT, _gcvt(cutoff, 7, buf));
}
