// ParticleColorEditDlg.cpp: implementation of the CParticleColorEditDlg class.
//
//////////////////////////////////////////////////////////////////////
#include "stdafx.h"
#include "resource.h"

#include "dialogs/ParticleColorEditDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CParticleColorEditDlg::CParticleColorEditDlg(float ir, float ig, float ib, float ia) :
	r1(ir), g1(ig), b1(ib), alpha(ia)
{
	// Less commonly used colors (for line/triangle) are set to white
	r2 = g2 = b2 = 1.0;
	r3 = g3 = b3 = 1.0;

	// By default we use a point domain for colors.
	m_Domain = PDPoint;

	// No custom colors defined yet.
	memset(m_customColors, 0xFFFF, sizeof(m_customColors));
}

CParticleColorEditDlg::~CParticleColorEditDlg()
{
}

void CParticleColorEditDlg::setEntriesFromParams(int startIndex, particleParamType &entries)
{
	int i = startIndex;

	PDomainEnum domain = PDomainEnum((int)entries[i++]);
	m_Domain = domain;

	switch (domain) {
	case PDPoint:
		alpha = entries[i++];
		r1 = entries[i++]; g1 = entries[i++]; b1 = entries[i++];
		r2 = g2 = b2 = 1.0;
		r3 = g3 = b3 = 1.0;
		break;
	case PDLine:
		alpha = entries[i++];
		r1 = entries[i++]; g1 = entries[i++]; b1 = entries[i++];
		r2 = entries[i++]; g2 = entries[i++]; b2 = entries[i++];
		r3 = g3 = b3 = 1.0;
		break;
	case PDTriangle:
		alpha = entries[i++];
		r1 = entries[i++]; g1 = entries[i++]; b1 = entries[i++];
		r2 = entries[i++]; g2 = entries[i++]; b2 = entries[i++];
		r3 = entries[i++]; g3 = entries[i++]; b3 = entries[i++];
		break;
	case PDDisc:
		break;
	default:
		break;
	}

	// Put the member values into the edit controls
	setEditLayout(m_Domain);
}

void CParticleColorEditDlg::getParamsFromEntries(particleParamType &params)
{
	char buf[32];
	params.push_back((float)m_Domain);

	// Push the alpha value
	GetDlgItemText(IDC_ALPHA_COLOR_EDIT, buf, sizeof(buf));
	params.push_back((float)atof(buf));

	// Get first color (always used)
	GetDlgItemText(IDC_RED1_COLOR_EDIT, buf, sizeof(buf));
	params.push_back((float)atof(buf));
	GetDlgItemText(IDC_GREEN1_COLOR_EDIT, buf, sizeof(buf));
	params.push_back((float)atof(buf));
	GetDlgItemText(IDC_BLUE1_COLOR_EDIT, buf, sizeof(buf));
	params.push_back((float)atof(buf));

	switch (m_Domain) {
	case PDPoint:
		break;
	case PDLine:
		GetDlgItemText(IDC_RED2_COLOR_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_GREEN2_COLOR_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_BLUE2_COLOR_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		break;
	case PDTriangle:
		GetDlgItemText(IDC_RED2_COLOR_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_GREEN2_COLOR_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_BLUE2_COLOR_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_RED3_COLOR_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_GREEN3_COLOR_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		GetDlgItemText(IDC_BLUE3_COLOR_EDIT, buf, sizeof(buf));
		params.push_back((float)atof(buf));
		break;
	default:
		OutputDebugString("Bad domain type in CParticleColorEditDlg\n");
		break;
	}
}

LRESULT CParticleColorEditDlg::OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	// Get 
	int index;
	index = SendDlgItemMessage(IDC_COLOR_DOMAIN_COMBO, CB_ADDSTRING, 0, (LPARAM)"Point");
	SendDlgItemMessage(IDC_COLOR_DOMAIN_COMBO, CB_SETITEMDATA, index, (LPARAM)PDPoint);
	index = SendDlgItemMessage(IDC_COLOR_DOMAIN_COMBO, CB_ADDSTRING, 0, (LPARAM)"Line");
	SendDlgItemMessage(IDC_COLOR_DOMAIN_COMBO, CB_SETITEMDATA, index, (LPARAM)PDLine);
	index = SendDlgItemMessage(IDC_COLOR_DOMAIN_COMBO, CB_ADDSTRING, 0, (LPARAM)"Triangle");
	SendDlgItemMessage(IDC_COLOR_DOMAIN_COMBO, CB_SETITEMDATA, index, (LPARAM)PDTriangle);
	// index = SendDlgItemMessage(IDC_COLOR_DOMAIN_COMBO, CB_ADDSTRING, 0, (LPARAM)"Disc");
	// SendDlgItemMessage(IDC_COLOR_DOMAIN_COMBO, CB_SETITEMDATA, index, (LPARAM)PDDisc);

	SendDlgItemMessage(IDC_ALPHA_SLIDER, TBM_SETRANGE, TRUE, (LPARAM)MAKELONG(0, 1000));
	SendDlgItemMessage(IDC_ALPHA_SLIDER, TBM_SETTICFREQ, 100, 0);
	// SendDlgItemMessage(IDC_ALPHA_SLIDER, TBM_SETBUDDY, FALSE, (LPARAM)(HWND)GetDlgItem(IDC_ALPHA_COLOR_EDIT));

	SendDlgItemMessage(IDC_COLOR_DOMAIN_COMBO, CB_SELECTSTRING, -1, (LPARAM)"Point");
	// ::EnableWindow(GetDlgItem(IDC_COLOR_DOMAIN_COMBO), FALSE);

	// Untitle group boxes (except for the first color)
	SetDlgItemText(IDC_COLOR2_GROUP, "Unused");
	SetDlgItemText(IDC_COLOR3_GROUP, "Unused");

	setEditLayout(m_Domain);

	return 0;
}


void CParticleColorEditDlg::setEditLayout(PDomainEnum domain)
{
	// Temp storage for building strings used in dialog fields.
	char buf[128];

	// Start by disabling everything except the first color (which is used for
	// all domain variations).
	::EnableWindow(GetDlgItem(IDC_RED2_COLOR_EDIT), FALSE);
	::EnableWindow(GetDlgItem(IDC_GREEN2_COLOR_EDIT), FALSE);
	::EnableWindow(GetDlgItem(IDC_BLUE2_COLOR_EDIT), FALSE);
	::EnableWindow(GetDlgItem(IDC_CHOOSE_COLOR2_BUTTON), FALSE);
	::EnableWindow(GetDlgItem(IDC_RED3_COLOR_EDIT), FALSE);
	::EnableWindow(GetDlgItem(IDC_GREEN3_COLOR_EDIT), FALSE);
	::EnableWindow(GetDlgItem(IDC_BLUE3_COLOR_EDIT), FALSE);
	::EnableWindow(GetDlgItem(IDC_CHOOSE_COLOR3_BUTTON), FALSE);

	// Clear out all numeric values
	SetDlgItemText(IDC_RED1_COLOR_EDIT, "");
	SetDlgItemText(IDC_GREEN1_COLOR_EDIT, "");
	SetDlgItemText(IDC_BLUE1_COLOR_EDIT, "");
	SetDlgItemText(IDC_RED2_COLOR_EDIT, "");
	SetDlgItemText(IDC_GREEN2_COLOR_EDIT, "");
	SetDlgItemText(IDC_BLUE2_COLOR_EDIT, "");
	SetDlgItemText(IDC_RED3_COLOR_EDIT, "");
	SetDlgItemText(IDC_GREEN3_COLOR_EDIT, "");
	SetDlgItemText(IDC_BLUE3_COLOR_EDIT, "");

	// All variants use the first color so we just fill it in.
	SetDlgItemText(IDC_RED1_COLOR_EDIT, _gcvt(r1, 7, buf));
	SetDlgItemText(IDC_GREEN1_COLOR_EDIT, _gcvt(g1, 7, buf));
	SetDlgItemText(IDC_BLUE1_COLOR_EDIT, _gcvt(b1, 7, buf));
	SetDlgItemText(IDC_ALPHA_COLOR_EDIT, _gcvt(alpha, 7, buf));

	// Now enable based on what type of domain was chosen
	switch (m_Domain) {
	case PDPoint: // Single point
		SendDlgItemMessage(IDC_COLOR_DOMAIN_COMBO, CB_SELECTSTRING, -1, (LPARAM)"Point");
		SetDlgItemText(IDC_COLOR1_GROUP, "Point");
		break;
	case PDLine: // Line segment
		SendDlgItemMessage(IDC_COLOR_DOMAIN_COMBO, CB_SELECTSTRING, -1, (LPARAM)"Line");
		SetDlgItemText(IDC_COLOR1_GROUP, "Point 1");
		SetDlgItemText(IDC_COLOR2_GROUP, "Point 2");
		::EnableWindow(GetDlgItem(IDC_RED2_COLOR_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_GREEN2_COLOR_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_BLUE2_COLOR_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_CHOOSE_COLOR2_BUTTON), TRUE);
		SetDlgItemText(IDC_RED2_COLOR_EDIT, _gcvt(r2, 7, buf));
		SetDlgItemText(IDC_GREEN2_COLOR_EDIT, _gcvt(g2, 7, buf));
		SetDlgItemText(IDC_BLUE2_COLOR_EDIT, _gcvt(b2, 7, buf));
		break;
	case PDTriangle: // Triangle
		SendDlgItemMessage(IDC_COLOR_DOMAIN_COMBO, CB_SELECTSTRING, -1, (LPARAM)"Triangle");
		SetDlgItemText(IDC_COLOR1_GROUP, "Point 1");
		SetDlgItemText(IDC_COLOR2_GROUP, "Point 2");
		SetDlgItemText(IDC_COLOR3_GROUP, "Point 3");
		::EnableWindow(GetDlgItem(IDC_RED2_COLOR_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_GREEN2_COLOR_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_BLUE2_COLOR_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_CHOOSE_COLOR2_BUTTON), TRUE);
		::EnableWindow(GetDlgItem(IDC_RED3_COLOR_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_GREEN3_COLOR_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_BLUE3_COLOR_EDIT), TRUE);
		::EnableWindow(GetDlgItem(IDC_CHOOSE_COLOR3_BUTTON), TRUE);
		SetDlgItemText(IDC_RED2_COLOR_EDIT, _gcvt(r2, 7, buf));
		SetDlgItemText(IDC_GREEN2_COLOR_EDIT, _gcvt(g2, 7, buf));
		SetDlgItemText(IDC_BLUE2_COLOR_EDIT, _gcvt(b2, 7, buf));
		SetDlgItemText(IDC_RED3_COLOR_EDIT, _gcvt(r3, 7, buf));
		SetDlgItemText(IDC_GREEN3_COLOR_EDIT, _gcvt(g3, 7, buf));
		SetDlgItemText(IDC_BLUE3_COLOR_EDIT, _gcvt(b3, 7, buf));
		break;
	default:
		// Default to single color particles
		SendDlgItemMessage(IDC_COLOR_DOMAIN_COMBO, CB_SELECTSTRING, -1, (LPARAM)"Point");
		SetDlgItemText(IDC_COLOR1_GROUP, "Point");
		break;
	}
}
LRESULT CParticleColorEditDlg::OnBnClickedChooseColor1Button(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	CHOOSECOLOR colorStruct;
	memset(&colorStruct, 0, sizeof(CHOOSECOLOR));
	colorStruct.lStructSize  = sizeof(CHOOSECOLOR);
	colorStruct.hwndOwner    = m_hWnd;
	colorStruct.lpCustColors = m_customColors;
	colorStruct.rgbResult    = RGB(getIntRed1(), getIntGreen1(), getIntBlue1());
	colorStruct.Flags        = CC_ANYCOLOR | CC_RGBINIT;

	if (SUCCEEDED(ChooseColor(&colorStruct))) {
		r1 = (float)GetRValue(colorStruct.rgbResult) / 255.0f;
		g1 = (float)GetGValue(colorStruct.rgbResult) / 255.0f;
		b1 = (float)GetBValue(colorStruct.rgbResult) / 255.0f;

		// Update the text representation of the color
		char buf[32];
		sprintf(buf, "%7.3f", r1);
		SetDlgItemText(IDC_RED1_COLOR_EDIT, buf);
		sprintf(buf, "%7.3f", g1);
		SetDlgItemText(IDC_GREEN1_COLOR_EDIT, buf);
		sprintf(buf, "%7.3f", b1);
		SetDlgItemText(IDC_BLUE1_COLOR_EDIT, buf);

		::InvalidateRect(GetDlgItem(IDC_CHOOSE_COLOR1_BUTTON), NULL, FALSE);
	}

	return 0;
}

LRESULT CParticleColorEditDlg::OnBnClickedChooseColor2Button(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	CHOOSECOLOR colorStruct;
	memset(&colorStruct, 0, sizeof(CHOOSECOLOR));
	colorStruct.lStructSize  = sizeof(CHOOSECOLOR);
	colorStruct.hwndOwner    = m_hWnd;
	colorStruct.lpCustColors = m_customColors;
	colorStruct.rgbResult    = RGB(getIntRed2(), getIntGreen2(), getIntBlue2());
	colorStruct.Flags        = CC_ANYCOLOR | CC_RGBINIT;

	if (SUCCEEDED(ChooseColor(&colorStruct))) {
		r2 = (float)GetRValue(colorStruct.rgbResult) / 255.0f;
		g2 = (float)GetGValue(colorStruct.rgbResult) / 255.0f;
		b2 = (float)GetBValue(colorStruct.rgbResult) / 255.0f;

		// Update the text representation of the color
		char buf[32];
		sprintf(buf, "%7.3f", r2);
		SetDlgItemText(IDC_RED2_COLOR_EDIT, buf);
		sprintf(buf, "%7.3f", g2);
		SetDlgItemText(IDC_GREEN2_COLOR_EDIT, buf);
		sprintf(buf, "%7.3f", b2);
		SetDlgItemText(IDC_BLUE2_COLOR_EDIT, buf);

		::InvalidateRect(GetDlgItem(IDC_CHOOSE_COLOR2_BUTTON), NULL, FALSE);
	}

	return 0;
}

LRESULT CParticleColorEditDlg::OnBnClickedChooseColor3Button(WORD /*wNotifyCode*/, WORD /*wID*/, HWND /*hWndCtl*/, BOOL& /*bHandled*/)
{
	CHOOSECOLOR colorStruct;
	memset(&colorStruct, 0, sizeof(CHOOSECOLOR));
	colorStruct.lStructSize  = sizeof(CHOOSECOLOR);
	colorStruct.hwndOwner    = m_hWnd;
	colorStruct.lpCustColors = m_customColors;
	colorStruct.rgbResult    = RGB(getIntRed3(), getIntGreen3(), getIntBlue3());
	colorStruct.Flags        = CC_ANYCOLOR | CC_RGBINIT;

	if (SUCCEEDED(ChooseColor(&colorStruct))) {
		r3 = (float)GetRValue(colorStruct.rgbResult) / 255.0f;
		g3 = (float)GetGValue(colorStruct.rgbResult) / 255.0f;
		b3 = (float)GetBValue(colorStruct.rgbResult) / 255.0f;

		// Update the text representation of the color
		char buf[32];
		sprintf(buf, "%7.3f", r3);
		SetDlgItemText(IDC_RED3_COLOR_EDIT, buf);
		sprintf(buf, "%7.3f", g3);
		SetDlgItemText(IDC_GREEN3_COLOR_EDIT, buf);
		sprintf(buf, "%7.3f", b3);
		SetDlgItemText(IDC_BLUE3_COLOR_EDIT, buf);

		::InvalidateRect(GetDlgItem(IDC_CHOOSE_COLOR3_BUTTON), NULL, FALSE);
	}

	return 0;
}

LRESULT CParticleColorEditDlg::OnDrawItem(UINT /*uMsg*/, WPARAM wParam, LPARAM lParam, BOOL& /*bHandled*/)
{
	int dlgItem = (int)wParam;
	if (dlgItem == IDC_CHOOSE_COLOR1_BUTTON) {
		DRAWITEMSTRUCT *drawItemPtr = (DRAWITEMSTRUCT *)lParam;
		UINT uStyle = DFCS_BUTTONPUSH;

		// If drawing selected, add the pushed style to DrawFrameControl.
		if (drawItemPtr->itemState & ODS_SELECTED)
			uStyle |= DFCS_PUSHED;

		// Compute a rectangle within the button by taking the client area and squashing a little.
		RECT rect;
		HWND btnWnd = GetDlgItem(dlgItem);
		::GetClientRect(btnWnd, &rect);
		InflateRect(&rect, -4, -4);

		// Draw the button frame as if it were a normal button
		::DrawFrameControl(drawItemPtr->hDC, &drawItemPtr->rcItem, DFC_BUTTON, uStyle);

		// Draw a rectangle within the button, using the currently selected color
		HBRUSH greenBrush = CreateSolidBrush(RGB(r1*255, g1*255, b1*255));
		FillRect(drawItemPtr->hDC, &rect, greenBrush);
		DeleteObject(greenBrush);
	} else if (dlgItem == IDC_CHOOSE_COLOR2_BUTTON) {
		DRAWITEMSTRUCT *drawItemPtr = (DRAWITEMSTRUCT *)lParam;
		UINT uStyle = DFCS_BUTTONPUSH;

		// If drawing selected, add the pushed style to DrawFrameControl.
		if (drawItemPtr->itemState & ODS_SELECTED)
			uStyle |= DFCS_PUSHED;

		// Compute a rectangle within the button by taking the client area and squashing a little.
		RECT rect;
		HWND btnWnd = GetDlgItem(dlgItem);
		::GetClientRect(btnWnd, &rect);
		InflateRect(&rect, -4, -4);

		// Draw the button frame as if it were a normal button
		::DrawFrameControl(drawItemPtr->hDC, &drawItemPtr->rcItem, DFC_BUTTON, uStyle);

		// Draw a rectangle within the button, using the currently selected color
		HBRUSH greenBrush = CreateSolidBrush(RGB(r2*255, g2*255, b2*255));
		FillRect(drawItemPtr->hDC, &rect, greenBrush);
		DeleteObject(greenBrush);
	} else if (dlgItem == IDC_CHOOSE_COLOR3_BUTTON) {
		DRAWITEMSTRUCT *drawItemPtr = (DRAWITEMSTRUCT *)lParam;
		UINT uStyle = DFCS_BUTTONPUSH;

		// If drawing selected, add the pushed style to DrawFrameControl.
		if (drawItemPtr->itemState & ODS_SELECTED)
			uStyle |= DFCS_PUSHED;

		// Compute a rectangle within the button by taking the client area and squashing a little.
		RECT rect;
		HWND btnWnd = GetDlgItem(dlgItem);
		::GetClientRect(btnWnd, &rect);
		InflateRect(&rect, -4, -4);

		// Draw the button frame as if it were a normal button
		::DrawFrameControl(drawItemPtr->hDC, &drawItemPtr->rcItem, DFC_BUTTON, uStyle);

		// Draw a rectangle within the button, using the currently selected color
		HBRUSH greenBrush = CreateSolidBrush(RGB(r3*255, g3*255, b3*255));
		FillRect(drawItemPtr->hDC, &rect, greenBrush);
		DeleteObject(greenBrush);
	}

	return 0;
}


LRESULT CParticleColorEditDlg::OnComboChange(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
	int curSel = SendDlgItemMessage(IDC_COLOR_DOMAIN_COMBO, CB_GETCURSEL);

	// What is the desired shape? (We cached the appropriate enum values in the data part
	// of the combo box entries.)
	int dval = SendDlgItemMessage(IDC_COLOR_DOMAIN_COMBO, CB_GETITEMDATA, curSel, (LPARAM)0);

	m_Domain = (PDomainEnum)dval;

	setEditLayout(m_Domain);

	return 0;
}

