#include "stdafx.h"
#include "dialogs\particlekillolddlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif
CParticleKillOldDlg::CParticleKillOldDlg(void) :
	age_limit(100000.0),
	kill_less_than(false)
{
}

CParticleKillOldDlg::~CParticleKillOldDlg(void)
{
}

void CParticleKillOldDlg::setEntriesFromMembers()
{
	char buf[32];
	sprintf(buf, "%7.3f", age_limit);
	SetDlgItemText(IDC_KILL_OLD_AGE_LIMIT_EDIT, buf);

	if (kill_less_than) {
		CheckDlgButton(IDC_KILL_OLD_LESS_THAN_CHECK, BST_CHECKED);
	} else {
		CheckDlgButton(IDC_KILL_OLD_LESS_THAN_CHECK, BST_UNCHECKED);
	}
}

void CParticleKillOldDlg::setEntriesFromParams(int startIndex, particleParamType &params)
{
	int i = startIndex;

	age_limit = params[i++];
	kill_less_than = (params[i++] == 0.0 ? false : true);

	setEntriesFromMembers();
}

void CParticleKillOldDlg::getParamsFromEntries(particleParamType &params)
{
	char buf[32];
	GetDlgItemText(IDC_KILL_OLD_AGE_LIMIT_EDIT, buf, sizeof(buf));
	params.push_back((float)atof(buf));
	params.push_back((IsDlgButtonChecked(IDC_KILL_OLD_LESS_THAN_CHECK) == BST_CHECKED ? 1.0f : 0.0f));
}

LRESULT CParticleKillOldDlg::OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
	setEntriesFromMembers();

	return 0;
}

