
#ifndef LIFTRANSLATOR_H
#define LIFTRANSLATOR_H

#include <translator/MImageTranslator.h>


using namespace Aztec;



class MLIFTranslator : public MImageTranslator {
protected:

public:
   MLIFTranslator();
   virtual ~MLIFTranslator();

   // Class related
   virtual MStr getClassName() {return MStr("MLIFTranslator");};
   virtual MStr getParentClassName() {return MStr("MImageTranslator");};
   virtual MTranslatorPtr createNew() const;

   std::string getFilter() { return "*.LIF"; }
   std::string getFilterDescription() { return "Layered Image Format"; }
   virtual bool canImport() {return true;};
   virtual bool canExport() {return false;};
   virtual bool canImportFile(MStr Filename);

   virtual bool importFile(MStr Filename, MImagePtr Image);
   virtual bool exportFile(MStr Filename, MImagePtr Image);
};


#endif
