#ifndef WALTRANSLATOR_H
#define WALTRANSLATOR_H

#include <translator/MImageTranslator.h>


using namespace Aztec;



class MWALTranslator : public MImageTranslator {
protected:

public:
   MWALTranslator();
   virtual ~MWALTranslator();

   // Class related
   virtual MStr getClassName() {return MStr("MWALTranslator");};
   virtual MStr getParentClassName() {return MStr("MImageTranslator");};
   virtual MTranslatorPtr createNew() const;

   std::string getFilter() { return "*.WAL"; }
   std::string getFilterDescription() { return "Quake2 Textures"; }
   virtual bool canImport() {return true;};
   virtual bool canExport() {return false;};
   virtual bool canImportFile(MStr Filename);

   virtual bool importFile(MStr Filename, MImagePtr Image);
   virtual bool exportFile(MStr Filename, MImagePtr Image);
};


#endif
