#include "StdAfx.h"
#include "MD2Translator.h"

#include "MBaseObject.h"
#include "MSystemManager.h"
#include "MAnimMesh.h"
#include "DevilTranslator.h"
#include "MMeshShape.h"
#include "HelperFuncs.h"


#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <assert.h>
#include <string.h>


#if defined( _DEBUG ) && defined( _MSC_VER )
// Memory leak detection for MS compiler
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//Linux does not support strcmpi, so we define it to it's Linux counter-part
#ifndef WIN32
#define strcmpi(x,y) strcasecmp(x,y)
#endif


MMD2Translator::MMD2Translator()
{
}

MMD2Translator::~MMD2Translator()
{
}

// Class related
MTranslatorPtr MMD2Translator::createNew() const {
  MMD2Translator   *NewTranslator;
  
  NewTranslator = new MMD2Translator;
  
  return NewTranslator;
}

bool MMD2Translator::canImportFile(MStr Filename) {
  MMD2Header  Head;
  
  FILE *hFile;
  
  Filename.Replace('/', '\\');
  hFile = fopen(Filename, "rb");
  
  if (!hFile)
    return false;
  
  fread(&Head,sizeof(MMD2Header),1,hFile);
  
  if (Head.id != MD2_IDALIASHEADER || Head.version != MD2_ALIAS_VERSION)
  {
    fclose(hFile);
    return false;
  }
  
  fclose(hFile);
  
  return true;
}

bool MMD2Translator::importFile(MStr Filename, MScenePtr Scene) {
	MSystemManagerPtr SysMan;
	MMD2Header        Head;
	FILE              *hFile;
    int				  n;
	MAnimMeshPtr Mesh;
	MEditableMeshPtr SkinMesh;
	MTriangle *NewTris, *SkinTris;
	MMaterialPtr SkinMaterial;
	MStr MasterObjName;
	
	char              SkinNames[MD2_MAX_MD2SKINS][MD2_MAX_SKINNAME];
	
	SysMan = Aztec::getSystemManager();
	assert(SysMan != NULL);
	
	Filename.Replace('/', '\\');
	
	hFile = fopen(Filename,"rb");
	
	if (!hFile)
		return false;
	
	fread(&Head,sizeof(MMD2Header),1,hFile);
	
	if (Head.id != MD2_IDALIASHEADER || Head.version != MD2_ALIAS_VERSION)
	{
		fclose(hFile);
		return false;
	}
	
	{
		char  JustName[256];
		// If the filename is tris.md2, then get the object name from the directory we are in.
		MSplitPath(Filename, NULL, NULL, JustName, NULL);
		if (strcmpi("tris", JustName) != 0)
		{
			MasterObjName = JustName;
		}
		else
		{
			// Get the name of the object from the directory structure. For quake2 models its normally the
			// the directory that the model is in.
			char  TempName[256], *Str;
			int   SlashesFound = 0;
			
			strcpy(TempName, (LPCTSTR)Filename);
			Str = TempName + strlen(TempName);
			
			while (Str > TempName)
			{
				if (*Str == '\\')
				{
					SlashesFound ++;
					*Str = '\x0';
					if (SlashesFound == 2)
						break;
				}
				Str--;
			}
			
			// We are now at a null character if it was a alsh. Move forward if it is.
			if (*Str == '\x0')
				Str++;
			
			// Str will now contain the current directory.
			MasterObjName = Str;
		}
	}
	
	
	Mesh = new MAnimMesh;
	NewTris = new MTriangle[Head.num_tris];
	SkinTris = new MTriangle[Head.num_tris];
	SkinMesh = new MEditableMesh;
	
	SkinMaterial = NULL;
	
	
	// Read in the skin names
	{
		for (n = 0; n<Head.num_skins; n++)
		{
			fread(SkinNames[n],MD2_MAX_SKINNAME,1,hFile);
			// do something with the skin name
		}
	}
	
	// Load the actual skins
	{
		for (n = 0; n<Head.num_skins; n++)
		{
			{
        DevilTranslator    PCXTrans(DevilTranslator::PCX);
				
				SkinMaterial = new MMaterial;
				
				char              SkinFileName[256];
				
				// Try and locate the skin required.
				{
					char     DirStr[256];
					bool     FoundFile = false;
					int      c;
					
					strcpy(DirStr, (LPCTSTR)Filename);
					
					while (!FoundFile)
					{
						c = strlen(DirStr) - 1;
						while (c--)
						{
							if (DirStr[c] == '\\')
							{
								DirStr[c+1] = '\x0';
								break;
							}
						}
						strcpy(SkinFileName, DirStr);
						
						strcat(SkinFileName, SkinNames[n]);
						
						if (PCXTrans.canImportFile(SkinFileName)) {
							FoundFile = true;
						}
						if (strlen(DirStr)<=3)
							break;
					}
					if (FoundFile) {
						SkinMaterial->setDiffuseMapFilename(SkinFileName);
						SkinMaterial->setName("Material");
						Scene->addObject(SkinMaterial);
					}
				}
			}
			
			break;
			
		}
	}
	
	
	
	// Read in the skin vertices.
	{
		MMD2SkinVertex    *FileSkinVerts;
		MVector3 *TempSkinVerts;
		
		FileSkinVerts = new MMD2SkinVertex[Head.num_st];
		TempSkinVerts = new MVector3[Head.num_st];
		
		fread(FileSkinVerts,sizeof(MMD2SkinVertex)*Head.num_st,1,hFile);
		
		for (n=0; n<Head.num_st; n++)
		{
			TempSkinVerts[n].x = (float)FileSkinVerts[n].s / Head.skinwidth;
			TempSkinVerts[n].y = 1.0f - (float)FileSkinVerts[n].t / Head.skinheight;
			TempSkinVerts[n].z = 0;
			// Do stuff with the skin Verts
		}
		SkinMesh->addVertexArray(TempSkinVerts, Head.num_st);
		
		delete[] FileSkinVerts;
		delete[] TempSkinVerts;
	}
	
	
	// Read in the triangles.
	{
		MMD2Triangle      *FileTris;
		
		FileTris = new MMD2Triangle[Head.num_tris];
		
		fread(FileTris,sizeof(MMD2Triangle)*Head.num_tris,1,hFile);
		
		for (n = 0; n<Head.num_tris; n++)
		{
			NewTris[n].setVertex(0, FileTris[n].Vertices[2]);
			NewTris[n].setVertex(1, FileTris[n].Vertices[1]);
			NewTris[n].setVertex(2, FileTris[n].Vertices[0]);
			
			// Also do something with skin verts here as well
			SkinTris[n].setVertex(0, FileTris[n].SkinVerts[2]);
			SkinTris[n].setVertex(1, FileTris[n].SkinVerts[1]);
			SkinTris[n].setVertex(2, FileTris[n].SkinVerts[0]);
		}
		
		delete[] FileTris;
	}
	
	
	// read in the vertices for every frame in the animation.
	{
		MVector3 *Verts;
		MMD2Vertex     *FileVerts;
		MMD2FrameInfo  FileFrameInfo;
		int            Frame;
		
		FileVerts = new MMD2Vertex[Head.num_xyz];
		Verts = new MVector3[Head.num_xyz];
		
		
		for (Frame = 0; Frame<Head.num_frames;Frame++)
		{
			fread(&FileFrameInfo, sizeof(MMD2FrameInfo),1,hFile);
			fread(FileVerts, sizeof(MMD2Vertex)*Head.num_xyz,1,hFile);
			
			for (n=0; n < Head.num_xyz; n++)
			{
				MVector3    V;
				
				V.x = FileVerts[n].v[0];
				V.y = FileVerts[n].v[1];
				V.z = FileVerts[n].v[2];
				
				V.x *= FileFrameInfo.scale[0];
				V.y *= FileFrameInfo.scale[1];
				V.z *= FileFrameInfo.scale[2];
				V.x += FileFrameInfo.translate[0];
				V.y += FileFrameInfo.translate[1];
				V.z += FileFrameInfo.translate[2];
				
				Verts[n].x = V.x;
				Verts[n].y = V.y;
				Verts[n].z = V.z;
				
			}
			if (Frame == 0) {     // If we are on the first frame, create the animated vertices
				Mesh->addVertexArray(Verts, Head.num_xyz);
			} else {
				Mesh->setVertexArray(Frame*120, Verts, Head.num_xyz);
			}
		}
		
		delete[] Verts;
		delete[] FileVerts;
	}
	
	fclose(hFile);
	
	
	Mesh->addTriangleArray(NewTris, Head.num_tris);
	SkinMesh->addTriangleArray(SkinTris, Head.num_tris);
	
	delete[] NewTris;
	delete[] SkinTris;
	
	// Add the mesh to the scene
	
	MTreeObjectNodePtr NewObjNode;
	MMeshShapePtr meshShape;
	
	Mesh->setTextureMesh(SkinMesh);
	Mesh->setName(MasterObjName + "Mesh");
	Mesh->calculateNormals();
	
	meshShape = new MMeshShape(Mesh);
	Mesh->setName(MasterObjName + "Shape");
	
	MSceneObjectPtr sceneObj = new MSceneObject(meshShape);
	sceneObj->setTextureMaterial(SkinMaterial);
	sceneObj->setName(MasterObjName);
	
	NewObjNode = Scene->addObject(sceneObj);
	
	return true;
}

bool MMD2Translator::exportFile(MStr Filename, MScenePtr Scene) {
  return false;
}





