
function labelledSliderListener(slider, output, redraw){
  var text = slider.getValue();
  output.setValue(text);
  if(redraw) Scene.redraw();
}

function createLabelledSlider(container, caption,units, min, max, value) {
  var label = new MLabel(caption);
  var slider = new MSlider(min, max, value);
  var units = new MLabel(units);
  var sliderValue = new MTextField(value, 5);

  container.addComponent(label);
  container.addComponent(sliderValue);
  container.addComponent(slider);
  container.addComponent(units);

  slider.addListener(labelledSliderListener, slider, sliderValue, false);
  slider.setMinimumSize(150,1);
  sliderValue.setMinimumSize(10,1);
  sliderValue.addAcceptListener(sliderTextFieldListener, slider);

  return slider;
}

function sliderTextFieldListener(textField, slider){
    var fieldValue = textField.getValue();
	slider.setValue(fieldValue);
}

function createLabel(container,label){
	var label = new MLabel(label);
    container.addComponent(label);
}

function onConnect(slider) {
    Scene.edgeConnect(slider.getValue());
}

function displayEdgeConnectOptions() {

  var mainWindow = new MToolWindow("Edge Connect Options");
  var amount = 1;
  
  mainWindow.setLayoutManager(new MFlowLayout(10,2,4));
  var slider = createLabelledSlider(mainWindow, "Connect Edges with","divisions",1,25,amount,"");

  var button = new MButton("Connect Edges");
  mainWindow.addComponent(button);
  button.addListener(onConnect, slider);

  mainWindow.setSize(300,100);
  mainWindow.setVisible(true);	

}

displayEdgeConnectOptions();


