#ifndef __CAMERAVIEW_H
#define __CAMERAVIEW_H
#include "MedDLeGFX\MedDLeTypes.h"

enum cMedDLeShading {cSHADE_NONE, cSHADE_FLAT, cSHADE_GOUROURD};

class CCameraView : public CView
{
protected: // create from serialization only
	CCameraView();
	DECLARE_DYNCREATE(CCameraView)

// Attributes
public:
	CMedDLeDoc* GetDocument();
	CMedDLeMatrix	m_Proj, m_View, m_World;	// Matrices
	CMedDLeMatrix	Scaling;

	cMedDLeShading	ShadeMode;
	BOOL			bShowWireFrame;
	BOOL			bShowVertices;
	BOOL			bTextureMap;


	// mouse manipulation variables
	BOOL LeftStart, RightStart;
	BOOL LeftClean, RightClean;
	BOOL HasShift;
	BOOL HasCtrl;
	BOOL RotatingLight;
	BOOL MovingEye;
	BOOL RotatingEye;
	CPoint OldPoint;
	CPoint ClickPoint;

	int m_nCamera;


	int NoMotion;
	float sensitivity;  // mouse moving parameter
	void ResetView(void);
// Operations
public:
	void RenderHit(CPoint point);
	void DrawGrid(int resy);

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCameraView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual void OnInitialUpdate();
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CCameraView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CCameraView)
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRButtonUp(UINT nFlags, CPoint point);
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnR3dvReset();
	afx_msg void OnNotext();
	afx_msg void OnUpdateNotext(CCmdUI* pCmdUI);
	afx_msg void OnFrontback();
	afx_msg void OnUpdateFrontback(CCmdUI* pCmdUI);
	afx_msg void OnVertex();
	afx_msg void OnUpdateVertex(CCmdUI* pCmdUI);
	afx_msg void OnWireframe();
	afx_msg void OnUpdateWireframe(CCmdUI* pCmdUI);
	afx_msg void OnFlatshade();
	afx_msg void OnUpdateFlatshade(CCmdUI* pCmdUI);
	afx_msg void OnGourourd();
	afx_msg void OnUpdateGourourd(CCmdUI* pCmdUI);
	afx_msg void OnTextured();
	afx_msg void OnUpdateTextured(CCmdUI* pCmdUI);
	afx_msg void OnLightshade();
	afx_msg void OnUpdateLightshade(CCmdUI* pCmdUI);
	afx_msg void OnContextMenu(CWnd* pWnd, CPoint point);
	afx_msg void On3dcapture();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

#ifndef _DEBUG  // debug version in CameraView.cpp
inline CMedDLeDoc* CCameraView::GetDocument()
   { return (CMedDLeDoc*)m_pDocument; }
#endif

/////////////////////////////////////////////////////////////////////////////
#endif