#include "stdafx.h"
#include "..\MedDLeGFX\MedDLeTypes.h"
#include "..\MedDLeGFX\MedDLe3D.h"
#include "IO3DO.h"

static BOOL Read3DOFaces(CStdioFile &sin, CMedDLeObject &mo, int N);
static BOOL Read3DOVerts(CStdioFile &sin, CMedDLeObject &mo, int N);
static BOOL Read3DOTag(CStdioFile &sin,CMedDLeObject &mo);
static BOOL Read3DOHDef(CStdioFile &sin, CMedDLeObject &mo);
static BOOL Read3DOHier(CStdioFile &sin, CMedDLeObject &mo, int N);

int vindexoff=0;
int meshcnt=0;

int frames=0;
int curframe=0;
int groups=0;
int curgroup=0;
int groupsadded=0;
int framesadded=0;

BYTE cmap[8]={8, 212, 25, 47, 55, 144, 79, 128};

int gGeo=0;

int IO3DOGeos(LPCSTR fname)
{

	gGeo=1;

	return gGeo;
}
BOOL IO3DORead(LPCSTR fname, CMedDLeObject &mo, int g)
{
	gGeo=g;
	vindexoff=0;
	meshcnt=0;
	frames=0;
	curframe=-1;
	groups=0;
	curgroup=-1;
	groupsadded=0;
	framesadded=0;

	int i,j,k;
	
	FILE *in;
	in=fopen(fname,"rt");
	if(in==NULL) return FALSE;

	CStdioFile sin(in);

	while(Read3DOTag(sin,mo));

	sin.Close();

	return TRUE;

}


BOOL Read3DOTag(CStdioFile &sin,CMedDLeObject &mo)
{
	char str[256];
	char *keys[]={
		"GEOSETS","GEOSET",
		"MESHES", "MESH","NAME",
		"VERTICES","TEXTURE","VERTEX","FACES","FACE",
		"HIERARCHY",
		NULL};
	enum nkeys {
		GEOSETS,GEOSET,
		MESHES, MESH, NAME,
		VERTICES, TEXTURE, VERTEX,FACES, FACE,
		HIERARCHY};


	char *sections[]={"HEADER","MODELRESOURCE","GEOMETRYDEF","HIERARCHYDEF", NULL};
	enum nsections {HEADER,MODELRESOURCE,GEOMETRYDEF,HIERARCHYDEF};


	FILE *in=sin.m_pStream;

	int N;
	int length;
	CString line;
	CString tmp;
	if(!sin.ReadString(line)) return 0;

//	AfxMessageBox(line);
	int where;
	where=line.Find("#");
	if(where>0)
		line=line.Left(where);
	line.TrimLeft();
	if(line.IsEmpty()) return 1;

	sscanf(line.GetBuffer(0),"%s",str);
	tmp=str;

	CString ss;
	
	if(tmp.Compare("SECTION:")==0)
	{
		line=line.Right(line.GetLength()-tmp.GetLength());
		line.TrimLeft();
		sscanf(line.GetBuffer(0),"%s",str);
		tmp=str;
		if(tmp.Compare("GEOMETRYDEF"))
		{
			return Read3DOTag(sin,mo);
		}
	}
	else
	{
		for(int i=0; keys[i]!=NULL; i++)
		{
			if(tmp.CompareNoCase(keys[i])==0)
			{
//				AfxMessageBox(line);
				switch (i)
				{
				case GEOSETS:
					line=line.Right(line.GetLength()-tmp.GetLength());
					line.TrimLeft();
					sscanf(line.GetBuffer(0),"%d",&N);
					frames=N;
					//N=1;
					// can't handle more geo sets yet
					if(framesadded==0)
					{
						framesadded=1;
						mo.m_BaseFrame->f.RemoveAll();
						mo.m_BaseFrame->l.RemoveAll();
						mo.m_BaseFrame->v.RemoveAll();
				//		mo.m_Frames.RemoveAll();
					
						CString n;
//						for(int j=0; j<N; j++)
//						{
						n.Format("frame%d",gGeo);
						CMedDLeFrame *mf = new CMedDLeFrame(n);
						mo.m_Frames.Add(mf);

							//AfxMessageBox("FrameAdded");
//						}
					}
					break;
				case GEOSET:
					line=line.Right(line.GetLength()-tmp.GetLength());
					line.TrimLeft();
					sscanf(line.GetBuffer(0),"%d",&N);
					curframe=N;
					break;
				case MESHES:
					if(curframe!=gGeo) break;

					line=line.Right(line.GetLength()-tmp.GetLength());
					line.TrimLeft();
					sscanf(line.GetBuffer(0),"%d",&N);
					groups=N;
					if(groupsadded==0)
					{
						groupsadded=1;
						for(int j=0; j<N; j++)
						{
							CMedDLeGroup mg;
							CString name;
							name.Format("group %d",j);
							mg.name=name;
							mg.color=cmap[(meshcnt-1)&0x07];
							mg.flags=0;
							mg.bone=0;
							mo.m_BaseFrame->g.Add(mg);
							//AfxMessageBox("GroupAdded");

						}
					}
					break;
				case MESH:
					if(curframe!=gGeo) break;
					line=line.Right(line.GetLength()-tmp.GetLength());
					line.TrimLeft();
					sscanf(line.GetBuffer(0),"%d",&N);
					curgroup=N;
					break;
				case NAME:
					if(curframe!=gGeo) break;
					if(groupsadded)
					{
						line=line.Right(line.GetLength()-tmp.GetLength());
						line.TrimLeft();
						sscanf(line.GetBuffer(0),"%s",str);
						mo.m_BaseFrame->g[curgroup].name=str;
						break;
					}

				case TEXTURE:
						break;
				case VERTICES:
					
					if(curframe!=gGeo) break;
					if(curgroup==0) vindexoff=0;

					line=line.Right(line.GetLength()-tmp.GetLength());
					line.TrimLeft();
					sscanf(line.GetBuffer(0),"%d",&N);
					//AfxMessageBox(line);	
					//if(N<=0) return 1;
					if(Read3DOVerts(sin, mo, N)==0) return 0;
					break;
				case FACES:
					if(curframe!=gGeo) break;
					
					line=line.Right(line.GetLength()-tmp.GetLength());
					line.TrimLeft();
					sscanf(line.GetBuffer(0),"%d",&N);
					if(Read3DOFaces(sin, mo, N)==0) return 0;
					break;

				case HIERARCHY:
					line=line.Right(line.GetLength()-tmp.GetLength());
					line.TrimLeft();
					sscanf(line.GetBuffer(0),"%s %d",str,&N);
					if(Read3DOHier(sin, mo, N)==0) return 0;
					break;

				}


				break;
			}
		}
	}
		
	return 1;


}

BOOL Read3DOHier(CStdioFile &sin, CMedDLeObject &mo, int N)
{
//	AfxMessageBox("Hier");

	FILE *in=sin.m_pStream;
	char str[256];

	CString mstr;
	unsigned length;
	unsigned prev_size=0;
	CString cstr;

	int nodes=N;

//	length=fscanf(in,"%s %d",str,&nodes);
//	if((length==EOF)||(length<=0)) return 0;


	mstr.Format("N=%d",nodes);
//	AfxMessageBox(mstr);


	CString key;

	for(int i=0; i<nodes; i++)
	{
		key.Format("%d:",i);
		while(1)
		{
			length=fscanf(in,"%s",str);
			if((length==EOF)||(length<=0)) return 0;
			cstr=str;
			if(cstr.Compare(key.GetBuffer(0))==0) break;
		}

		int mpcsn[5];
		float fparam[9];
		char name[256];

		// junk
		for(int j=0; j<2; j++)
		{
			length=fscanf(in,"%s",str);
			if((length==EOF)||(length<=0)) return 0;
		}

		for(j=0; j<5; j++)
		{
			length=fscanf(in,"%s",str);
			if((length==EOF)||(length<=0)) return 0;
			mpcsn[j]=atoi(str);
		}
		for(j=0; j<9; j++)
		{
			length=fscanf(in,"%s",str);
			if((length==EOF)||(length<=0)) return 0;
			fparam[j]=atof(str);
		}
		length=fscanf(in,"%s",name);
		if((length==EOF)||(length<=0)) return 0;

		CMedDLeBone b;
		b.head=CMedDLePoint3D(fparam[0]*1000,fparam[1]*1000,fparam[2]*1000);  // off
		b.tail=CMedDLePoint3D(fparam[6]*1000,fparam[7]*1000,fparam[8]*1000);  // piviot
		b.orientation=1.f;
		b.name=name;

		b.flags=0;//B_VISIBLE;
		b.length=10;
		b.twist=0;
		b.parent=mpcsn[1];
		b.kid.RemoveAll();
		
		mo.m_BaseFrame->b.Add(b);

		if(mpcsn[0]!=-1)
		{
			int NN=mo.m_BaseFrame->v.GetSize();
			for(int ii=0;ii<NN;ii++)
			{
				if(mo.m_BaseFrame->v[ii].group==mpcsn[0])
				{
					mo.m_BaseFrame->v[ii].bone=i;
				}
			}
		}


	}

	int NN=mo.m_BaseFrame->v.GetSize();

	// move each vertex
	for(int ii=0;ii<NN;ii++)
	{

		int nb=mo.m_BaseFrame->v[ii].bone;
		CMedDLeBone b;
		b=mo.m_BaseFrame->b[nb];

		float x=0,y=0,z=0;
		x+=b.head.x[0];
		y+=b.head.x[1];
		z+=b.head.x[2];
		x+=b.tail.x[0];
		y+=b.tail.x[1];
		z+=b.tail.x[2];
		while(b.parent!=-1)
		{
			b=mo.m_BaseFrame->b[b.parent];
			x+=b.head.x[0];
			y+=b.head.x[1];
			z+=b.head.x[2];
		}
		mo.m_Frames[0]->v[ii].x[0]+=x;
		mo.m_Frames[0]->v[ii].x[1]+=y;
		mo.m_Frames[0]->v[ii].x[2]+=z;
	}

	// move bones to meddle format
	int nb=mo.m_BaseFrame->b.GetSize();
	CArray <CMedDLeBone, CMedDLeBone &> ba;
	ba.RemoveAll();
	for(i=0; i<nb; i++)
	{
		ba.Add(mo.m_BaseFrame->b[i]);
	}
	CMedDLeBone b;
	for(i=0; i<nb; i++)
	{
		b=ba[i];

		float x=0,y=0,z=0;
//		x+=b.head.x[0];
//		y+=b.head.x[1];
//		z+=b.head.x[2];
		x+=b.tail.x[0];
		y+=b.tail.x[1];
		z+=b.tail.x[2];
		while(b.parent!=-1)
		{
			b=ba[b.parent];
			x+=b.head.x[0];
			y+=b.head.x[1];
			z+=b.head.x[2];
		}
		mo.m_BaseFrame->b[i].head.x[0]+=x;
		mo.m_BaseFrame->b[i].head.x[1]+=y;
		mo.m_BaseFrame->b[i].head.x[2]+=z;
		mo.m_BaseFrame->b[i].tail.x[0]+=x;
		mo.m_BaseFrame->b[i].tail.x[1]+=y;
		mo.m_BaseFrame->b[i].tail.x[2]+=z;
	}

	return 1;
}

BOOL Read3DOHDef(CStdioFile &sin, CMedDLeObject &mo)
{

	return 1;

}

BOOL Read3DOVerts(CStdioFile &sin, CMedDLeObject &mo, int N)
{


	if(curframe!=gGeo) return 1;
	FILE *in=sin.m_pStream;


	char str[256];

	CString mstr;
	unsigned length;
	unsigned prev_size=0;
	CString cstr;

//	cstr.Format("cframe %d",curframe);
//	AfxMessageBox(cstr);

	CString key;

	CMedDLeVertex v1;

	CMedDLeFrame *mf;

	mf=mo.m_Frames[0];

	for(int i=0; i<N; i++)
	{
		key.Format("%d:",i);
		while(1)
		{
			length=fscanf(in,"%s",str);
			if((length==EOF)||(length<=0)) return 0;
			cstr=str;
			if(cstr.Compare(key.GetBuffer(0))==0) break;
		}
		float v[4];
		for(int j=0; j<4; j++)
		{
			length=fscanf(in,"%s",str);
			if((length==EOF)||(length<=0)) return 0;
			v[j]=atof(str);
		}

		v1.x[0]=v[0]*1000.;
		v1.x[1]=v[1]*1000.;
		v1.x[2]=v[2]*1000.;
		mf->v.Add(v1);
		CMedDLeBaseVertex bv;
		bv.group=curgroup;
		mo.m_BaseFrame->v.Add(bv);

	}

	return 1;
}

BOOL Read3DOFaces(CStdioFile &sin, CMedDLeObject &mo, int N)
{
	FILE *in=sin.m_pStream;
	if(curframe!=gGeo) return 1;
//	if(curframe>0) return 1;

	char str[256];
	CString mstr;
//	mstr.Format("faces %d",N);
//	AfxMessageBox(mstr);
	
	unsigned length;
	unsigned prev_size=0;
	CString cstr;

	CString key;

	CMedDLeLine ml;

//	if(curframe!=0) return 1;

	for(int i=0; i<N; i++)
	{
		key.Format("%d:",i);
		while(1)
		{
			length=fscanf(in,"%s",str);
			if((length==EOF)||(length<=0)) return 0;
			cstr=str;
			if(cstr.Compare(key.GetBuffer(0))==0) break;
		}
		int mat;
		WORD type;
		int geo, light, tex,verts;
		float extralight;

		fscanf(in,"%d%x%d%d%d%g%d",&mat,&type,&geo,&light,&tex,&extralight,&verts );

//		mstr.Format("%d: n=%d ",i, verts);
//		AfxMessageBox(mstr);

		int *vi, *ti;
		vi=new int[verts];
		ti=new int[verts];
		for(int j=0; j<verts; j++)
		{
				length=fscanf(in,"%d,\t%d",&vi[j], &ti[j]);
//				mstr.Format("%d,\t%d ",vi[j],ti[j]);
//				AfxMessageBox(mstr);
				if((length==EOF)||(length<=0)) {delete []vi; delete []ti; return 0;}


		}

		// save to meddle
		CMedDLeFace m;
		mo.m_BaseFrame->f.Add(m);

		int p;
		p=mo.m_BaseFrame->f.GetSize()-1;

		mo.m_BaseFrame->f[p].vindex[0]=vi[0]+vindexoff;
		mo.m_BaseFrame->f[p].vindex[2]=vi[1]+vindexoff;
		mo.m_BaseFrame->f[p].vindex[1]=vi[2]+vindexoff;

		mo.m_BaseFrame->f[p].group= curgroup;
		mo.m_BaseFrame->f[p].color=cmap[curgroup&0x07];

		for(j=3; j<verts; j++)
		{
			mo.m_BaseFrame->f.Add(m);
			p=mo.m_BaseFrame->f.GetSize()-1;
			mo.m_BaseFrame->f[p].vindex[0]=vi[0]+vindexoff;
			mo.m_BaseFrame->f[p].vindex[2]=vi[j-1]+vindexoff;
			mo.m_BaseFrame->f[p].vindex[1]=vi[j]+vindexoff;
			mo.m_BaseFrame->f[p].group= curgroup;
			mo.m_BaseFrame->f[p].color=cmap[curgroup&0x07];
		}

		delete [] vi;
		delete [] ti;

	}

	vindexoff=mo.m_Frames[0]->v.GetSize();

	return 1;
}

BOOL IO3DOWrite(LPCSTR fname,CMedDLeObject &mo)
{
	return 1;

}