#include "stdafx.h"
#include "..\MedDLeGFX\MedDLeTypes.h"
#include "..\MedDLeGFX\MedDLe3D.h"
#include "IOMDL.h"

#define MDL_VERSION 6
#define MDL_ONSEEM  32
#define MDL_ONFRONT 1

BOOL IOMDLRead(LPCSTR fname, CMedDLeObject &mo)
{
	CFile f;

	if( !f.Open( fname,CFile::modeRead ) ) 
	{
		return FALSE;
	}
	CArchive ar( &f, CArchive::load );
  

	BYTE dummy[4];
	long version;
	float scale[3], offset[3], eye[3], radius, size;
	int nSkins, nVerts, nTris, nFrames, nSkinW, nSkinH,
		sync, flags;

	ar.Read(dummy,4);       // magic nums
	ar >> version;			// version 6 now
	ar >> scale[0] >> scale[1] >> scale[2];// scale = (max - min)/255.9
	ar >> offset[0] >> offset[1] >> offset[2];
	ar >> radius;        // bounding radius
	ar >> eye[0] >> eye[1] >> eye[2]; // eye position
	ar >> nSkins;      // num skins
	ar >> nSkinW;        // skin width
	ar >> nSkinH;        // skin height
	ar >> nVerts;
	ar >> nTris;
	ar >> nFrames;

	if(version == MDL_VERSION )
		ar >> sync; // sync type, either 0 or random
	else
		sync=0;
	ar >> flags;          // flags
	if(version == MDL_VERSION)
		ar >> size;       // average size  pixels/triangle?
	else
		size=(float)0.0;
	/// that ends the header

	mo.m_BaseFrame->t.RemoveAll();

	unsigned i,j,k;

		// quake =1, quake2 =2 jk =3 hexen =4
	mo.m_game=1;
	mo.m_bValidSkin=TRUE;	// q,q2,h
	mo.m_nSkinWidth=nSkinW;	// q,q2,h
	mo.m_nSkinHeight=nSkinH;
	mo.m_bSaveSkins=TRUE;
	
	for(k=0; k<nSkins; k++)
	{	

		DWORD type;
		ar >> type;
		if(type==0)
		{
			CMedDLeTexture *mt=new CMedDLeTexture;
			mt->bitmap = new BYTE [nSkinW*nSkinH];
			mt->header=new BYTE[sizeof(RGBQUAD)*256+sizeof(BITMAPINFOHEADER)];
			mt->bmpheader = (LPBITMAPINFOHEADER)mt->header;
			mt->colors = (RGBQUAD*)(mt->header+sizeof(BITMAPINFOHEADER));
			mt->bmpheader->biWidth=nSkinW;
			mt->bmpheader->biHeight=nSkinH;
			mt->bmpheader->biBitCount=8;

			mt->bmpheader->biSize = sizeof(BITMAPINFOHEADER);
			mt->bmpheader->biPlanes = 1;
			mt->bmpheader->biCompression = BI_RGB;
			mt->bmpheader->biSizeImage = nSkinW*nSkinH;
			mt->bmpheader->biXPelsPerMeter = 0;
			mt->bmpheader->biYPelsPerMeter = 0;
			mt->bmpheader->biClrUsed = 256;
			mt->bmpheader->biClrImportant = 0;

			if(mt->bitmap)
			{
				ar.Read(mt->bitmap,nSkinW*nSkinH);
//					theApp.m_Textures.Add(mt);
				mo.m_BaseFrame->t.Add(mt);
			}
			else delete mt;
		}
		else
		{
			// make a grouped skin
			
			int gs;
			float tcode;
	
			ar >> gs;
			for(j=0; j<gs; j++)
			{
				ar >> tcode;
			}
			for(j=0; j<gs; j++)
			{
				CMedDLeTexture *mt=new CMedDLeTexture;
				mt->bitmap = new BYTE [nSkinW*nSkinH];
				mt->header=new BYTE[sizeof(RGBQUAD)*256+sizeof(BITMAPINFOHEADER)];
				mt->bmpheader = (LPBITMAPINFOHEADER)mt->header;
				mt->colors = (RGBQUAD*)(mt->header+sizeof(BITMAPINFOHEADER));
	//			mt->bitmap = new BYTE [nSkinW*nSkinW];
	//			mt->colors = new RGBQUAD [256];
				for(int yy=0; yy<256; yy++)
				{
					mt->colors[yy].rgbBlue=yy;
					mt->colors[yy].rgbGreen=yy;
					mt->colors[yy].rgbRed=yy;
					mt->colors[yy].rgbReserved=0;
				}
				mt->bmpheader->biWidth=nSkinW;
				mt->bmpheader->biHeight=nSkinH;
				mt->bmpheader->biBitCount=8;
				mt->bmpheader->biSize=nSkinW*nSkinH;
				if(mt->bitmap)
				{
					ar.Read(mt->bitmap,nSkinW*nSkinH);
//					theApp.m_Textures.Add(mt);
					mo.m_BaseFrame->t.Add(mt);
				}
				else delete mt;

			}
				
		}

	}



	int *vflag=new int[nVerts];
	int *vx=new int[nVerts];
	int *vy=new int[nVerts];
	// now read the 2d vertices
	for(i=0;i<nVerts;i++)
	{
		ar >> vflag[i];
		if(version!=MDL_VERSION)
		{
			if(vflag[i] & 1) vflag[i]=MDL_ONSEEM;
		}
		ar >> vx[i];
		ar >> vy[i];
	}

	// now read triangle definitions
	CMedDLeFace m;
	CMedDLeLine ml;
	for(i=0;i<nTris;i++)
	{
		int tflags, vindex;
		ar >> tflags;

		for(j=0;j<3; j++) 
		{
			ar >> vindex;
			m.vindex[j]=vindex;
			if((vflag[vindex]&MDL_ONSEEM)&&(!(tflags&MDL_ONFRONT)))
				m.tx[j][0] = vx[vindex]+nSkinW/2;
			else
				m.tx[j][0] = vx[vindex];
			m.tx[j][1] = vy[vindex];
		}

		mo.m_BaseFrame->f.Add(m);
	}

	delete [] vflag;
	delete [] vx;
	delete [] vy;

	mo.m_Frames.RemoveAll();
	int frmcnt=0;
	for(k=0; k<nFrames;  k++)
	{
		DWORD type;
		if(version == MDL_VERSION)
			ar >> type;
		else type=0;
		// if single frames
		if(type==0)
		{	
			
			BYTE buf[4];
			char name[16];

			if(version!=MDL_VERSION) 
				ar.Read(buf,4);
			ar.Read(buf,4);
			ar.Read(buf,4);

//			for(i=0; i<3; i++)
//			{
//				mf->fbboxmin.v[i]=(float)mf->bboxmin.v[i]*scale[i]+offset[i];
//				mf->fbboxmax.v[i]=(float)mf->bboxmax.v[i]*scale[i]+offset[i];
//			}
			
			if(version==MDL_VERSION)
				ar.Read(name,16);
			else strcpy(name,"noname");
			
			CMedDLeFrame *mf = new CMedDLeFrame(name);

			//mf->groupnumber=-1;
			for(i=0;i<nVerts;i++)
			{
				ar.Read(buf,4);

				CMedDLeVertex v1;

				v1.x[0] = (float)buf[0]*scale[0]+offset[0];
				v1.x[1] = (float)buf[1]*scale[1]+offset[1];
				v1.x[2] = (float)buf[2]*scale[2]+offset[2];

				mf->v.Add(v1);

			}
			mo.m_Frames.Add(mf);
			frmcnt++;
		}
		//grouped frames
		else
		{
			int gf;
			ar >> gf;

			BYTE buf[4];
			char name[16];

			ar.Read(buf,4);
			ar.Read(buf,4);

//			for(i=0; i<3; i++)
//			{
//				mfg->fbboxmin.v[i]=(float)mfg->bboxmin.v[i]*scale[i]+offset[i];
//				mfg->fbboxmax.v[i]=(float)mfg->bboxmax.v[i]*scale[i]+offset[i];
//			}

			for(j=0; j<gf; j++)
			{
				float tcode;
				ar >> tcode;
			}
			for(j=0; j<gf; j++)
			{
				ar.Read(buf,4);
				ar.Read(buf,4);
				ar.Read(name,16);
			
				CMedDLeFrame *mf = new CMedDLeFrame(name);
				for(i=0;i<nVerts;i++)
				{
					ar.Read(buf,4);
					CMedDLeVertex v1;
					v1.x[0] = (float)buf[0]*scale[0]+offset[0];
					v1.x[1] = (float)buf[1]*scale[1]+offset[1];
					v1.x[2] = (float)buf[2]*scale[2]+offset[2];

					mf->v.Add(v1);

				}
				mo.m_Frames.Add(mf);
			}
				
		}

	}

	// set up verts in base
	CMedDLeBaseVertex bv;
	for(i=0;i<nVerts;i++)
	{
		mo.m_BaseFrame->v.Add(bv);
	}

	mo.m_curFrameN=0;
	mo.m_curFrame=mo.m_Frames[0];

	f.Close();


	return TRUE;
}
BOOL IOMDLWrite(LPCSTR fname,CMedDLeObject &mo)
{

	return FALSE;
}


