// FrameDlg.cpp : implementation file
// 

#include "stdafx.h"
#include "MedDLe.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CFrameDlg dialog


CFrameDlg::CFrameDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CFrameDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CFrameDlg)
	//}}AFX_DATA_INIT
}


void CFrameDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CFrameDlg)
	DDX_Control(pDX, IDC_TREE_FRAMEMAN, m_FrameTree);
	//}}AFX_DATA_MAP
//	m_FrameTree.InvalidateRect(NULL);
	//OnInitDialog();
}


BEGIN_MESSAGE_MAP(CFrameDlg, CDialog)
	//{{AFX_MSG_MAP(CFrameDlg)
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONUP()
	ON_NOTIFY(TVN_BEGINRDRAG, IDC_TREE_FRAMEMAN, OnBeginrdragTreeFrameman)
	ON_NOTIFY(TVN_BEGINDRAG, IDC_TREE_FRAMEMAN, OnBegindragTreeFrameman)
	ON_NOTIFY(TVN_ENDLABELEDIT, IDC_TREE_FRAMEMAN, OnEndlabeleditTreeFrameman)
	ON_NOTIFY(TVN_SELCHANGED, IDC_TREE_FRAMEMAN, OnSelchangedTreeFrameman)
	ON_NOTIFY(NM_RCLICK, IDC_TREE_FRAMEMAN, OnRclickTreeFrameman)
	ON_WM_DRAWITEM()
	ON_NOTIFY(TVN_BEGINLABELEDIT, IDC_TREE_FRAMEMAN, OnBeginlabeleditTreeFrameman)
	ON_NOTIFY(NM_RETURN, IDC_TREE_FRAMEMAN, OnReturnTreeFrameman)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CFrameDlg message handlers

void CFrameDlg::PostNcDestroy() 
{
	// TODO: Add your specialized code here and/or call the base class
	theApp.FrameManOn=0;
	delete this;
	//CDialog::PostNcDestroy();
}

void CFrameDlg::OnCancel() 
{
	// TODO: Add ex
	DestroyWindow();
}

void CFrameDlg::OnOK() 
{
	UpdateData(TRUE);
	DestroyWindow();

}

BOOL CFrameDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();

//	m_imageList.Create( IDB_FRAMETREE, 14,1,RGB(255,0,0));
//	m_FrameTree.SetImageList( &m_imageList, TVSIL_NORMAL);
	
	FillTree();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CFrameDlg::OnMouseMove(UINT nFlags, CPoint point) 
{

		
	if( m_bIsDragging == TRUE)
	{	
		CPoint ptTree( point );
		MapWindowPoints( &m_FrameTree, &ptTree, 1 );
		CImageList::DragMove(ptTree);
		UINT uHitTest = TVHT_ONITEM;
		m_dragTarget = m_FrameTree.HitTest(ptTree, &uHitTest);

	}
	
	CDialog::OnMouseMove(nFlags, point);
}

void CFrameDlg::OnLButtonUp(UINT nFlags, CPoint point) 
{

	if(m_bIsDragging == TRUE)
	{
		CImageList::DragLeave( &m_FrameTree);
		CImageList::EndDrag();
		ReleaseCapture();
		m_bIsDragging = FALSE;
		if( m_dragTarget !=NULL)
		{
			HTREEITEM hParent;
			hParent = m_FrameTree.GetParentItem(m_dragTarget);
			CString szLabel = m_FrameTree.GetItemText(m_dragItem);
			if(hParent !=NULL)
				m_FrameTree.InsertItem(szLabel,1,1,hParent,m_dragTarget);
			else
				m_FrameTree.InsertItem(szLabel,1,1,m_dragTarget,TVI_FIRST);
			m_FrameTree.DeleteItem(m_dragItem);
		}
	}
	else
	
	CDialog::OnLButtonUp(nFlags, point);
}

void CFrameDlg::OnBeginrdragTreeFrameman(NMHDR* pNMHDR, LRESULT* pResult) 
{
	*pResult = 0;
}

void CFrameDlg::FillTree(void)
{
	m_FrameTree.DeleteAllItems();

	int nDocs=theApp.DocArray.GetSize();
	CMedDLeDoc *pDoc;
	for(int i=0; i<nDocs; i++)
	{
		pDoc=theApp.DocArray.GetAt(i);

		CString modelpname=pDoc->GetTitle();
		//int n=modelpname.ReverseFind( '\\' )+1;
		//if(n==0) n=1;
		//CString modelname=modelpname.Mid(n);
		pDoc->TreeInfoModel = m_FrameTree.InsertItem(modelpname);//,0,0);
		if(pDoc->cur.frameptr != NULL)
		{
			HTREEITEM where;
			int gcnt=pDoc->FrameGroups.GetSize();
			for(int j=0; j<gcnt; j++)
			{
					pDoc->FrameGroups.GetAt(j)->TreeInfoGFrame=m_FrameTree.InsertItem(pDoc->FrameGroups.GetAt(j)->name,pDoc->TreeInfoModel);
			}
			pDoc->MapGen->TreeInfoFrame=m_FrameTree.InsertItem(pDoc->MapGen->name,pDoc->TreeInfoModel);
			pDoc->Base->TreeInfoFrame=m_FrameTree.InsertItem(pDoc->Base->name,pDoc->TreeInfoModel);
			for(j=0; j<pDoc->Frames.GetSize(); j++)
			{
				//if group
				if(pDoc->Frames.GetAt(j)->type!=0)
				{
					Frame *mf;
					mf=pDoc->Frames.GetAt(j);
					mf->TreeInfoFrame=m_FrameTree.InsertItem(pDoc->Frames.GetAt(j)->name,pDoc->FrameGroups.GetAt(mf->groupnumber)->TreeInfoGFrame);
				}
				else
					pDoc->Frames.GetAt(j)->TreeInfoFrame=m_FrameTree.InsertItem(pDoc->Frames.GetAt(j)->name,pDoc->TreeInfoModel);
			}
		}
	}
	UpdateData();	
}

void CFrameDlg::OnBegindragTreeFrameman(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
/*	m_dragItem = pNMTreeView->itemNew.hItem;
	if(m_FrameTree.GetParentItem(m_dragItem) !=NULL)
	{
		CImageList* pDragImage;
		pDragImage = m_FrameTree.CreateDragImage(m_dragItem);
		m_FrameTree.SelectItem(m_dragItem);
		pDragImage->BeginDrag(0,CPoint(0,0));
		pDragImage->DragEnter(&m_FrameTree, pNMTreeView->ptDrag);
		SetCapture();
		m_bIsDragging = TRUE;
	}
*/	
	*pResult = 0;
}

void CFrameDlg::OnEndlabeleditTreeFrameman(NMHDR* pNMHDR, LRESULT* pResult) 
{
	TV_DISPINFO* pTVDispInfo = (TV_DISPINFO*)pNMHDR;
	
	*pResult = 0;
}

void CFrameDlg::OnSelchangedTreeFrameman(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;

	HTREEITEM selc=m_FrameTree.GetSelectedItem();	

	int nDocs=theApp.DocArray.GetSize();
	CMedDLeDoc *pDoc;
	for(int i=0; i<nDocs; i++)
	{
		pDoc=theApp.DocArray.GetAt(i);
		if(pDoc->cur.frameptr != NULL)
		{
			if(pDoc->TreeInfoModel==selc)
			{
				// here I should set sel to active doc
				//pDoc->GetView();SetActive
				pDoc->UpdateAllViews(NULL);
				break;
			}

			if(pDoc->MapGen->TreeInfoFrame==selc)
			{
				pDoc->cur.frame=-2;
				pDoc->cur.frameptr=pDoc->MapGen;
				pDoc->UpdateAllViews(NULL);
				break;
			}
			else if(pDoc->Base->TreeInfoFrame==selc)
			{
				pDoc->cur.frame=-1;
				pDoc->cur.frameptr=pDoc->Base;
				pDoc->UpdateAllViews(NULL);
				break;
			}
			else {
			for(int j=0; j<pDoc->Frames.GetSize(); j++)
			{
				if(pDoc->Frames.GetAt(j)->TreeInfoFrame==selc)
				{
					pDoc->cur.frame=j;
					pDoc->cur.frameptr=pDoc->Frames[j];
					pDoc->UpdateAllViews(NULL);
					break;
				}
			}
			}
		}
	}

	
	*pResult = 0;
}


void CFrameDlg::OnRclickTreeFrameman(NMHDR* pNMHDR, LRESULT* pResult) 
{
	*pResult = 0;
}

void CFrameDlg::OnDrawItem(int nIDCtl, LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
//	UpdateData();
//	FillTree();
	CDialog::OnDrawItem(nIDCtl, lpDrawItemStruct);
}

BOOL CFrameDlg::OnNotify(WPARAM wParam, LPARAM lParam, LRESULT* pResult) 
{
	// TODO: Add your specialized code here and/or call the base class
	
	return CDialog::OnNotify(wParam, lParam, pResult);
}

void CFrameDlg::OnBeginlabeleditTreeFrameman(NMHDR* pNMHDR, LRESULT* pResult) 
{
	TV_DISPINFO* pTVDispInfo = (TV_DISPINFO*)pNMHDR;
	// TODO: Add your control notification handler code here
	
	*pResult = 0;
}

void CFrameDlg::OnReturnTreeFrameman(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	
	*pResult = 0;
}
