// MedDLeDoc2.cpp : implementation of the CMedDLeDoc class
//

#include "stdafx.h"
#include "MedDLe.h"
//#include "CameraView.h"
#include "MainFrm.h"
#include "ChildFrm.h"
#include "2DView.h"
#include "MedDLeIO.h"
#include "MedDLeEdit.h"		// Our added graphics routines

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CMedDLeDoc2
//void AutoCreateLineData(CMedDLeFrame *mf);
//void AutoCreateObjects(CMedDLeFrame *mf);
//void AutoCreateColors(CMedDLeFrame *mf);

void CMedDLeDoc::AutoCreateLineData(CMedDLeBaseFrame &mf)
{

	BYTE found;
	//Triangle ctri;
	//LineRef clne;

	CMedDLeLine l;
	CMedDLeFace f;

	//AfxMessageBox("start lines");
	mf.l.RemoveAll();


	int i,j,k;
	// all tris
	for(j=0; j<mf.f.GetSize(); j++)
	{
		f = mf.f[j]; 
		// all sides
		for(i=0; i<3; i++)
		{
			found=0;
			// check against sort list of lines
			for(k=0; k<mf.l.GetSize(); k++)
			{
				l=mf.l[k];
				// if matched, then goto next side of triangle
				if (((l.vindex[0] == f.vindex[i%3]) && (l.vindex[1] == f.vindex[(i+1)%3])) ||
					((l.vindex[0] == f.vindex[(i+1)%3]) && (l.vindex[1] == f.vindex[i%3]))) 
				{
					found=1;
					break;
				}

			}
			// if not found, ad the mofo
			if(!found)
			{
				l.vindex[0] = f.vindex[i%3];
				l.vindex[1] = f.vindex[(i+1)%3];
				l.flags = 0;
				l.color = mf.f[j].color;
				mf.l.Add(l);
			}
		}
	}
	
}

void CMedDLeDoc::AutoCreateObjects(CMedDLeBaseFrame &mf)
{
	BYTE cmap[8]={8, 212, 25, 47, 55, 144, 79, 128};
	int cindex;

	CString str;
//	str.Format("%d",l.GetSize());

	int i,j,k;

	// init to -1

//	int **pig = new int*[mf.v.GetSize()+1];
	int *ig = new int[mf.v.GetSize()+1];
	
	int *fg = new int[mf.f.GetSize()];


	for(j=0;j<mf.f.GetSize(); j++) fg[j]=-1;

	int N=mf.v.GetSize();


	int cg=0;
	for(i=0;i<N; i++) 
	{
//		pig[i]=&ig[i];
		ig[i]=i;
	}
	for(j=0;j<mf.f.GetSize(); j++)
	{
		fg[j]=-1;
	}

	
		// all tris
	for(i=0;i<N; i++) 
	{
		for(j=0;j<mf.f.GetSize(); j++)
		{
			if((i==mf.f[j].vindex[0])||(i==mf.f[j].vindex[1])||(i==mf.f[j].vindex[2]))
			{
				if(fg[j]==-1)
					fg[j]=ig[i];
				else
				{
					int key;

					if(fg[j]<ig[i])
						key=ig[i];
					else 	
						key=fg[j];
					for(int jj=0;jj<mf.f.GetSize(); jj++)
					{
						if(fg[jj]==key) fg[jj]=fg[j];
					}
					for(jj=0;jj<N; jj++) if(key==ig[jj]) ig[i]=fg[j];
				}
			}
		}
	}


	CArray <int, int&> l;

	l.RemoveAll();
	k=0;
//	l.Add(fg[0]);
	int add;

	
	mf.g.RemoveAll();
	
	for(i=0;i<mf.f.GetSize(); i++)
	{
		add=1;
		for(j=0; j<l.GetSize(); j++)
		{
			if(fg[i]==l[j])
			{
				mf.f[i].group=j;
				mf.f[i].color=cmap[j&0x07];
				add=0;
				break;
			}
		}
		if(add)
		{
			CMedDLeGroup mg;
			l.Add(fg[i]);
			CString name;
			name.Format("group %d",l.GetSize());
			mg.name=name;
			mg.color=cmap[(l.GetSize()-1)&0x07];
			mg.flags=G_VISIBLE;
			mg.bone=0;
			mf.g.Add(mg);
			mf.f[i].group= l.GetSize()-1;
			mf.f[i].color=cmap[(l.GetSize()-1)&0x07];
		}

	}

	delete [] ig;
	delete [] fg;


}

void CMedDLeDoc::UpdateGrid(DWORD gn)
{
/*	float d, d2, d3;
	int i;
	int m0, m1;
	int vert, line;
	int steps[3];
	float size[3];
	float stepsize[3];
	float center[3];
	for (i=0; i<3; i++){
		steps[i]=Grids[gn].steps[i];
		size[i]=Grids[gn].size[i];
		center[i]=Grids[gn].center[i];
		stepsize[i]=size[i]/(steps[i]-1);
		Grids[gn].stepsize[i]=stepsize[i];
	}
	for (char view=0; view<3; view++){
		m0=AxisMap[view][0];
		m1=AxisMap[view][1];
		d=center[m0]-(size[m0]/2);
		d2=center[m1]-(size[m1]/2);
		d3=center[m1]+(size[m1]/2);
		Grids[gn].fv[view][0][0]=d;
		Grids[gn].fv[view][0][1]=d2;
		Grids[gn].fv[view][steps[m0]][0]=d;
		Grids[gn].fv[view][steps[m0]][1]=d3;
		Grids[gn].sl[view][0][0]=0;
		Grids[gn].sl[view][0][1]=steps[m0];
		line=1;
		vert=1;
		for (i=1; i<steps[m0]; i++){
			d+=stepsize[m0];
			Grids[gn].fv[view][vert][0]=d;
			Grids[gn].fv[view][vert][1]=d2;
			Grids[gn].fv[view][steps[m0]+vert][0]=d;
			Grids[gn].fv[view][steps[m0]+vert][1]=d3;
			Grids[gn].sl[view][line][0]=vert;
			Grids[gn].sl[view][line][1]=steps[m0]+vert;
			line++;
			vert++;
		}
		line=steps[m0];
		vert=steps[m0]*2;
		d=center[m1]-(size[m1]/2);
		d2=center[m0]-(size[m0]/2);
		d3=center[m0]+(size[m0]/2);
		Grids[gn].fv[view][vert][1]=d;
		Grids[gn].fv[view][vert][0]=d2;
		Grids[gn].fv[view][vert+steps[m1]][1]=d;
		Grids[gn].fv[view][vert+steps[m1]][0]=d3;
		Grids[gn].sl[view][line][0]=vert;
		Grids[gn].sl[view][line][1]=vert+steps[m1];
		vert++;
		line++;
		for (i=1; i<steps[m1]; i++){
			d+=stepsize[m1];
			Grids[gn].fv[view][vert][1]=d;
			Grids[gn].fv[view][vert][0]=d2;
			Grids[gn].fv[view][vert+steps[m1]][1]=d;
			Grids[gn].fv[view][vert+steps[m1]][0]=d3;
			Grids[gn].sl[view][line][0]=vert;
			Grids[gn].sl[view][line][1]=vert+steps[m1];
			line++;
			vert++;
		}
		Grids[gn].lines[view]=steps[m0]+steps[m1];
		Grids[gn].points[view]=(steps[m0]+steps[m1])*2;
	}
	*/
}

void CMedDLeDoc::AutoCreateColors(CMedDLeBaseFrame &mf)
{
/*	int v1, v2;
	int i,j;
	
	if (cur.frameptr==NULL) return;
	if(ClearBlue){
		for (j=0; j<Verts.GetSize(); j++) Verts[j].flags &= ~O_DRAW_BLUE;
	}
	if ((EditMode == SM_VERT)||(EditMode == SM_SKEL)){
		for (j=0; j<Verts.GetSize(); j++){
			if (Verts[j].flags & O_SELECTED) Verts[j].flags |= O_VSELECTED;
			else Verts[j].flags &= ~O_VSELECTED;
		}
		BOOL hide;
		BOOL sel;
		for (j=0; j<Tris.GetSize(); j++){
			hide=FALSE;
			sel=TRUE;
			for (i=0; i<3; i++){
				if (Verts[Tris[j].vindex[i]].flags&O_HIDDEN) hide=TRUE;
				if (!(Verts[Tris[j].vindex[i]].flags&O_SELECTED)) sel=FALSE;
				if (Verts[Tris[j].vindex[i]].group==Verts[Tris[j].vindex[(i+1)%3]].group) 
					Tris[j].color[i]=Objects[Verts[Tris[j].vindex[i]].object].Groups[Verts[Tris[j].vindex[i]].group]->color;
				else Tris[j].color[i]=Objects[Verts[Tris[j].vindex[i]].object].color;
			}
			if (hide) Tris[j].Vflags |= O_VHIDDEN;
			else Tris[j].Vflags &=~ O_VHIDDEN;
			if (sel) Tris[j].Vflags |= O_VSELECTED;
			else Tris[j].Vflags &=~ O_VSELECTED;
		}
	} else if (EditMode == SM_TRI){
		for (j=0; j<Verts.GetSize(); j++) Verts[j].flags &=~O_VSELECTED;
		for (j=0; j<Tris.GetSize(); j++){
			if (Tris[j].Vflags&O_HIDDEN) Tris[j].Vflags |= O_VHIDDEN;
			else Tris[j].Vflags &= ~O_VHIDDEN;
			for (i=0; i<3; i++){
				if (Verts[Tris[j].vindex[i]].group==Verts[Tris[j].vindex[(i+1)%3]].group) Tris[j].color[i]=Objects[Verts[Tris[j].vindex[i]].object].Groups[Verts[Tris[j].vindex[i]].group]->color;
				else Tris[j].color[i]=Objects[Verts[Tris[j].vindex[i]].object].color;
			}
			if (Tris[j].Vflags&O_SELECTED){
				Tris[j].Vflags |= O_VSELECTED;
				Verts[Tris[j].vindex[0]].flags |= O_VSELECTED;
				Verts[Tris[j].vindex[1]].flags |= O_VSELECTED;
				Verts[Tris[j].vindex[2]].flags |= O_VSELECTED;
			} else Tris[j].Vflags &=~O_VSELECTED;
		}
	} else if (EditMode == SM_GROUP){
		for (j=0; j<Verts.GetSize(); j++){
			if (Objects[Verts[j].object].Groups[Verts[j].group]->flags & O_SELECTED) Verts[j].flags |= O_VSELECTED;
			else Verts[j].flags &= ~O_VSELECTED;
		}
		BOOL hide;
		BOOL sel;
		for (j=0; j<Tris.GetSize(); j++){
			hide=FALSE;
			sel=TRUE;
			for (i=0; i<3; i++){
				if (Objects[Verts[Tris[j].vindex[i]].object].Groups[Verts[Tris[j].vindex[i]].group]->flags&O_HIDDEN) hide=TRUE;
				if (!(Objects[Verts[Tris[j].vindex[i]].object].Groups[Verts[Tris[j].vindex[i]].group]->flags&O_SELECTED)) sel=FALSE;
				if (Verts[Tris[j].vindex[i]].group==Verts[Tris[j].vindex[(i+1)%3]].group) 
					Tris[j].color[i]=Objects[Verts[Tris[j].vindex[i]].object].Groups[Verts[Tris[j].vindex[i]].group]->color;
				else Tris[j].color[i]=Objects[Verts[Tris[j].vindex[i]].object].color;
			}
			if (hide) Tris[j].Vflags |= O_VHIDDEN;
			else Tris[j].Vflags &=~ O_VHIDDEN;
			if (sel) Tris[j].Vflags |= O_VSELECTED;
			else Tris[j].Vflags &=~O_VSELECTED;
		}
	} if (EditMode == SM_OBJECT){
		for(j=0; j<Verts.GetSize(); j++){
			if (Objects[Verts[j].object].flags & O_SELECTED) Verts[j].flags |= O_VSELECTED;
			else Verts[j].flags &= ~O_VSELECTED;
		}
		for (j=0; j<Tris.GetSize(); j++){
			if (Objects[Verts[Tris[j].vindex[0]].object].flags&O_HIDDEN) Tris[j].Vflags |= O_VHIDDEN;
			else Tris[j].Vflags &= ~O_VHIDDEN;
			if (Objects[Verts[Tris[j].vindex[0]].object].flags&O_SELECTED) Tris[j].Vflags |= O_VSELECTED;
			else Tris[j].Vflags &= ~O_VSELECTED;
			for (i=0; i<3; i++) {
				Tris[j].color[i]=Objects[Verts[Tris[j].vindex[i]].object].color;
			}
		}
	}
	for (j=0; j<Tris.GetSize(); j++){
		if ((Verts[Tris[j].vindex[0]].flags&O_VSELECTED) && (Verts[Tris[j].vindex[1]].flags&O_VSELECTED)) Tris[j].color[0]=251;
		if ((Verts[Tris[j].vindex[0]].flags&O_DRAW_BLUE) && (Verts[Tris[j].vindex[1]].flags&O_DRAW_BLUE)) Tris[j].color[0]=208;
		if ((Verts[Tris[j].vindex[1]].flags&O_VSELECTED) && (Verts[Tris[j].vindex[2]].flags&O_VSELECTED)) Tris[j].color[1]=251;
		if ((Verts[Tris[j].vindex[1]].flags&O_DRAW_BLUE) && (Verts[Tris[j].vindex[2]].flags&O_DRAW_BLUE)) Tris[j].color[1]=208;
		if ((Verts[Tris[j].vindex[2]].flags&O_VSELECTED) && (Verts[Tris[j].vindex[0]].flags&O_VSELECTED)) Tris[j].color[2]=251;
		if ((Verts[Tris[j].vindex[2]].flags&O_DRAW_BLUE) && (Verts[Tris[j].vindex[0]].flags&O_DRAW_BLUE)) Tris[j].color[2]=208;
	}
	*/
}

void CMedDLeDoc::ResetViewVars(int view)
{

//	int i=view;
	// for each axis
//	for(int j=0; j<2; j++)
//	{
//		Extent[i][j]=cur.frameptr->fbboxmax.v[AxisMap[i][j]] - cur.frameptr->fbboxmin.v[AxisMap[i][j]];
//		Center[i][j]=Extent[i][j]/2.+ cur.frameptr->fbboxmin.v[AxisMap[i][j]];
//	}

	Zoom[view]=1.f;
  
}

void CMedDLeDoc::HandleCommonKeys(UINT nChar, UINT nRepCnt, UINT nFlags, int view)
{
/*	int cframe;
	CView* pView;
	CCameraView *pCameraView;
	CMainFrame *Main=(CMainFrame *)theApp.m_pMainWnd;
	int i;

	// this gets a pointer to the 3d view
	POSITION pos = GetFirstViewPosition();
	while(pos != NULL)
	{
		pView = GetNextView(pos);
		if(pView->IsKindOf(RUNTIME_CLASS(CCameraView)))
		{
			pCameraView = (CCameraView *)pView;
			break;
		}
	}
	cframe=cur.frame;
//	if (Frames[cur.frame] != NULL){
//		for (i=0; i<num.frames; i++){
//			if (Frames[i]==cur.frame) cframe=i;
//		}
//		if (cur.frame==Base) cframe=-1;
//		if (cur.frame==MapGen) cframe=-2;
//	}

	switch (nChar){
		case VK_LEFT: if(cur.skin==0) cur.skin=Skins.GetSize()-1;
			else cur.skin-=1;
			pCameraView->InvalidateRect(NULL,0);
			break;
		case VK_RIGHT: cur.skin++;
			if(cur.skin==Skins.GetSize()) cur.skin=0;
			pCameraView->InvalidateRect(NULL,0);break;
		case VK_PRIOR: bcolor++;
			if(bcolor>13) bcolor=0;
			pCameraView->InvalidateRect(NULL,0);break;
		case VK_NEXT: tcolor++;
			if(tcolor>13) tcolor=0;
			pCameraView->InvalidateRect(NULL,0);break;
		case VK_RETURN:
	//		if((ViewAct==C_SCALE)||(ViewAct==C_ROTATE)) ViewAct=C_NONE;
			break;
		// change current frame
		case VK_UP: 
			if ((cur.frameptr != NULL) && (cframe>=0)){
				cframe++; 
				if(cframe>=Frames.GetSize()) cframe=0; 
				cur.frameptr=Frames[cframe];
				cur.frame=cframe;
				UpdateAllViews(NULL);
			}
			break;
		case VK_DOWN: 
			if ((cur.frameptr != NULL) && (cframe>=0)){
				if(cframe==0) cframe=Frames.GetSize(); 
				cframe--; 
				cur.frameptr=Frames[cframe];
				cur.frame=cframe;
				UpdateAllViews(NULL);
			}
			break;
	}
	*/
}

//returns quakes vertex normal index, pass it a frame, a vertex, and the
// array of normals for all tris : float norm[3*num.tris]
int CMedDLeDoc::GetVertexNormal(CMedDLeFrame *f,int vindex,float *norm)
{
/*	#include "normals.h" // defines vertex_normal[];
	BG_3pt vnormal;
	double avex,avey,avez;
	int norm_count;

	avex=avey=avez=0.0;
	norm_count=0;
	int iii;
	for(int i=0; i<num.triangles; i++)
	{

		if((vindex==Tris[i].vindex[0])||(vindex==Tris[i].vindex[1])||(vindex==Tris[i].vindex[2]) )
		{
				iii=3*i;
				avex+=norm[iii];
				avey+=norm[iii+1];
				avez+=norm[iii+2];
				
				norm_count++;
		}
	}
	double C=1./(double)norm_count;
	vnormal.x=avex*C;
	vnormal.y=avey*C;
	vnormal.z=avez*C;

	int k=0; /// this is the index!
	double dotted_val, hi_dot;
	hi_dot=BG_DotProduct(&vertex_normal[0],&vnormal);

	for(i=1; i<162; i++)
	{
		dotted_val=BG_DotProduct(&vertex_normal[i],&vnormal);
		if(dotted_val>hi_dot)
		{
			hi_dot=dotted_val;
			k=i;
		}
	}
	return k;
*/
	return 1;
}

void CMedDLeDoc::GetNormal(CMedDLeFrame *f, int tri, float *norm)
{
/*
	BG_3pt a, b, c;

	b.x=f->fv[Tris[tri].vindex[1]].v[0] - f->fv[Tris[tri].vindex[0]].v[0];
	b.y=f->fv[Tris[tri].vindex[1]].v[1] - f->fv[Tris[tri].vindex[0]].v[1];
	b.z=f->fv[Tris[tri].vindex[1]].v[2] - f->fv[Tris[tri].vindex[0]].v[2];
	
	a.x=f->fv[Tris[tri].vindex[2]].v[0] - f->fv[Tris[tri].vindex[1]].v[0];
	a.y=f->fv[Tris[tri].vindex[2]].v[1] - f->fv[Tris[tri].vindex[1]].v[1];
	a.z=f->fv[Tris[tri].vindex[2]].v[2] - f->fv[Tris[tri].vindex[1]].v[2];
	// cross product
	c.x=(a.y*b.z) - (a.z*b.y);
    c.y=(a.z*b.x) - (a.x*b.z);
    c.z=(a.x*b.y) - (a.y*b.x);

	double mag = c.x*c.x+c.y*c.y+c.z*c.z;
    mag = sqrt(mag);
    if ( mag != 0.0 )
    {
		float C =1./mag;
        norm[0]=C*c.x;
        norm[1]=C*c.y;
        norm[2]=C*c.z;
    }
*/
}

void CMedDLeDoc::GetMDLScaleOffRad(float *scale,float *offset, float *rad)
{
/*	rad[0]=0;
	for(int i=0; i<3; i++)
	{
		offset[i]=boxmin[i];
		scale[i]=(boxmax[i]-boxmin[i])/255.0;	
		rad[0]+=(boxmax[i]-boxmin[i])*(boxmax[i]-boxmin[i]);
	}

	rad[0]=sqrt(rad[0]);
*/
}
// this creates the triverts
void CMedDLeDoc::MakeMDL(void)
{
/*	int i, j, k;
	float scale[3], offset[3], rad;
	GetMDLScaleOffRad(scale,offset,&rad);
	for(i=0; i<3; i++)
	{
		if(scale[i]==0) {AfxMessageBox("Warning:Model has no size in one or more dimensions..");}
	}
	for(i=0; i<Frames.GetSize(); i++)
	{
		for(j=0; j<3; j++)
		{
			if(scale[j]!=0)
			{
				Frames[i]->bboxmin.v[j]=(Frames[i]->fbboxmin.v[j]-offset[j])/scale[j];
				Frames[i]->bboxmax.v[j]=(Frames[i]->fbboxmax.v[j]-offset[j])/scale[j];
			}
			else 
			{
				Frames[i]->bboxmin.v[j]=0;
				Frames[i]->bboxmax.v[j]=0;
			}
		}

		for(k=0;k<num.vertices;k++)
		{
			for(j=0; j<3; j++)
			{
				Frames[i]->tv[k].vnormal = Frames[i]->fv[k].vnormal;
				
				if(scale[j]!=0)
					Frames[i]->tv[k].v[j]= (Frames[i]->fv[k].v[j]-offset[j])/scale[j];
				else 
					Frames[i]->tv[k].v[j]= 0;
			}
		}

		

	}

	Gflags |= S_IS_MDL;  // make 255 mesh
*/
}

//void CMedDLeDoc::GenerateBlankSkin(Skin *s)
//{
/*	// new skin (polygon pic)
	if(s==NULL) return;
	
	int x1,x2,x3;
	unsigned p1,p2,p3,p4;
	if(s->bitmap!=NULL) delete s->bitmap;
	s->bitmap =new unsigned char [SkinW*SkinH];

	memset(s->bitmap,0,SkinW*SkinH);

	int v1[2], v2[2];
	for(int i=0;i<num.triangles;i++)
	{
				p1=Tris[i].vindex[0];
				p2=Tris[i].vindex[1];
				p3=Tris[i].vindex[2];
				p4=Tris[i].flags;
				x1=x2=x3=0;
				if((Verts[p1].Mflags&S_ONSEEM)&&(p4==0)) x1=SkinW/2;
				if((Verts[p2].Mflags&S_ONSEEM)&&(p4==0)) x2=SkinW/2;
				if((Verts[p3].Mflags&S_ONSEEM)&&(p4==0)) x3=SkinW/2;
				v1[0]=Verts[p2].x+x2;
				v1[1]=Verts[p2].y;
				v2[0]=Verts[p3].x+x3;
				v2[1]=Verts[p3].y;
				vline(s->bitmap,v1,v2,this);
				v1[0]=Verts[p3].x+x3;
				v1[1]=Verts[p3].y;
				v2[0]=Verts[p1].x+x1;
				v2[1]=Verts[p1].y;
				vline(s->bitmap,v1,v2,this);
				v1[0]=Verts[p1].x+x1;
				v1[1]=Verts[p1].y;
				v2[0]=Verts[p2].x+x2;
				v2[1]=Verts[p2].y;
				vline(s->bitmap,v1,v2,this);
	}
*/
//}
// makes the 2d verts
void CMedDLeDoc::MakeSkinMapping(void)
{
/*	// set up SkinMap

	if(MapGen==NULL) MapGenFromFrame(0);
		
	for (int i=0 ; i<num.vertices; i++)
	{
		Verts[i].Mflags = 0;
	}
	
	for(i=0; i<Skins.GetSize();i++)
	{
		if(Skins[i]->bitmap!=NULL) delete [] Skins[i]->bitmap;
	}

	Skins.RemoveAll();

	float min[3], max[3];
	for (i=0; i<3; i++)
	{
		min[i]=floor(MapGen->fbboxmin.v[i]);
		max[i]=ceil(MapGen->fbboxmax.v[i]);
	}

	double width = (max[1] - min[1]);
	double height = (max[2] - min[2]);
	
	double scale = 8.;
	
	if (width*scale >= 150)
		scale = 150. / width;
	if (height*scale >= 190)
		scale = 190. / height;
	
	int iwidth,iheight;
	iwidth = (int)(ceil(width*scale) + 4);
	iheight = (int)(ceil(height*scale) + 4);

	int skinwidth = iwidth*2;

	SkinW = (skinwidth + 3) & ~3;
	SkinH = iheight;
	//char str[256];
	//sprintf(str,"%d %d",SkinW,SkinH);
	//AfxMessageBox(str);	
//	Skin *s=new Skin;
//	Skins.Add(s);

	
	float basex, basey;

	for (i=0 ; i<num.triangles ; i++)
	{
		int		j;

		// may be minus	block[0].side_normal[i]
		// look at y part
		// if facing back
		float norm[3];
		GetNormal(MapGen, i, norm);
		
		if (norm[0] < 0)
		{
			basex = iwidth + 2;
			Tris[i].flags = 0;
		}
		else
		{
			basex = 2;
			Tris[i].flags = 1;
		}

		basey = 2;


		for (j=0 ; j<3 ; j++)
		{
			//BG_3pt *vert3;
			//vert3=&block[0].ptlist[side[i].pt[j]];
		
			int tri_index=Tris[i].vindex[j];

			if (Tris[i].flags)
			{
				Verts[tri_index].Mflags |=1;
			}
			else
			{
				Verts[tri_index].Mflags |= 2;
			}

			if ((Tris[i].flags) || ((Verts[tri_index].Mflags & 1) == 0))
			{
			   // we want the front s value for seam vertices
				Verts[tri_index].x=(int)((MapGen->fv[tri_index].v[1] - min[1]) * scale + basex);
				Verts[tri_index].y=SkinH-(int)((MapGen->fv[tri_index].v[2] - min[2]) * scale + basey);
			}
		}
		
	}

	for (i=0 ; i<num.vertices ; i++)
	{
		if (Verts[i].Mflags == 3)
		{
			 Verts[i].Mflags = S_ONSEEM;
		}
		else
		{
			 Verts[i].Mflags = 0;
		}
	}

//	AfxMessageBox("skinned");
	Skin *s=new Skin;
	s->type=0;
	Skins.Add(s);
	num.skins=1;
	GenerateBlankSkin(Skins[0]);


	Gflags |= S_HAS_SKIN;  //make a skin
*/
}

// make a base frome the skin mapping
void CMedDLeDoc::MapGenFromSkinMap(void)
{
/*	if(MapGen!=NULL) delete MapGen;
	MapGen=new Frame;
	MapGen->type=0;

	strcpy(MapGen->name,"MappingFrame");
	int i,j,k;
	for(i=0; i<3; i++)
	{
		MapGen->fbboxmin.v[i]=1e23;
		MapGen->fbboxmax.v[i]=-1e23;
	}
	float minx=1e23, maxx=-1e23, miny=1e23,maxy=-1e23;
	for(i=0;i<num.vertices;i++)
	{
		if(Verts[i].x<minx)minx=Verts[i].x;
		if(Verts[i].x>maxx)maxx=Verts[i].x;
		if(Verts[i].y<miny)miny=Verts[i].y;
		if(Verts[i].y>maxy)maxy=Verts[i].y;
	}
	if(maxx==minx) maxx+=1.;
	if(maxy==miny) maxy+=1.;

	float scalex, scaley;

	scalex=(boxmax[1]-boxmin[1])/(maxx-minx)*2.*.75;
	scaley=(boxmax[2]-boxmin[2])/(maxy-miny)*.75;

	for(i=0;i<num.vertices;i++)
	{	
		if(Verts[i].x > SkinW/2)
			MapGen->fv[i].v[1]=(float)(Verts[i].x - SkinW/2-minx)*scalex+boxmin[1];
		else
			MapGen->fv[i].v[1]=(float)(Verts[i].x-minx)*scalex+boxmin[1];
		
		if(Verts[i].Mflags&S_ONSEEM)
			MapGen->fv[i].v[0]=0;
		else if(Verts[i].x > SkinW/2)
			MapGen->fv[i].v[0]=-20.;
		else
			MapGen->fv[i].v[0]=20.;

		MapGen->fv[i].v[2]=(float)(maxy-Verts[i].y+miny)*scaley+boxmin[2];

		for(j=0; j<3; j++)
		{	
			if(MapGen->fbboxmin.v[j] > MapGen->fv[i].v[j])
				MapGen->fbboxmin.v[j] = MapGen->fv[i].v[j];
			if(MapGen->fbboxmax.v[j] < MapGen->fv[i].v[j])
				MapGen->fbboxmax.v[j] = MapGen->fv[i].v[j];
		}	

	}
	// now find vertex normals!
	float *norm=new float [3*num.triangles];
	for( k=0; k <num.triangles ; k++) 
		GetNormal(MapGen, k, &norm[3*k]);

	for( j=0;j<num.vertices; j++){
		MapGen->fv[j].vnormal=GetVertexNormal(MapGen,j,norm);
		//Verts[j].flags=0;
	}
	delete [] norm; 
	*/
}

void CMedDLeDoc::BaseFromSkinMap(void)
{
/*	if(Base!=NULL) delete Base;
	Base=new Frame;
	strcpy(Base->name,"BaseFrame");
	Base->type=0;

	int i,j,k;
	for(i=0; i<3; i++)
	{
		Base->fbboxmin.v[i]=1e23;
		Base->fbboxmax.v[i]=-1e23;
	}
	float minx=1e23, maxx=-1e23, miny=1e23,maxy=-1e23;
	for(i=0;i<num.vertices;i++)
	{
		if(Verts[i].x<minx)minx=Verts[i].x;
		if(Verts[i].x>maxx)maxx=Verts[i].x;
		if(Verts[i].y<miny)miny=Verts[i].y;
		if(Verts[i].y>maxy)maxy=Verts[i].y;
	}
	if(maxx==minx) maxx+=1.;
	if(maxy==miny) maxy+=1.;

	float scalex, scaley;

	scalex=(boxmax[1]-boxmin[1])/(maxx-minx)*2.*.75;
	scaley=(boxmax[2]-boxmin[2])/(maxy-miny)*.75;

	for(i=0;i<num.vertices;i++)
	{	
		if(Verts[i].x > SkinW/2)
			Base->fv[i].v[1]=(float)(Verts[i].x - SkinW/2-minx)*scalex+boxmin[1];
		else
			Base->fv[i].v[1]=(float)(Verts[i].x-minx)*scalex+boxmin[1];
		
		if(Verts[i].Mflags&S_ONSEEM)
			Base->fv[i].v[0]=0;
		else if(Verts[i].x > SkinW/2)
			Base->fv[i].v[0]=-20.;
		else
			Base->fv[i].v[0]=20.;

		Base->fv[i].v[2]=(float)(maxy-Verts[i].y+miny)*scaley+boxmin[2];

		for(j=0; j<3; j++)
		{	
			if(Base->fbboxmin.v[j] > Base->fv[i].v[j])
				Base->fbboxmin.v[j] = Base->fv[i].v[j];
			if(Base->fbboxmax.v[j] < Base->fv[i].v[j])
				Base->fbboxmax.v[j] = Base->fv[i].v[j];
		}	

	}
	// now find vertex normals!
	float *norm=new float [3*num.triangles];
	for( k=0; k <num.triangles ; k++) 
		GetNormal(Base, k, &norm[3*k]);

	for( j=0;j<num.vertices; j++){
		Base->fv[j].vnormal=GetVertexNormal(Base,j,norm);
		//Verts[j].flags=0;
	}
	delete [] norm;

*/ 
}
void CMedDLeDoc::MapGenFromFrame(int frame)
{
/*	int i;
	if(MapGen!=NULL) delete MapGen;
	MapGen=new Frame;
	if(frame==-1) 
	{
		memcpy(MapGen, Base,sizeof(Frame));
	}
	else
	{
		memcpy(MapGen, Frames[frame],sizeof(Frame));
	}
	strcpy(MapGen->name,"MappingFrame");
	MapGen->type=0;
*/
}

#include <memory.h>
void CMedDLeDoc::BaseFromFrame(int frame)
{
/*	int i;
	Gflags |= S_HAS_BASE;
	if(Base!=NULL) delete Base;
	Base=new Frame;
	memcpy(Base, Frames[frame],sizeof(Frame));
	strcpy(Base->name,"BaseFrame");
	Base->type=0;
*/
}
void CMedDLeDoc::AddFrame(CMedDLeFrame *frame)
{
//	Frames.Add(frame);

}

void CMedDLeDoc::DeleteFrame(int frame)
{
/*	if((frame>0)&&(frame<Frames.GetSize()))
	{
		//if(cur.frame>=Frames.GetSize()) 
		//{
		if(cur.frame>=frame)
		{
			cur.frame=frame-1;
			if(cur.frame>=0)
				cur.frameptr=Frames[cur.frame];
			else {cur.frame=-1; cur.frameptr=Base;}
		}	
			Frame *f;
			f=Frames[frame];
			Frames.RemoveAt(frame);
			delete f;
	//	}
	}
*/
}

void CMedDLeDoc::CopyFrame(CMedDLeFrame *dest, CMedDLeFrame *src)
{
	memcpy(dest, src,sizeof(CMedDLeFrame));
}

void CMedDLeDoc::InsertFrame(CMedDLeFrame *frame, int pos)
{
//	if(pos>=Frames.GetSize()) AddFrame(frame);
//	else if((pos>=0)&&(pos<Frames.GetSize()))
//	{
//		Frames.InsertAt(pos, frame);
//		if(cur.frame>=pos) {cur.frame++; cur.frameptr=Frames[cur.frame];}
//	}
}

void CMedDLeDoc::AddFrameToFGroup(int framepos, int groupid)
{

}


void CMedDLeDoc::ParseAnimationInfo(void)
{

	
	int N=m_MedDLeObject.m_Anims.GetSize();
	int i;
	for(i=0; i<N; i++)
	{
		delete m_MedDLeObject.m_Anims[i];
	}
	m_MedDLeObject.m_Anims.RemoveAll();

	CString name;
	CString num;
	int nnum;

	name=m_MedDLeObject.m_Frames[0]->name;

	int k,j;
	i=name.FindOneOf("0123456789");
	num=name.Right(name.GetLength()-i);
	nnum=atoi(num.GetBuffer(0));
	nnum=nnum/100;
	if(nnum>0) 
		name=name.Left(i+1);
	else	
		name=name.Left(i);

	CMedDLeMeshAnimation *ma;
	ma=new CMedDLeMeshAnimation;

	ma->name=name;
	i=0;
	ma->framelist.Add(i);

	m_MedDLeObject.m_Anims.Add(ma);

	m_MedDLeObject.m_curAnim=ma;
	m_MedDLeObject.m_curAnimN=0;

	for(j=1; j< m_MedDLeObject.m_Frames.GetSize(); j++)
	{

		name=m_MedDLeObject.m_Frames[j]->name;
		i=name.FindOneOf("0123456789");
		num=name.Right(name.GetLength()-i);
		nnum=atoi(num.GetBuffer(0));
		nnum=nnum/100;
		if(nnum>0) 
			name=name.Left(i+1);
		else	
			name=name.Left(i);

		int makenew=1;
		for(k=0; k<m_MedDLeObject.m_Anims.GetSize(); k++)
		{
			CString cname;
			cname=m_MedDLeObject.m_Anims[k]->name;

			if(name.CompareNoCase(cname)==0)
			{
				m_MedDLeObject.m_Anims[k]->framelist.Add(j);
				makenew=0;
				break;
			}
		}

		if(makenew) // make new
		{
			CMedDLeMeshAnimation *ma2=new CMedDLeMeshAnimation;
			ma2->name=name;
			ma2->framelist.Add(j);
			m_MedDLeObject.m_Anims.Add(ma2);
		}
		m_MedDLeObject.m_Frames[j]->animation=name;
	}
	
}

// this sucks.. will need to put a list in the bone of children
void CMedDLeDoc::FindChildBones(int bone)
{
/*	if((bone<0)||(bone>Skeleton.cnt)) return;
	int i,j;
	// go through all bones
	for(i=0; i<Skeleton.cnt; i++)
	{	
		// add to list
		if((bone==Skeleton.parentindex[i])&&(bone!=i))
		{
			int inlist=0;
			//see if already in list
			for(j=0; j<curChildBones.GetSize(); j++)
			{
				if(curChildBones[j]==i) {inlist=1; break;}
			}
			if(inlist==0) 
			{
				//AfxMessageBox("Found Kid");
				curChildBones.Add(i);
				// now get all of it's children
				FindChildBones(i);
			}
		}
	}
*/
}
