// CameraDlg.cpp : implementation file
//

#include "stdafx.h"
#include "MedDLe.h"
#include "MainFrm.h"
#include "CameraDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCameraDlg dialog


CCameraDlg::CCameraDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCameraDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCameraDlg)
	m_Tris = FALSE;
	m_Verts = FALSE;
	m_BackC = 0;
	m_ShirtC = 0;
	m_PantsC = 0;
	m_FrontBack = FALSE;
	//}}AFX_DATA_INIT
	
}


void CCameraDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCameraDlg)
	DDX_Control(pDX, IDC_SPIN3, m_SpinPants);
	DDX_Control(pDX, IDC_SPIN2, m_SpinShirt);
	DDX_Control(pDX, IDC_SLIDER2, m_Spot);
	DDX_Control(pDX, IDC_SLIDER1, m_Ambient);
	DDX_Control(pDX, IDC_RADIO_NONE, m_None);
	DDX_Control(pDX, IDC_RADIO_FLAT, m_Flat);
	DDX_Control(pDX, IDC_RADIO_SHADE, m_Shade);
	DDX_Control(pDX, IDC_RADIO_TEX, m_Tex);
	DDX_Control(pDX, IDC_RADIO_TEXSHADE, m_TexShade);
	DDX_Check(pDX, IDC_CHECK1, m_Tris);
	DDX_Check(pDX, IDC_CHECK2, m_Verts);
	DDX_Text(pDX, IDC_EDIT1, m_BackC);
	DDV_MinMaxUInt(pDX, m_BackC, 0, 255);
	DDX_Text(pDX, IDC_EDIT2, m_ShirtC);
	DDV_MinMaxUInt(pDX, m_ShirtC, 0, 15);
	DDX_Text(pDX, IDC_EDIT3, m_PantsC);
	DDV_MinMaxUInt(pDX, m_PantsC, 0, 15);
	DDX_Check(pDX, IDC_CHECK3, m_FrontBack);
	//}}AFX_DATA_MAP
	if(pdoc->IsKindOf(RUNTIME_CLASS(CMedDLeDoc)))
	{
		//pdoc->fill_mode=viewmode;
//		if (m_Tris) pdoc->Rflags |= R_WIRE;
//		else pdoc->Rflags &= ~R_WIRE;
//		if (m_Verts) pdoc->Rflags |= R_VERT;
//		else pdoc->Rflags &= ~R_VERT;
//		if (m_FrontBack) pdoc->Rflags |= R_FB;
//		else pdoc->Rflags &= ~R_FB;
		pdoc->back_color=m_BackC;
		pdoc->tcolor=m_ShirtC;
		pdoc->bcolor=m_PantsC;
		pdoc->UpdateAllViews(NULL);

	}

}


BEGIN_MESSAGE_MAP(CCameraDlg, CDialog)
	//{{AFX_MSG_MAP(CCameraDlg)
	ON_BN_CLICKED(IDC_RADIO_FLAT, OnRadioFlat)
	ON_BN_CLICKED(IDC_RADIO_NONE, OnRadioNone)
	ON_BN_CLICKED(IDC_RADIO_SHADE, OnRadioShade)
	ON_BN_CLICKED(IDC_RADIO_TEX, OnRadioTex)
	ON_BN_CLICKED(IDC_RADIO_TEXSHADE, OnRadioTexshade)
	ON_WM_CLOSE()
	ON_WM_HSCROLL()
	ON_BN_CLICKED(IDC_BUTTON_BACKPAL, OnButtonBackpal)
	ON_BN_CLICKED(IDC_CHECK1, OnCheck1)
	ON_BN_CLICKED(IDC_CHECK2, OnCheck2)
	ON_BN_CLICKED(IDC_CHECK3, OnCheck3)
	ON_EN_CHANGE(IDC_EDIT1, OnChangeEdit1)
	ON_EN_CHANGE(IDC_EDIT2, OnChangeEdit2)
	ON_EN_CHANGE(IDC_EDIT3, OnChangeEdit3)
	ON_NOTIFY(NM_CLICK, IDC_SPIN2, OnClickSpin2)
	ON_NOTIFY(NM_CLICK, IDC_SPIN3, OnClickSpin3)
	ON_EN_UPDATE(IDC_EDIT2, OnUpdateEdit2)
	ON_EN_UPDATE(IDC_EDIT3, OnUpdateEdit3)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCameraDlg message handlers

void CCameraDlg::OnRadioFlat() 
{
//	viewmode=1;
	pdoc->fill_mode=1;
	pdoc->UpdateAllViews(NULL);
	SetGreys();
}

void CCameraDlg::OnRadioNone() 
{
//	viewmode=0;
	pdoc->fill_mode=0;
	pdoc->UpdateAllViews(NULL);
	SetGreys();
}

void CCameraDlg::OnRadioShade() 
{
//	viewmode=2;
	pdoc->fill_mode=2;
	pdoc->UpdateAllViews(NULL);
	SetGreys();
}

void CCameraDlg::OnRadioTex() 
{
//	viewmode=3;
	pdoc->fill_mode=3;
	pdoc->UpdateAllViews(NULL);

	SetGreys();
}

void CCameraDlg::OnRadioTexshade() 
{
//	viewmode=4;
	pdoc->fill_mode=4;
	pdoc->UpdateAllViews(NULL);

	SetGreys();
}


BOOL CCameraDlg::OnInitDialog() 
{
	
	CDialog::OnInitDialog();
	
	//if((!(pdoc->Gflags & S_HAS_SKIN))&&(pdoc->fill_mode>2)) pdoc->fill_mode=2;
	
	m_Spot.SetRange(0,63);
	m_Ambient.SetRange(0,63);
	//m_SpinBack.SetRange(0,255);
	m_SpinShirt.SetRange(0,15);
	m_SpinPants.SetRange(0,15);
	if(pdoc->fill_mode==0) m_None.SetCheck(1);	
	if(pdoc->fill_mode==1) m_Flat.SetCheck(1);	
	if(pdoc->fill_mode==2) m_Shade.SetCheck(1);	
	if(pdoc->fill_mode==3) m_Tex.SetCheck(1);	
	if(pdoc->fill_mode==4) m_TexShade.SetCheck(1);	

	m_Spot.SetPos(pdoc->light_intensity);
	m_Ambient.SetPos(pdoc->ambient_intensity);

	SetGreys();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CCameraDlg::OnClose() 
{
	CDialog::OnClose();
}

void CCameraDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	//DoDataExchange();
	pdoc->light_intensity=m_Spot.GetPos();
	pdoc->ambient_intensity=m_Ambient.GetPos();
	pdoc->UpdateAllViews(NULL);

	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}

void CCameraDlg::SetGreys() 
{
	if(pdoc->fill_mode<4)
	{
		m_Spot.EnableWindow(FALSE);
		m_Ambient.EnableWindow(FALSE);
	}
	else
	{
		m_Spot.EnableWindow(TRUE);
		m_Ambient.EnableWindow(TRUE);
	}

	if(pdoc->fill_mode >2)
	{
//		m_ShirtC.EnableWindow(TRUE);
//		m_PantsC.EnableWindow(TRUE);
	}
	else
	{
//		m_ShirtC.EnableWindow(FALSE);
//		m_PantsC.EnableWindow(FALSE);

	}
//	if(pdoc->Gflags&S_HAS_SKIN)
//	{
//		m_Tex.EnableWindow(TRUE);		
//		m_TexShade.EnableWindow(TRUE);	
//		m_FrontBack.EnableWindow(TRUE);
//	}
//	else
//	{
//		m_Tex.EnableWindow(FALSE);		
//		m_TexShade.EnableWindow(FALSE);			
//		m_FrontBack.EnableWindow(FALSE);

//	}

}


#include "PaletteDlg.h"
void CCameraDlg::OnButtonBackpal() 
{
	int old;
	int backcolor;
	CPaletteDlg pdlg;
	old=pdoc->back_color;
	pdlg.SelectedColor=pdoc->back_color;
	pdlg.pDoc=pdoc;
	backcolor=pdoc->back_color;
	pdlg.color=(int *)&pdoc->back_color;
	if(pdlg.DoModal()!=IDOK)
		pdoc->back_color=old;
	//else pdoc->back_color=backcolor;
	m_BackC=pdoc->back_color;
	UpdateData(FALSE);
	pdoc->UpdateAllViews(NULL);


}

void CCameraDlg::OnCheck1() 
{
	UpdateData();
//		if (m_Tris) pdoc->Rflags |= R_WIRE;
//		else pdoc->Rflags &= ~R_WIRE;
		pdoc->UpdateAllViews(NULL);
	
}

void CCameraDlg::OnCheck2() 
{
	UpdateData();
//		if (m_Verts) pdoc->Rflags |= R_VERT;
//		else pdoc->Rflags &= ~R_VERT;
		pdoc->UpdateAllViews(NULL);
}

void CCameraDlg::OnCheck3() 
{
	UpdateData();
//		if (m_FrontBack) pdoc->Rflags |= R_FB;
//		else pdoc->Rflags &= ~R_FB;
		pdoc->UpdateAllViews(NULL);
}

void CCameraDlg::OnChangeEdit1() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	pdoc->back_color=m_BackC;
	pdoc->UpdateAllViews(NULL);
	
}

void CCameraDlg::OnChangeEdit2() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	pdoc->tcolor=m_ShirtC;
	pdoc->UpdateAllViews(NULL);
	
}

void CCameraDlg::OnChangeEdit3() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	pdoc->bcolor=m_PantsC;
	pdoc->UpdateAllViews(NULL);	
}

void CCameraDlg::OnClickSpin2(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	pdoc->tcolor=m_ShirtC;
	pdoc->UpdateAllViews(NULL);
		
	*pResult = 0;
}

void CCameraDlg::OnClickSpin3(NMHDR* pNMHDR, LRESULT* pResult) 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	pdoc->bcolor=m_PantsC;
	pdoc->UpdateAllViews(NULL);
	
	*pResult = 0;
}

void CCameraDlg::OnUpdateEdit2() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	pdoc->tcolor=m_ShirtC;
	pdoc->UpdateAllViews(NULL);
	
}

void CCameraDlg::OnUpdateEdit3() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	pdoc->bcolor=m_PantsC;
	pdoc->UpdateAllViews(NULL);	
	
}
