// md2 io
#include "stdafx.h"
#include "..\MedDLeGFX\MedDLeTypes.h"
#include "..\MedDLeGFX\MedDLe3D.h"
#include "..\MedDLeGFX\MedDLeMath.h"
#include "IOPCX.h"
#include "IOMD2.h"

BOOL IOPCXWrite(LPCSTR fname, CMedDLeTexture &mt );

void BuildGlCmds (void);

#define IDALIASHEADER (('2'<<24)+('P'<<16)+('D'<<8)+'I')
#define ALIAS_VERSION 8
#define MAX_TRIANGLES 4096
#define MAX_VERTS 2048
#define MAX_FRAMES 512
#define MAX_MD2SKINS 32
#define MAX_SKINNAME 64

typedef struct
{
short s;
short t;
} dstvert_t;

typedef struct 
{
short index_xyz[3];
short index_st[3];
} dtriangle_t;

typedef struct
{
BYTE v[3]; // scaled byte to fit in frame mins/maxs
BYTE lightnormalindex;
} dtrivertx_t;

#define DTRIVERTX_V0 0
#define DTRIVERTX_V1 1
#define DTRIVERTX_V2 2
#define DTRIVERTX_LNI 3
#define DTRIVERTX_SIZE 4

typedef struct
{
float scale[3]; // multiply byte verts by this
float translate[3]; // then add this
char name[16]; // frame name from grabbing
dtrivertx_t verts[1]; // variable sized
} daliasframe_t;

// the glcmd format:
// a positive integer starts a tristrip command, followed by that many
// vertex structures.
// a negative integer starts a trifan command, followed by -x vertexes
// a zero indicates the end of the command list.
// a vertex consists of a floating point s, a floating point t,
// and an integer vertex index.
typedef struct
{
	float s;
	float t;
	int   index;
} glvert;

typedef struct
{
int ident;
int version;

int skinwidth;
int skinheight;
int framesize; // byte size of each frame

int num_skins;
int num_xyz;
int num_st; // greater than num_xyz for seams
int num_tris;
int num_glcmds; // dwords in strip/fan command list
int num_frames;

int ofs_skins; // each skin is a MAX_SKINNAME string
int ofs_st; // byte offset from start for stverts
int ofs_tris; // offset for dtriangles
int ofs_frames; // offset for first frame
int ofs_glcmds; 
int ofs_end; // end of file

} dmdl_t;

typedef float vec_t;
typedef vec_t vec3_t[3];


dmdl_t		*model;

//
// base frame info
//
int			numcommands;
int			numglverts;

vec3_t		*base_xyz;
dstvert_t	*base_st;
dtriangle_t	*triangles;

int			*triangle_st;

// the command list holds counts, s/t values, and xyz indexes
// that are valid for every frame
int			*commands;
int			*used;
int		*strip_xyz;
int		*strip_st;
int		*strip_tris;
int		stripcount;


BOOL IOMD2Read(LPCSTR fname, CMedDLeObject &mo)
{
	dmdl_t md2;


	FILE *in;
	in=fopen(fname,"rb");
	if(in==NULL) return FALSE;
	// header
	fread(&md2,sizeof(dmdl_t),1,in);

	mo.m_BaseFrame->f.RemoveAll();
	mo.m_BaseFrame->l.RemoveAll();
	mo.m_BaseFrame->v.RemoveAll();
	mo.m_Frames.RemoveAll();
	
	
	CString n;
	int i,j;

//	CString txt;
//	txt.Format("s:%d xyz:%d st:%d t:%d gl:%d f:%d",md2.num_skins, md2.num_xyz,md2.num_st,	md2.num_tris,md2.num_glcmds,md2.num_frames);
//AfxMessageBox(txt);
//	txt.Format("s:%u st:%u tri:%u f:%u gl:%u f:%u",
//	md2.ofs_skins,md2.ofs_st,md2.ofs_tris,md2.ofs_frames,md2.ofs_glcmds,md2.ofs_end);
//AfxMessageBox(txt);
	
	/*md2.ofs_skins,
	md2.ofs_st=md2.ofs_skins+MAX_SKINNAME*md2.num_skins; // byte offset from start for stverts
	md2.ofs_tris=md2.ofs_st+sizeof(dstvert_t)*md2.num_st; // offset for dtriangles
	md2.ofs_frames=md2.ofs_tris+sizeof(dtriangle_t)*md2.num_tris; // offset for first frame
	md2.ofs_glcmds=md2.ofs_frames+md2.framesize*md2.num_frames; 
	md2.ofs_end=md2.ofs_glcmds+3*md2.num_tris*sizeof(glvert)+sizeof(int)*(md2.num_tris+1); // end of file
*/
	// skin names
	fseek(in,(UINT)md2.ofs_skins,SEEK_SET);
	char skinname[MAX_SKINNAME];

	CString str;
	CWinApp* pApp = AfxGetApp();
	str=pApp->GetProfileString("games\\quake2", "base", "c:/quake2/baseq2");
	CString last;
	str.TrimRight();
	str.TrimLeft();
	last = str.Right(1);
	if((last != "\\") &&(last != "/")) str+="/";

		// quake =1, quake2 =2 jk =3 hexen =4
	mo.m_game=2;
	mo.m_bValidSkin=TRUE;	// q,q2,h
	mo.m_nSkinWidth=md2.skinwidth;	// q,q2,h
	mo.m_nSkinHeight=md2.skinheight;
	if(md2.num_skins==0) mo.m_bSaveSkins=FALSE;
	else mo.m_bSaveSkins=TRUE;

	for(i=0; i<md2.num_skins; i++)
	{
		fread(skinname,MAX_SKINNAME,1,in);
		CMedDLeTexture *mt=new CMedDLeTexture;
		//AfxMessageBox(skinname);
		CString str2;
		str2=str;
		str2+=skinname;
//		AfxMessageBox(str2);
//		AfxMessageBox(skinname);
		mt->name=skinname;
		mt->size[0]=md2.skinwidth;
		mt->size[1]=md2.skinheight;
		if(!mt->Read(str2)) delete mt;
		else mo.m_BaseFrame->t.Add(mt);
	}

	// read texture mapping info
	fseek(in,(UINT)md2.ofs_st,SEEK_SET);
	dstvert_t *dst = new dstvert_t[md2.num_st];
	fread(&dst[0],sizeof(dstvert_t),md2.num_st,in);

	// read faces
	fseek(in,(UINT)md2.ofs_tris,SEEK_SET);
	for(i=0; i<md2.num_tris; i++)
	{
		dtriangle_t dt;
		fread(&dt,sizeof(dtriangle_t),1,in);

		CMedDLeFace m;

		m.vindex[0]=dt.index_xyz[0];
		m.vindex[1]=dt.index_xyz[1];
		m.vindex[2]=dt.index_xyz[2];

		m.tx[0][0] = dst[dt.index_st[0]].s;
		m.tx[0][1] = dst[dt.index_st[0]].t;
		m.tx[1][0] = dst[dt.index_st[1]].s;
		m.tx[1][1] = dst[dt.index_st[1]].t;
		m.tx[2][0] = dst[dt.index_st[2]].s;
		m.tx[2][1] = dst[dt.index_st[2]].t;

		mo.m_BaseFrame->f.Add(m);

	}

	fseek(in,(UINT)md2.ofs_frames,SEEK_SET);
	for(j=0; j<md2.num_xyz; j++)
	{
		CMedDLeBaseVertex bv;
		mo.m_BaseFrame->v.Add(bv);
	}

	CMedDLeVertex v;
	for(i=0; i<md2.num_frames; i++)
	{
		float scale[3]; // multiply byte verts by this
		float translate[3]; // then add this
		char name[16]; // frame name from grabbing

		fread(scale,sizeof(float),3,in);
		fread(translate,sizeof(float),3,in);
		fread(name,1,16,in);
		n=name;
		CMedDLeFrame *mf = new CMedDLeFrame(n);
		dtrivertx_t tv;
		for(j=0; j<md2.num_xyz; j++)
		{
			fread(&tv,sizeof(dtrivertx_t),1,in);
			v.x[0]=scale[0]*tv.v[0]+translate[0];
			v.x[1]=scale[1]*tv.v[1]+translate[1];
			v.x[2]=scale[2]*tv.v[2]+translate[2];
			mf->v.Add(v);
		}
		mo.m_Frames.Add(mf);
	}

/*	fseek(in,(UINT)md2.ofs_glcmds,SEEK_SET);
	// spit to file 
	FILE *o=fopen("gl.txt","wt");

	int N;
	int id=1;
	float f;
	glvert glv;
	while(id!=0)
	{
		fread(&id,sizeof(int),1,in);
		fprintf(o,"%d:",id);

		id=abs(id);
		for(j=0;j<id;j++)
		{
			fread(&f,sizeof(float),1,in);
			fprintf(o,"\t%g",f);
			fread(&f,sizeof(float),1,in);
			fprintf(o,", %g",f);
			fread(&N,sizeof(int),1,in);
			fprintf(o,", %d\n",N);
		}
	}
	id=0;
//	fwrite(&id,sizeof(int),1,out);

	fclose(o);
*/
	// delete temp st vertex
	delete [] dst;

	fclose(in);
	return 1;
}



BOOL IOMD2Write(LPCSTR fname,CMedDLeObject &mo)
{

	dmdl_t md2;



	model = &md2;

	md2.ident=IDALIASHEADER;
	md2.version=ALIAS_VERSION;


	int i,j,k,N, count;

	N=mo.m_BaseFrame->f.GetSize();


	base_st=new dstvert_t[3*N];			//////////////////
	triangles=new dtriangle_t[N];		//////////////////

	//base_xyz = new vec3_t[MAX_VERTS];				
	//triangle_st = new int[MAX_TRIANGLES*3*2];

	commands =new int[16384];
	used=new int[MAX_TRIANGLES];
	strip_xyz=new int[128];
	strip_st=new int[128];
	strip_tris=new int[128];

	count=0;
	int s,t,add;
	for(i=0; i<N; i++)
	{
	//	CMedDLeFace m
		for(j=0;j<3;j++)
		{

			triangles[i].index_xyz[j]=mo.m_BaseFrame->f[i].vindex[j];
			
			s=mo.m_BaseFrame->f[i].tx[j][0];
			t=mo.m_BaseFrame->f[i].tx[j][1];
			add=1;
			for(k=0; k<count; k++)
			{
				if((s== base_st[k].s)&&(t == base_st[k].t))
				{
					triangles[i].index_st[j]=k;
					add=0;
					break;
				}
			}
			if(add)
			{
				triangles[i].index_st[j]=count;
				base_st[count].s=s;
				base_st[count].t=t;
				count++;
			}

		}	
	
	}

	md2.num_skins=mo.m_BaseFrame->t.GetSize();

	CString txt;
//	txt.Format("%d",md2.num_skins);
//	AfxMessageBox(txt);

	//m_bValidSkin=TRUE;	// q,q2,h
//	m_nSkinWidth=md2.skinwidth;	// q,q2,h
//	m_nSkinHeight=md2.skinheight;
//	if(md2.num_skins==0) m_bSaveSkins=FALSE;
//	else m_bSaveSkins=TRUE;
	
	md2.skinwidth=mo.m_nSkinWidth;
	md2.skinheight=mo.m_nSkinHeight;

	if(md2.num_skins>0)
	{
		md2.skinwidth=mo.m_BaseFrame->t[0]->bmpheader->biWidth;
		md2.skinheight=mo.m_BaseFrame->t[0]->bmpheader->biHeight;
	}

	md2.framesize=sizeof(daliasframe_t)+DTRIVERTX_SIZE*mo.m_BaseFrame->v.GetSize()-1; // byte size of each frame
	
	md2.num_xyz=mo.m_BaseFrame->v.GetSize();
	md2.num_st=count; // greater than num_xyz for seams
	md2.num_tris=mo.m_BaseFrame->f.GetSize();

	md2.ofs_skins=sizeof(dmdl_t); // each skin is a MAX_SKINNAME string
	md2.ofs_st=md2.ofs_skins+MAX_SKINNAME*md2.num_skins; // byte offset from start for stverts
	md2.ofs_tris=md2.ofs_st+sizeof(dstvert_t)*md2.num_st; // offset for dtriangles
	md2.ofs_frames=md2.ofs_tris+sizeof(dtriangle_t)*md2.num_tris; // offset for first frame
	md2.num_frames=mo.m_Frames.GetSize();
	md2.framesize=(int)&((daliasframe_t *)0)->verts[md2.num_xyz];		// byte size of each frame
	

	// now the tricky gl stuff
	BuildGlCmds();
	
	md2.num_glcmds= numcommands;; // dwords in strip/fan command list
	md2.ofs_glcmds=md2.ofs_frames+md2.framesize*md2.num_frames; 
	md2.ofs_end=md2.ofs_glcmds+md2.num_glcmds*sizeof(int);

//	txt.Format("%d %d",md2.ofs_skins,md2.ofs_st);
//	AfxMessageBox(txt);

	FILE *out;
	out=fopen(fname,"wb");
	if(out==NULL) return FALSE;
	
	// header
	//md2.ofs_st=sizeof(dmdl_t);
	fwrite(&md2,sizeof(dmdl_t),1,out);



	char skinname[MAX_SKINNAME];

	if(mo.m_bSaveSkins)
	{
	for(i=0; i<md2.num_skins; i++)
	{
		if(mo.m_BaseFrame->t[i]->name.Find(".PCX")!=0)
		{
			mo.m_BaseFrame->t[i]->name.Format("skin%d.PCX",i);
			IOPCXWrite(mo.m_BaseFrame->t[i]->name.GetBuffer(0), *mo.m_BaseFrame->t[i]);
		}
		strncpy(skinname,mo.m_BaseFrame->t[i]->name.GetBuffer(0),MAX_SKINNAME);
		fwrite(skinname,MAX_SKINNAME,1,out);
	}
	}

	// read texture mapping info
	fwrite(&base_st[0],sizeof(dstvert_t),md2.num_st,out);

	fwrite(&triangles[0],sizeof(dtriangle_t),md2.num_tris,out);


	CMedDLeVertex v;
	dtrivertx_t *tv=new dtrivertx_t[md2.num_xyz];
	CMedDLePoint3D	*vnormal=new CMedDLePoint3D[md2.num_xyz];		
	int *vnormalcount=new int [md2.num_xyz];

#define NUMVERTEXNORMALS	162

float	avertexnormals[NUMVERTEXNORMALS][3] = {
#include "anorms.h"
};

	for(i=0; i<md2.num_frames; i++)
	{
		float scale[3]; // multiply byte verts by this
		float translate[3]; // then add this
		char name[16]; // frame name from grabbing

		strncpy(name,mo.m_Frames[i]->name.GetBuffer(0),16);


		int NN=mo.m_BaseFrame->f.GetSize();
		CMedDLePoint3D	pt[3];		
		CMedDLePoint3D	facenormal;		
		int vindex;
		for(int ii=0; ii<NN;ii++)
		{
			vnormalcount[ii]=0;
			vnormal[ii] = CMedDLePoint3D(0,0,0);
		}

		for(ii=0; ii<NN;ii++)
		{
			vindex=mo.m_BaseFrame->f[ii].vindex[0];
			pt[0].x[0]=mo.m_Frames[i]->v[vindex].wx[0];
			pt[0].x[1]=mo.m_Frames[i]->v[vindex].wx[1];
			pt[0].x[2]=mo.m_Frames[i]->v[vindex].wx[2];
		
			vindex=mo.m_BaseFrame->f[ii].vindex[1];
			pt[1].x[0]=mo.m_Frames[i]->v[vindex].wx[0];
			pt[1].x[1]=mo.m_Frames[i]->v[vindex].wx[1];
			pt[1].x[2]=mo.m_Frames[i]->v[vindex].wx[2];

			vindex=mo.m_BaseFrame->f[ii].vindex[2];
			pt[2].x[0]=mo.m_Frames[i]->v[vindex].wx[0];
			pt[2].x[1]=mo.m_Frames[i]->v[vindex].wx[1];
			pt[2].x[2]=mo.m_Frames[i]->v[vindex].wx[2];

			// get face normal
			facenormal=CrossProduct(pt[0] - pt[1], pt[2] - pt[1]);
			facenormal=Normalize(facenormal);

			// has 3 points, add this to all 3
			vindex=mo.m_BaseFrame->f[ii].vindex[0];
			vnormal[vindex]= vnormal[vindex]+ facenormal; 
			vnormalcount[vindex]++;
			vindex=mo.m_BaseFrame->f[ii].vindex[1];
			vnormal[vindex]= vnormal[vindex]+ facenormal; 
			vnormalcount[vindex]++;
			vindex=mo.m_BaseFrame->f[ii].vindex[2];
			vnormal[vindex]= vnormal[vindex]+ facenormal; 
			vnormalcount[vindex]++;

		}



		float max[3];
		max[0]=translate[0]=mo.m_Frames[i]->v[0].x[0];
		max[1]=translate[1]=mo.m_Frames[i]->v[0].x[1];
		max[2]=translate[2]=mo.m_Frames[i]->v[0].x[2];

		for(j=0; j<md2.num_xyz; j++)
		{
			for(k=0;k<3;k++)
			{
				if(mo.m_Frames[i]->v[j].x[k]<translate[k]) translate[k]=mo.m_Frames[i]->v[j].x[k];
				if(mo.m_Frames[i]->v[j].x[k]>max[k]) max[k]=mo.m_Frames[i]->v[j].x[k];
			}
		}
		
		scale[0]=(max[0]-translate[0])/255.0f;
		scale[1]=(max[1]-translate[1])/255.0f;
		scale[2]=(max[2]-translate[2])/255.0f;

		fwrite(scale,sizeof(float),3,out);
		fwrite(translate,sizeof(float),3,out);
		fwrite(name,1,16,out);
		
		for(j=0; j<md2.num_xyz; j++)
		{
			tv[j].v[0]=(BYTE)((mo.m_Frames[i]->v[j].x[0]-translate[0])/scale[0]);
			tv[j].v[1]=(BYTE)((mo.m_Frames[i]->v[j].x[1]-translate[1])/scale[1]);
			tv[j].v[2]=(BYTE)((mo.m_Frames[i]->v[j].x[2]-translate[2])/scale[2]);

			float sc = vnormalcount[ii];
			if (sc==0) sc = 1.f;
			else sc = 1.f/sc;
			vnormal[j].x[0] = vnormal[j].x[0]*sc;
			vnormal[j].x[1] = vnormal[j].x[1]*sc;
			vnormal[j].x[2] = vnormal[j].x[2]*sc;

			vnormal[j]=Normalize(vnormal[j]);



			int		maxdotindex;
			float	maxdot;

			maxdot = -10.0;
			maxdotindex = -1;

			for (k=0 ; k<NUMVERTEXNORMALS ; k++)
			{
				float	dot;

				dot = DotProduct (vnormal[j], CMedDLePoint3D(avertexnormals[k][0],avertexnormals[k][1],avertexnormals[k][2]));
				if (dot > maxdot)
				{
					maxdot = dot;
					maxdotindex = k;
				}
			}

			
			tv[j].lightnormalindex=maxdotindex;
		}

		fwrite(tv,DTRIVERTX_SIZE,md2.num_xyz,out);
	}
	delete [] tv;
	delete [] vnormal;
	delete [] vnormalcount;
//
// calculate the vertex normals, match them to the template list, and store the
// index of the best match
//
		// get the 3 vertices for this face (in camera's coordinates)


	// write gl stuff
	fwrite (commands, sizeof(int), numcommands,out);
/*
	N=mo.m_BaseFrame->f.GetSize();
	int id;
	glvert glv;
	for(i=0; i<N; i++)
	{

		id=-3;
		fwrite(&id,sizeof(int),1,out);

		id=abs(id);
		for(j=0;j<id;j++)
		{
			if(	md2.skinwidth!=0)
				glv.s=(float)mo.m_BaseFrame->f[i].tx[j][0]/(float)md2.skinwidth;

			else 
				glv.s=0.f;

			if(	md2.skinheight!=0)
				glv.t=(float)mo.m_BaseFrame->f[i].tx[j][1]/(float)md2.skinheight;
			else
				glv.t=0.f;
	
			glv.index=mo.m_BaseFrame->f[i].vindex[j];
			fwrite(&glv.s,sizeof(float),1,out);
			fwrite(&glv.t,sizeof(float),1,out);
			fwrite(&glv.index,sizeof(int),1,out);
		}
	}
	id=0;
	fwrite(&id,sizeof(int),1,out);
*/
	// delete temp st vertex
	fclose(out);

	delete [] base_xyz;
	delete [] base_st;
	delete [] triangles;
	delete [] triangle_st;

	delete [] commands;
	delete [] used;
	delete [] strip_xyz;
	delete [] strip_st;
	delete [] strip_tris;

	return 1;
}

// use of id code..................
// THANKS JOHN!

/*
=================================================================

ALIAS MODEL DISPLAY LIST GENERATION

=================================================================
*/


/*
================
StripLength
================
*/
int	StripLength (int starttri, int startv)
{
	int			m1, m2;
	int			st1, st2;
	int			j;
	dtriangle_t	*last, *check;
	int			k;

	used[starttri] = 2;

	last = &triangles[starttri];

	strip_xyz[0] = last->index_xyz[(startv)%3];
	strip_xyz[1] = last->index_xyz[(startv+1)%3];
	strip_xyz[2] = last->index_xyz[(startv+2)%3];
	strip_st[0] = last->index_st[(startv)%3];
	strip_st[1] = last->index_st[(startv+1)%3];
	strip_st[2] = last->index_st[(startv+2)%3];

	strip_tris[0] = starttri;
	stripcount = 1;

	m1 = last->index_xyz[(startv+2)%3];
	st1 = last->index_st[(startv+2)%3];
	m2 = last->index_xyz[(startv+1)%3];
	st2 = last->index_st[(startv+1)%3];

	// look for a matching triangle
nexttri:
	for (j=starttri+1, check=&triangles[starttri+1]
		; j<model->num_tris ; j++, check++)
	{
		for (k=0 ; k<3 ; k++)
		{
			if (check->index_xyz[k] != m1)
				continue;
			if (check->index_st[k] != st1)
				continue;
			if (check->index_xyz[ (k+1)%3 ] != m2)
				continue;
			if (check->index_st[ (k+1)%3 ] != st2)
				continue;

			// this is the next part of the fan

			// if we can't use this triangle, this tristrip is done
			if (used[j])
				goto done;

			// the new edge
			if (stripcount & 1)
			{
				m2 = check->index_xyz[ (k+2)%3 ];
				st2 = check->index_st[ (k+2)%3 ];
			}
			else
			{
				m1 = check->index_xyz[ (k+2)%3 ];
				st1 = check->index_st[ (k+2)%3 ];
			}

			strip_xyz[stripcount+2] = check->index_xyz[ (k+2)%3 ];
			strip_st[stripcount+2] = check->index_st[ (k+2)%3 ];
			strip_tris[stripcount] = j;
			stripcount++;

			used[j] = 2;
			goto nexttri;
		}
	}
done:

	// clear the temp used flags
	for (j=starttri+1 ; j<model->num_tris ; j++)
		if (used[j] == 2)
			used[j] = 0;

	return stripcount;
}


/*
===========
FanLength
===========
*/
int	FanLength (int starttri, int startv)
{
	int		m1, m2;
	int		st1, st2;
	int		j;
	dtriangle_t	*last, *check;
	int		k;

	used[starttri] = 2;

	last = &triangles[starttri];

	strip_xyz[0] = last->index_xyz[(startv)%3];
	strip_xyz[1] = last->index_xyz[(startv+1)%3];
	strip_xyz[2] = last->index_xyz[(startv+2)%3];
	strip_st[0] = last->index_st[(startv)%3];
	strip_st[1] = last->index_st[(startv+1)%3];
	strip_st[2] = last->index_st[(startv+2)%3];

	strip_tris[0] = starttri;
	stripcount = 1;

	m1 = last->index_xyz[(startv+0)%3];
	st1 = last->index_st[(startv+0)%3];
	m2 = last->index_xyz[(startv+2)%3];
	st2 = last->index_st[(startv+2)%3];


	// look for a matching triangle
nexttri:
	for (j=starttri+1, check=&triangles[starttri+1] 
		; j<model->num_tris ; j++, check++)
	{
		for (k=0 ; k<3 ; k++)
		{
			if (check->index_xyz[k] != m1)
				continue;
			if (check->index_st[k] != st1)
				continue;
			if (check->index_xyz[ (k+1)%3 ] != m2)
				continue;
			if (check->index_st[ (k+1)%3 ] != st2)
				continue;

			// this is the next part of the fan

			// if we can't use this triangle, this tristrip is done
			if (used[j])
				goto done;

			// the new edge
			m2 = check->index_xyz[ (k+2)%3 ];
			st2 = check->index_st[ (k+2)%3 ];

			strip_xyz[stripcount+2] = m2;
			strip_st[stripcount+2] = st2;
			strip_tris[stripcount] = j;
			stripcount++;

			used[j] = 2;
			goto nexttri;
		}
	}
done:

	// clear the temp used flags
	for (j=starttri+1 ; j<model->num_tris ; j++)
		if (used[j] == 2)
			used[j] = 0;

	return stripcount;
}



/*
================
BuildGlCmds

Generate a list of trifans or strips
for the model, which holds for all frames
================
*/

void BuildGlCmds (void)
{
	int		i, j, k;
	int		startv;
	float	s, t;
	int		len, bestlen, besttype;
	int		best_xyz[1024];
	int		best_st[1024];
	int		best_tris[1024];
	int		type;

	//
	// build tristrips
	//
	numcommands = 0;
	numglverts = 0;
	memset (used, 0, sizeof(int)*MAX_TRIANGLES);
	for (i=0 ; i<model->num_tris ; i++)
	{
		// pick an unused triangle and start the trifan
		if (used[i])
			continue;

		bestlen = 0;
		for (type = 0 ; type < 2 ; type++)
//	type = 1;
		{
			for (startv =0 ; startv < 3 ; startv++)
			{
				if (type == 1)
					len = StripLength (i, startv);
				else
					len = FanLength (i, startv);
				if (len > bestlen)
				{
					besttype = type;
					bestlen = len;
					for (j=0 ; j<bestlen+2 ; j++)
					{
						best_st[j] = strip_st[j];
						best_xyz[j] = strip_xyz[j];
					}
					for (j=0 ; j<bestlen ; j++)
						best_tris[j] = strip_tris[j];
				}
			}
		}

		// mark the tris on the best strip/fan as used
		for (j=0 ; j<bestlen ; j++)
			used[best_tris[j]] = 1;

		if (besttype == 1)
			commands[numcommands++] = (bestlen+2);
		else
			commands[numcommands++] = -(bestlen+2);

		numglverts += bestlen+2;

		for (j=0 ; j<bestlen+2 ; j++)
		{
			// emit a vertex into the reorder buffer
			k = best_st[j];

			// emit s/t coords into the commands stream
			s = base_st[k].s;
			t = base_st[k].t;

			s = (s + 0.5) / model->skinwidth;
			t = (t + 0.5) / model->skinheight;

			*(float *)&commands[numcommands++] = s;
			*(float *)&commands[numcommands++] = t;
			*(int *)&commands[numcommands++] = best_xyz[j];
		}
	}

	commands[numcommands++] = 0;		// end of list marker
}


/*
===============================================================

BASE FRAME SETUP

===============================================================
*/

/*
============
BuildST

Builds the triangle_st array for the base frame and
model->skinwidth / model->skinheight

  FIXME: allow this to be loaded from a file for
  arbitrary mappings
============

void BuildST (triangle_t *ptri, int numtri)
{
	int			i, j;
	int			width, height, iwidth, iheight, swidth;
	float		basex, basey;
	float		s_scale, t_scale;
	float		scale;
	vec3_t		mins, maxs;
	float		*pbasevert;
	vec3_t		vtemp1, vtemp2, normal;

	//
	// find bounds of all the verts on the base frame
	//
	ClearBounds (mins, maxs);
	
	for (i=0 ; i<numtri ; i++)
		for (j=0 ; j<3 ; j++)
			AddPointToBounds (ptri[i].verts[j], mins, maxs);
	
	for (i=0 ; i<3 ; i++)
	{
		mins[i] = floor(mins[i]);
		maxs[i] = ceil(maxs[i]);
	}
	
	width = maxs[0] - mins[0];
	height = maxs[2] - mins[2];

	if (!g_fixedwidth)
	{	// old style
		scale = 8;
		if (width*scale >= 150)
			scale = 150.0 / width;	
		if (height*scale >= 190)
			scale = 190.0 / height;

		s_scale = t_scale = scale;

		iwidth = ceil(width*s_scale);
		iheight = ceil(height*t_scale);

		iwidth += 4;
		iheight += 4;
	}
	else
	{	// new style
		iwidth = g_fixedwidth / 2;
		iheight = g_fixedheight;

		s_scale = (float)(iwidth-4) / width;
		t_scale = (float)(iheight-4) / height;
	}

//
// determine which side of each triangle to map the texture to
//
	for (i=0 ; i<numtri ; i++)
	{
		VectorSubtract (ptri[i].verts[0], ptri[i].verts[1], vtemp1);
		VectorSubtract (ptri[i].verts[2], ptri[i].verts[1], vtemp2);
		CrossProduct (vtemp1, vtemp2, normal);

		if (normal[1] > 0)
		{
			basex = iwidth + 2;
		}
		else
		{
			basex = 2;
		}
		basey = 2;
		
		for (j=0 ; j<3 ; j++)
		{
			pbasevert = ptri[i].verts[j];

			triangle_st[i][j][0] = Q_rint((pbasevert[0] - mins[0]) * s_scale + basex);
			triangle_st[i][j][1] = Q_rint((maxs[2] - pbasevert[2]) * t_scale + basey);
		}
	}

// make the width a multiple of 4; some hardware requires this, and it ensures
// dword alignment for each scan
	swidth = iwidth*2;
	model->skinwidth = (swidth + 3) & ~3;
	model->skinheight = iheight;
}
*/