// MainToolBar1.cpp : implementation file
//

#include "stdafx.h"
#include "meddle.h"
#include "MainToolBar1.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

enum tabs {ANIMATE, GRID, PRIMATIVE};
/////////////////////////////////////////////////////////////////////////////
// CMainToolBar1 dialog


CMainToolBar1::CMainToolBar1(CWnd* pParent /*=NULL*/)
	: CDialog(CMainToolBar1::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMainToolBar1)
	//}}AFX_DATA_INIT
}


void CMainToolBar1::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMainToolBar1)
	DDX_Control(pDX, IDC_BTN_P, m_btnp);
	DDX_Control(pDX, IDC_BTN_T, m_btnt);
	DDX_Control(pDX, IDC_BTN_G, m_btng);
	DDX_Control(pDX, IDC_BTN_A, m_btna);
	DDX_Control(pDX, IDC_TOOLFRAME, m_frame);
	DDX_Control(pDX, IDC_DELETE, m_btnDelete);
	DDX_Control(pDX, IDC_LIST1, m_FrameLC);
	DDX_Control(pDX, IDC_TREE1, m_GroupTree);
	DDX_Control(pDX, IDC_ANIMATIONS, m_AnimationCombo);
	DDX_Control(pDX, IDC_NEW, m_btnNew);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CMainToolBar1, CDialog)
	//{{AFX_MSG_MAP(CMainToolBar1)
	ON_CBN_SELCHANGE(IDC_ANIMATIONS, OnSelchangeAnimations)
	ON_WM_VKEYTOITEM()
	ON_BN_CLICKED(IDC_NEW, OnNew)
	ON_NOTIFY(NM_RCLICK, IDC_LIST1, OnRclickList1)
	ON_NOTIFY(NM_CLICK, IDC_LIST1, OnClickList1)
	ON_COMMAND(ID_2_COPYFRAME, On2Copyframe)
	ON_COMMAND(ID_2_DELETEFRAME, On2Deleteframe)
	ON_COMMAND(ID_2_PASTEFRAMEAFTER, On2Pasteframeafter)
	ON_COMMAND(ID_2_PASTEFRAMEBEFORE, On2Pasteframebefore)
	ON_COMMAND(ID_GENSKIN, OnGenSkin)
	ON_COMMAND(ID_GROUP_VISIBLE, OnGroupVisible)
	ON_NOTIFY(LVN_KEYDOWN, IDC_LIST1, OnKeydownList1)
	ON_BN_CLICKED(IDC_DELETE, OnDelete)
	ON_WM_KEYDOWN()
	ON_NOTIFY(NM_RCLICK, IDC_TREE1, OnRclickTree1)
	ON_NOTIFY(TVN_ENDLABELEDIT, IDC_TREE1, OnEndlabeleditTree1)
	ON_NOTIFY(TVN_BEGINDRAG, IDC_TREE1, OnBegindragTree1)
	ON_BN_CLICKED(IDC_BTN_A, OnBtnA)
	ON_BN_CLICKED(IDC_BTN_G, OnBtnG)
	ON_BN_CLICKED(IDC_BTN_P, OnBtnP)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMainToolBar1 message handlers

void CMainToolBar1::OnSelchangeAnimations() 
{
//	UpdateData();

//	MessageBeep(0xffffffff);
	CMedDLeDoc *pDoc=theApp.m_pActiveDoc;

	CMedDLeObject *mo=&pDoc->m_MedDLeObject;
	CString str;
	m_AnimationCombo.GetLBText(m_AnimationCombo.GetCurSel(), str);

	for(int i=0; i<pDoc->m_MedDLeObject.m_Anims.GetSize(); i++)
	{
		if(str.CompareNoCase(pDoc->m_MedDLeObject.m_Anims[i]->name)==0)
		{
			pDoc->m_MedDLeObject.m_curAnim=pDoc->m_MedDLeObject.m_Anims[i];
			pDoc->m_MedDLeObject.m_curAnimN=i;
			break;
		}
	}

	int j;
	m_FrameLC.DeleteAllItems( );
	if(mo->m_Anims[mo->m_curAnimN]->framelist.GetSize()>0)
	{
		for(i=0; i<mo->m_Anims[mo->m_curAnimN]->framelist.GetSize(); i++)
		{
			j=mo->m_Anims[mo->m_curAnimN]->framelist[i];
			m_FrameLC.InsertItem(i,mo->m_Frames[j]->name);
		}

		pDoc->m_MedDLeObject.m_curFrame=
			pDoc->m_MedDLeObject.m_Frames[mo->m_Anims[mo->m_curAnimN]->framelist[0]];
		pDoc->m_MedDLeObject.m_curFrameN=
			mo->m_Anims[mo->m_curAnimN]->framelist[0];
	}
	else
	{
		pDoc->m_MedDLeObject.m_curFrame=NULL;
		pDoc->m_MedDLeObject.m_curFrameN=-1;
	}
//	m_FrameList.SetCurSel(0);
	pDoc->UpdateAllViews(NULL);
	
}

void CMainToolBar1::Refresh()
{

	CMedDLeObject *mo;
	int i,j;
	m_FrameLC.DeleteAllItems( );
//	m_FrameList.ResetContent();
	m_AnimationCombo.ResetContent();

	CString str;
	if(theApp.m_pActiveDoc!=NULL)
	{
		CMedDLeDoc *pDoc=theApp.m_pActiveDoc;
		mo=&pDoc->m_MedDLeObject;
		if(!mo) return;

		if(mo->m_Anims.GetSize()>0)
		{

		for(i=0; i<mo->m_Anims.GetSize(); i++)
		{
			str=mo->m_Anims[i]->name;
			if(!str.IsEmpty()) m_AnimationCombo.AddString(str);
		}

		if((mo->m_curAnimN >= 0) && (mo->m_curAnimN<i))
		m_AnimationCombo.SetCurSel(mo->m_curAnimN);

		for(i=0; i<mo->m_Anims[mo->m_curAnimN]->framelist.GetSize(); i++)
		{
			j=mo->m_Anims[mo->m_curAnimN]->framelist[i];
			str=mo->m_Frames[j]->name;
			if(!str.IsEmpty())
			{
//				m_FrameList.AddString(str);
				m_FrameLC.InsertItem( i, str);

			}
		}
		}
	}

	// group area

	m_GroupTree.DeleteAllItems( );

	if(theApp.m_pActiveDoc!=NULL)
	{
		CMedDLeDoc *pDoc=theApp.m_pActiveDoc;
		mo=&pDoc->m_MedDLeObject;

		HTREEITEM hi;
		int N=mo->m_BaseFrame->g.GetSize();
		for(i=0; i<N; i++)
		{
			if(mo->m_BaseFrame->g[i].flags&G_VISIBLE)
				hi=m_GroupTree.InsertItem( mo->m_BaseFrame->g[i].name, 1, 1);
			else 
				hi=m_GroupTree.InsertItem( mo->m_BaseFrame->g[i].name, 0, 0);
			m_GroupTree.SetItemData(hi,(DWORD)i);
			//m_GroupTree.InsertItem(mo->m_BaseFrame->g[i].name);
		}
	}
}

int CMainToolBar1::OnVKeyToItem(UINT nKey, CListBox* pListBox, UINT nIndex) 
{

	return CDialog::OnVKeyToItem(nKey, pListBox, nIndex);
}

#include "NewAnimation.h"
void CMainToolBar1::OnNew() 
{

	if(!theApp.m_pActiveDoc) return;

	CNewAnimation dlg;
	
	if(dlg.DoModal()==IDOK)
	{
		
		CMedDLeMeshAnimation *ma;
		ma=new CMedDLeMeshAnimation;
		ma->name=dlg.m_AnimationName;
		ma->framelist.RemoveAll();

		CMedDLeObject *mo;
		CMedDLeDoc *pDoc=theApp.m_pActiveDoc;
		pDoc->m_MedDLeObject.m_Anims.Add(ma);
		pDoc->m_MedDLeObject.m_curAnim=ma;
		Refresh();
	}
}

void CMainToolBar1::OnRclickList1(NMHDR* pNMHDR, LRESULT* pResult) 
{

	CMenu menu;
	if (menu.LoadMenu(IDR_POPUPS))
	{
		CMenu* pPopup = menu.GetSubMenu(2);
		if(theApp.ClipBoardStatus!=2) pPopup->EnableMenuItem( ID_2_PASTEFRAMEAFTER,MF_GRAYED );
		if(theApp.ClipBoardStatus!=2) pPopup->EnableMenuItem( ID_2_PASTEFRAMEBEFORE,MF_GRAYED );

		ASSERT(pPopup != NULL);
		CPoint point;
		if(GetCursorPos( &point ) && pPopup)
		{
			//ClientToScreen(&point);
			pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,	point.x, point.y, this);
		}
	}
	*pResult = 0;
}

void CMainToolBar1::OnClickList1(NMHDR* pNMHDR, LRESULT* pResult) 
{

	CMedDLeDoc *pDoc=theApp.m_pActiveDoc;

	CString str;
	
	int hit=m_FrameLC.GetNextItem(-1, LVNI_ALL | LVNI_SELECTED );
	if(hit == -1) { *pResult = 0; return;}

	str=m_FrameLC.GetItemText(hit , 0 );

	for(int i=0; i<pDoc->m_MedDLeObject.m_Frames.GetSize(); i++)
	{
		if(str.CompareNoCase(pDoc->m_MedDLeObject.m_Frames[i]->name)==0)
		{
			pDoc->m_MedDLeObject.m_curFrame=pDoc->m_MedDLeObject.m_Frames[i];
			pDoc->m_MedDLeObject.m_curFrameN=i;
			break;
		}
	}

	pDoc->UpdateAllViews(NULL);
	
	*pResult = 0;
	
}



void CMainToolBar1::On2Copyframe() 
{
	CMedDLeDoc *pDoc=theApp.m_pActiveDoc;

//	CString str;
//	int hit=m_FrameLC.GetNextItem(-1, LVNI_ALL | LVNI_SELECTED );
//	if(hit == -1) { return;}
//	str=m_FrameLC.GetItemText(hit , 0 );

	if(!pDoc->m_MedDLeObject.m_curFrame) return;
	theApp.m_BaseClipBoard = *pDoc->m_MedDLeObject.m_BaseFrame;  // for copy, etc
	theApp.m_ClipBoard=*pDoc->m_MedDLeObject.m_curFrame;  // for copy, etc
	theApp.ClipBoardStatus=2;	// 0=empty
							// 1=parts
							// 2=wholeframe

}

void CMainToolBar1::On2Deleteframe() 
{
	CMedDLeDoc *pDoc=theApp.m_pActiveDoc;

	CString str;
	int hit=m_FrameLC.GetNextItem(-1, LVNI_ALL | LVNI_SELECTED );
	if(hit == -1) { return;}
	str=m_FrameLC.GetItemText(hit , 0 );

	if(!pDoc->m_MedDLeObject.m_curFrame) return;
	theApp.m_BaseClipBoard = *pDoc->m_MedDLeObject.m_BaseFrame;  // for copy, etc
	theApp.m_ClipBoard=*pDoc->m_MedDLeObject.m_curFrame;  // for copy, etc
	theApp.ClipBoardStatus=2;	// 0=empty

	if(pDoc->m_MedDLeObject.m_Anims[pDoc->m_MedDLeObject.m_curAnimN]->framelist.GetSize()>1)
		RemoveFrame(str,pDoc->m_MedDLeObject.m_curAnimN);
	Refresh();
	pDoc->UpdateAllViews(NULL);
}

void CMainToolBar1::On2Pasteframeafter() 
{

	CMedDLeDoc *pDoc=theApp.m_pActiveDoc;

	CString str;
	int hit=m_FrameLC.GetNextItem(-1, LVNI_ALL | LVNI_SELECTED );
	if(hit == -1) { return;}
	str=m_FrameLC.GetItemText(hit , 0 );


	// get current num and animation num

	int i,j,gt,key=-1;
	int N=pDoc->m_MedDLeObject.m_Anims[pDoc->m_MedDLeObject.m_curAnimN]->framelist.GetSize();

	for(i=0; i<N; i++)
	{
		j=pDoc->m_MedDLeObject.m_Anims[pDoc->m_MedDLeObject.m_curAnimN]->framelist[i];
		if(str.CompareNoCase(pDoc->m_MedDLeObject.m_Frames[j]->name.GetBuffer(0))==0)
		{
			gt=i;
			key=j;
			break;
		}
	}

	if(N==0)
	{
		key=pDoc->m_MedDLeObject.m_Frames.GetSize()-1;
		gt=-1;
		}
	if(key<0) return;


	
//fix numbers in animations
	
	for(i=0; i<pDoc->m_MedDLeObject.m_Anims.GetSize(); i++)
	{
		for (int k=0; k<pDoc->m_MedDLeObject.m_Anims[i]->framelist.GetSize(); k++)
		{
			int l=pDoc->m_MedDLeObject.m_Anims[i]->framelist[k];
			if(l>key) pDoc->m_MedDLeObject.m_Anims[i]->framelist[k]++;
		}
	}

// insert the frame


	//theApp.m_BaseClipBoard = *pDoc->m_MedDLeObject.m_BaseFrame;  // for copy, etc
	//pDoc->m_MedDLeObject.m_curFrame=
	CMedDLeFrame *mf=new CMedDLeFrame(theApp.m_ClipBoard);
	pDoc->m_MedDLeObject.m_Frames.InsertAt(key+1,mf);
	pDoc->m_MedDLeObject.m_curFrame=mf;

// fix animation

	int d1=key+1;
	int d2=gt+1;
	pDoc->m_MedDLeObject.m_Anims[pDoc->m_MedDLeObject.m_curAnimN]->framelist.InsertAt(d2,d1);

	// rename frames
	N=pDoc->m_MedDLeObject.m_Anims[pDoc->m_MedDLeObject.m_curAnimN]->framelist.GetSize();

	for(i=0; i<N; i++)
	{
		j=pDoc->m_MedDLeObject.m_Anims[pDoc->m_MedDLeObject.m_curAnimN]->framelist[i];
		str.Format("%s%d",pDoc->m_MedDLeObject.m_Anims[pDoc->m_MedDLeObject.m_curAnimN]->name.GetBuffer(0),i+1);
		pDoc->m_MedDLeObject.m_Frames[j]->name=str;
	}

	Refresh();
	pDoc->UpdateAllViews(NULL);
}

void CMainToolBar1::On2Pasteframebefore() 
{

	CMedDLeDoc *pDoc=theApp.m_pActiveDoc;

	CString str;
	int hit=m_FrameLC.GetNextItem(-1, LVNI_ALL | LVNI_SELECTED );
	if(hit == -1) { return;}
	str=m_FrameLC.GetItemText(hit , 0 );


	// get current num and animation num

	int i,j,gt,key=-1;
	int N=pDoc->m_MedDLeObject.m_Anims[pDoc->m_MedDLeObject.m_curAnimN]->framelist.GetSize();

	for(i=0; i<N; i++)
	{
		j=pDoc->m_MedDLeObject.m_Anims[pDoc->m_MedDLeObject.m_curAnimN]->framelist[i];
		if(str.CompareNoCase(pDoc->m_MedDLeObject.m_Frames[j]->name.GetBuffer(0))==0)
		{
			gt=i;
			key=j;
			break;
		}
	}

	if(N==0)
	{
		key=pDoc->m_MedDLeObject.m_Frames.GetSize();
		gt=0;
	}
	if(key<0) return;
	
//fix numbers in animations
	
	for(i=0; i<pDoc->m_MedDLeObject.m_Anims.GetSize(); i++)
	{
		for (int k=0; k<pDoc->m_MedDLeObject.m_Anims[i]->framelist.GetSize(); k++)
		{
			int l=pDoc->m_MedDLeObject.m_Anims[i]->framelist[k];
			if(l>=key) pDoc->m_MedDLeObject.m_Anims[i]->framelist[k]++;
		}
	}

// insert the frame


	//theApp.m_BaseClipBoard = *pDoc->m_MedDLeObject.m_BaseFrame;  // for copy, etc
	//pDoc->m_MedDLeObject.m_curFrame=
	CMedDLeFrame *mf=new CMedDLeFrame(theApp.m_ClipBoard);
	pDoc->m_MedDLeObject.m_Frames.InsertAt(key,mf);
	pDoc->m_MedDLeObject.m_curFrame=mf;

// fix animation

	pDoc->m_MedDLeObject.m_Anims[pDoc->m_MedDLeObject.m_curAnimN]->framelist.InsertAt(gt+1,key);

	// rename frames
	N=pDoc->m_MedDLeObject.m_Anims[pDoc->m_MedDLeObject.m_curAnimN]->framelist.GetSize();

	for(i=0; i<N; i++)
	{
		j=pDoc->m_MedDLeObject.m_Anims[pDoc->m_MedDLeObject.m_curAnimN]->framelist[i];
		str.Format("%s%d",pDoc->m_MedDLeObject.m_Anims[pDoc->m_MedDLeObject.m_curAnimN]->name.GetBuffer(0),i+1);
		pDoc->m_MedDLeObject.m_Frames[j]->name=str;
	}

	Refresh();
	pDoc->UpdateAllViews(NULL);
}

void CMainToolBar1::OnGroupVisible() 
{

	HTREEITEM hi=m_GroupTree.GetSelectedItem();
	if(hi==NULL) return;
	int i=m_GroupTree.GetItemData(hi);

	BOOL show=FALSE;
	if((theApp.m_pActiveDoc!=NULL)&&(i>=0))
	{
		CMedDLeDoc *pDoc=theApp.m_pActiveDoc;
		CMedDLeObject *mo=&pDoc->m_MedDLeObject;
		if(mo->m_BaseFrame->g[i].flags &G_VISIBLE) 
		{
			mo->m_BaseFrame->g[i].flags&=~G_VISIBLE;
			show=FALSE;
		}
		else
		{
			mo->m_BaseFrame->g[i].flags|=G_VISIBLE;
			show=TRUE;
		}

		for(int j=0; j<mo->m_BaseFrame->f.GetSize(); j++)
		{
			if(pDoc->m_MedDLeObject.m_BaseFrame->f[j].group==i)
			{
				int vindex;
				for(int k=0; k<3; k++)
				{
					vindex=mo->m_BaseFrame->f[j].vindex[k];
					if(show)pDoc->m_MedDLeObject.m_BaseFrame->v[vindex].flags|=V_VISIBLE;
					else pDoc->m_MedDLeObject.m_BaseFrame->v[vindex].flags&=~V_VISIBLE;
				}
			}
		}

		Refresh();
		pDoc->UpdateAllViews(NULL);
	}

}
void CMainToolBar1::OnKeydownList1(NMHDR* pNMHDR, LRESULT* pResult) 
{
	LV_KEYDOWN* pLVKeyDow = (LV_KEYDOWN*)pNMHDR;
	Refresh();
	*pResult = 0;
}

void CMainToolBar1::RemoveFrame(CString str, int a)
{


	CMedDLeDoc *pDoc=theApp.m_pActiveDoc;


// fix animation
	int i,j,gt;
	int N=pDoc->m_MedDLeObject.m_Anims[a]->framelist.GetSize();

//	AfxMessageBox(str);
	for(i=N-1; i>=0; i--)
	{
		j=pDoc->m_MedDLeObject.m_Anims[a]->framelist[i];
		if(str.CompareNoCase(pDoc->m_MedDLeObject.m_Frames[j]->name.GetBuffer(0))==0)
		{
			pDoc->m_MedDLeObject.m_Anims[a]->framelist.RemoveAt(i);
			if(pDoc->m_MedDLeObject.m_Anims[a]->framelist.GetSize()>0)
			{
				gt=pDoc->m_MedDLeObject.m_Anims[a]->framelist[i];
			}
			else
				gt=-1;
			break;
		}
	}
	
	N=pDoc->m_MedDLeObject.m_Frames.GetSize(); 

	delete pDoc->m_MedDLeObject.m_Frames[j];
	pDoc->m_MedDLeObject.m_Frames.RemoveAt(j);
	pDoc->m_MedDLeObject.m_curFrame=NULL;
	pDoc->m_MedDLeObject.m_curFrameN=-1;
	if(gt>=0)
	{
		pDoc->m_MedDLeObject.m_curFrame=pDoc->m_MedDLeObject.m_Frames[gt];
	}


//fix numbers in animations
	
	for(i=0; i<pDoc->m_MedDLeObject.m_Anims.GetSize(); i++)
	{
		for (int k=0; k<pDoc->m_MedDLeObject.m_Anims[i]->framelist.GetSize(); k++)
		{
			int l=pDoc->m_MedDLeObject.m_Anims[i]->framelist[k];
			if(l>j) pDoc->m_MedDLeObject.m_Anims[i]->framelist[k]--;
		}
	}
	
	// rename frames
	N=pDoc->m_MedDLeObject.m_Anims[a]->framelist.GetSize();

	for(i=0; i<N; i++)
	{
		j=pDoc->m_MedDLeObject.m_Anims[a]->framelist[i];
		str.Format("%s%d",pDoc->m_MedDLeObject.m_Anims[a]->name.GetBuffer(0),i+1);
		pDoc->m_MedDLeObject.m_Frames[j]->name=str;
	}

}

void CMainToolBar1::OnDelete() 
{
	CMedDLeDoc *pDoc=theApp.m_pActiveDoc;

	CMedDLeObject *mo=&pDoc->m_MedDLeObject;
	CString str;
	m_AnimationCombo.GetLBText(m_AnimationCombo.GetCurSel(), str);

	CString msg;
	msg.Format("Are you sure you want to delete %s and all of the associated frames?",str.GetBuffer(0));
	if(AfxMessageBox(msg,MB_YESNO)==IDYES)
	{
		int N=mo->m_Anims[mo->m_curAnimN]->framelist.GetSize();
		for(int i=N-1; i>=0; i--)
		{
			int j=mo->m_Anims[mo->m_curAnimN]->framelist[i];
			str=mo->m_Frames[j]->name;
			RemoveFrame(str,mo->m_curAnimN);
		}

		pDoc->m_MedDLeObject.m_Anims.RemoveAt(mo->m_curAnimN);

	}


	Refresh();
	pDoc->UpdateAllViews(NULL);

}

/*
void CMainToolBar1::OnSelchangeTab(NMHDR* pNMHDR, LRESULT* pResult) 
{

	int i = m_Tab.GetCurSel();

	if(i<0) return;
	// hide all

	// show correct one

	switch(i)
	{
	case 0:// primative
		break;
	case 1:// animation
		break;
	case 2:// texture
		break;
	case 3:// grid
		break;
	case 4:// cur
		break;
	}
	*pResult = 0;
}
*/
BOOL CMainToolBar1::OnInitDialog() 
{
	CDialog::OnInitDialog();

//	m_tAnimate.SetParent(this);
//	m_t
	m_GroupImages.Create(IDB_GROUPLIST,16,1,RGB(255,255,255));
//	m_PrimativeImages;
//	m_TabImages.Create(IDB_TABLIST,16,1,RGB(255,255,255));

	m_GroupTree.SetImageList(&m_GroupImages,TVSIL_NORMAL);
//	m_Tab.SetImageList(&m_TabImages);
/*	TC_ITEM item;
	item.mask=TCIF_IMAGE;
	item.mask=TCIF_TEXT;
//	item.iImage=0;
    item.pszText="Grid";
	m_Tab.InsertItem(0, &item);

//	item.iImage=1;
    item.pszText="Animation";
	m_Tab.InsertItem(1, &item);

    item.pszText="Texture";
//	item.iImage=2;
	m_Tab.InsertItem(2, &item);
//	item.iImage=3;
	m_Tab.InsertItem(3, &item);
//	item.iImage=4;
	m_Tab.InsertItem(4, &item);
*/

	CRect rc;
	m_frame.GetWindowRect(rc);
	ScreenToClient(rc);
	//0
	m_tAnimate.Create(IDD_ANIMATE,this);
	m_tAnimate.SetWindowPos(&wndTop,rc.left,rc.top,rc.Width(),rc.Height(),0);

	m_tGrid.Create(IDD_GRID,this);
	m_tGrid.SetWindowPos(&wndTop,rc.left,rc.top,rc.Width(),rc.Height(),0);
//
//	m_tPrimative.Create(IDD_GRID,this);
//	m_tPrimative.SetWindowPos(&wndTop,rc.left,rc.top,rc.Width(),rc.Height(),0);
	Activate(ANIMATE);


//	CSize sz(0,0);
//	m_Tab.SetPadding(sz);



	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CMainToolBar1::Activate(int tab)
{
	m_tAnimate.ShowWindow(SW_HIDE);
	m_tGrid.ShowWindow(SW_HIDE);
//	m_tPrimative.ShowWindow(SW_HIDE);

	m_btna.SetCheck(FALSE);
	m_btng.SetCheck(FALSE);
//	m_btnp.SetCheck(FALSE);

	switch(tab)
	{
	case ANIMATE:
		m_btna.SetCheck(TRUE);
		m_tAnimate.ShowWindow(SW_SHOW);
		break;
	case GRID:
		m_btng.SetCheck(TRUE);
		m_tGrid.ShowWindow(SW_SHOW);
		break;
	case PRIMATIVE:
//		m_btnp.SetCheck(TRUE);
//		m_tPrimative.ShowWindow(SW_SHOW);
		break;
	}

}

void CMainToolBar1::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags) 
{

	m_tAnimate.FullScreen(0);
	CDialog::OnKeyDown(nChar, nRepCnt, nFlags);
}

void CMainToolBar1::OnRclickTree1(NMHDR* pNMHDR, LRESULT* pResult) 
{
	CMenu menu;
//	HTREEITEM hi=m_GroupTree.GetSelectedItem();
	if (menu.LoadMenu(IDR_POPUPS))
	{
		CMenu* pPopup = menu.GetSubMenu(4);
		pPopup->EnableMenuItem( ID_GROUP_VISIBLE,MF_GRAYED );
		pPopup->EnableMenuItem( ID_4_PROPERTIES,MF_GRAYED );
		pPopup->EnableMenuItem( ID_GROUP_DELETE,MF_GRAYED );
		ASSERT(pPopup != NULL);
		CPoint point;
		if(GetCursorPos( &point ) && pPopup)
		{
			CPoint p;
			UINT fl;

			p=point;
			m_GroupTree.ScreenToClient(&p);
			HTREEITEM hi= m_GroupTree.HitTest( p, &fl);
			if((fl&TVHT_ONITEM)||(fl&TVHT_ONITEMRIGHT))
			{
				if(m_GroupTree.Select(hi,TVGN_CARET|TVGN_DROPHILITE))
				{
					int i=m_GroupTree.GetItemData(hi);
					if((theApp.m_pActiveDoc!=NULL)&&(i>=0))
					{
						pPopup->EnableMenuItem( ID_GROUP_VISIBLE,MF_ENABLED );
						CMedDLeDoc *pDoc=theApp.m_pActiveDoc;
						CMedDLeObject *mo=&pDoc->m_MedDLeObject;
						if(i<mo->m_BaseFrame->g.GetSize())
						{
							if(mo->m_BaseFrame->g[i].flags &G_VISIBLE) 
								pPopup->CheckMenuItem(ID_GROUP_VISIBLE,MF_CHECKED);	
							else
								pPopup->CheckMenuItem(ID_GROUP_VISIBLE,MF_UNCHECKED);
						}
					}
				}
			}

			//ClientToScreen(&point);
			pPopup->TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,	point.x, point.y, this);
		}
	}
	*pResult = 0;
}

void CMainToolBar1::OnGenSkin()
{

}

void CMainToolBar1::OnEndlabeleditTree1(NMHDR* pNMHDR, LRESULT* pResult) 
{
	TV_DISPINFO* pTVDispInfo = (TV_DISPINFO*)pNMHDR;
	// TODO: Add your control notification handler code here
	
	*pResult = 0;
}

void CMainToolBar1::OnBegindragTree1(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	// TODO: Add your control notification handler code here
	
	*pResult = 0;
}

void CMainToolBar1::OnBtnA() 
{
	Activate(ANIMATE);
}

void CMainToolBar1::OnBtnG() 
{
	Activate(GRID);
	
}

void CMainToolBar1::OnBtnP() 
{
	Activate(PRIMATIVE);
	
}
