// MedDLe.cpp : Defines the class behaviors for the application.
//  

#include "stdafx.h"
#include "MedDLe.h"

#include "MainFrm.h"
#include "ChildFrm.h"
#include "MedDLeView.h"
#include "Anim.h"
#include "Splash.h"
#include "MedDLeGFX\MedDLeGFX.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
BOOL zbufflag=0;
#ifdef _USEZBUFFER
DWORD *zbuffer;
#endif

BYTE AppColors[64];


// misc colors, grids, 2d back, pts, sel, pts...

/////////////////////////
// Interace style Defines
//HPEN syspens[16];

/////////////////////////////////////
// DIB Size
//int ResX, ResY;
//BYTE *RAMScreen;
//HDRAWDIB hDrawDib;

/////////////////////////////////////////////////////////////////////////////
// CMedDLeApp

BEGIN_MESSAGE_MAP(CMedDLeApp, CWinApp)
	//{{AFX_MSG_MAP(CMedDLeApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMedDLeApp construction

CMedDLeApp::CMedDLeApp()
{
	m_pActiveDoc=NULL;
	AnimDlgOn=0;
	m_pAnimDlg=NULL;

	ClipBoardStatus=0;

	m_Textures.RemoveAll();

}

/////////////////////////////////////////////////////////////////////////////
// The one and only CMedDLeApp object

CMedDLeApp theApp;

/////////////////////////////////////////////////////////////////////////////
// CMedDLeApp initialization

BOOL CMedDLeApp::InitInstance()
{
	AfxEnableControlContainer();
	SetRegistryKey("ZombyWoofWare");

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif

	LoadStdProfileSettings(12);  // Load standard INI file options (including MRU)
	
	if(!MedDLeInitGFX()) return 0;

	// Register document templates

	CMultiDocTemplate* pDocTemplate;
	pDocTemplate = new CMultiDocTemplate(
		IDR_MEDDLETYPE,
		RUNTIME_CLASS(CMedDLeDoc),
		RUNTIME_CLASS(CChildFrame), // custom MDI child frame
		RUNTIME_CLASS(CMedDLeView));
	AddDocTemplate(pDocTemplate);

	// create main MDI Frame window
	CMainFrame* pMainFrame = new CMainFrame;
	if (!pMainFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;
	m_pMainWnd = pMainFrame;
	pMainFrame->ShowWindow(m_nCmdShow);
	pMainFrame->UpdateWindow();

	// Enable drag/drop open
	m_pMainWnd->DragAcceptFiles();

	// Enable DDE Execute open
	EnableShellOpen();
	RegisterShellFileTypes(TRUE);

	// Parse command line for standard shell commands, DDE, file open
	CCommandLineInfo cmdInfo;
	ParseCommandLine(cmdInfo);
	CSplashWnd::EnableSplashScreen(cmdInfo.m_bShowSplash);

	// Dispatch commands specified on the command line
	//if (!ProcessShellCommand(cmdInfo)) { AfxMessageBox("App Finish Dispatch ERROR"); return FALSE;}
//	if (!ProcessShellCommand(cmdInfo)) return FALSE;
	
	
	// set up colors (from ini file eventually)
	// 8 bit index for now
	AppColors[AC_2DBACK]=14; //2d view back
	AppColors[AC_3DBACK]=0; //2d view grids 
	AppColors[AC_GRID]=12; //2d view grids 
	AppColors[AC_AXIS]=0; //2d view grids 
	AppColors[AC_XAXIS]=251;//192; //2d view grids 
	AppColors[AC_YAXIS]=63; //2d view grids 
	AppColors[AC_ZAXIS]=208; //2d view grids 
	AppColors[AC_TEXTAXIS]=0; //2d view grids 
	


	#ifdef _USEZBUFFER
	zbuffer=new DWORD [800*600];
	if(zbuffer==NULL) {AfxMessageBox("Not enough mem for z buffer"); zbufflag=0;}
	else zbufflag=1;
	#endif
	
	// open last 
	CString strSection = "Pref";
	CString file;
    file=GetProfileString(strSection, "LastDoc");
	FILE *op;
	op=fopen(file,"rb");
	if(op!=NULL)
	{
		fclose(op);
		OpenDocumentFile(file);
	}
	// set tool dialogs
	m_AppMode=AM_VERT;
	m_AppAction = AA_SELECT;
//	m_pMainWnd->ShowWindow(SW_SHOWMAXIMIZED);
	m_ClipBoard.name = "ClipBoard";
	m_BaseClipBoard.name = "BaseClipBoard";
	return TRUE;

}

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CMedDLeApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

/////////////////////////////////////////////////////////////////////////////
// CMedDLeApp commands

int CMedDLeApp::ExitInstance() 
{
//	DrawDibClose(hDrawDib);
//	#ifdef _USEZBUFFER
//	if(zbuffer!=NULL) delete [] zbuffer;
//	#endif

//	if (ClipBoard!=NULL) delete ClipBoard;
//	HideProject();
#ifdef _BFIX
	FILE *out=fopen("C:\\meddlelog.txt","at");
	if(out)
	{
		fprintf(out,"exit instance \n");	
		fclose(out);
	}
#endif

	MedDLeShutDownGFX();

	int N=m_Textures.GetSize();
	for(int i=0; i<N; i++)
	{
		delete m_Textures[i];
	}
	m_Textures.RemoveAll();

	return CWinApp::ExitInstance();
}
void CMedDLeApp::OnFileOpen() 
{


/*	CString Filter("3d Objects (*.mm;*.mdl;*.3ds;*.asc;*.dxf;*.raw;*.cob;*.wrl;*.nff;*.obj;*.pov;*.inc) | *.mdl; *.3ds; *.asc; *.dxf; *.raw; *.cob; *.wrl; *.nff; *.obj; *.pov; *.inc |");
	Filter+="MedDLe Model (*.mm)|*.mm|";
	Filter+="Quake Model (*.mdl)|*.mdl|";
	Filter+="3D Studio Object (*.3ds)|*.3ds|";
	Filter+="3D Studio Ascii (*.asc)|*.asc|";
	Filter+="RAW Object (*.raw)|*.raw|";
	Filter+="AutoCAD DXF (*.dxf)|*.dxf|";
  	Filter+="Truespace Object (*.cob)|*.cob|";
 	Filter+="VRML (*.wrl)|*.wrl|";
  	Filter+="Wavefront Object (*.obj)|*.obj|";
	Filter+="WorldToolkit Object (*.nff)|*.nff|";
	Filter+="POVRay V2.2 File (*.pov)|*.pov|";
	Filter+="POVRay V2.2 Include (*.inc)|*.inc|";
	Filter+="All Files (*.*) | *.* ||";
*/
	CString Filter("MedDLe Model (*.mm) | *.mm |");
	Filter+="Quake/Hexen2 Model (*.mdl)|*.mdl|";
	Filter+="Quake2 Model (*.md2)|*.md2|";
	Filter+="Jedi Knight Model (*.3do)|*.3do|";
	Filter+="|";

	CFileDialog fileDlg(TRUE, NULL,
		"*.mm",
		OFN_HIDEREADONLY| OFN_PATHMUSTEXIST,
		Filter);

//	CFileDialog fileDlg(TRUE, NULL,
//		"*.mdl;*.3ds;*.asc;*.dxf;*.raw;*.cob;*.wrl;*.nff;*.obj;*.pov;*.inc",
//		OFN_HIDEREADONLY| OFN_PATHMUSTEXIST,Filter);
	if(fileDlg.DoModal()==IDOK)
	{
		CString name=fileDlg.GetPathName();
		// check extension
		char *extn1;
		extn1=strstr(name.GetBuffer(1),".");

		// if there isn't a typed in extension, put one on! (unless it is *.* filter, then save as mdl
		if((extn1==NULL)&&((fileDlg.m_ofn.nFilterIndex!=13)||(fileDlg.m_ofn.nFilterIndex!=1)))
		{
			switch(fileDlg.m_ofn.nFilterIndex)
			{

			case 0: break;
			case 1: name += ".mm"; break;
			case 2: name += ".mdl"; break;
			case 3: name += ".md2"; break;
			case 4: name += ".3do"; break;
		//	case 4: name += ".3ds"; break;
		//	case 5: name += ".asc"; break;
		//	case 6: name += ".raw"; break;
		//	case 7: name += ".dxf"; break;
		//	case 8: name += ".cob"; break;
		//	case 9: name += ".wrl"; break;
		//	case 10: name += ".obj"; break;
		//	case 11: name += ".nff"; break;
		//	case 12: name += ".pov"; break;
		//	case 13: name += ".inc"; break;
			}

		}
		

		m_pActiveDoc=(CMedDLeDoc*) CMedDLeApp::OpenDocumentFile(name);
			
	}			
	
	
}
/*
void CMedDLeApp::OnViewPlayer() 
{
	if(!AnimDlgOn)
	{
		if(m_pAnimDlg!=NULL) delete m_pAnimDlg;
		m_pAnimDlg=new CAnim;
		m_pAnimDlg->Create(IDD_ANIMATIONDLG);
		AnimDlgOn=1;
	}
}

void CMedDLeApp::OnUpdateViewPlayer(CCmdUI* pCmdUI) 
{
	pCmdUI->SetCheck(AnimDlgOn);	
	
}
*/
BOOL CMedDLeApp::PreTranslateMessage(MSG* pMsg)
{
	// CG: The following lines were added by the Splash Screen component.
	if (CSplashWnd::PreTranslateAppMessage(pMsg))
		return TRUE;

	return CWinApp::PreTranslateMessage(pMsg);
}
