// SkinPage.cpp : implementation file
//

#include "stdafx.h"
#include "MedDLe.h"
#include "SkinPage.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

////////////////////////////////////////
// CSkinPage property page

IMPLEMENT_DYNCREATE(CSkinPage, CPropertyPage)

CSkinPage::CSkinPage() : CPropertyPage(CSkinPage::IDD)
{
	//{{AFX_DATA_INIT(CSkinPage)
	m_ShowMapping = FALSE;
	m_Width = 0;
	m_Height = 0;
	//}}AFX_DATA_INIT
	m_xoff=0;
	m_yoff=0;
}

CSkinPage::~CSkinPage()
{
	m_SkinTree.DeleteAllItems();
//	if(curSkinBMP!=NULL) delete [] curSkinBMP;
}

void CSkinPage::DoDataExchange(CDataExchange* pDX)
{
	CPropertyPage::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSkinPage)
	DDX_Control(pDX, IDC_SCROLLBAR2, m_scroll2);
	DDX_Control(pDX, IDC_SCROLLBAR1, m_scroll1);
	DDX_Control(pDX, IDC_BUTTON1, m_GenSkin);
	DDX_Control(pDX, IDC_SKINVIEW, m_SkinView);
	DDX_Control(pDX, IDC_TREE_SKINS, m_SkinTree);
	DDX_Check(pDX, IDC_CHECK1, m_ShowMapping);
	DDX_Text(pDX, IDC_EDIT1, m_Width);
	DDX_Text(pDX, IDC_EDIT2, m_Height);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSkinPage, CPropertyPage)
	//{{AFX_MSG_MAP(CSkinPage)
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_CHECK1, OnCheck1)
	ON_BN_CLICKED(IDC_BUTTON1, OnButton1)
	ON_NOTIFY(TVN_SELCHANGED, IDC_TREE_SKINS, OnSelchangedTreeSkins)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSkinPage message handlers

void CSkinPage::FillSkinTree(void)
{
	m_SkinTree.DeleteAllItems();
	if(theApp.m_pActiveDoc==NULL){ UpdateData(); return;}

	CMedDLeDoc *pDoc=theApp.m_pActiveDoc;

	
	HTREEITEM where;
	int gcnt=pDoc->SkinGroups.GetSize();
	char name[24];
	int i;
	for(int j=0; j<gcnt; j++)
	{
			sprintf(name,"Group%d",j+1);
			pDoc->SkinGroups.GetAt(j)->TreeInfoGSkin=m_SkinTree.InsertItem(name);
	}
	for(j=0; j<pDoc->Skins.GetSize(); j++)
	{
		//if group
		if(pDoc->Skins.GetAt(j)->type!=0)
		{
			sprintf(name,"skin%d",j+1);
			pDoc->Skins[j]->TreeInfoSkin=m_SkinTree.InsertItem(name,pDoc->SkinGroups[pDoc->Skins[j]->groupnumber]->TreeInfoGSkin);
		}
		else
		{
			sprintf(name,"skin%d",j+1);
			pDoc->Skins.GetAt(j)->TreeInfoSkin=m_SkinTree.InsertItem(name);
		}
	}


	if(curSkinBMP!=NULL) delete [] curSkinBMP;
	if(pDoc->Gflags & S_HAS_SKIN)
	{
		curSkinBMP=new BYTE [pDoc->SkinW*pDoc->SkinH];
		for(i=0; i<pDoc->SkinH; i++) 
			memcpy(curSkinBMP+pDoc->SkinW*i,
			pDoc->Skins[pDoc->cur.skin]->bitmap+pDoc->SkinW*(pDoc->SkinH-i-1),
			pDoc->SkinW);	
		m_GenSkin.ShowWindow(SW_HIDE);
	}
	else
		m_GenSkin.ShowWindow(SW_SHOW);

	m_Width=pDoc->SkinW;
	m_Height=pDoc->SkinH;
	

	UpdateData(0);
	
}

BOOL CSkinPage::OnSetActive() 
{
	// TODO: Add your specialized code here and/or call the base class
	FillSkinTree();	
	return CPropertyPage::OnSetActive();
}
#include "MedDLeIO.h"
void CSkinPage::OnPaint() 
{
	CPaintDC dc(this); // device context for painting
	
	CDC *pdc=m_SkinView.GetDC();
	HDRAWDIB hDrawDib;
	
	CRect rc;
	m_SkinView.GetClientRect(&rc);
	CMedDLeDoc* pDoc=theApp.m_pActiveDoc;
    
	if((pDoc==NULL)|| !(pDoc->Gflags & S_HAS_SKIN))
	{
		//pdc->TextOut(20,20,"No Skin");
		return;
	}
	
	
	hDrawDib=DrawDibOpen();
	BYTE *pic=new BYTE [pDoc->SkinH*pDoc->SkinW];
	memcpy(pic,curSkinBMP,pDoc->SkinH*pDoc->SkinW);
	if(m_ShowMapping) 
	{
		
		int x1,x2,x3,p1,p2,p3,v1[2],v2[2],v3[2];
		for(int i=0;i<pDoc->Tris.GetSize();i++)
		{
			p1=pDoc->Tris[i].vindex[0];
			p2=pDoc->Tris[i].vindex[1];
			p3=pDoc->Tris[i].vindex[2];
			x1=x2=x3=0;
			if((pDoc->Verts[p1].Mflags&MDL_ONSEEM)&& !(pDoc->Tris[i].flags&S_FRONT)) x1=pDoc->SkinW/2;
			if((pDoc->Verts[p2].Mflags&MDL_ONSEEM)&& !(pDoc->Tris[i].flags&S_FRONT)) x2=pDoc->SkinW/2;
			if((pDoc->Verts[p3].Mflags&MDL_ONSEEM)&& !(pDoc->Tris[i].flags&S_FRONT)) x3=pDoc->SkinW/2;
			v1[0]=pDoc->Verts[p1].x+x1+m_xoff;
			v1[1]=pDoc->SkinH-pDoc->Verts[p1].y-m_yoff;
			v2[0]=pDoc->Verts[p2].x+x2+m_xoff;
			v2[1]=pDoc->SkinH-pDoc->Verts[p2].y-m_yoff;
			v3[0]=pDoc->Verts[p3].x+x3+m_xoff;
			v3[1]=pDoc->SkinH-pDoc->Verts[p3].y-m_yoff;
			vline(pic, v1, v2,pDoc);
			vline(pic, v2, v3,pDoc);
			vline(pic, v3, v1,pDoc);
			
		}
		
	}
	// blit dib!
	BITMAPINFO *bm = (BITMAPINFO *)MedDLeDIBInfo;
	bm->bmiHeader.biWidth=pDoc->SkinW;
	bm->bmiHeader.biHeight=pDoc->SkinH;  // negative makes it a top down bmp
	bm->bmiHeader.biSizeImage=pDoc->SkinH*pDoc->SkinW;
	DrawDibRealize(hDrawDib,pdc->GetSafeHdc(),TRUE);
	int x0,x1,y0,y1;
	x0=rc.right-4; 
	y0=rc.bottom-4;
	if(x0<pDoc->SkinW) x1=x0+2;
	else {x0=pDoc->SkinW; x1=x0+2;}
	if(y0<pDoc->SkinH) y1=y0+2;
	else{y0=pDoc->SkinH; y1=y0+2;}
	DrawDibDraw(hDrawDib, pdc->GetSafeHdc(),
			2,2,  //x,y
			x0, y0, //w,h
			(BITMAPINFOHEADER *)MedDLeDIBInfo,//mdi,
			pic,
			m_xoff,m_yoff, //source x,y
			x1+m_xoff,y1+m_yoff,//source w,h
			DDF_BACKGROUNDPAL
		);

	DrawDibClose(hDrawDib);
	delete [] pic;
	m_SkinView.ReleaseDC(pdc);
	// Do not call CPropertyPage::OnPaint() for painting messages
}


void CSkinPage::OnCheck1() 
{
	UpdateData();
	//CRect rc;
	//m_SkinView.GetClientRect(&rc);
	InvalidateRect(NULL,0);
}

void CSkinPage::OnButton1() 
{
	// call gen skin from mapgen
	theApp.m_pActiveDoc->MakeSkinMapping();
	FillSkinTree();
	
}

void CSkinPage::OnSelchangedTreeSkins(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;
	// TODO: Add your control notification handler code here
	HTREEITEM selc=m_SkinTree.GetSelectedItem();	

	CMedDLeDoc *pDoc=theApp.m_pActiveDoc;
	if(pDoc==NULL) {*pResult = 0; return;}

	for(int j=0; j<pDoc->Skins.GetSize(); j++)
	{
		if(pDoc->Skins.GetAt(j)->TreeInfoSkin==selc)
		{
			pDoc->cur.skin=j;
			pDoc->UpdateAllViews(NULL);
			FillSkinTree();	
			OnPaint();			
			//CRect rc;
			//m_SkinView.GetClientRect(&rc);
			//m_SkinView.InvalidateRect(rc,0);
			break;
		}
	}
	
	
	*pResult = 1;
}

BOOL CSkinPage::OnInitDialog() 
{
	CPropertyPage::OnInitDialog();
	
	FillSkinTree();
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
