//
// this file by brian martin 1996
// brian@phyast.pitt.edu
//
// this is part of the source for the MedDLe quake model viewer/editor
//

#include<stdio.h>
#include<stdlib.h>
#include<conio.h>
#include<dos.h>
#include<string.h>
#include<limits.h>
#include"bg_grx.h"
#include"bg_mouse.h"
#include<grx20.h>

#define VERSION  1.7      //meddle version
#define ONSEEM 0x0020

//  new struuctures
typedef struct situation {
	BG_3pt pos;
	BG_Matrix pos_matrix;
	BG_Matrix dir_matrix;
	unsigned int ix, iy;
	};


struct MDL_model{
	char filetype[4];
	int version;
	float xscale,yscale,zscale;        // scale model
	float xoffset,yoffset,zoffset;     // scale origin
	float radius;                      // bounding radius
	float eyex,eyey,eyez;              // eye position
	unsigned num_skins;                // num skins
	unsigned skinw;                    // skin width
	unsigned skinh;                    // skin height
	unsigned num_vertices;
	unsigned num_triangles;
	unsigned num_frames;
	unsigned sync_type;
	unsigned flags;
	float ave_size;

	struct MDL_model_skin *skin;
	unsigned int *vertex;
	unsigned int *triangle;
	struct MDL_frame *frame;
//	unsigned int  frame_type;
//	struct MDL_model_frame_group *frame_group;
	char filename[128];
	unsigned cur_skin;
	unsigned blocks;
	BG_Block *block;
	BG_Side *side;
	situation sit;
	int tcolor;
	int bcolor;
//	unsigned tot_frames;
};


struct trivertex {
	unsigned char	v[3];
	unsigned char vnormal;
};

struct MDL_group_skin{
	unsigned char *bitmap;
};

struct MDL_model_skin{
	unsigned type;
	unsigned char *bitmap;
	unsigned num_gskins;
	float *gskin_interval;
	struct MDL_group_skin *gskin;

};

struct MDL_model_frame {
	trivertex	bboxmin;	// lightnormal isn't used
	trivertex	bboxmax;	// lightnormal isn't used
	char		name[16];	// frame name from grabbing
	trivertex   *tv;
};
struct MDL_model_frame_group{
	unsigned num_gsframes;
	trivertex	bboxmin;	// lightnormal isn't used
	trivertex	bboxmax;	// lightnormal isn't used
	float *gsframe_interval;
	struct MDL_model_frame *gsframe;

};

struct MDL_frame{
	unsigned type;
	struct  MDL_model_frame_group gframe;
	struct  MDL_model_frame  sframe;

};

extern unsigned char pal[256*3];
extern unsigned char cmap[256*32];
extern int quiet;

struct MDL_window {
	int windowed;
	int x,y,w,h;
	GrContext *gcontext;
};

extern MDL_window win2d;
extern MDL_window win3d;
extern int cur_gskin;
extern int res;

extern int mdl_3d(MDL_model *, MDL_window *);
extern int mdl_2d(MDL_model *, MDL_window *);
extern void write_mdl(FILE *out, MDL_model *);
extern void read_mdl(FILE *, MDL_model *);
extern void setup_3d_data( MDL_model *);
extern void delete_3d_data(MDL_model *m);
extern void delete_frame(MDL_model *m, int frame);
extern void export_mdl_frame(char *filename, int frame, MDL_model *model);
extern int import_mdl_frame(char *filename, int frame, MDL_model *model);
extern void export_mdl_skin(char *fname, int skin, MDL_model *model );
extern int import_mdl_skin(char *fname, int skin, MDL_model *model );
extern void write_gif(char *name, unsigned char *pic, unsigned w, unsigned h);
extern void model_script(char *filename);
extern void clean_mdl(MDL_model *model);
extern void generate_mdl(char *inframe, MDL_model *model);
extern void vline(unsigned char *pic, int *v1, int *v2, MDL_model *model);
extern void init_win_stuff(void);
extern void	set_full_screen(void);
extern void set_graphics_win(MDL_window *w);


#define win_width 3.20
#define win_height 2.40
#define focus 2.00


#define FLAT_SHADING    0x1     // constant colour polygon
#define GOURAUD_SHADED  0x2     // Gouraud shaded polygon
#define TEXTURED        0x3     // texture mapped polygon
#define ARROW_LEFT  75
#define ARROW_RIGHT 77
#define ARROW_UP    72
#define ARROW_DOWN  80
#define KEY_ENTER       13
#define KEY_SPACE       32
#define KEY_TAB          9               /* all i can think of */

//extern BG_Block *block;
//extern BG_Object *object;




