//
//                 mxToolKit (c) 1999 by Mete Ciragan
//
// file:           mxFileDialog.cpp
// implementation: Win32 API
// last modified:  Mar 14 1999, Mete Ciragan
// copyright:      The programs and associated files contained in this
//                 distribution were developed by Mete Ciragan. The programs
//                 are not in the public domain, but they are freely
//                 distributable without licensing fees. These programs are
//                 provided without guarantee or warrantee expressed or
//                 implied.
//
#include <mx/mxFileDialog.h>
#include <mx/mxWindow.h>
#include <windows.h>
#include <commdlg.h>
#include <string.h>






const char *
mxGetOpenFileName (mxWindow *parent, int fileType/*, const char *path, const char *filter*/)
{
	//CHAR szPath[_MAX_PATH], szFilter[_MAX_PATH];
	OPENFILENAME ofn;
	static CHAR sd_path[_MAX_PATH]; // buffer for file name

	//const char* realPath;
	memset(sd_path, 0, sizeof(sd_path));

	memset(&ofn, 0, sizeof(ofn));
	ofn.lStructSize = sizeof(ofn);
	if (parent)
		ofn.hwndOwner = (HWND)parent->getHandle();
	ofn.hInstance = (HINSTANCE)GetModuleHandle(NULL);

	//memset(sd_path, 0, _MAX_PATH);
	//memcpy(szFilter, "Pack_Files(*.pak)\0*.pak\0\0", sizeof(szFilter)); break;
	//ofn.lpstrFilter = szFilter;

	switch (fileType)
	{

	case 1: // FILE_TYPE_MDX:
	case 2: //FILE_TYPE_MD2:
		ofn.lpstrFilter = "Kingpin_Models(.mdx/.md2)\0*.mdx;*.md2\0MDX_Model(.mdx)\0*.mdx\0MD2_Model(.md2)\0*.md2\0"; break;
	case 3 ://FILE_TYPE_TGA:
		ofn.lpstrFilter = "Kingpin_Images(.tga/.pcx)\0*.tga;*.pcx\0TGA_Image(.tga)\0*.tga\0PCX_File(.pcx)\0*.pcx\0\0"; break;
	case 4: //FILE_TYPE_PCX:
		ofn.lpstrFilter = "PCX_Files(*.pcx)\0*.pcx\0TGA_Image(.tga)\0*.tga\0\0"; break;
	case 5: //FILE_TYPE_PAK:
		ofn.lpstrFilter = "Pack_Files(*.pak)\0*.pak\0\0"; break;
	default:
		ofn.lpstrFilter = "\0\0";
	}
	
	ofn.lpstrFile = sd_path;
	//ofn.lpstrFile[0] = '\0';
	ofn.nFilterIndex = 1;
	ofn.lpstrFileTitle = NULL;
	ofn.nMaxFileTitle = 0;
	ofn.lpstrInitialDir = NULL;
	ofn.nMaxFile = sizeof(sd_path)-1;
	ofn.lpstrInitialDir = NULL;
	ofn.Flags = OFN_FILEMUSTEXIST | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY;

	if (GetOpenFileName (&ofn))
			return (const char*)sd_path;
		else
			return 0;
}



const char*mxGetSaveFileName (mxWindow *parent, int fileType/*, const char *path, const char *filter*/)
{
	OPENFILENAME ofn;
	static CHAR sd_path[_MAX_PATH] = ""; // buffer for file name

	memset(sd_path, 0, sizeof(sd_path));

	memset (&ofn, 0, sizeof (ofn));
	ofn.lStructSize = sizeof (ofn);
	if (parent)
		ofn.hwndOwner = (HWND) parent->getHandle ();
	ofn.hInstance = (HINSTANCE) GetModuleHandle (NULL);

	switch (fileType)
	{
	case 1: // FILE_TYPE_MDX:
	case 2: //FILE_TYPE_MD2:
		ofn.lpstrFilter = "Kingpin_Model(.md2)\0*.md2\0\0"; break;
	case 3://FILE_TYPE_TGA:
		ofn.lpstrFilter = "TGA_Image(.tga)\0*.tga\0PCX_Files(.pcx)\0*.pcx\0\0"; break;
	
	case 6://FILE_TYPE_AVI:
		ofn.lpstrFilter = "Video File(*.avi)\0*.avi\0\0"; break;

	default:
		ofn.lpstrFilter = "\0\0";

	}

	ofn.lpstrFile = sd_path;
	//ofn.nFilterIndex = 1;
	//ofn.lpstrFileTitle = NULL;
	//ofn.nMaxFileTitle = 0;
	ofn.nMaxFile = sizeof(sd_path) - 1;
	ofn.lpstrInitialDir = NULL;
	ofn.Flags = OFN_OVERWRITEPROMPT | OFN_PATHMUSTEXIST | OFN_HIDEREADONLY;

	if (GetSaveFileName (&ofn))
			return sd_path;
		else
			return 0;
}
