#ifndef INCLUDED_PAKVIEWER
#define INCLUDED_PAKVIEWER


#ifndef INCLUDED_MXWINDOW
#include <mx/mxWindow.h>
#endif


#define IDC_PAKVIEWER		1001


typedef struct
{
	char name[56];
	int filepos;
	int filelen;
} lump_t;



#ifdef __cpluspus
extern "C" {
#endif

int pak_ExtractFile (const char *pakFile, const char *lumpName, char *outFile);

#ifdef __cpluspus
}
#endif


class mxTreeView;
class mxPopupMenu;
class mxTab;
class GlWindow;


class PAKViewer : public mxWindow
{
	char d_pakFile[256];
	char d_currLumpName[256];
	bool d_loadEntirePAK;
	mxTreeView *UI_tvPAK;
	mxPopupMenu *pmMenu;
	mxTab *UI_pakTab;
	//GlWindow *glw; hypov8

public:
	// CREATORS
	PAKViewer (mxWindow *window);
	~PAKViewer ();

	// MANIPULATORS
	virtual int handleEvent (mxEvent *event);
	int OnPAKViewer ();
	int OnLoadModel (int pos);
	int OnLoadTexture (int pos, bool isTGA);
	int OnPlaySound ();
	int OnExtract ();

	bool openPAKFile (const char *pakFile);
	void closePAKFile ();
	void setLoadEntirePAK (bool b) { d_loadEntirePAK = b; }

	// ACCESSORS
	bool getLoadEntirePAK () const { return d_loadEntirePAK; }
};



#endif // INCLUDED_PAKVIEWER