/*  Misfit Model 3D
 * 
 *  Copyright (c) 2004-2005 Kevin Worcester
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 *
 *  See the COPYING file for full license text.
 */


#include "atrneartool.h"

#include "model.h"
#include "log.h"
#include "modelstatus.h"
#include "pixmap/atrneartool.xpm"
#include "glmath.h"

#include <math.h>

AttractNearTool::AttractNearTool()
{
}

AttractNearTool::~AttractNearTool()
{
}

const char * AttractNearTool::getName( int arg )
{
   return "Attract Near";
}

bool AttractNearTool::getKeyBinding( int arg, int & keyBinding )
{
   return false;
}

void AttractNearTool::mouseButtonDown( Parent * parent, int buttonState, int x, int y )
{
   m_vertexCoords.clear();
   m_jointCoords.clear();

   Model * model = parent->getModel();
   list<int> vertices = model->getSelectedVertices();
   list<int>::iterator it;

   bool firstSet = false;

   int index = 0;

   double curX = 0;
   double curY = 0;
   double curZ = 0;
   
   if ( !parent->getXValue( x, y, &curX ) )
   {
      index = 1;
   }
   if ( !parent->getYValue( x, y, &curY ) )
   {
      index = 2;
   }
   if ( !parent->getZValue( x, y, &curZ ) )
   {
      index = 0;
   }

   for ( it = vertices.begin(); it != vertices.end(); it++ )
   {
      double coords[3];
      model->getVertexCoords( (*it), coords );

      VertexCoords vc;
      vc.index = (*it);
      vc.x = coords[0];
      vc.y = coords[1];
      vc.z = coords[2];

      switch ( index )
      {
         case 0:
            vc.dist = ::distance( curX, curY, vc.x, vc.y );
            break;
         case 1:
            vc.dist = ::distance( curZ, curY, vc.z, vc.y );
            break;
         case 2:
            vc.dist = ::distance( curX, curZ, vc.x, vc.z );
            break;
         default:
            break;
      }

      // update range
      if ( !firstSet )
      {
         m_minDistance = vc.dist;
         m_maxDistance = vc.dist;
         firstSet = true;
      }
      else
      {
         if ( vc.dist < m_minDistance ) { m_minDistance = vc.dist; }
         if ( vc.dist > m_maxDistance ) { m_maxDistance = vc.dist; }
      }

      m_vertexCoords.push_back( vc );
   }

   list<int> joints = model->getSelectedBoneJoints();

   for ( it = joints.begin(); it != joints.end(); it++ )
   {
      double coords[3];
      model->getBoneJointCoords( (*it), coords );

      VertexCoords vc;
      vc.index = (*it);
      vc.x = coords[0];
      vc.y = coords[1];
      vc.z = coords[2];

      switch ( index )
      {
         case 0:
            vc.dist = ::distance( curX, curY, vc.x, vc.y );
            break;
         case 1:
            vc.dist = ::distance( curZ, curY, vc.z, vc.y );
            break;
         case 2:
            vc.dist = ::distance( curX, curZ, vc.x, vc.z );
            break;
         default:
            break;
      }


      // update range
      if ( !firstSet )
      {
         m_minDistance = vc.dist;
         m_maxDistance = vc.dist;
         firstSet = true;
      }
      else
      {
         if ( vc.dist < m_minDistance ) { m_minDistance = vc.dist; }
         if ( vc.dist > m_maxDistance ) { m_maxDistance = vc.dist; }
      }

      m_jointCoords.push_back( vc );
   }

   m_startX = curX;
   m_startY = curY;
   m_startZ = curZ;

   model_status( model, StatusNormal, STATUSTIME_SHORT, "Attracting near selected primitives" );
}

void AttractNearTool::mouseButtonMove( Parent * parent, int buttonState, int x, int y )
{
   LOG_PROFILE();

   Model * model = parent->getModel();

   int index = 0;

   double curX = 0;
   double curY = 0;
   double curZ = 0;

   if ( !parent->getXValue( x, y, &curX ) )
   {
      index = 1;
   }
   if ( !parent->getYValue( x, y, &curY ) )
   {
      index = 2;
   }
   if ( !parent->getZValue( x, y, &curZ ) )
   {
      index = 0;
   }

   double lengthX = curX - m_startX;
   double lengthY = curY - m_startY;
   double lengthZ = curZ - m_startZ;

   list<VertexCoords>::iterator it;

   for( it = m_vertexCoords.begin(); it != m_vertexCoords.end(); it++ )
   {
      double x = (*it).x;
      double y = (*it).y;
      double z = (*it).z;

      if ( (m_maxDistance - m_minDistance) >= 0.00001f )
      {
         x += (lengthX * ( 1.0 - ((*it).dist - m_minDistance) / (m_maxDistance - m_minDistance) ) );
         y += (lengthY * ( 1.0 - ((*it).dist - m_minDistance) / (m_maxDistance - m_minDistance) ) );
         z += (lengthZ * ( 1.0 - ((*it).dist - m_minDistance) / (m_maxDistance - m_minDistance) ) );
      }
      else
      {
         x += lengthX;
         y += lengthY;
         z += lengthZ;
      }

      model->moveVertex( (*it).index, x, y, z );
   }
   for( it = m_jointCoords.begin(); it != m_jointCoords.end(); it++ )
   {
      double x = (*it).x;
      double y = (*it).y;
      double z = (*it).z;

      if ( (m_maxDistance - m_minDistance) >= 0.00001f )
      {
         x += (lengthX * ( 1.0 - ((*it).dist - m_minDistance) / (m_maxDistance - m_minDistance) ) );
         y += (lengthY * ( 1.0 - ((*it).dist - m_minDistance) / (m_maxDistance - m_minDistance) ) );
         z += (lengthZ * ( 1.0 - ((*it).dist - m_minDistance) / (m_maxDistance - m_minDistance) ) );
      }
      else
      {
         x += lengthX;
         y += lengthY;
         z += lengthZ;
      }

      model->moveBoneJoint( (*it).index, x, y, z );
   }

   parent->updateAllViews();
}

void AttractNearTool::mouseButtonUp( Parent * parent, int buttonState, int x, int y )
{
   model_status( parent->getModel(), StatusNormal, STATUSTIME_SHORT, "Attract near complete" );
}

const char ** AttractNearTool::getPixmap()
{
   return (const char **) atrneartool_xpm;
}

double AttractNearTool::distance( double x1, double y1, double x2, double y2 )
{
   double xDiff = x2 - x1;
   double yDiff = y2 - y1;
   return sqrt( xDiff*xDiff + yDiff*yDiff );
}

double AttractNearTool::max( double a, double b )
{
   return ( a > b ) ? a : b;
}

