/*  Misfit Model 3D
 * 
 *  Copyright (c) 2004-2005 Kevin Worcester
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 *
 *  See the COPYING file for full license text.
 */

#ifndef __CHECKUPDATE_H
#define __CHECKUPDATE_H

enum CheckUpdateVersion_e {
   CUV_Stable,
   CUV_Devel,
   CUV_MAX
};
typedef enum CheckUpdateVersion_e CheckUpdateVersion;

// Start check process, returns >0 if check started
int check_update_start();

// Is update check is done? returns >0 if check update complete
int check_update_is_done();

// Has the check update process been started (regardless of whether it is complete)?
int check_update_should_check();

// Clear the started flag
void check_update_clear_check();

// Call after check_update_is_done() returns >0
int check_update_get_version( CheckUpdateVersion version, int & major, int & minor, int & patch );

// Statically allocated string, do not free/delete
const char * check_update_get_version_string( CheckUpdateVersion version );

#endif // __CHECKUPDATE_H
