/*  Misfit Model 3D
 * 
 *  Copyright (c) 2004-2005 Kevin Worcester
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 *
 *  See the COPYING file for full license text.
 */


#include "selectgrouptool.h"
#include "bounding.h"
#include "decalmgr.h"
#include "log.h"
#include "modelstatus.h"

#include "pixmap/selectgrouptool.xpm"

#include <stdio.h>
#include <qnamespace.h>

SelectGroupTool::SelectGroupTool()
   : m_boundingBox( NULL),
     m_tracking( false ),
     m_unselect( false ),
     m_startX( 0 ),
     m_startY( 0 ),
     m_x1( 0.0 ),
     m_y1( 0.0 ),
     m_z1( 0.0 ),
     m_selectionMode( Model::SelectGroups )
{
}

SelectGroupTool::~SelectGroupTool()
{
}

void SelectGroupTool::mouseButtonDown( Parent * parent, int buttonState, int x, int y )
{
   if ( m_tracking )
   {
      return;
   }

   parent->getModel()->setSelectionMode( Model::SelectGroups );

   m_boundingBox = new BoundingBox();
   DecalManager::getInstance()->addDecalToParent( m_boundingBox, parent );

   if ( buttonState & BS_Right )
   {
      m_unselect = true;
   }
   else
   {
      m_unselect = false;
   }

   m_tracking = true;
   m_startX = x;
   m_startY = y;

   m_x1 = 0.0;
   m_y1 = 0.0;
   m_z1 = 0.0;

   parent->getXValue( x, y, &m_x1 );
   parent->getYValue( x, y, &m_y1 );
   parent->getZValue( x, y, &m_z1 );

   if ( ! m_unselect && ! (buttonState & BS_Shift) )
   {
      parent->getModel()->unselectAll();
   }

   parent->updateAllViews();
   model_status( parent->getModel(), StatusNormal, STATUSTIME_SHORT, "Starting selection" );
}

void SelectGroupTool::mouseButtonUp( Parent * parent, int buttonState, int x, int y )
{
   if ( m_unselect )
   {
      if ( buttonState & BS_Left )
      {
         // We're waiting for the right button
         return;
      }
   }
   else
   {
      if ( buttonState & BS_Right )
      {
         // We're waiting for the left button
         return;
      }
   }

   if ( m_tracking )
   {
      m_tracking = false;

      double x1 = m_x1;
      double y1 = m_y1;
      double z1 = m_z1;
      double x2 = 0.0;
      double y2 = 0.0;
      double z2 = 0.0;

      Model * model = parent->getModel();
      if ( parent->getXValue( x, y, &x2 ) )
      {
         if ( parent->getYValue( x, y, &y2 ) )
         {
            if ( m_unselect )
            {
               model->unselectInVolumeXY( x1, y1, x2, y2 );
            }
            else
            {
               model->selectInVolumeXY( x1, y1, x2, y2 );
            }
         }
         else if ( parent->getZValue( x, y, &z2 ) )
         {
            if ( m_unselect )
            {
               model->unselectInVolumeXZ( x1, z1, x2, z2 );
            }
            else
            {
               model->selectInVolumeXZ( x1, z1, x2, z2 );
            }
         }
      }
      else
      {
         if ( parent->getYValue( x, y, &y2 ) )
         {
            if ( parent->getZValue( x, y, &z2 ) )
            {
               if ( m_unselect )
               {
                  model->unselectInVolumeYZ( y1, z1, y2, z2 );
               }
               else
               {
                  model->selectInVolumeYZ( y1, z1, y2, z2 );
               }
            }
         }
      }

      DecalManager::getInstance()->removeDecal( m_boundingBox );
      m_boundingBox = NULL;

      parent->updateAllViews();
      model_status( parent->getModel(), StatusNormal, STATUSTIME_SHORT, "Selection complete" );
   }
}

void SelectGroupTool::mouseButtonMove( Parent * parent, int buttonState, int x, int y )
{
   if ( m_tracking )
   {
      double x1 = m_x1;
      double y1 = m_y1;
      double z1 = m_z1;
      double x2 = 0.0;
      double y2 = 0.0;
      double z2 = 0.0;

      parent->getXValue( x, y, &x2 );
      parent->getYValue( x, y, &y2 );
      parent->getZValue( x, y, &z2 );
      m_boundingBox->setBounds( x1, y1, z1, x2, y2, z2 );
      parent->updateView();
   }
}

const char ** SelectGroupTool::getPixmap()
{
   return (const char **) selectgrouptool_xpm;
}

const char * SelectGroupTool::getName( int arg )
{
   return "Select Groups";
}

bool SelectGroupTool::getKeyBinding( int arg, int & keyBinding )
{
   keyBinding = Qt::Key_G;
   return true;
}

