/*  Misfit Model 3D
 * 
 *  Copyright (c) 2004-2005 Kevin Worcester
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 *
 *  See the COPYING file for full license text.
 */

#include "memguard.h"
#include <new>
#include <stdio.h>
#include <stdlib.h>

static bool _initialized = false;
static memguard_free_function  _fptr = NULL;
static int    _reserve = 0;
static char * _ptr = NULL;
static MemGuardStateE _state = MGS_NoMemory;

static void _free_internal()
{
   if ( _ptr )
   {
      printf( "did internal free\n" );
      delete[] _ptr;
      _ptr = NULL;
   }
   _state = MGS_NoBuffer;
}

static void _alloc_internal()
{
   if ( _ptr == NULL && _reserve > 0 )
   {
      _ptr = new char[ _reserve ];
      _state = MGS_Normal;
   }
}

static void _handler_exit()
{
   printf( "out of memory exit handler called\n" );
   exit( -1 );
}

static void _handler()
{
   static bool mustExit = true;
   mustExit = true;

   printf( "handler called\n" );
   std::set_new_handler( _handler_exit );
   if ( _ptr )
   {
      mustExit = false;
      _free_internal();
   }

   if ( _fptr )
   {
      if ( _fptr() <= 0 && mustExit )
      {
         _state = MGS_NoMemory;
         printf( "out of memory\n" );
         exit( -1 );
      }
   }
   std::set_new_handler( _handler );
}

void memguard_init( memguard_free_function f )
{
   if ( !_initialized )
   {
      printf( "allocated buffer\n" );
      _fptr = f;
      _reserve = 10 * 1024 * 1024;
      _state = MGS_NoBuffer;

      _alloc_internal();

      std::set_new_handler( _handler );
      _initialized = true;
   }
}

void memguard_shutdown()
{
   _free_internal();
   std::set_new_handler( NULL );
   _initialized = false;
}

MemGuardStateE memguard_get_state()
{
   return _state;
}

