/*  Misfit Model 3D
 * 
 *  Copyright (c) 2004-2005 Kevin Worcester
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 *  USA.
 *
 *  See the COPYING file for full license text.
 */


#include "sheartool.h"

#include "model.h"
#include "modelstatus.h"
#include "pixmap/sheartool.xpm"

#include <math.h>

ShearTool::ShearTool()
{
}

ShearTool::~ShearTool()
{
}

const char * ShearTool::getName( int arg )
{
   return "Shear";
}

bool ShearTool::getKeyBinding( int arg, int & keyBinding )
{
   return false;
}

void ShearTool::mouseButtonDown( Parent * parent, int buttonState, int x, int y )
{
   m_vertexCoords.clear();
   m_jointCoords.clear();

   Model * model = parent->getModel();
   list<int> vertices = model->getSelectedVertices();
   list<int>::iterator it;

   double cminX = 0;
   double cminY = 0;
   double cminZ = 0;
   double cmaxX = 0;
   double cmaxY = 0;
   double cmaxZ = 0;

   bool setFirst = false;

   for ( it = vertices.begin(); it != vertices.end(); it++ )
   {
      double coords[3];
      model->getVertexCoords( (*it), coords );

      VertexCoords vc;
      vc.index = (*it);
      vc.x = coords[0];
      vc.y = coords[1];
      vc.z = coords[2];

      // update range
      if ( !setFirst )
      {
         cminX = vc.x;
         cminY = vc.y;
         cminZ = vc.z;
         cmaxX = vc.x;
         cmaxY = vc.y;
         cmaxZ = vc.z;
         setFirst = true;
      }
      else
      {
         if ( vc.x < cminX ) { cminX = vc.x; }
         if ( vc.x > cmaxX ) { cmaxX = vc.x; }
         if ( vc.y < cminY ) { cminY = vc.y; }
         if ( vc.y > cmaxY ) { cmaxY = vc.y; }
         if ( vc.z < cminZ ) { cminZ = vc.z; }
         if ( vc.z > cmaxZ ) { cmaxZ = vc.z; }
      }

      m_vertexCoords.push_back( vc );
   }

   list<int> joints = model->getSelectedBoneJoints();

   for ( it = joints.begin(); it != joints.end(); it++ )
   {
      double coords[3];
      model->getBoneJointCoords( (*it), coords );

      VertexCoords vc;
      vc.index = (*it);
      vc.x = coords[0];
      vc.y = coords[1];
      vc.z = coords[2];

      // update range
      if ( !setFirst )
      {
         cminX = vc.x;
         cminY = vc.y;
         cminZ = vc.z;
         cmaxX = vc.x;
         cmaxY = vc.y;
         cmaxZ = vc.z;
         setFirst = true;
      }
      else
      {
         if ( vc.x < cminX ) { cminX = vc.x; }
         if ( vc.x > cmaxX ) { cmaxX = vc.x; }
         if ( vc.y < cminY ) { cminY = vc.y; }
         if ( vc.y > cmaxY ) { cmaxY = vc.y; }
         if ( vc.z < cminZ ) { cminZ = vc.z; }
         if ( vc.z > cmaxZ ) { cmaxZ = vc.z; }
      }

      m_jointCoords.push_back( vc );
   }

   double curX = 0;
   double curY = 0;
   double curZ = 0;
   
   double minX = 0;
   double minY = 0;
   double minZ = 0;
   double maxX = 0;
   double maxY = 0;
   double maxZ = 0;

   m_startLengthX = 0;
   m_startLengthY = 0;
   m_startLengthZ = 0;

   m_axis = 0;

   int index = 0;

   if ( !parent->getXValue( x, y, &curX ) )
   {
      index = 1;
   }
   if ( !parent->getYValue( x, y, &curY ) )
   {
      index = 2;
   }
   if ( !parent->getZValue( x, y, &curZ ) )
   {
      index = 0;
   }

   switch ( index )
   {
      case 0:
         minX = fabs( cminX - curX );
         minY = fabs( cminY - curY );
         maxX = fabs( cmaxX - curX );
         maxY = fabs( cmaxY - curY );

         if ( minX > maxX )
         {
            if ( minX > minY )
            {
               if ( minX > maxY )
               {
                  m_axis = 1;
                  m_far  = cminX;
                  m_orig = curY;
               }
               else
               {
                  m_axis = 0;
                  m_far  = cmaxY;
                  m_orig = curX;
               }
            }
            else
            {
               // minY > cminX
               if ( minY > maxY )
               {
                  m_axis = 0;
                  m_far  = cminY;
                  m_orig = curX;
               }
               else
               {
                  m_axis = 0;
                  m_far  = cmaxY;
                  m_orig = curX;
               }
            }
         }
         else
         {
            // maxX > minX
            if ( maxX > minY )
            {
               if ( maxX > maxY )
               {
                  m_axis = 1;
                  m_far  = cmaxX;
                  m_orig = curY;
               }
               else
               {
                  m_axis = 0;
                  m_far  = cmaxY;
                  m_orig = curX;
               }
            }
            else
            {
               // minY > maxX
               if ( minY > maxY )
               {
                  m_axis = 0;
                  m_far  = cminY;
                  m_orig = curX;
               }
               else
               {
                  m_axis = 0;
                  m_far  = cmaxY;
                  m_orig = curX;
               }
            }
         }
         break;
      case 1:
         minZ = fabs( cminZ - curZ );
         minY = fabs( cminY - curY );
         maxZ = fabs( cmaxZ - curZ );
         maxY = fabs( cmaxY - curY );

         if ( minZ > maxZ )
         {
            if ( minZ > minY )
            {
               if ( minZ > maxY )
               {
                  m_axis = 1;
                  m_far  = cminZ;
                  m_orig = curY;
               }
               else
               {
                  m_axis = 2;
                  m_far  = cmaxY;
                  m_orig = curZ;
               }
            }
            else
            {
               // minY > minZ
               if ( minY > maxY )
               {
                  m_axis = 2;
                  m_far  = cminY;
                  m_orig = curZ;
               }
               else
               {
                  m_axis = 2;
                  m_far  = cmaxY;
                  m_orig = curZ;
               }
            }
         }
         else
         {
            // maxZ > minZ
            if ( maxZ > minY )
            {
               if ( maxZ > maxY )
               {
                  m_axis = 1;
                  m_far  = cmaxZ;
                  m_orig = curY;
               }
               else
               {
                  m_axis = 2;
                  m_far  = cmaxY;
                  m_orig = curZ;
               }
            }
            else
            {
               // minY > maxZ
               if ( minY > maxY )
               {
                  m_axis = 2;
                  m_far  = cminY;
                  m_orig = curZ;
               }
               else
               {
                  m_axis = 2;
                  m_far  = cmaxY;
                  m_orig = curZ;
               }
            }
         }
         break;
      case 2:
         minX = fabs( cminX - curX );
         minZ = fabs( cminZ - curZ );
         maxX = fabs( cmaxX - curX );
         maxZ = fabs( cmaxZ - curZ );

         if ( minX > maxX )
         {
            if ( minX > minZ )
            {
               if ( minX > maxZ )
               {
                  m_axis = 2;
                  m_far  = cminX;
                  m_orig = curZ;
               }
               else
               {
                  m_axis = 0;
                  m_far  = cmaxZ;
                  m_orig = curX;
               }
            }
            else
            {
               // minZ > cminX
               if ( minZ > maxZ )
               {
                  m_axis = 0;
                  m_far  = cminZ;
                  m_orig = curX;
               }
               else
               {
                  m_axis = 0;
                  m_far  = cmaxZ;
                  m_orig = curX;
               }
            }
         }
         else
         {
            // maxX > minX
            if ( maxX > minZ )
            {
               if ( maxX > maxZ )
               {
                  m_axis = 2;
                  m_far  = cmaxX;
                  m_orig = curZ;
               }
               else
               {
                  m_axis = 0;
                  m_far  = cmaxZ;
                  m_orig = curX;
               }
            }
            else
            {
               // minZ > maxX
               if ( minZ > maxZ )
               {
                  m_axis = 0;
                  m_far  = cminZ;
                  m_orig = curX;
               }
               else
               {
                  m_axis = 0;
                  m_far  = cmaxZ;
                  m_orig = curX;
               }
            }
         }
         break;
      default:
         break;
   }

   m_startLengthX = distance( m_far, 0, curX, 0 );
   m_startLengthY = distance( m_far, 0, curY, 0 );
   m_startLengthZ = distance( m_far, 0, curZ, 0 );

   model_status( parent->getModel(), StatusNormal, STATUSTIME_SHORT, "Starting shear on selected primitives" );
}

void ShearTool::mouseButtonMove( Parent * parent, int buttonState, int x, int y )
{
   Model * model = parent->getModel();

   int index = 0;

   double curX = 0;
   double curY = 0;
   double curZ = 0;

   if ( !parent->getXValue( x, y, &curX ) )
   {
      index = 1;
   }
   if ( !parent->getYValue( x, y, &curY ) )
   {
      index = 2;
   }
   if ( !parent->getZValue( x, y, &curZ ) )
   {
      index = 0;
   }

   list<VertexCoords>::iterator it;

   switch ( index )
   {
      case 0:
         if ( m_axis == 0 )
         {
            double offset = curX - m_orig;
            for( it = m_vertexCoords.begin(); it != m_vertexCoords.end(); it++ )
            {
               double x = (*it).x;
               double y = (*it).y;
               double z = (*it).z;

               x = x + (offset * (fabs( y - m_far) / m_startLengthY) );

               model->moveVertex( (*it).index, x, y, z );
            }
            for( it = m_jointCoords.begin(); it != m_jointCoords.end(); it++ )
            {
               double x = (*it).x;
               double y = (*it).y;
               double z = (*it).z;

               x = x + (offset * (fabs( y - m_far) / m_startLengthY) );

               model->moveBoneJoint( (*it).index, x, y, z );
            }
         }
         else
         {
            double offset = curY - m_orig;
            for( it = m_vertexCoords.begin(); it != m_vertexCoords.end(); it++ )
            {
               double x = (*it).x;
               double y = (*it).y;
               double z = (*it).z;

               y = y + (offset * (fabs(x - m_far) / m_startLengthX) );

               model->moveVertex( (*it).index, x, y, z );
            }
            for( it = m_jointCoords.begin(); it != m_jointCoords.end(); it++ )
            {
               double x = (*it).x;
               double y = (*it).y;
               double z = (*it).z;

               y = y + (offset * (fabs(x - m_far) / m_startLengthX) );

               model->moveBoneJoint( (*it).index, x, y, z );
            }
         }
         break;
      case 1:
         if ( m_axis == 2 )
         {
            double offset = curZ - m_orig;
            for( it = m_vertexCoords.begin(); it != m_vertexCoords.end(); it++ )
            {
               double x = (*it).x;
               double y = (*it).y;
               double z = (*it).z;

               z = z + (offset * (fabs( y - m_far) / m_startLengthY) );

               model->moveVertex( (*it).index, x, y, z );
            }
            for( it = m_jointCoords.begin(); it != m_jointCoords.end(); it++ )
            {
               double x = (*it).x;
               double y = (*it).y;
               double z = (*it).z;

               z = z + (offset * (fabs( y - m_far) / m_startLengthY) );

               model->moveBoneJoint( (*it).index, x, y, z );
            }
         }
         else
         {
            double offset = curY - m_orig;
            for( it = m_vertexCoords.begin(); it != m_vertexCoords.end(); it++ )
            {
               double x = (*it).x;
               double y = (*it).y;
               double z = (*it).z;

               y = y + (offset * (fabs(z - m_far) / m_startLengthZ) );

               model->moveVertex( (*it).index, x, y, z );
            }
            for( it = m_jointCoords.begin(); it != m_jointCoords.end(); it++ )
            {
               double x = (*it).x;
               double y = (*it).y;
               double z = (*it).z;

               y = y + (offset * (fabs(z - m_far) / m_startLengthZ) );

               model->moveBoneJoint( (*it).index, x, y, z );
            }
         }
         break;
      case 2:
         if ( m_axis == 0 )
         {
            double offset = curX - m_orig;
            for( it = m_vertexCoords.begin(); it != m_vertexCoords.end(); it++ )
            {
               double x = (*it).x;
               double y = (*it).y;
               double z = (*it).z;

               x = x + (offset * (fabs( z - m_far) / m_startLengthZ) );

               model->moveVertex( (*it).index, x, y, z );
            }
            for( it = m_jointCoords.begin(); it != m_jointCoords.end(); it++ )
            {
               double x = (*it).x;
               double y = (*it).y;
               double z = (*it).z;

               x = x + (offset * (fabs( z - m_far) / m_startLengthZ) );

               model->moveBoneJoint( (*it).index, x, y, z );
            }
         }
         else
         {
            double offset = curZ - m_orig;
            for( it = m_vertexCoords.begin(); it != m_vertexCoords.end(); it++ )
            {
               double x = (*it).x;
               double y = (*it).y;
               double z = (*it).z;

               z = z + (offset * (fabs(x - m_far) / m_startLengthX) );

               model->moveVertex( (*it).index, x, y, z );
            }
            for( it = m_jointCoords.begin(); it != m_jointCoords.end(); it++ )
            {
               double x = (*it).x;
               double y = (*it).y;
               double z = (*it).z;

               z = z + (offset * (fabs(x - m_far) / m_startLengthX) );

               model->moveBoneJoint( (*it).index, x, y, z );
            }
         }
         break;
      default:
         break;
   }

   parent->updateAllViews();
}

void ShearTool::mouseButtonUp( Parent * parent, int buttonState, int x, int y )
{
   model_status( parent->getModel(), StatusNormal, STATUSTIME_SHORT, "Shear complete" );
}

const char ** ShearTool::getPixmap()
{
   return (const char **) sheartool_xpm;
}

double ShearTool::distance( const double & x1, const double & y1, const double & x2, const double & y2 )
{
   double xDiff = x2 - x1;
   double yDiff = y2 - y1;
   return sqrt( xDiff*xDiff + yDiff*yDiff );
}

double ShearTool::max( double a, double b )
{
   return ( a > b ) ? a : b;
}
