#include <iostream>
#include <gl/glut.h>
#include "data.h"

// "Object" data structure
typedef struct _obj {
	Point3	*vertices;
	long	*v_idx;
	Point3	*normals;
	long	*n_idx;
	Point2	*uvs;
	int		num_faces;
} Obj;

void reshapeFunc(int w, int h);
void displayFunc();

GLfloat light_diffuse[]	=	{1.0, 0.0, 0.0, 1.0};	// red diffuse light
GLfloat light_position[] =	{1.0, 1.0, 1.0, 0.0};	// infinite light position

Obj sph01;

int main(int argc, char **argv)
{
	glutInit(&argc, argv);
	glutInitWindowSize(800,600);
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_DEPTH | GLUT_RGB);
	glutCreateWindow("OpenGL C++ Exporter");
	glutReshapeFunc(reshapeFunc);
	glutDisplayFunc(displayFunc);
	glClearColor(0.2,0.5,0.5,0.0);
	glEnable(GL_DEPTH_TEST);

	glLightfv	(GL_LIGHT0, GL_DIFFUSE,  light_diffuse);
	glLightfv	(GL_LIGHT0, GL_POSITION, light_position);
	glEnable	(GL_LIGHT0);
	glEnable	(GL_LIGHTING);

	sph01.vertices = Sphere01_vertex;
	sph01.v_idx = Sphere01_vidx;
	sph01.normals = Sphere01_normal;
	sph01.n_idx = Sphere01_nidx;
	sph01.uvs = Sphere01_uv;
	sph01.num_faces = (sizeof(Sphere01_vidx)/sizeof(long));

	glutMainLoop();
	
	return 0;
}

/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

void reshapeFunc(int w, int h)
{
	glViewport(0,0,w,h);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	if(h<1) h=1;
	gluPerspective(40.0, (double)w/(double)h, 1.0, 1000.0);
	glMatrixMode(GL_MODELVIEW);
}

void displayFunc(){
	static GLfloat angle1 = 0.0;
	angle1 += 1.0;
	glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
	glLoadIdentity();
	glTranslatef( 0.0, 0.0, -120.0 );
	
	glRotatef( angle1,       0.0, 1.0, 0.0 );
	glRotatef( angle1 / 3.0, 1.0, 0.0, 0.0 );

	glBegin( GL_TRIANGLES );

	for(int i=0; i<sph01.num_faces; i++)
	{
		//--- This is how to use the provided texture coordinates
		// glTexCoord2f( sph01.uvs[sph01.v_idx[i]].x, sph01.uvs[sph01.v_idx[i]].y );

		glNormal3f( sph01.normals[sph01.n_idx[i]].x,
					sph01.normals[sph01.n_idx[i]].y,
					sph01.normals[sph01.n_idx[i]].z );
		glVertex3f(	sph01.vertices[sph01.v_idx[i]].x,
					sph01.vertices[sph01.v_idx[i]].y,
					sph01.vertices[sph01.v_idx[i]].z );					
	}

	glEnd();

	glutSwapBuffers();
	glutPostRedisplay();
}
