#ifndef __MS_PLUGIN_IMPL_H__
#define __MS_PLUGIN_IMPL_H__



#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif



#include "resource.h"
#include "msPlugIn.h"

#include <XSIParser.h>
#include <SIBCMatrix.h>

typedef int (XSI2MS) ( msModel *, CdotXSITemplate * );

typedef struct g_tMap_table_tag {

	char	*m_szTemplateName;
	XSI2MS*	m_pHandler;

} g_tMap_table;

typedef struct tNullBone_tag {
	
	char			m_szName[256];
	char			m_szParentName[256];
	CSIBCMatrix4x4	m_mSRT;
	CSIBCMatrix4x4	m_mGlobalSRT;

} tNullBone;


void	BuildLocalMatrix ( CdotXSITemplate *in_pTmp, CSIBCMatrix4x4* l_mLocal );
void	BuildGlobalMatrix ( CSIBCMatrix4x4& l_mGlobal );
tNullBone*	GetBone ( char *inszBoneName );
bool IsBone ( const char * );

CdotXSITemplates * FindTemplateRecursively ( CdotXSITemplates* , const char * );
//
// MAPS
//

int	SIScene ( msModel *, CdotXSITemplate * );
int	SIMaterial ( msModel *, CdotXSITemplate * );
int	SIMesh ( msModel *, CdotXSITemplate * );
int	SIEnvelope ( msModel *, CdotXSITemplate * );
int SITransform ( msModel *, CdotXSITemplate * );
int SINull ( msModel *, CdotXSITemplate * );

g_tMap_table	g_Maps [] = {
	"SI_Scene", SIScene,
	"SI_Material", SIMaterial,
	"SI_Mesh",SIMesh,
	"SI_EnvelopeList", SIEnvelope,
	"SI_Transform",SITransform,
	"SI_Null",SINull,
	NULL,NULL };

int	GetMap ( CdotXSITemplate * );



/////////////////////////////////////////////////////////////////////////////
// CMsPlugInApp
//
//

class CMsPlugInApp : public CWinApp
{
public:
	CMsPlugInApp();

	//{{AFX_VIRTUAL(CMsPlugInApp)
	//}}AFX_VIRTUAL

	//{{AFX_MSG(CMsPlugInApp)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};



/////////////////////////////////////////////////////////////////////////////
// cPlugIn
//
//

struct msModel;
class cPlugIn : public cMsPlugIn
{
    char szTitle[64];

public:
	cPlugIn ();
    virtual ~cPlugIn ();

public:
    int             GetType ();
    const char *    GetTitle ();
    int             Execute (msModel* pModel);

private:

	int				ConvertXSITemplate ( CdotXSITemplate * );

	int				PrintError (char *msg);

	msModel			*m_pModel;		
	CXSIParser		*m_pParser;

};

//
// Helpers
//

void GetFloatFromTemplate ( CdotXSITemplate *, int, float& );
char* GetStringFromTemplate ( CdotXSITemplate *in_pTmp, int in_iPos );
int GetIntFromTemplate ( CdotXSITemplate *in_pTmp, int in_iPos );
float *GetFloatPtrFromTemplate ( CdotXSITemplate *in_pTmp, int in_iPos );
int *GetIntPtrFromTemplate ( CdotXSITemplate *in_pTmp, int in_iPos );

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ fgt unmittelbar vor der vorhergehenden Zeile zustzliche Deklarationen ein.

#endif // __MS_PLUGIN_IMPL_H__