//i'm writing this while completely drunk. apologies for any errors!

#include "stdafx.h"
#include "kingpinmdx.h"

// hypov8 todo: 
// textures
// 

typedef struct mdxAnimHold_s
{
	modelMatrix_t		*mats;
	int					numFrames;
	float				frameRate;
	int					numBones;
} mdxAnimHold_t;

//retrives animation data
static mdxAnimHold_t *Model_MDX_GetAnimData(noeRAPI_t *rapi)
{
	int animDataSize;
	BYTE *animData = rapi->Noesis_GetExtraAnimData(animDataSize);
	if (!animData)
	{
		return NULL;
	}

	noesisAnim_t *anim = rapi->Noesis_AnimAlloc("animout", animData, animDataSize); //animation containers are pool-allocated, so don't worry about freeing them
	//copy off the raw matrices for the animation frames
	mdxAnimHold_t *amdx = (mdxAnimHold_t *)rapi->Noesis_PooledAlloc(sizeof(mdxAnimHold_t));
	memset(amdx, 0, sizeof(mdxAnimHold_t));
	amdx->mats = rapi->rpgMatsFromAnim(anim, amdx->numFrames, amdx->frameRate, &amdx->numBones, true);

	return amdx;
}

//index normal into the mdx normals list
static int Model_MDX_IndexNormal(float *nrm)
{
	float bestDP = nrm[0]*g_q2Normals[0][0] + nrm[1]*g_q2Normals[0][1] + nrm[2]*g_q2Normals[0][2];
	int bestIdx = 0;
	for (int i = 1; i < 162; i++)
	{
		float dp = nrm[0]*g_q2Normals[i][0] + nrm[1]*g_q2Normals[i][1] + nrm[2]*g_q2Normals[i][2];
		if (dp > bestDP)
		{
			bestDP = dp;
			bestIdx = i;
		}
	}
	return bestIdx;
}


//bake a frame of vertex data
static void Model_MDX_MakeFrame(sharedModel_t *pmdl, modelMatrix_t *animMats, mdxFrame_t *frames, int frameNum, int frameSize, noeRAPI_t *rapi,
	mdxBBox_t *bboxFrames ,int bboxSize) //hypov8 bbox
{
	mdxFrame_t *frame = (mdxFrame_t *)((BYTE *)frames + frameSize*frameNum);
	mdxBBox_t  *bbox =  (mdxBBox_t *) ((BYTE *)bboxFrames + bboxSize*frameNum); //hypov8 bbox
	sprintf_s(frame->name, 16, "fr_%i", frameNum);
	float frameMins[3] = {0.0f, 0.0f, 0.0f};
	float frameMaxs[3] = {0.0f, 0.0f, 0.0f};
	float bboxMins[3] = {0.0f, 0.0f, 0.0f};
	float bboxMaxs[3] = {0.0f, 0.0f, 0.0f};

	if (frameNum > 0 && animMats)
	{ //if working with skeletal data, create/updated the transformed vertex arrays
		rapi->rpgTransformModel(pmdl, animMats, frameNum-1);
	}
	//allocate temporary buffers for the high-precision data
	modelVert_t *vpos = (modelVert_t *)rapi->Noesis_UnpooledAlloc(sizeof(modelVert_t)*pmdl->numAbsVerts);
	modelVert_t *vnrm = (modelVert_t *)rapi->Noesis_UnpooledAlloc(sizeof(modelVert_t)*pmdl->numAbsVerts);
	//fill out high-precision data arrays while calculating the frame bounds
	for (int i = 0; i < pmdl->numAbsVerts; i++)
	{
		sharedVMap_t *svm = pmdl->absVertMap+i;
		sharedMesh_t *mesh = pmdl->meshes+svm->meshIdx;
		modelVert_t *verts = NULL;
		modelVert_t *normals = NULL;
		if (frameNum == 0)
		{ //initial base-pose frame
			verts = mesh->verts+svm->vertIdx;
			normals = mesh->normals+svm->vertIdx;
		}
		else if (frameNum > 0 && animMats)
		{ //bake in skeletally-transformed verts
			verts = mesh->transVerts+svm->vertIdx;
			normals = mesh->transNormals+svm->vertIdx;
		}
		else if (frameNum > 0 && mesh->numMorphFrames > 0 && frameNum-1 < mesh->numMorphFrames)
		{ //copy over vertex morph frames
			verts = mesh->morphFrames[frameNum-1].pos+svm->vertIdx;
			normals = mesh->morphFrames[frameNum-1].nrm+svm->vertIdx;
		}
		modelVert_t *framePos = vpos+i;
		modelVert_t *frameNrm = vnrm+i;
		if (!verts || !normals)
		{ //something went wrong with the transforms
			framePos->x = 0.0f;
			framePos->y = 0.0f;
			framePos->z = 0.0f;
			frameNrm->x = 0.0f;
			frameNrm->y = 0.0f;
			frameNrm->z = 1.0f;
		}
		else
		{
			framePos->x = verts->x;
			framePos->y = verts->y;
			framePos->z = verts->z;
			frameNrm->x = normals->x;
			frameNrm->y = normals->y;
			frameNrm->z = normals->z;
		}
		//add to the frame bounds
		if (i == 0)
		{
			g_mfn->Math_VecCopy((float *)framePos, frameMins);
			g_mfn->Math_VecCopy((float *)framePos, frameMaxs);
			g_mfn->Math_VecCopy((float *)framePos, bboxMins); //hypov8 bbox
			g_mfn->Math_VecCopy((float *)framePos, bboxMaxs); //hypov8 bbox
		}
		else
		{
			g_mfn->Math_ExpandBounds(frameMins, frameMaxs, (float *)framePos, (float *)framePos);
			g_mfn->Math_ExpandBounds(bboxMins, bboxMaxs, (float *)framePos, (float *)framePos); //hypov8 bbox
		}
	}

	 //hypov8 bbox
	bbox->min[0] = bboxMins[0];
	bbox->min[1] = bboxMins[1];
	bbox->min[2] = bboxMins[2];
	bbox->max[0] = bboxMaxs[0];
	bbox->max[1] = bboxMaxs[1];
	bbox->max[2] = bboxMaxs[2];


	//now convert the data to a mdx frame
	frame->trans[0] = frameMins[0];
	frame->trans[1] = frameMins[1];
	frame->trans[2] = frameMins[2];
	const float frange = 255.0f;
	const float invFRange = 1.0f/frange;
	frame->scale[0] = (frameMaxs[0]-frameMins[0])*invFRange;
	frame->scale[1] = (frameMaxs[1]-frameMins[1])*invFRange;
	frame->scale[2] = (frameMaxs[2]-frameMins[2])*invFRange;
	mdxVert_t *mdxVerts = (mdxVert_t *)(frame+1);
	for (int i = 0; i < pmdl->numAbsVerts; i++)
	{
		mdxVert_t *lv = mdxVerts+i;
		float *hvPos = (float *)(vpos+i);
		float *hvNrm = (float *)(vnrm+i);
		for (int j = 0; j < 3; j++)
		{
			float f = (((hvPos[j]-frameMins[j])/(frameMaxs[j]-frameMins[j])) * frange)+0.5f; //hypov8 added .5 to round better
			lv->vertPos[j] = (BYTE)g_mfn->Math_Min2(f, frange);
		}
		lv->normalIndex = Model_MDX_IndexNormal(hvNrm);
	}

	rapi->Noesis_UnpooledFree(vpos);
	rapi->Noesis_UnpooledFree(vnrm);
}

//put uv in 0-1 range
static float Model_MDX_CrunchUV(float f)
{
	f = fmodf(f, 1.0f);
	while (f < 0.0f)
	{
		f += 1.0f;
	}
	return f;
}

//create the skin page
BYTE *Model_MDX_CreateSkin(CArrayList<noesisTexRef_t> &trefs, sharedModel_t *pmdl, int &skinWidth, int &skinHeight, modelTexCoord_t *fuvs, noeRAPI_t *rapi)
{
	if (trefs.Num() <= 0)
	{
		rapi->LogOutput("WARNING: No textures to embed, creating placeholder image.\n");
		skinWidth = 128;
		skinHeight = 128;
		BYTE *page = (BYTE *)rapi->Noesis_UnpooledAlloc(skinWidth*skinHeight);
		for (int i = 0; i < skinWidth*skinHeight; i++)
		{
			page[i] = 15;
		}
		return page;
	}

	skinWidth = 0;
	skinHeight = 0;
	BYTE *page = rapi->Noesis_CreateRefImagePage(trefs, skinWidth, skinHeight);

	//now create new uv's indexing the appropriate sub-textures in the page
	for (int i = 0; i < pmdl->numAbsVerts; i++)
	{
		sharedVMap_t *svm = pmdl->absVertMap + i;
		sharedMesh_t *mesh = pmdl->meshes + svm->meshIdx;
		modelTexCoord_t *uv = fuvs+i;
		if (mesh->uvs && mesh->texRefIdx && mesh->texRefIdx[0] >= 0 && mesh->texRefIdx[0] < trefs.Num())
		{
			modelTexCoord_t *srcUV = mesh->uvs + svm->vertIdx;
			noesisTexRef_t &tref = trefs[mesh->texRefIdx[0]];
			if (tref.t)
			{
				float biasX = (float)tref.pageX / (float)skinWidth;
				float biasY = (float)tref.pageY / (float)skinHeight;
				float scaleX = (float)tref.t->w / (float)skinWidth;
				float scaleY = (float)tref.t->h / (float)skinHeight;
				uv->u = biasX + /*Model_MDX_CrunchUV(*/srcUV->u/*)*/*scaleX; //hypov8 dont crunch gl cmds?
				uv->v = biasY + /*Model_MDX_CrunchUV(*/srcUV->v/*)*/*scaleY; //hypov8 dont crunch gl cmds?
			}
			else
			{
				uv->u = 0.0f;
				uv->v = 0.0f;
			}
		}
		else
		{
			uv->u = 0.0f;
			uv->v = 0.0f;
		}
	}

	char *mdlskinsizeOpt = rapi->Noesis_GetOption("mdlskinsize");
	if (mdlskinsizeOpt)
	{ //share the mdl-format resize texture page option
		int resizeImg[2] = {0, 0};
		sscanf_s(mdlskinsizeOpt, "%i %i", &resizeImg[0], &resizeImg[1]);
		if (resizeImg[0] && resizeImg[1])
		{
			rapi->LogOutput("Resampling texture page to %ix%i.\n", resizeImg[0], resizeImg[1]);
			BYTE *pageResized = (BYTE *)rapi->Noesis_UnpooledAlloc(resizeImg[0]*resizeImg[1]*4);
			rapi->Noesis_ResampleImageBilinear(page, skinWidth, skinHeight, pageResized, resizeImg[0], resizeImg[1]);
			rapi->Noesis_UnpooledFree(page);
			page = pageResized;
			skinWidth = resizeImg[0];
			skinHeight = resizeImg[1];
		}
	}


	BYTE *pagePal = (BYTE *)rapi->Noesis_UnpooledAlloc(skinWidth*skinHeight);
	BYTE *qpala = &g_q2Pal[0][0];
	
	rapi->LogOutput("Palettizing texture...\n");
	rapi->Noesis_ApplyPaletteRGBA(page, skinWidth, skinHeight, pagePal, qpala);
	rapi->Noesis_UnpooledFree(page);

	return pagePal;
}

//generate the gl command data
BYTE *Model_MDX_GenerateGLCmds(sharedModel_t *pmdl, mdxTri_t *tris, modelTexCoord_t *fuvs, int &glcmdsSize, noeRAPI_t *rapi)
{
	rapi->LogOutput("Generating GL command lists...\n");
	RichBitStream bs;
	bool hasStrips = false;
	sharedStripList_t *slist = NULL;
	int numSList = 0;
	//char *mdxStripOpt = rapi->Noesis_GetOption("md2strips");
	if (true) //mdxStripOpt && atoi(mdxStripOpt)) //hypov8 forced glCommands
	{
		//convert the triangle indices to a flat short list for ingestion by the stripper
		WORD *triIdx = (WORD *)rapi->Noesis_UnpooledAlloc(sizeof(WORD)*pmdl->numAbsTris*3);
		for (int i = 0; i < pmdl->numAbsTris; i++)
		{
			mdxTri_t *tri = tris+i;
			WORD *dst = triIdx + i*3;
			dst[0] = tri->vertIndex[0];
			dst[1] = tri->vertIndex[1];
			dst[2] = tri->vertIndex[2];
		}
		hasStrips = rapi->rpgGenerateStripLists(triIdx, pmdl->numAbsTris*3, &slist, numSList, false);
		rapi->Noesis_UnpooledFree(triIdx);
	}

	if (!hasStrips)
	{ //if there are no strip lists, plot a plain list
		for (int i = 0; i < pmdl->numAbsTris; i++)
		{
			mdxTri_t *tri = tris+i;
			bs.WriteInt(3); //TrisTypeNum
			bs.WriteInt(0); //SubObjectID
			mdxGLCmd_t glcmds[3];
			for (int j = 0; j < 3; j++)
			{
				glcmds[j].vertexIndex = tri->vertIndex[j];
				glcmds[j].st[0] = fuvs[tri->vertIndex[j]].u;
				glcmds[j].st[1] = fuvs[tri->vertIndex[j]].v;
			}
			bs.WriteBytes(glcmds, sizeof(glcmds));
		}
	}
	else
	{ //plot the strips down
		for (int i = 0; i < numSList; i++)
		{
			sharedStripList_t *strip = slist+i;
			if (strip->type == SHAREDSTRIP_LIST)
			{ //plot it down as a list
				for (int j = 0; j < strip->numIdx; j += 3)
				{
					WORD *tri = strip->idx+j;
					bs.WriteInt(3); //TrisTypeNum //hypov8 todo: this only writes 1 triangle for fan!!
					bs.WriteInt(0); //SubObjectID
					mdxGLCmd_t glcmds[3];
					for (int j = 0; j < 3; j++)
					{
						glcmds[j].vertexIndex = tri[j];
						glcmds[j].st[0] = fuvs[tri[j]].u;
						glcmds[j].st[1] = fuvs[tri[j]].v;
					}
					bs.WriteBytes(glcmds, sizeof(glcmds));
				}
			}
			else
			{ //plot a strip
				bs.WriteInt(strip->numIdx); //TrisTypeNum
				bs.WriteInt(0);				//SubObjectID
				for (int j = 0; j < strip->numIdx; j++)
				{
					mdxGLCmd_t glcmd;
					WORD idx = strip->idx[j];
					glcmd.vertexIndex = idx;
					glcmd.st[0] = fuvs[idx].u;
					glcmd.st[1] = fuvs[idx].v;
					bs.WriteBytes(&glcmd, sizeof(glcmd));
				}
			}
		}
	}
	bs.WriteInt(0); //finish of with zero..
	//hypov8 todo: should we write whole object to end just incase??

	glcmdsSize = bs.GetSize();
	BYTE *tmp = (BYTE *)rapi->Noesis_UnpooledAlloc(glcmdsSize);
	memcpy(tmp, bs.GetBuffer(), glcmdsSize);
	rapi->LogOutput("Generated %i GL commands\n", glcmdsSize);
	return tmp;
}

#if 0
//export the page as pcx (assume q2 palette)
static void Model_MDX_OutputSkinPage(BYTE *pix, int pixW, int pixH, noeRAPI_t *rapi)
{
	char *outName = rapi->Noesis_GetOutputName();
	char outPath[MAX_NOESIS_PATH];
	rapi->Noesis_GetDirForFilePath(outPath, outName);

	strcat_s(outPath, MAX_NOESIS_PATH, "skinpage.pcx");
	if (rapi->Noesis_FileExists(outPath))
	{ //if the file exists, see if the user wants to overwrite it
		HWND wnd = g_nfn->NPAPI_GetMainWnd();
		if (wnd && MessageBox(wnd, L"skinpage.pcx already exists at the specified path. Are you sure you want to overwrite it?", L"MDX Exporter", MB_YESNO) != IDYES)
		{
			return;
		}
	}

	//grab an extension function for paletted pcx output
	bool (*pcxOut)(char *filename, BYTE *pixData, BYTE *palData, int w, int h);
	*((NOEXFUNCTION *)&pcxOut) = rapi->Noesis_GetExtProc("Image_WritePalettedPCX256");
	if (!pcxOut)
	{
		rapi->LogOutput("WARNING: Image_WritePalettedPCX256 extension unavailable, skipping texture page output.\n");
		return;
	}

	rapi->LogOutput("Writing '%s'.\n", outPath);
	pcxOut(outPath, pix, &g_q2Pal[0][0], pixW, pixH);
}
#endif

//hypov8
void Model_MDX_Null_SkinName(mdxSkin_t &skin)
{
	int i = 0;
	bool fileEnd = false;
	int len = sizeof(skin.name);

	while (i < len)
	{
		if (fileEnd|| skin.name[i] == '\0')
		{
			fileEnd = true;
			skin.name[i] = '\0';
		}
		i++;
	}
}

//hypov8
bool Model_MDX_CleanString(noeRAPI_t *rapi, const char in[MAX_NOESIS_PATH], char out[MAX_NOESIS_PATH])
{
	int i=0, fileEnd = false;
	bool outOK = true;
	char *playerDir, *modelDir, *texturesDir;

	strcpy_s(out, MAX_NOESIS_PATH, in);

	while (i < MAX_NOESIS_PATH)
	{
		if (out[i] == '\\')
			out[i] = '/';
		i++;
	}

	modelDir = strstr(out, "models/");
	playerDir = strstr(out, "players/");
	texturesDir = strstr(out, "textures/");
	if (modelDir || playerDir || texturesDir)
	{
		if (modelDir)
			strcpy_s(out,MAX_NOESIS_PATH,modelDir);
		else if (playerDir)
			strcpy_s(out,MAX_NOESIS_PATH,playerDir);
		else //texturesDir
			strcpy_s(out,MAX_NOESIS_PATH,texturesDir);
	}
	else
		outOK = false; //try use model folder name instead of internal image name.

	//chect file type. force .tga if missing
	if (!rapi->Noesis_CheckFileExt(out, ".tga") && !rapi->Noesis_CheckFileExt(out, ".pcx"))
	{
		rapi->Noesis_GetExtensionlessName(out, out);
		strcat_s(out, MAX_NOESIS_PATH, ".tga");
	}

	return outOK;
}


//export to mdx
bool Model_MDX_Write(noesisModel_t *mdl, RichBitStream *outStream, noeRAPI_t *rapi)
{
	sharedModel_t *pmdl = rapi->rpgGetSharedModel(mdl, NMSHAREDFL_WANTGLOBALARRAY|NMSHAREDFL_REVERSEWINDING);
	if (!pmdl)
	{
		return false;
	}

	if (pmdl->numAbsVerts > 65535)
	{ //this is a hard format limit
		rapi->LogOutput("ERROR: numVerts (%i) exceeds 65535!\n", pmdl->numAbsVerts);
		return false;
	}

	rapi->LogOutput("Attempting to fetch textures to bake into MDX...\n");
	CArrayList<noesisTexRef_t> &trefs = rapi->Noesis_LoadTexturesForModel(pmdl);
	rapi->LogOutput("Fetched %i texture(s).\n", trefs.Num());

	if (pmdl->numAbsVerts > 2048)
	{ //warn them if they're exceeding standard format limits
		rapi->LogOutput("WARNING: numVerts (%i) exceeds 2048, model will not work in standard Quake 2 engines.\n", pmdl->numAbsVerts);
	}
	if (pmdl->numAbsTris > 4096)
	{ //warn them if they're exceeding standard format limits
		rapi->LogOutput("WARNING: numTris (%i) exceeds 4096, model will not work in standard Quake 2 engines.\n", pmdl->numAbsTris);
	}

	//first, let's see if the data being exported contains any morph frames. we'll prioritize those over skeletal animation data, although we could also combine them.
	int maxMorphFrames = 0;
	for (int i = 0; i < pmdl->numMeshes; i++)
	{
		sharedMesh_t *mesh = pmdl->meshes+i;
		if (!mesh->morphFrames || mesh->numMorphFrames <= 0)
		{
			continue;
		}
		if (mesh->numMorphFrames > maxMorphFrames)
		{
			maxMorphFrames = mesh->numMorphFrames;
		}
	}

	mdxAnimHold_t *amdx = NULL;
	if (pmdl->bones && pmdl->numBones > 0 && maxMorphFrames <= 0)
	{ //if it's a skeletal mesh and no morph frames were found, look for some skeletal animation data
		amdx = Model_MDX_GetAnimData(rapi);
		if (amdx && amdx->numBones != pmdl->numBones)
		{ //got some, but the bone count doesn't match!
			amdx = NULL;
		}
	}

	int mdlFrames = (amdx) ? 1 + amdx->numFrames : 1 + maxMorphFrames;
	if (mdlFrames > 512)
	{ //warn them if they're exceeding standard format limits
		rapi->LogOutput("WARNING: numFrames (%i) exceeds 512, not compatible with standard Quake 2 network protocol.\n", mdlFrames);
	}

	modelMatrix_t *animMats = (amdx) ? amdx->mats : NULL;

	//now, bake all the frame data out
	rapi->LogOutput("Compressing and encoding frames...\n");
	int frameSize = sizeof(mdxFrame_t) + sizeof(mdxVert_t)*pmdl->numAbsVerts;
	int bboxSize = sizeof(mdxBBox_t);
	mdxFrame_t *frames = (mdxFrame_t *)rapi->Noesis_UnpooledAlloc(frameSize*mdlFrames);
	mdxBBox_t *bboxFrames = (mdxBBox_t *)rapi->Noesis_UnpooledAlloc(bboxSize*mdlFrames);
	for (int i = 0; i < mdlFrames; i++)
	{
		Model_MDX_MakeFrame(pmdl, animMats, frames, i, frameSize, rapi, bboxFrames, bboxSize); //hypov8 add bbox
	}

	//VERTEX INFO
	mdxVertInfo_t *vertexInfo = (mdxVertInfo_t *)rapi->Noesis_UnpooledAlloc(sizeof(mdxVertInfo_t)*pmdl->numAbsVerts);
	//hypov8 vert group id (always 1)
	for (int i = 0; i < pmdl->numAbsVerts; i++)
	{
		vertexInfo[i].objectNum = 1;
	}


	//next, create triangle data
	mdxTri_t *tris = (mdxTri_t *)rapi->Noesis_UnpooledAlloc(pmdl->numAbsTris*sizeof(mdxTri_t));
	for (int i = 0; i < pmdl->numAbsTris; i++)
	{
		modelLongTri_t *src = pmdl->absTris+i; //hypov8 todo: 
		mdxTri_t *dst = tris+i;
		dst->vertIndex[0] = src->idx[0];
		dst->vertIndex[1] = src->idx[1];
		dst->vertIndex[2] = src->idx[2];
		dst->texIndex[0] = src->idx[0]; //textureIndices
		dst->texIndex[1] = src->idx[1]; //textureIndices
		dst->texIndex[2] = src->idx[2]; //textureIndices
	}

	mdxHdr_t hdr;
	memset(&hdr, 0, sizeof(hdr));
	memcpy(hdr.id, "IDPX", 4);
	hdr.ver = 4;
	hdr.frameSize = frameSize;
	hdr.numSkins = 1;
	hdr.numVerts = pmdl->numAbsVerts;
	//hdr.numST = pmdl->numAbsVerts;
	hdr.numTris = pmdl->numAbsTris;
	hdr.numFrames = mdlFrames;


	//now fill out the st's and create a single texture page
	rapi->LogOutput("Compiling texture page(s)...\n");
	modelTexCoord_t *fuvs = (modelTexCoord_t *)rapi->Noesis_UnpooledAlloc(sizeof(modelTexCoord_t)*pmdl->numAbsVerts);
	memset(fuvs, 0, sizeof(modelTexCoord_t)*pmdl->numAbsVerts);
	BYTE *skinPage = Model_MDX_CreateSkin(trefs, pmdl, hdr.skinWidth, hdr.skinHeight, fuvs, rapi);
	int glcmdsSize;
	BYTE *glcmds = Model_MDX_GenerateGLCmds(pmdl, tris, fuvs, glcmdsSize, rapi);
	hdr.numGLCmds = glcmdsSize/4;

	//set skins up
	char *mdxpainOpt = rapi->Noesis_GetOption("md2painskin"); //hypov8 todo: do we need this
	bool addPainSkin = (mdxpainOpt && atoi(mdxpainOpt));
	mdxSkin_t skins[2];
	memset(skins, 0, sizeof(skins));
	char skinName[MAX_NOESIS_PATH];
	char srcDir[MAX_NOESIS_PATH];
	char *srcFileName;

	strcpy_s(srcDir, MAX_NOESIS_PATH, pmdl->meshes->skinName);
	if (!Model_MDX_CleanString(rapi, srcDir, skinName)) //hypov8 search for "players" or "models" in skiname
	{	
		srcFileName = rapi->Noesis_GetOutputName();
		strcpy_s(srcDir,MAX_NOESIS_PATH,srcFileName);
		if (!Model_MDX_CleanString(rapi, srcDir, skinName))	//use "model_path/model_name.tga"
		{
			//set the default material name from noesis. crashes if to long
			rapi->Noesis_GetDirForFilePath(srcDir, pmdl->meshes->skinName); //grab the name path from the first mesh
			strcat_s(srcDir, MAX_NOESIS_PATH, "tris.tga");
			Model_MDX_CleanString(rapi, srcDir, skinName);
		}
	}
	strcpy_s(skins[0].name, 64, skinName); 
	Model_MDX_Null_SkinName(skins[0]); //hypov8 clean string
	rapi->LogOutput("Skin path: %s\n", skins[0].name);

	if (addPainSkin)
	{
		rapi->Noesis_GetDirForFilePath(skins[1].name, skins[0].name);
		strcat_s(skins[1].name, 64, "pain.pcx");
		hdr.numSkins++;
	}
	//export the page as pcx
	//Model_MDX_OutputSkinPage(skinPage, hdr.skinWidth, hdr.skinHeight, rapi);

	//set up all the offsets
	hdr.ofsSkins = sizeof(hdr);
	hdr.ofsTris = hdr.ofsSkins + sizeof(mdxSkin_t)*hdr.numSkins;
	hdr.ofsFrames = hdr.ofsTris + sizeof(mdxTri_t)*hdr.numTris;
	hdr.ofsGLCmds = hdr.ofsFrames + frameSize*hdr.numFrames;
	hdr.offsetVertexInfo = hdr.ofsGLCmds + glcmdsSize;
	hdr.offsetSfxDefines =hdr.offsetVertexInfo + sizeof(mdxVertInfo_t)*hdr.numVerts; //todo: numObjects
	hdr.offsetSfxEntries = hdr.offsetSfxDefines + 0; // hdr.num_SfxDefines no sfx def's
	hdr.offsetBBoxFrames = hdr.offsetSfxEntries + 0; // no sfx entries
	hdr.offsetDummyEnd = hdr.offsetBBoxFrames+ (sizeof(mdxBBox_t)*hdr.numFrames);
	hdr.ofsEnd = hdr.offsetDummyEnd;

	//now write it all to the output stream
	outStream->WriteBytes(&hdr, sizeof(hdr));
	outStream->WriteBytes(skins, sizeof(mdxSkin_t)*hdr.numSkins);
	outStream->WriteBytes(tris, sizeof(mdxTri_t)*hdr.numTris);
	outStream->WriteBytes(frames, frameSize*hdr.numFrames);
	outStream->WriteBytes(glcmds, glcmdsSize);
	outStream->WriteBytes(vertexInfo, sizeof(mdxVertInfo_t)*hdr.numVerts);
	// offsetSfxDefines null
	// offsetSfxEntries null
	outStream->WriteBytes(bboxFrames, sizeof(mdxBBox_t)* hdr.numFrames); //hypov8 bbox
	//end

	rapi->Noesis_UnpooledFree(glcmds);
	rapi->Noesis_UnpooledFree(skinPage);
	rapi->Noesis_UnpooledFree(fuvs);
	rapi->Noesis_UnpooledFree(frames);
	rapi->Noesis_UnpooledFree(tris);
	rapi->Noesis_UnpooledFree(vertexInfo); //hypov8 vertexinfo
	rapi->Noesis_UnpooledFree(bboxFrames); //hypov8 bbox


	return true;
}

//catch anim writes
//(note that this function would normally write converted data to a file at anim->filename, but for this format it instead saves the data to combine with the model output)
void Model_MDX_WriteAnim(noesisAnim_t *anim, noeRAPI_t *rapi)
{
	if (!rapi->Noesis_HasActiveGeometry() || rapi->Noesis_GetActiveType() != g_fmtHandle)
	{
		rapi->LogOutput("WARNING: Stand-alone animations cannot be converted to MDX.\nNothing will be written.\n");
		return;
	}

	rapi->Noesis_SetExtraAnimData(anim->data, anim->dataLen);
}


