//General requirements and/or suggestions for Noesis plugins:
//
// -Use 1-byte struct alignment for all shared structures. (plugin MSVC project file defaults everything to 1-byte-aligned)
// -Always clean up after yourself. Your plugin stays in memory the entire time Noesis is loaded, so you don't want to crap up the process heaps.
// -Try to use reliable type-checking, to ensure your plugin doesn't conflict with other file types and create false-positive situations.
// -Really try not to write crash-prone logic in your data check function! This could lead to Noesis crashing from trivial things like the user browsing files.
// -When using the rpg begin/end interface, always make your Vertex call last, as it's the function which triggers a push of the vertex with its current attributes.
// -!!!! Check the web site and documentation for updated suggestions/info! !!!!

#include "stdafx.h"
#include "quakemd2.h"
#include "q2nrm.h"
#include "q2pal.h"

extern bool Model_MD2_Write(noesisModel_t *mdl, RichBitStream *outStream, noeRAPI_t *rapi);
extern void Model_MD2_WriteAnim(noesisAnim_t *anim, noeRAPI_t *rapi);

const char *g_pPluginName = "kingpinmdx";
const char *g_pPluginDesc = "Kingpin MDX format handler, by Hypov8."; //duplicate of md2
int g_fmtHandle = -1;

//hypov8
//objGlArray_t mdxFrameObj[MAX_FRAMES]; //store all vertex info
//objGlArray_t mdxFrameGL[1]; //store only gl commands. using vert info above
glVertex_t mdxGlVertArray[MAX_MDX_GLCMDS];


//is it this format?
bool Model_MD2_Check(BYTE *fileBuffer, int bufferLen, noeRAPI_t *rapi)
{
	if (bufferLen < sizeof(md2Hdr_t))
	{
		return false;
	}
	md2Hdr_t *hdr = (md2Hdr_t *)fileBuffer;
	if (memcmp(hdr->id, "IDPX", 4)) //hypov8
	{
		return false;
	}
	if (hdr->ver != 4) //hypov8
	{
		return false;
	}
	if (hdr->ofsEnd <= 0 || hdr->ofsEnd > bufferLen)
	{
		return false;
	}
	if (hdr->ofsSkins <= 0 || hdr->ofsSkins > bufferLen ||
		//hdr->ofsST <= 0 || hdr->ofsST > bufferLen || //not in mdx
		hdr->ofsTris <= 0 || hdr->ofsTris > bufferLen ||
		hdr->ofsFrames <= 0 || hdr->ofsFrames > bufferLen ||
		hdr->ofsGLCmds <= 0 || hdr->ofsGLCmds > bufferLen ||
	//mdx
		hdr->offsetVertexInfo <= 0 || hdr->offsetVertexInfo > bufferLen ||
		hdr->offsetSfxDefines <= 0 || hdr->offsetSfxDefines > bufferLen ||
		hdr->offsetSfxEntries <= 0 || hdr->offsetSfxEntries > bufferLen ||
		hdr->offsetBBoxFrames <= 0 || hdr->offsetBBoxFrames > bufferLen ||
		hdr->offsetDummyEnd <= 0 || hdr->offsetDummyEnd > bufferLen ||

		hdr->ofsEnd <= 0 || hdr->ofsEnd > bufferLen)
	{
		return false;
	}

	return true;
}

//decode a vert
static void Model_MD2_DecodeVert(md2Frame_t *frame, md2Vert_t *vert, float *pos, float *nrm)
{
	assert(vert->normalIndex < 162);
	nrm[0] = g_q2Normals[vert->normalIndex][0];
	nrm[1] = g_q2Normals[vert->normalIndex][1];
	nrm[2] = g_q2Normals[vert->normalIndex][2];
	pos[0] = (float)vert->vertPos[0] * frame->scale[0] + frame->trans[0];
	pos[1] = (float)vert->vertPos[1] * frame->scale[1] + frame->trans[1];
	pos[2] = (float)vert->vertPos[2] * frame->scale[2] + frame->trans[2];
}

void StringTrimRight(const char srcDir[MAX_NOESIS_PATH], int len, char out[MAX_NOESIS_PATH])
{
	//char out[MAX_NOESIS_PATH];

	for (int j = 0; j < len; j++)
	{
		out[j] = srcDir[j];
		if (j == len - 1)
		{
			out[j + 1] = '\0';
		}
	}

//	return (char*)out;

}

void StringStripFdSlash(const char in[MAX_NOESIS_PATH], char out[MAX_NOESIS_PATH])
{
	for (int j = 0; j < MAX_NOESIS_PATH; j++)
	{
		if (in[j] == '/') 
			out[j] = '\\';
		else
			out[j] = in[j];

		if (in[j] == '\0')
			return;
	}
}

//load it (note that you don't need to worry about validation here, if it was done in the Check function)
noesisModel_t *Model_MD2_Load(BYTE *fileBuffer, int bufferLen, int &numMdl, noeRAPI_t *rapi)
{
//mdx todo: object number..
	int			mdxGlVertCount = 0;
	md2Hdr_t	*hdr = (md2Hdr_t *)fileBuffer;
	md2Skin_t	*skins = (md2Skin_t *)(fileBuffer+hdr->ofsSkins);
	md2Tri_t	*tris = (md2Tri_t *)(fileBuffer+hdr->ofsTris);
	int			frameSize = hdr->frameSize;
	wchar_t		noesisFileDir[MAX_NOESIS_PATH];
	char		srcDir[MAX_NOESIS_PATH];
	char		outDir[MAX_NOESIS_PATH];

	void		*pgctx = rapi->rpgCreateContext();
	for (int j = 1; j < hdr->numFrames; j++)
	{ //commit extra frames as morph frames
		int frameNum = 0;
		md2Frame_t *frame = (md2Frame_t *)(fileBuffer+hdr->ofsFrames + frameSize*j);
		md2Vert_t *vertData = (md2Vert_t *)(frame+1);
		float *xyz = (float *)rapi->Noesis_PooledAlloc(sizeof(float)*3*hdr->numVerts);
		float *nrm = (float *)rapi->Noesis_PooledAlloc(sizeof(float)*3*hdr->numVerts);
		for (int k = 0; k < hdr->numVerts; k++)
		{
			Model_MD2_DecodeVert(frame, vertData+k, xyz+k*3, nrm+k*3);
		}
		rapi->rpgFeedMorphTargetPositions(xyz, RPGEODATA_FLOAT, sizeof(float)*3);
		rapi->rpgFeedMorphTargetNormals(nrm, RPGEODATA_FLOAT, sizeof(float)*3);
		rapi->rpgCommitMorphFrame(hdr->numVerts);
	}
	rapi->rpgCommitMorphFrameSet();

	
	//skin full path
	{
		char *playerIdx, *modelIdx;
		char truncDir[MAX_NOESIS_PATH];
		int lenPlayer,lenModel, lenFile;
		g_nfn->NPAPI_GetSelectedFile(noesisFileDir);

		wcstombs(srcDir, noesisFileDir, sizeof(srcDir));

		playerIdx = strstr(srcDir, "\\players\\");
		modelIdx = strstr(srcDir, "\\models\\");

		if (playerIdx ||modelIdx)
		{
			lenFile = strlen(srcDir);
			if (playerIdx)
			{
				lenPlayer = strlen(playerIdx);
				lenPlayer = strlen(playerIdx);
				StringTrimRight(srcDir, lenFile - lenPlayer+1, truncDir);
			}
			else if (modelIdx) 
			{
				lenModel = strlen(modelIdx);
				StringTrimRight(srcDir, lenFile - lenModel+1, truncDir);
			}
			//combine and clean string
			strcpy(srcDir, truncDir);
			strcat(srcDir, skins->name);
			StringStripFdSlash(srcDir, outDir);

			//set the default material name (full path)
			rapi->rpgSetMaterial(outDir);
		}

		else	//set the default material name (in model)
			rapi->rpgSetMaterial(skins->name);
	}



	//hypov8 retreve mdx gl commands data
	{
		int countGLHeader = 0;	//# glcommands read from buffer
		int countGLvertex = 0;	//# glvertex read from buffer

		bool glData = true;
		while (glData)
		{
			glCmdHeader_t *glInfo = (glCmdHeader_t *)(fileBuffer + hdr->ofsGLCmds + (sizeof(glCmdHeader_t)*countGLHeader) + (sizeof(glVertex_t)* countGLvertex));
			int numGlVerts = glInfo->TrisTypeNum;
			int objID = glInfo->SubObjectID; //todo
			int glVertCnt;
			countGLHeader += 1;
			glVertex_t *glVert = (glVertex_t *)(fileBuffer + hdr->ofsGLCmds + (sizeof(glCmdHeader_t)*countGLHeader) + (sizeof(glVertex_t)*countGLvertex));

			//Triangle strip		
			if (numGlVerts > 0 && numGlVerts >= 3 && numGlVerts < MAX_MDX_VERT)		
			{
				bool flip = false;
				glVertCnt = numGlVerts;

				//set first tri.
				copyUVIdx(glVert[0], mdxGlVertArray[mdxGlVertCount], mdxGlVertCount);
				copyUVIdx(glVert[1], mdxGlVertArray[mdxGlVertCount], mdxGlVertCount);
				copyUVIdx(glVert[2], mdxGlVertArray[mdxGlVertCount], mdxGlVertCount);
				countGLvertex += 3;

				for (int j = 3; j < glVertCnt;j++)
				{
					if (!flip)
					{
						copyUVIdx(glVert[j-1], mdxGlVertArray[mdxGlVertCount], mdxGlVertCount);
						copyUVIdx(glVert[j-2], mdxGlVertArray[mdxGlVertCount], mdxGlVertCount);
						copyUVIdx(glVert[j], mdxGlVertArray[mdxGlVertCount], mdxGlVertCount);
					}
					else
					{
						copyUVIdx(glVert[j-2], mdxGlVertArray[mdxGlVertCount], mdxGlVertCount);
						copyUVIdx(glVert[j-1], mdxGlVertArray[mdxGlVertCount], mdxGlVertCount);
						copyUVIdx(glVert[j], mdxGlVertArray[mdxGlVertCount], mdxGlVertCount);
					}

					countGLvertex += 1;
					flip = flip ? false : true;
				}
			}
			//Triangle fan
			else if (numGlVerts < 0 && numGlVerts <= -3 && numGlVerts > -MAX_MDX_VERT)
			{
				glVertCnt = -numGlVerts;

				//store vert[0] (centre)
				copyUVIdx(glVert[0], mdxGlVertArray[mdxGlVertCount], mdxGlVertCount);
				countGLvertex += 1;

				for (int j = 1; j < glVertCnt;j++)
				{
					copyUVIdx(glVert[j], mdxGlVertArray[mdxGlVertCount], mdxGlVertCount);
					countGLvertex += 1;

					if (j > 2)
					{				
						copyUVIdx(glVert[0], mdxGlVertArray[mdxGlVertCount], mdxGlVertCount);//vert[0] (centre)
						copyUVIdx(glVert[j-1], mdxGlVertArray[mdxGlVertCount], mdxGlVertCount);//previour vertex
					}
					if (glVertCnt > 4 && j == glVertCnt-1) //todo last tri in 4+
						j=j;//hypov8 no model created with a tri created here??
				}
			}
			else
				glData = false; //done. This will also catch some vertex count errors
		}
	}

	//now render out the base frame geometry
	md2Frame_t *frame = (md2Frame_t *)(fileBuffer + hdr->ofsFrames);
	md2Vert_t *vertData = (md2Vert_t *)(frame + 1);
	rapi->rpgBegin(RPGEO_TRIANGLE);
	for (int i = 0; i < mdxGlVertCount; i+=3)
	{
		for (int j = 2; j >= 0; j--)
		{
			int order = i+j;
			int vIdx = mdxGlVertArray[order].vertexIndex;
			float pos[3], nrm[3], uv[2];

			Model_MD2_DecodeVert(frame, &vertData[vIdx], pos, nrm);

			uv[0] = mdxGlVertArray[order].s;
			uv[1] = mdxGlVertArray[order].t;

			rapi->rpgVertUV2f(uv, 0);
			rapi->rpgVertNormal3f(nrm);
			rapi->rpgVertMorphIndex(vIdx); //this is important to tie this vertex to the pre-provided morph arrays
			rapi->rpgVertex3f(pos);
		}
	}
	rapi->rpgEnd();
	rapi->rpgOptimize();

	noesisModel_t *mdl = rapi->rpgConstructModel();
	if (mdl)
	{
		numMdl = 1; //it's important to set this on success! you can set it to > 1 if you have more than 1 contiguous model in memory
		rapi->SetPreviewAnimSpeed(10.0f);
		//this'll rotate the model (only in preview mode) into quake-friendly coordinates
		static float mdlAngOfs[3] = {0.0f, 180.0f, 0.0f};
		rapi->SetPreviewAngOfs(mdlAngOfs);
	}

	rapi->rpgDestroyContext(pgctx);
	return mdl;
}

//called by Noesis to init the plugin
bool NPAPI_InitLocal(void)
{
	g_fmtHandle = g_nfn->NPAPI_Register("Kingpin MDX", ".mdx");
	if (g_fmtHandle < 0)
	{
		return false;
	}

	//set the data handlers for this format
	g_nfn->NPAPI_SetTypeHandler_TypeCheck(g_fmtHandle, Model_MD2_Check);
	g_nfn->NPAPI_SetTypeHandler_LoadModel(g_fmtHandle, Model_MD2_Load);
	//export functions //hypov8 todo:
	//g_nfn->NPAPI_SetTypeHandler_WriteModel(g_fmtHandle, Model_MD2_Write); //hypov8 disable 4 now
	//g_nfn->NPAPI_SetTypeHandler_WriteAnim(g_fmtHandle, Model_MD2_WriteAnim); //hypov8 disable 4 now

	return true;
}

//called by Noesis before the plugin is freed
void NPAPI_ShutdownLocal(void)
{
	//nothing to do in this plugin
}

BOOL APIENTRY DllMain( HMODULE hModule,
                       DWORD  ul_reason_for_call,
                       LPVOID lpReserved
					 )
{
	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
	case DLL_THREAD_ATTACH:
	case DLL_THREAD_DETACH:
	case DLL_PROCESS_DETACH:
		break;
	}
    return TRUE;
}
