  #INCLUDE ONCE "freeimage.bi"
  
  #DEFINE HiColor   16777216
  #DEFINE LoColor      65536

  #DEFINE Opt_AlwaysReplaceFiles  &h00000001
  #DEFINE Opt_SearchSubFolders    &h00000002
  #DEFINE Opt_IgnoreSizeCheck     &h00000004
  #DEFINE Opt_LookUp16            &h00000010
  #DEFINE Opt_ForceBSPList        &h00000020
  #DEFINE Opt_NeverReplaceFiles   &h00000040
  
  #DEFINE Path_IsFolder   &h00
  #DEFINE Path_IsFile     &h01
  #DEFINE Path_Absolute   &h02
	
  #DEFINE Center(Message) (SPACE((LOWORD(WIDTH) \ 2) - (LEN(Message) \ 2)) + Message)
  #DEFINE isPoT(iSrc)     ((2 ^ CINT(LOG(iSrc) / LOG(2))) = iSrc)
	
  #MACRO zstringPtr(myPtr, myMsg)
  IF LEN(myMsg) THEN
    DIM AS TYPEOF(*myPtr) PTR xPtr
    xPtr = CALLOCATE((LEN(myMsg) + 1) * SIZEOF(TYPEOF(*MyPtr))): *xPtr = myMsg
    IF (myPtr <> 0) THEN DEALLOCATE(myPtr)
    myPtr = xPtr
  ELSE
    IF (myPtr <> 0) THEN DEALLOCATE(myPtr): myPtr = 0
  END IF
  #ENDMACRO
  
	#MACRO FreeMem(MyPtr)
		IF (MyPtr <> 0) THEN DEALLOCATE(MyPtr): MyPtr = 0
	#ENDMACRO
  
  EXTERN _CRT_glob ALIAS "_CRT_glob" AS INTEGER
  DIM SHARED _CRT_glob AS INTEGER = 0

  EXTERN _dowildcard ALIAS "_dowildcard" AS LONG
  DIM SHARED _dowildcard AS LONG = 0

	TYPE CmdOption_t
		Label						AS ZSTRING PTR
		Label2					AS ZSTRING PTR
		ParamList				AS ZSTRING PTR
		Message					AS ZSTRING PTR
		SwitchVar				AS UINTEGER PTR
		SwitchFnc				AS ANY PTR
		SwitchVal				AS UINTEGER
		Triggered				AS UBYTE
	END TYPE
  
  TYPE color_t
    attr            AS UINTEGER PTR
    count           AS UINTEGER
    lookup          as ubyte ptr
    lookupSize      as uinteger
    DECLARE FUNCTION  loadFile        (BYREF FileName AS STRING) AS INTEGER
    DECLARE FUNCTION  findNearest     (BYREF r AS UINTEGER, BYREF g as UINTEGER, byref b as UINTEGER) AS UBYTE
    declare FUNCTION  initLookUp      (BYREF FileName AS STRING) AS INTEGER
    DECLARE SUB       destroy         ()
  END TYPE

  TYPE image_t
    length          AS INTEGER
    height          AS INTEGER
    buffer          AS UINTEGER PTR
    DECLARE FUNCTION  loadFile        (BYREF FileName AS STRING) AS INTEGER
    DECLARE SUB       saveWal         (BYREF FileName AS STRING, BYREF ColorMap AS color_t PTR)
    DECLARE SUB       destroy         ()
  END TYPE
  
	TYPE bspFLump_t FIELD = 1
		AS uinteger    offset
		AS uinteger     length
		AS    ubyte PTR buffer
	END TYPE

	TYPE bspFile_t FIELD = 1
		AS   uinteger     magic
		AS   uinteger     version
		AS bspFLump_t PTR lump
		DECLARE SUB      initialize ()
		DECLARE SUB      destroy    ()
		DECLARE FUNCTION loadFrom   (BYREF filename AS zstring PTR) AS INTEGER
	END TYPE

	TYPE point3f_t FIELD = 1
		AS single x
		AS single y
		AS single z
	END TYPE

	TYPE bspTexInfo_t FIELD = 1
		AS point3f_t u_axis
		AS    single u_offset
		AS point3f_t v_axis
		AS    single v_offset
		AS  uinteger flags
		AS  uinteger value
		AS STRING*31 texture_name
		AS  uinteger next_texinfo
	END TYPE

  '' load from file
  PRIVATE FUNCTION bspFile_t.loadFrom(BYREF filename AS zstring PTR) AS INTEGER
    DIM AS INTEGER ff = FREEFILE
    
    ' load file
    ? "Loading " + CHR(34) + *filename + CHR(34) + "..."
    IF (this.lump = 0) THEN this.initialize()
    IF (filename = 0) THEN RETURN -1 ' no file specified
    IF (ff = 0) THEN RETURN -2 ' no handle available
    IF (DIR(*filename, &h23) = "") THEN RETURN -3 ' file no found
    IF (OPEN(*filename FOR BINARY AS #ff)) THEN RETURN -4 ' general i/o error
    IF (LOF(ff) = 0) THEN CLOSE #ff: RETURN -5 ' file is empty
  
    ' get header and directory
    GET #ff, , this.magic
    IF (this.magic <> &h50534249) THEN CLOSE #ff: RETURN -11 ' not a BSP
    GET #ff, , this.version
    IF (this.version <> 38) THEN CLOSE #ff: RETURN -12 ' unsupported version
    FOR i AS INTEGER = 0 TO 18
      WITH this.lump[i]
        GET #ff, , .offset
        GET #ff, , .length
        IF (.length) THEN .buffer = CALLOCATE(.length)
      END WITH
    NEXT i
    
    ' get lumps
    FOR i AS INTEGER = 0 TO 18
      WITH this.lump[i]
        IF (.length = 0) THEN CONTINUE FOR
        GET #ff, .offset + 1, *.buffer, .length
      END WITH
    NEXT i
  
    ' done, everything went a-okay I guess?
    CLOSE #ff
    RETURN 0
  END FUNCTION

  '' initialize structure (lump directory)
  PRIVATE SUB bspFile_t.initialize()
    this.destroy()
    this.lump = CALLOCATE(SIZEOF(TYPEOF(*this.lump)) * 19)  
  END SUB
  
  '' destroy structure
  PRIVATE SUB bspFile_t.destroy()
    this.magic = 0
    this.version = 0
    IF (this.lump) THEN
      FOR i AS INTEGER = 0 TO 18
        WITH (this.lump[i])
					FreeMem(.buffer)
        END WITH
      NEXT i
			FreeMem(this.lump)
    END IF
  END SUB
  
  NAMESPACE app
    DIM Settings    AS UINTEGER
    DIM LastError   AS UINTEGER
    DIM AlphaVal    AS UINTEGER
    DIM SourceBSP   as ZSTRING PTR
    DIM BaseDir     AS ZSTRING PTR  
    DIM PalFile     AS ZSTRING PTR  
    DIM LkpFile     AS ZSTRING PTR
    DIM Mask        AS ZSTRING PTR
  END NAMESPACE

 	DECLARE SUB       cmdOptionUsage2		(BYVAL id AS INTEGER)
	DECLARE FUNCTION  cmdOptionRead			(BYVAL Ditch AS INTEGER = 0) AS INTEGER
	DECLARE SUB       cmdOptionUsage		()
	DECLARE SUB       cmdOptionSet			(BYREF Label AS STRING, BYREF SomePtr AS ANY PTR, BYREF ParamList AS STRING, BYREF Message AS STRING)
	DECLARE FUNCTION  cmdOverwrite			(BYREF filename AS STRING, BYREF Variable AS INTEGER PTR, BYREF FlagAlways AS INTEGER, BYREF FlagNever AS INTEGER) AS INTEGER
	DECLARE FUNCTION  cmdPrompt					(BYREF text AS STRING, BYREF clist AS STRING) AS INTEGER
	DECLARE FUNCTION  cmdValidParams		(Dst() AS STRING, BYREF Param AS STRING, Src() AS STRING, BYREF ParamVars AS STRING) AS INTEGER
  DECLARE SUB       cmdPathClean      (BYREF In_Path AS STRING, BYREF In_IsFile AS INTEGER)
  DECLARE SUB       cmdStringTime     (BYVAL Seconds AS DOUBLE = 0, BYREF Dst AS STRING)
  DECLARE SUB       Init_SourceDir    (Array() AS STRING)
  DECLARE SUB       Init_SourceBSP    (Array() as string)
  DECLARE SUB       Init_Palette      (Array() AS STRING)
  DECLARE SUB       PathList          (Out_List() AS STRING)
  DECLARE FUNCTION  Main							() AS INTEGER

	REDIM SHARED AS CmdOption_t CmdOption(0 TO 0)
	DIM		SHARED AS STRING			CmdAppName, CmdAppNote
  END MAIN()

  PRIVATE SUB cmdStringTime (BYVAL Seconds AS DOUBLE = 0, BYREF Dst AS STRING)
    DIM AS UINTEGER Counter = ABS(Seconds)
    Dst = ""
    IF (Counter >= (60 * 60 * 24)) THEN Dst += STR(Counter \ 86400) + "D ": Counter MOD= 86400
    IF (Counter >= (60 * 60)     ) THEN Dst += STR(Counter \ 3600) + "h ":  Counter MOD= 3600
    IF (Counter >= 60            ) THEN Dst += STR(Counter \ 60) + "m ":    Counter MOD= 60
    Dst += STR(Counter) + "s"
  END SUB

	PRIVATE FUNCTION cmdOptionRead(BYVAL Ditch AS INTEGER = 0) AS INTEGER
		DIM		AS INTEGER		Count = 1, OptCount, k = ANY, z = ANY
		DIM		AS STRING			Cmd
		REDIM AS STRING			Args(0)
		DIM									Func AS SUB(Array() AS STRING)
    IF LEN(COMMAND(1)) THEN PRINT ":: Parsing command line parameters"
		DO WHILE LEN(COMMAND(Count))
			Cmd = COMMAND(Count)
			FOR k = LBOUND(CmdOption) TO UBOUND(CmdOption) + 1
				IF k = (UBOUND(CmdOption) + 1) THEN ' We ran out of parameters, tell the user
					IF LEFT(Cmd, 1) = "-" THEN
						PRINT "   Argument unknown: " + CHR(34) + Cmd + CHR(34): Count = 0: FUNCTION = 1: EXIT DO
					ELSE
						PRINT "   Lonely parameter: " + CHR(34) + Cmd + CHR(34): Count = 0: FUNCTION = 1: EXIT DO
					END IF
				END IF
				IF (LCASE(TRIM(Cmd)) <> LCASE(*CmdOption(k).Label)) AND (LCASE(TRIM(Cmd)) <> LCASE(*CmdOption(k).Label2)) THEN CONTINUE FOR	 ' Not the right parameter, keep searching
				IF (CmdOption(k).SwitchFnc) THEN
					REDIM Args(1 TO CmdOption(k).SwitchVal)
					FOR z = 1 TO CmdOption(k).SwitchVal
            Count += 1: Args(z) = COMMAND(Count)
            IF (Args(z) = "") THEN PRINT "   Missing parameters: ";: cmdOptionUsage2(k): FUNCTION = 1: EXIT DO
					NEXT z
					REDIM AS STRING Valid(LBOUND(Args) TO UBOUND(Args))
					IF (cmdValidParams(Valid(), *CmdOption(k).Label, Args(), *CmdOption(k).ParamList) = 0) THEN EXIT DO 'something went wrong, don't even bother
					Func = CmdOption(k).SwitchFnc: Func(Valid()): EXIT FOR  ' Done, check next command
				ELSE
          IF (CmdOption(k).SwitchVar = 0) THEN Ditch = 0: EXIT DO ' Display usage, or don't bother cuz something went wrong
					IF (CmdOption(k).Triggered = 1) THEN EXIT FOR			      ' We parsed that already
					*CmdOption(k).SwitchVar OR= CmdOption(k).SwitchVal
					CmdOption(k).Triggered = 1
					IF OptCount = 0 THEN OptCount = 1: PRINT ":: OPTIONS"
					PRINT "   " + *CmdOption(k).Message
					EXIT FOR
				END IF
			NEXT k
			Count += 1
		LOOP
		ERASE Args
		IF (Count = 1) THEN
      IF (Ditch = 0) THEN cmdOptionUsage()
      RETURN (Ditch xor 1)
    END IF
	END FUNCTION

	PRIVATE SUB cmdOptionUsage2(BYVAL id AS INTEGER)
		DIM AS STRING		Param2, VarTemp, VarType
		DIM AS INTEGER	i, Ofst1, Ofst2
		WITH CmdOption(id)
			COLOR 7: PRINT CHR(34);
			FOR i = 1 TO LEN(*.Label)
				IF MID(*.Label, i, 1) = UCASE(MID(*.Label, i, 1)) THEN COLOR 15 ELSE COLOR 7
				PRINT MID(*.Label, i, 1);
			NEXT i
			IF .SwitchFnc THEN
				COLOR 8
				Ofst1 = 1: Param2 = *.ParamList + " "
				FOR i = 1 TO .SwitchVal
					Ofst2 = INSTR(Ofst1, Param2, CHR(32))
					VarTemp = TRIM(MID(Param2, Ofst1, Ofst2 - Ofst1))
					VarType = UCASE(LEFT(VarTemp, INSTR(VarTemp, ":") - 1))
					VarTemp = RIGHT(VarTemp, LEN(VarTemp) - LEN(VarType) - 1)
					Ofst1 = Ofst2 + 1
					PRINT " <" + VarTemp + ">";
				NEXT i
			END IF
		END WITH
		COLOR 7:PRINT CHR(34)
	END SUB

	PRIVATE SUB cmdOptionUsage ()
		DIM AS INTEGER	Longest = 0, k = ANY, i = ANY, Ofst2 = ANY, Ofst1 = ANY, PrintSize = 0
		DIM AS STRING		Param2, VarTemp, VarType
		PRINT "Syntax: IMG2WAL.EXE [Commands]"
		FOR k = LBOUND(CmdOption) TO UBOUND(CmdOption)
			WITH CmdOption(k)
				IF .SwitchFnc THEN
					PrintSize = (LEN(*.ParamList) + 1) - .SwitchVal + LEN(*.Label)
				ELSE
					PrintSize = LEN(*.Label)
				END IF
				IF (PrintSize > Longest) THEN Longest = PrintSize
			END WITH
		NEXT k
      Longest += 4
		FOR k = LBOUND(CmdOption) TO UBOUND(CmdOption)
			WITH CmdOption(k)
				IF (LEN(*.Label) = 0) THEN CONTINUE FOR
				PRINT "   ";
				FOR i = 1 TO LEN(*.Label)
					IF MID(*.Label, i, 1) = UCASE(MID(*.Label, i, 1)) THEN COLOR 15 ELSE COLOR 7
					PRINT MID(*.Label, i, 1);
				NEXT i
				IF .SwitchFnc THEN
					COLOR 8
					Ofst1 = 1: Param2 = *.ParamList + " "
					FOR i = 1 TO .SwitchVal
						Ofst2 = INSTR(Ofst1, Param2, CHR(32))
						VarTemp = TRIM(MID(Param2, Ofst1, Ofst2 - Ofst1))
						VarType = UCASE(LEFT(VarTemp, INSTR(VarTemp, ":") - 1))
						VarTemp = RIGHT(VarTemp, LEN(VarTemp) - LEN(VarType) - 1)
						Ofst1 = Ofst2 + 1
						PRINT " <" + VarTemp + ">";
					NEXT i
				END IF
				COLOR 15: PRINT TAB(Longest + 2); *.Message
			END WITH
		NEXT k
		COLOR 7: IF LEN(CmdAppNote) THEN PRINT: PRINT CmdAppNote
		SLEEP
	END SUB

	PRIVATE SUB cmdOptionSet (BYREF Label AS STRING, BYREF SomePtr AS ANY PTR, BYREF ParamList AS STRING, BYREF Message AS STRING)
		DIM AS INTEGER	NextCmd = UBOUND(CmdOption), i = ANY
		DIM AS STRING		Msg2 = TRIM(ParamList) + " ", Label2
		IF (LEN(*CmdOption(NextCmd).Label)) THEN NextCmd += 1
		REDIM PRESERVE CmdOption(0 TO NextCmd)
		WITH CmdOption(NextCmd)
			Label = TRIM(Label): ParamList = TRIM(ParamList)
			IF LEN(Label)		THEN .Label		= CALLOCATE((LEN(Label) + 1) * SIZEOF(ZSTRING)): *.Label	 = Label
			IF LEN(Message) THEN .Message = CALLOCATE((LEN(Message) + 1) * SIZEOF(ZSTRING)): *.Message	 = Message
			FOR i = 1 TO LEN(Label)
				IF (MID(Label, i, 1) = UCASE(MID(Label, i, 1))) THEN Label2 += MID(Label, i, 1)
			NEXT i: Label2 = UCASE(TRIM(Label2))
			.Label2 = CALLOCATE((LEN(Label2) + 1)	 * SIZEOF(ZSTRING)): *.Label2	 = Label2
			IF (ParamList = STR(VAL(ParamList))) THEN
				.SwitchVar = CPTR(UINTEGER PTR, SomePtr)
				.SwitchVal = VAL(ParamList)
			ELSE
				.SwitchFnc = SomePtr: .SwitchVal = 0
				FOR x AS INTEGER = 1 TO LEN(Msg2): .SwitchVal += ABS(MID(Msg2, x, 1) = CHR(32)): NEXT x
				IF LEN(ParamList) THEN .ParamList = CALLOCATE((LEN(ParamList) + 1) * SIZEOF(ZSTRING)): *.ParamList = ParamList
			END IF
		END WITH
	END SUB

	PRIVATE SUB cmdOptionKill () DESTRUCTOR
		IF UBOUND(CmdOption) < 0 THEN EXIT SUB
		FOR k AS INTEGER = LBOUND(CmdOption) TO UBOUND(CmdOption)
			WITH CmdOption(k)
				FreeMem(.Label)
				FreeMem(.Label2)
				FreeMem(.ParamList)
				FreeMem(.Message)
				.SwitchVar = 0: .SwitchVal = 0: .SwitchFnc = 0
			END WITH
		NEXT k
		ERASE CmdOption
	END SUB

  PRIVATE SUB CmdPathClean (BYREF In_Path AS STRING, BYREF In_IsFile AS INTEGER)
    REDIM AS STRING   Path_Nodes(0 TO 0)
    DIM   AS STRING   Path_Copy = In_Path
    DIM   AS INTEGER  Path_Current
    DIM   AS INTEGER  k = any
    DIM   AS STRING   Path_Default = CURDIR
    IF (LEN(TRIM(In_Path)) = 0) THEN In_Path = "": EXIT SUB
    IF INSTR("\/", RIGHT(Path_Copy, 1)) = 0 THEN Path_Copy += "/"
    FOR k = 1 TO LEN(Path_Default)
      IF INSTR("\/", MID(Path_Default, k, 1)) THEN MID(Path_Default, k, 1) = "/"
    NEXT k
    FOR k = 1 TO LEN(Path_Copy)
      IF INSTR("\/", MID(Path_Copy, k, 1)) THEN
        Path_Nodes(Path_Current) = TRIM(Path_Nodes(Path_Current))
        IF (Path_Nodes(Path_Current) = ".") THEN Path_Nodes(Path_Current) = "": CONTINUE FOR
        IF (Path_Nodes(Path_Current) = "..") AND (Path_Current > 0) THEN
          IF (Path_Nodes(Path_Current - 1) <> "..") THEN
            Path_Nodes(Path_Current) = ""
            Path_Current -= 1
            Path_Nodes(Path_Current) = ""
            CONTINUE FOR
          END IF
        END IF
        Path_Current += 1: REDIM PRESERVE Path_Nodes(0 TO UBOUND(Path_Nodes) + 1)
      ELSE
        Path_Nodes(Path_Current) += MID(Path_Copy, k, 1)
      END IF
    NEXT k: Path_Copy = ""
    FOR k = LBOUND(Path_Nodes) TO UBOUND(Path_Nodes)
      IF (Path_Nodes(k) = "") OR (Path_Nodes(k) = ".") THEN CONTINUE FOR
      Path_Copy += Path_Nodes(k) + "/"
    NEXT k: ERASE Path_Nodes
    IF (In_IsFile AND Path_IsFile) THEN Path_Copy = LEFT(Path_Copy, LEN(Path_Copy) - 1)
    In_Path = TRIM(Path_Copy)
    IF (In_IsFile AND Path_Absolute) THEN _
      IF (MID(In_Path, 2, 1) <> ":") THEN In_Path = Path_Default + "/" + In_Path
  END SUB

	PRIVATE FUNCTION CmdOverwrite (BYREF filename AS STRING, BYREF Variable AS INTEGER PTR, BYREF FlagAlways AS INTEGER, BYREF FlagNever AS INTEGER) AS INTEGER
		DIM AS STRING		UserEntry
		DIM AS INTEGER	UserSaid = ANY
		IF (DIR(Filename) = "") THEN RETURN 1
    IF (Variable) THEN
      if ((FlagNever)  ANDALSO (*Variable AND FlagNever)) then return 0
      if ((FlagAlways) ANDALSO (*Variable AND FlagAlways)) THEN KILL Filename: RETURN 1
    end if
		UserSaid = CmdPrompt(CHR(34) + Filename + CHR(34) + " already exists, replace", "Yes/No/Always/Skip all")
		IF (UserSaid = 1) THEN KILL Filename: RETURN 1
		IF (UserSaid = 2) THEN RETURN 0
		IF (UserSaid = 3) THEN *Variable OR= FlagAlways: KILL FileName: RETURN 1
    IF (UserSaid = 4) THEN *Variable OR= FlagNever: RETURN 0
	END FUNCTION

	PRIVATE FUNCTION CmdPrompt (BYREF text AS STRING, BYREF clist AS STRING) AS INTEGER
		REDIM AS STRING * 1 Choices(0 TO 0)
		DIM		AS STRING			UserKey, TmpString
		DIM		AS INTEGER		CurRow = POS, CurLine = CSRLIN, k = any
		IF (LEN(Clist) = 0) THEN CList = "Yes/No"
		IF (RIGHT(clist,1) <> "/") THEN clist += "/"
		TmpString = Clist
		DO
			FOR k = 1 TO LEN(TmpString)
				IF MID(TmpString, k, 1) = "/" THEN
					REDIM PRESERVE Choices(1 TO UBOUND(Choices) + 1)
					Choices(UBOUND(Choices)) = LCASE(LEFT(TmpString, 1))
					TmpString = RIGHT(TmpString, LEN(TmpString) - k)
					EXIT FOR
				END IF
			NEXT k
		LOOP WHILE LEN(TmpString)
		CurLine = CSRLIN: LOCATE CurLine,CurRow: PRINT Text + "? [" + LEFT(Clist, LEN(CList) - 1) + "]";
		DO
			UserKey = LCASE(INKEY)
			FOR k = LBOUND(Choices) TO UBOUND(Choices)
				IF (UserKey <> Choices(k)) THEN CONTINUE FOR
				LOCATE CurLine, CurRow
				PRINT SPACE(LEN(Text) + LEN(CList) + 4);
				LOCATE CurLine, CurRow
				ERASE Choices: RETURN k
			NEXT k
		LOOP
	END FUNCTION
  
  PRIVATE SUB color_t.destroy()
    this.count = 0
    this.lookupSize = 0
    IF (this.attr) THEN DEALLOCATE(this.attr): this.attr = 0
    IF (this.lookup) THEN DEALLOCATE(this.lookup): this.lookup = 0
  END SUB

  PRIVATE FUNCTION color_t.loadFile(BYREF FileName AS STRING) AS INTEGER
    DIM AS UINTEGER ff = FREEFILE, i = ANY
    DIM AS UBYTE    r = ANY, g = ANY, b = ANY
    this.destroy()
    IF (DIR(FileName, &h23) = "") THEN RETURN 1       ' File no found
    IF (ff = 0) THEN RETURN 2                         ' No hanld available
    IF OPEN(FileName FOR BINARY AS #ff) THEN RETURN 3 ' I/O error
    IF (LOF(ff) <> 768) THEN CLOSE #ff: RETURN 4      ' Not an ACT file
    this.attr  = CALLOCATE(256 * SIZEOF(TYPEOF(*this.attr)))
    this.count = 256
    FOR i = 0 TO 255
      GET #ff,, r
      GET #ff,, g
      GET #ff,, b
      this.attr[i] = RGBA(r, g, b, 255)
    NEXT i
    CLOSE #ff
    RETURN 0
  END FUNCTION
  
  PRIVATE FUNCTION color_t.initLookUp(ByRef FileName AS STRING) AS INTEGER
    IF ((this.count = 0) OR (this.attr = 0)) THEN return 1
    dim as uinteger ff = freefile: if ff = 0 then return 2
    if (len(dir(FileName, &h23))) then
      if open (FileName for binary as #ff) then return 3
      if ((lof(ff) = HiColor) OR (lof(ff) = LoColor)) then
        ? "Loading conversion table..."
        this.lookupSize = lof(ff)
        'if (this.lookupSize = LoColor) then app.settings or= Opt_LookUp16 ' DEBUG, do I really NEED this?
        this.lookup = callocate(this.lookupSize * sizeof(ubyte))
        get #ff,, *this.lookup, this.lookupSize
        close #ff: return 0
      end if
      close #ff
    end if
    ? "Initializing conversion table..."
    dim as uinteger     r = any, g = any, b = any, i = any
    DIM AS INTEGER      j = any
    DIM AS UBYTE PTR    dstCol = 0
    DIM AS UINTEGER     dstR  = ANY, dstG = ANY, dstB = ANY
    DIM AS DOUBLE       distB = any, distN = ANY
    if (app.settings and Opt_LookUp16) then
      this.lookupSize = LoColor
      this.lookup     = callocate(this.lookupSize * sizeof(ubyte))
      for i = 0 to this.lookupSize - 1
        r = ((i shr 10) and 31) * 15
        g = ((i shr  5) and 31) * 15
        b = ((i       ) and 31) * 15
        distB  = 32767
        dstCol = CPTR(UBYTE PTR, @this.attr[0])
        FOR j = 0 TO this.count - 1
          dstR = (r - dstCol[2])
          dstG = (g - dstCol[1])
          dstB = (b - dstCol[0])
          distN = SQR(dstR * dstR + dstG * dstG + dstB * dstB)
          IF (distN < distB) THEN distB = distN: this.lookup[i] = j
          dstCol += 4
        NEXT j
      next i
    else
      this.lookupSize = HiColor
      this.lookup     = callocate(this.lookupSize * sizeof(ubyte))
      for i = 0 to this.lookupSize - 1
        r = (i shr 16) and 255
        g = (i shr  8) and 255
        b = (i       ) and 255
        distB  = 32767
        dstCol = CPTR(UBYTE PTR, @this.attr[0])
        FOR j = 0 TO this.count - 1
          dstR = (r - dstCol[2])
          dstG = (g - dstCol[1])
          dstB = (b - dstCol[0])
          distN = SQR(dstR * dstR + dstG * dstG + dstB * dstB)
          IF (distN < distB) THEN distB = distN: this.lookup[i] = j
          dstCol += 4
        NEXT j
      next i
    end if
    ? "Writing conversion table..."
    IF CmdOverwrite(FileName, @app.settings, Opt_AlwaysReplaceFiles, Opt_NeverReplaceFiles) THEN
      if open (FileName for binary as #ff) then return 3
      put #ff,, *this.lookup, this.lookupSize
      close #ff
    END IF
    RETURN 0
  END FUNCTION

  PRIVATE FUNCTION color_t.findNearest(BYREF r AS UINTEGER, BYREF g as UINTEGER, byref b as UINTEGER) AS UBYTE
    if (this.lookupSize = HiColor) then
      return this.lookUp[(b) + (g shl 8) + (r shl 16)]
    elseif (this.lookupSize = LoColor) then
      return this.lookUp[(b \ 15) + ((g \ 15) shl 5) + ((r \ 15) shl 10)]
    else
      IF ((this.count = 0) OR (this.attr = 0)) THEN RETURN 0
      DIM AS INTEGER      iBest = ANY, j = any
      DIM AS UBYTE PTR    dstCol = CPTR(UBYTE PTR, @this.attr[0])
      DIM AS UINTEGER     dstR = ANY, dstG = ANY, dstB = ANY
      DIM AS DOUBLE       distB = 32767, distN = ANY
      FOR j = 0 TO this.count - 1
        dstR = (r - dstCol[2])
        dstG = (g - dstCol[1])
        dstB = (b - dstCol[0])
        distN = SQR(dstR * dstR + dstG * dstG + dstB * dstB)
        IF (distN < distB) THEN distB = distN: iBest = j
        dstCol += 4
      NEXT j
      RETURN iBest
    end if
  END FUNCTION

  '' Free reserved memory
  PRIVATE SUB image_t.destroy()
    this.length = 0: this.height = 0
    IF (this.buffer) THEN DEALLOCATE(this.buffer): this.buffer = 0
  END SUB

  '' Convert any image to raw R,G,B buffer
  PRIVATE FUNCTION image_t.loadFile (BYREF FileName AS STRING) AS INTEGER
    DIM AS FREE_IMAGE_FORMAT      PicType
    DIM AS          FIBITMAP PTR  PicData, PicTemp
    DIM AS             UBYTE PTR  PicRaw
    DIM AS          UINTEGER      PicPitch
    this.destroy()
    IF (DIR(FileName, &h23) = "") THEN RETURN 1         ' File no found
    PicType = FreeImage_GetFileTypeU(FileName)
    IF (PicType = FIF_UNKNOWN) THEN RETURN 1          ' Type unknown
    PicData  = FreeImage_LoadU(PicType, FileName, 0)
    IF (PicData = 0) THEN RETURN 1                    ' Couldn't decode
    this.length = FreeImage_GetWidth(PicData)
    this.height = FreeImage_GetHeight(PicData)
    this.buffer = CALLOCATE((this.length * this.height) * SIZEOF(TYPEOF(*this.buffer)))
    PicRaw      = CPTR(UBYTE PTR, this.buffer)
    PicTemp     = FreeImage_ConvertTo32Bits(PicData)
    FreeImage_Unload(PicData): PicData = PicTemp
    PicPitch    = FreeImage_GetPitch(PicData)
    FreeImage_ConvertToRawBits(PicRaw, PicData, PicPitch, 32, FI_RGBA_RED_MASK, FI_RGBA_GREEN_MASK, FI_RGBA_BLUE_MASK, FALSE)
    FreeImage_Unload(PicData)
    RETURN 0
  END FUNCTION
  
  private sub testNextFrame(byref filename as string, byref frameNow as string, frameNext as string)
    dim as  integer     ofs       = any
    dim as    ubyte     nextIndex = any
    dim as   string     nextTest
    dim as    ubyte ptr xPtr      = any
    
    '' super dirty workaround for a potential bug when using absolute paths
    dim as   string     absolute  = left(filename, instrrev(filename, "/textures/") + 9)
    dim as   string     temp      = right(filename, len(filename) - len(absolute))

    ' current frame & default next frame
    temp = left(temp, instrrev(temp, ".") - 1)
    frameNow = temp + STRING(32 - LEN(temp), 0)
    frameNext = STRING(32, 0)
    
    ofs = instrrev(frameNow, "/")
    xPtr = cptr(ubyte ptr, strptr(frameNow))
    if ((xPtr[ofs] <> &h2B) OR (xPtr[ofs + 1] < 48) OR (xPtr[ofs + 1] > 57)) then exit sub ' not an animation (must start with "+#")
    nextIndex = (xPtr[ofs + 1] - 47) mod 10

    nextTest = trim(frameNow)
    mid(nextTest, ofs + 2, 1) = str(nextIndex)
    if (dir(absolute + nextTest + ".*", &h23) = "") then
      ' failed to find next frame, return to zero?
      mid(nextTest, ofs + 2, 1) = "0"
      if (dir(absolute + nextTest + ".*", &h23) = "") then exit sub ' fail
    end if
    frameNext = nextTest + STRING(32 - LEN(nextTest), 0)
    exit sub
  end sub
  
  '' Save image to Quake2 WAL file
  PRIVATE SUB image_t.saveWal(BYREF FileName AS STRING, BYREF ColorMap AS color_t PTR)
    DIM AS UINTEGER       i = ANY, j = ANY, x = ANY, y = ANY, ff = FREEFILE, sampleSize = ANY, z = any, row1 = any, row2 = any, w = any, ofst = any
    DIM AS UINTEGER       walWidth = ANY, walHeight = ANY
    DIM AS UINTEGER       walOffset1 = ANY, walOffset2 = ANY, walOffset3 = ANY, walOffset4 = ANY
    DIM AS UINTEGER       cRed = ANY, cGreen = ANY, cBlue = ANY, cAlpha = ANY, c = any
    DIM AS    UBYTE PTR   bufferPtr = 0
    dim as uinteger       bufferLen = any
    DIM AS  INTEGER       walFlags = 0, walContents = 0, walValue = 0
    DIM AS UINTEGER PTR   walPos = ANY
    DIM AS    UBYTE       walIndex = ANY, nextFrame = any
    dim as    ubyte ptr   xPtr
    DIM AS   STRING       walName, walNext
    IF ((ff = 0) OR (FileName = "")) THEN EXIT SUB ' Can't save this // no handle
    IF (RIGHT(LCASE(FileName), 4) <> ".wal") THEN FileName += ".wal"
    walWidth   = this.length
    walHeight  = this.height
    PRINT "Writing " + FileName + "..."
    w = (walWidth * walHeight)
    bufferPtr = callocate(w * sizeof(ubyte))
    walOffset1 = 100
    walOffset2 = walOffset1 +  w
    walOffset3 = walOffset2 + (w shr 2)
    walOffset4 = walOffset3 + (w shr 4)
    
    '' get possible next frame (+#filename.wal)
    testNextFrame(filename, walName, walNext)
    if (len(trim(walNext))) then ? "Next frame: " + trim(walNext)

    IF OPEN (FileName FOR BINARY AS #ff) THEN EXIT SUB ' I/O error
    PUT #ff,, walName     ' 32 - Texture name
    PUT #ff,, walWidth    ' 4  - Texture width in pixels
    PUT #ff,, walHeight   ' 4  - Texture height in pixels
    PUT #ff,, walOffset1  ' 4  - Offset of first pixel of 1:1 texture
    PUT #ff,, walOffset2  ' 4  - Offset of first pixel of 1:2 texture
    PUT #ff,, walOffset3  ' 4  - Offset of first pixel of 1:4 texture
    PUT #ff,, walOffset4  ' 4  - Offset of first pixel of 1:8 texture
    PUT #ff,, walNext     ' 32 - Name of next texture (frames)
    PUT #ff,, walFlags    ' 4  - Surface flags
    PUT #ff,, walContents ' 4  - Content flags
    PUT #ff,, walValue    ' 4  - Light value
    FOR sampleSize = 1 TO 4
      z = (2^(sampleSize - 1))
      w = (sampleSize * sampleSize)
      bufferLen = 0
      FOR y = 0 TO this.height \ z - 1
        row1 = (y * z * this.length)
        FOR x = 0 TO this.length \ z - 1
          cRed = 0: cGreen = 0: cBlue = 0: cAlpha = 0
          ofst = (x * z) + row1
          FOR j = 0 TO sampleSize - 1
            row2 = (j * this.length) + ofst
            FOR i = 0 TO sampleSize - 1
              c       = this.buffer[i + row2]
              cRed   += (c shr 16) and 255
              cGreen += (c shr  8) and 255
              cBlue  += (c       ) and 255
              cAlpha += (c shr 24)
            NEXT i
          NEXT j
          IF ((cAlpha \ w) < app.AlphaVal) THEN
            bufferPtr[bufferLen] = 255
          ELSE
            bufferPtr[bufferLen] = colormap->findNearest(cRed \ w, cGreen \ w, cBlue \ w)
          END IF
          bufferLen += 1
        NEXT x
      NEXT y
      put #ff,, *bufferPtr, bufferLen
    NEXT sampleSize
    CLOSE #ff
    deallocate(bufferPtr): bufferPtr = 0
  END SUB

  PRIVATE FUNCTION cmdValidParams(Dst() AS STRING, BYREF Param AS STRING, Src() AS STRING, BYREF ParamVars AS STRING) AS INTEGER
		FUNCTION = 1
		DIM AS INTEGER IntLoop = ANY, Ofst1 = 1, Ofst2 = ANY
		DIM AS STRING	 VarTemp, VarType, Expected
		IF (RIGHT(ParamVars, 1) <> CHR(32)) THEN ParamVars += CHR(32)
		FOR intLoop = LBOUND(Src) TO UBOUND(Src)
      ' == Get variable type == '
			Ofst2 = INSTR(Ofst1, ParamVars, CHR(32))
			VarTemp = TRIM(MID(ParamVars, Ofst1, Ofst2 - Ofst1))
			VarType = UCASE(LEFT(VarTemp, INSTR(VarTemp, ":") - 1))
			VarTemp = RIGHT(VarTemp, LEN(VarTemp) - LEN(VarType) - 1)
			Ofst1 = Ofst2 + 1
      ' == Everything is always valid == '
			IF (VarType = "VAL") THEN
        if ((val(src(IntLoop))) >= 0) AND ((val(src(IntLoop))) <= 256) THEN
          DST(IntLoop) = Src(IntLoop): continue for
        else
          Expected = "a value between 0 and 256 (included)"
        end if
      ELSE
        DST(IntLoop) = Src(IntLoop): CONTINUE FOR
      END IF
      ? Param + ": <" + VarTemp + "> must be " + Expected: FUNCTION = 0: App.LastError = 1
    NEXT intLoop
	END FUNCTION

  private sub Init_SourceBSP(Array() as string)
    dim as string forceName
    if (lcase(right(array(1), 4)) = ".bsp") then
      zStringPtr(app.SourceBSP, array(1))
    else
      forceName = left(array(1), len(array(1)) - 4) + ".bsp"
      ? "Forcing BSP filename."
      zStringPtr(app.SourceBSP, forceName)
    end if
  end sub

  PRIVATE SUB Init_SourceDir(Array() AS STRING)
    DIM AS STRING CopyPath = Array(1)
    CmdPathClean(CopyPath, Path_IsFolder)
    zStringPtr(app.BaseDir, CopyPath)
  END SUB

  PRIVATE SUB Init_Palette(Array() AS STRING)
    IF (RIGHT(LCASE(array(1)), 4) <> ".act") THEN array(1) += ".act"
    zStringPtr(app.PalFile, Array(1))
  END SUB
  
  PRIVATE SUB Init_LookUp(Array() AS STRING)
    IF (RIGHT(LCASE(array(1)), 4) <> ".dat") THEN array(1) += ".dat"
    zStringPtr(app.lkpFile, Array(1))
  END SUB
  
  PRIVATE SUB Init_AlphaSet(Array() AS STRING)
    app.AlphaVal = val(Array(1))
  END SUB
  
  PRIVATE SUB PathList(Out_List() AS STRING)
    DIM   AS  INTEGER  Flag_DoItAgain  = 0
    DIM   AS  INTEGER  Folder_Current  = 0
    DIM   AS  INTEGER  k               = ANY
    DIM   AS   STRING  Folder_Found    = ""
    REDIM AS   STRING  Folder_List(0)
    DIM   AS   STRING  File_Found      = ""
    REDIM              Out_List(0)
    PRINT "Searching for files in sub folders..."
    ' Get folders and sub folders
    DO
      Folder_Found = DIR(*app.BaseDir + Folder_List(Folder_Current) + "*", 16)
      DO
        IF ((Folder_Found <> ".") AND (Folder_Found <> "..") AND (Folder_Found <> "")) THEN
          REDIM PRESERVE Folder_List(0 TO UBOUND(Folder_List) + 1)
          Folder_List(UBOUND(Folder_List)) = Folder_List(Folder_Current) + Folder_Found
          CmdPathClean(Folder_List(UBOUND(Folder_List)), Path_IsFolder)
        END IF
        Folder_Found = DIR()
      LOOP WHILE LEN(Folder_Found)
      Folder_Current += 1
    LOOP WHILE (Folder_Current <= UBOUND(Folder_List))
    
    ' Sort folders
    IF (UBOUND(Folder_List) > 1) THEN
      DO
        Flag_DoItAgain = 0
        FOR k = 1 TO UBOUND(Folder_List) - 1
          IF (LCASE(Folder_List(k)) > LCASE(Folder_List(k + 1))) THEN
            SWAP Folder_List(k), Folder_List(k + 1)
            Flag_DoItAgain = 1
          END IF
        NEXT k
      LOOP WHILE Flag_DoItAgain
    END IF
    
    ' Get files
    FOR k = 0 TO UBOUND(Folder_List)
      File_Found = DIR(*app.BaseDir + Folder_List(k) + "*", &h23)
      DO
        IF LEN(File_Found) THEN
          DIM AS STRING Form =  RIGHT(LCASE(File_Found), LEN(File_Found) - INSTRREV(File_Found, "."))
          IF INSTR(*app.Mask, "*" + Form + "*") THEN
            IF (Out_List(0) = "") THEN
              Out_List(0) = Folder_List(k) + File_Found
            ELSE
              REDIM PRESERVE Out_List(0 TO UBOUND(Out_List) + 1)
              Out_List(UBOUND(Out_List)) = Folder_List(k) + File_Found
            END IF
          END IF
          File_Found = DIR()
        END IF
      LOOP WHILE LEN(File_Found)
    NEXT k
    ERASE Folder_List
  END SUB
  
  PRIVATE FUNCTION Main() AS INTEGER
    REDIM AS STRING   Files(0)
    DIM   AS STRING   Result
    DIM   AS STRING   outFile
    DIM   AS color_t  ColorMap
    DIM   AS image_t  Texture
    DIM   AS UINTEGER i = ANY
    DIM   AS DOUBLE   Chrono = ANY

    '' DEFAULT
    app.Settings      = 0
    app.LastError     = 0
    app.AlphaVal      = 0
    zStringPtr(app.Mask, "*tga*bmp*gif*pcx*png*jpg*jpeg*")

    cmdAppName = COMMAND(0)
    cmdAppNote = "For more information, please see the readme file."
    cmdOptionSet  ("-Help",           0,                            "0",                          "Show usage sheet")
    cmdOptionSet	("-Replace",			  @App.Settings,							  STR(Opt_AlwaysReplaceFiles),  "Always overwrite existing files")
    cmdOptionSet	("-SKip",   			  @App.Settings,							  STR(Opt_NeverReplaceFiles),   "Never overwrite existing files")
    cmdOptionSet	("-SubFolders",		  @App.Settings,							  STR(Opt_SearchSubFolders),    "Also parse sub folders")
    cmdOptionSet	("-NoCheck",		    @App.Settings,							  STR(Opt_IgnoreSizeCheck),     "Do not check texture dimensions")
    cmdOptionSet	("-Set16",    	    @App.Settings, 		            STR(Opt_LookUp16),            "Use 16-bit conversion instead of 24")
    cmdOptionSet	("-SetAlpha", 	    PROCPTR(Init_AlphaSet), 		  "VAL:Threshold",              "Alpha transparency threshold")
    cmdOptionSet	("-LookUp", 	      PROCPTR(Init_LookUp),   		  "DAT:File",                   "Color conversion table")
    cmdOptionSet	("-PALette",        PROCPTR(Init_Palette),	      "PAL:File",                   ".ACT palette file (required)")
    cmdOptionSet  ("-Folder",         PROCPTR(Init_SourceDir),      "DIR:Path",                   "Source directory")
    cmdOptionSet  ("-Source",         PROCPTR(Init_SourceBSP),      "BSP:File",                   "Source .BSP")

    PRINT STRING(LOWORD(WIDTH), 196);
    PRINT Center ("Image to Quake II Wall    Version 0.5b    2018 by ACC")
		PRINT Center ("YOU MAY DISTRIBUTE THIS PROGRAM FREE OF CHARGE.")
    PRINT Center ("One hundred bucks to whoever recognize the layout I'm shamelessly ripping off.")
    PRINT STRING(LOWORD(WIDTH), 196)

    IF (cmdOptionRead(0) = 0) THEN
      IF (*app.baseDir = "") THEN
        zStringPtr(app.BaseDir, "./")
      END IF
      app.LastError = colormap.loadFile(*app.palFile)
      IF (app.LastError = 1) THEN
        PRINT "Palette file not found or unspecified"
      ELSEIF (app.LastError = 2) THEN
        PRINT "No handle available"
      ELSEIF (app.LastError = 3) THEN
        PRINT "I/O error"
      ELSEIF (app.LastError = 4) THEN
        PRINT "Specified palette is not an .ACT file"
      ELSE
        Chrono = TIMER
        IF (*app.LkpFile <> "") then
          app.LastError = colormap.initLookup(*app.LkpFile)
        end if
        '' parse from BSP
        if (app.sourceBSP) then
          dim as    bspFile_t     bsp
          dim as      integer     lastErr = any
          dim as bspTexInfo_t ptr texInfo = any
          dim as     uinteger     numTexInfo = any

          lastErr = bsp.loadFrom(*app.sourceBSP)
          if lastErr then
            ? "Couldn't load " + *app.sourceBSP + " (error " + str(lasterr) + ")"
          else
            texInfo = cptr(bspTexInfo_t ptr, bsp.lump[5].buffer)
            numTexInfo = bsp.lump[5].length / sizeof(typeof(*texInfo))
            for i as integer = 0 to numTexInfo - 1
              dim as integer register = 1
              Files(0) = *app.BaseDir + trim(texInfo[i].texture_name) + ".tga"
              ' check if this entry is already in
              if (ubound(Files)) then
                for j as integer = 1 to ubound(Files)
                  if (Files(j) = Files(0)) then register = 0: exit for
                next j
              end if
              ' add to register if needed
              if (register) then
                redim preserve Files(0 to ubound(Files) + 1)
                Files(ubound(Files)) = Files(0)
              end if
            next i
            App.Settings OR= Opt_ForceBSPList
          end if
          bsp.destroy()
        end if
        
        '' parse directories, only if no BSP file was found or used
        if ((App.Settings AND Opt_ForceBSPList) = 0) then
          IF (App.Settings AND Opt_SearchSubFolders) THEN
            PathList(Files())
          ELSE
            Files(0) = DIR(*app.BaseDir + "/*.*", &h23)
            DO
              IF INSTR(*app.mask, "*" + LCASE(RIGHT(Files(0), LEN(Files(0)) - INSTRREV(Files(0), "."))) + "*") THEN
                REDIM PRESERVE Files(0 TO UBOUND(Files) + 1)
                Files(UBOUND(Files)) = *app.BaseDir + Files(0)
              END IF
              Files(0) = DIR()
            LOOP WHILE LEN(Files(0))
          END IF
        END IF

        IF (UBOUND(Files) = 0) THEN
          PRINT "No image found"
          app.LastError = 5
        ELSE
          FOR i = 1 TO UBOUND(Files)
            IF (texture.loadFile(Files(i)) = 1) THEN
              PRINT Files(i) + ": unable to read!"
            ELSE
              outFile = LEFT(Files(i), INSTRREV(Files(i), ".")) + "wal"
              IF ((texture.length < 16) OR (texture.height < 16)) THEN
                PRINT Files(i) + ": image too small!"
              ELSE
                IF (((isPoT(texture.length) = 0) OR (isPoT(texture.height) = 0)) ANDALSO (app.Settings AND Opt_IgnoreSizeCheck)) THEN
                  PRINT Files(i) + ": image dimensions not a power of two!"
                ELSE
                  IF CmdOverwrite(outFile, @app.settings, Opt_AlwaysReplaceFiles, Opt_NeverReplaceFiles) THEN texture.saveWal(outFile, @colormap)
                END IF
              END IF
            END IF
            texture.destroy()
          NEXT i
          cmdStringTime(TIMER - Chrono, Result)
          PRINT "Converted " + STR(UBOUND(Files)) + " file(s) in " + Result
        END IF
      END IF
    END IF

    ERASE(Files)
    FreeMem(app.baseDir)
    FreeMem(app.sourceBSP)
    FreeMem(app.Mask)
    FreeMem(app.PalFile)
    ColorMap.destroy()
    RETURN app.LastError
  END FUNCTION









