    declare sub       RewriteMD2    (filename as string)
    declare SUB       ShowUsage     ()
    declare SUB       CPrint        (text AS STRING)
    declare SUB       vprint        (text AS STRING)
    declare function  Overwrite     (filename as string) as ubyte
    declare function  ReplaceString (Source as string, Find as string, Replace as string) as string
    declare function  AutoAddReturns(text as string) as string    
    declare function  FUNC_STRTRIM  (StringLump as string) as string
    
  ' Setting variables...
  '-----------------------------------------------------------------------------
    'tool vars
    dim shared as ubyte   TEMP_ToolFlag, TEMP_CurrentCommand=1
    dim shared as string  TEMP_Com, TEMP_SourceFileName, TEMP_DestinationFileName
    dim shared as ubyte   F_VERBOSE=1, F_OVERWRITE=2

  ' Display title...
  '-----------------------------------------------------------------------------
    CPRINT STRING$(78,CHR$(196))
    CPRINT "MD2RESKIN v.1"
    CPRINT "Programmed by Alias Conrad Coldwood (BUILD "+__DATE__+")"
    CPRINT STRING$(78,CHR$(196))

  ' Let's check parameters...
  '-----------------------------------------------------------------------------
    DO
      TEMP_Com = LTRIM$(RTRIM$(LCASE$(COMMAND$(TEMP_CurrentCommand))))
      IF TEMP_Com = "" THEN ShowUsage:END
      IF (TEMP_Com = "-h") OR (TEMP_Com = "-help") THEN
        ShowUsage:END
      ELSEIF ((TEMP_Com = "-v") OR (TEMP_Com = "-verbose")) AND ((TEMP_ToolFlag AND F_VERBOSE) = 0) THEN
        TEMP_ToolFlag += F_VERBOSE: vprint "OPTION: Detail is ON."
      ELSEIF ((TEMP_Com = "-r") OR (TEMP_Com = "-replace")) AND ((TEMP_ToolFlag AND F_OVERWRITE) = 0) THEN
        TEMP_ToolFlag += F_OVERWRITE: vprint "OPTION: Always replace existing files."
      ELSE
        IF LEFT$(TEMP_Com,1) = "-" THEN
          PRINT "WARNING: Option unknown "+CHR$(34)+TEMP_Com+CHR$(34)
        ELSE
          dim as string FFormat
          if instr(TEMP_COm, ".") then
            FFormat = lcase$(right$(TEMP_Com, len(TEMP_Com)-instr(TEMP_Com,".")+1))
          else
            FFormat = ".md2": TEMP_Com +=".md2"
          end if
          TEMP_SourceFileName = TEMP_Com
          if dir$(TEMP_SourceFileName) = "" then print "ERROR: "+TEMP_SourceFileName+" not found!":end
        END IF
      END IF
      TEMP_CurrentCommand += 1
    LOOP WHILE COMMAND$(TEMP_CurrentCommand) <> ""    
    
    ' Okay, let's do this...
    '---------------------------------------------------------------------------
    if TEMP_SourceFileName = "" then print "ERROR: No input file!":end
    dim as string FFormat: FFormat = lcase$(right$(TEMP_SourceFileName, len(TEMP_SourceFileName)-instr(TEMP_SourceFileName,".")+1))    
    RewriteMD2(TEMP_SourceFileName)
        
        ' CENTER PRINT
        '-----------------------------------------------------------------------
        SUB CPrint (text AS STRING)
          LOCATE ,40-(LEN(text)\2):PRINT text
        END SUB  
      
        ' VERBOSE DISPLAY
        '-----------------------------------------------------------------------
        SUB vprint (text AS STRING)
          IF (TEMP_ToolFlag AND F_VERBOSE) THEN PRINT "  "+text
        END SUB
        
        ' OVERWRITE FILE?
        '-----------------------------------------------------------------------
        function Overwrite(filename as string) as ubyte
          dim as string UserEntry
          Overwrite = 0 'set default value (do NOT replace)
          if dir$(Filename) = "" then overwrite = 1:exit function 'no file found
          if (TEMP_ToolFlag and F_OVERWRITE) then kill filename: Overwrite = 1:exit function 'file found, but replace flag is on
          print Filename+" already exists, replace? [Y/N]" 'file found, but replace flag is off
          do: UserEntry = lcase$(inkey$): loop until (UserEntry="y") or (UserEntry="n")
          if UserEntry = "y" then Overwrite = 1: kill filename
        end function
        
        ' USAGE
        '-----------------------------------------------------------------------
        SUB ShowUsage ()
          PRINT "Usage:  MD2RESKIN filename[.MD2] [commands]"
          PRINT "   -h (-help)          Display usage"
          print "   -v (-verbose)       Display details"
          print "   -r (-replace)       Always replace existing files"
          PRINT: PRINT "Modify DM2's skins"
        END SUB
      
        ' Replace all "Find" occurences in "Source" with "Replace"
        '-----------------------------------------------------------------------
        function ReplaceString(Source as string, Find as string, Replace as string) as string
          if instr(Source, Find) = 0 then return Source
          dim as string BaseStr
          do
            BaseStr = left$(Source,instr(Source,Find)-1)
            Source = BaseStr + Replace + right$(Source,len(Source)-instr(Source,Find)+1-len(Find))
          loop while instr(Source, Find)
          return Source
        end function

        'Add a return sign every 26 bytes
        '-----------------------------------------------------------------------
        function AutoAddReturns(text as string) as string
          dim as ushort LastSpace, ParsedChars
          for k as ushort = 1 to len(text)
            ParsedChars += 1
            if mid$(text,k,1) = " " then lastSpace = k
            if ParsedChars = 26 then
              ParsedChars = 0: k = lastSpace+1
              text = left$(text,LastSpace-1)+"\n"+right$(text,len(text)-LastSpace)
            end if
          next k
          return text
        end function
        
        ' Clean that string!
        ' ----------------------------------------------------------------------
        function FUNC_STRTRIM (StringLump as string) as string
          dim as string * 1 TmpStr1, TmpStr2: dim as string TempStr
          dim as ushort i
          'if instr(StringLump, "//") then StringLump = left$(StringLump, instr(StringLump, "//")-1)   ' check for comments marked with "//" and remove everything beyond
          for i = 1 to len(StringLump)    ' replace tab signs and multiple spaces with single space
            TmpStr1 = mid$(StringLump, i,1)
            if TmpStr1 = chr$(9) then TmpStr1 = chr$(32)
            if (TmpStr1 = chr$(32)) and (TmpStr2 = chr$(32)) then TmpStr1 = chr$(0) else TmpStr2 = TmpStr1
            TempStr += tmpSTR1
          next i
          return rtrim$(ltrim$(TempStr))  ' standard left and right triming, and return result
        end function
        
        ' REWRITE MD2
        ' ----------------------------------------------------------------------        
        sub RewriteMD2 (filename as string)
          dim as ushort ff =  freefile
          dim as string*4   Signature
          dim as string*64  SkinFilename
          dim as uinteger   SkinBPP, SkinLength, SkinHeight, SkinTotal, SkinFilenameOffset
          dim as uinteger   Something1, MdlVerticles, MdlTexCoords, MdlTris, MdlGLCmds, MdlFrames
          vprint "Opening "+str$(filename)
          open filename for binary as #ff
            get #ff,, Signature
            if Signature <> "IDP2" then close #ff:print "Format is not IDP2":exit sub
            get #ff,, SkinBPP     
            get #ff,, SkinLength
            get #ff,, SkinHeight: vprint "SKIN: "+str$(SkiNlength)+"x"+str$(SkinHEight)+"x"+str$(SkinBPP)
            get #ff,, Something1 
            get #ff,, SkinTotal: vprint "TOTAL OF SKINS: "+str$(SkinTotal)
            if SkinTotal = 0 then close #ff:print "There's no skins bound to this model":exit sub
            get #ff,, MdlVerticles: vprint "MODEL INFOS:":vprint "Verticles: "+str$(MdlVerticles)
            get #ff,, MdlTexCoords:vprint "TextCoords: "+str$(MdlTexCoords)
            get #ff,, MdlTris     :vprint "Triangles: "+str$(MdlTris)
            get #ff,, MdlGLCmds   :vprint "GLCommands: "+str$(MdlGLCmds)
            get #ff,, MdlFrames   :vprint "Frames: "+str$(MdlFrames)
            get #ff,, SkinFilenameOffset 'Skin directory offset
            seek #ff, SkinFileNameOffset+1
            dim as string*64 Newfilename(1 to SkinTotal)
            for i as uinteger = 1 to SkinTotal  'if there's no SkinTotal, we wouldn't be there
              get #ff,, SkinFilename
              print "Skin["+str$(i)+"] basedir relative filename:"
              print "  "+str$(SkinFileName)
              input "New filename: ",Newfilename(i)
            next i
            seek #ff, SkinFileNameOffset+1
            for i as uinteger = 1 to SkinTotal  'if there's no SkinTotal, we wouldn't be there
              put #ff,, NewFilename(i)
            next i
          close #ff
        end sub
        