/************************************************************************
* Special Item code from Action converted to Axshun, had to hack much.
* There's also much new stuff...
*/
#include "g_local.h"



// time too wait between failures to respawn?
#define SPEC_RESPAWN_TIME       60
// time before they will get respawned
#define SPEC_TECH_TIMEOUT       60

char *tnames[] = {
	// silencer		//stealh slip	//kevlar	//bandolier	//laser sight
    "item_quiet", "item_slippers", "item_vest", "item_band", "item_lasersight",
    NULL
};


void SpecThink(edict_t *spec);


static edict_t *FindSpecSpawn(void)
{
	edict_t *spot = NULL;
	int i = rand() % 16;

	while (i--)
		spot = G_Find (spot, FOFS(classname), "info_player_deathmatch");
	if (!spot)
		spot = G_Find (spot, FOFS(classname), "info_player_deathmatch");

	if (spot == NULL)
	{
		/* FB  6/24/99
		gi.dprintf("Warning: failed to find special item spawn point!\n");
		*/
	}

	return spot;
}



static void SpawnSpec(gitem_t *item, edict_t *spot)
{
	edict_t *ent;
	vec3_t  forward, right;
	vec3_t  angles;

	ent = G_Spawn();

	ent->classname = item->classname;
	ent->item = item;
	ent->spawnflags = DROPPED_ITEM;
	ent->s.effects = item->world_model_flags;
	ent->s.renderfx = RF_GLOW;
	VectorSet (ent->mins, -15, -15, -15);
	VectorSet (ent->maxs, 15, 15, 15);
		// zucc dumb hack to make laser look like it is on the ground
	if (stricmp(item->pickup_name, LASER_NAME) == 0)                  
	{
		VectorSet (ent->mins, -15, -15, -1);
		VectorSet (ent->maxs, 15, 15, 1);
	}
	gi.setmodel (ent, ent->item->world_model);
	ent->solid = SOLID_TRIGGER;
	ent->movetype = MOVETYPE_TOSS;  
	ent->touch = Touch_Item;
	ent->owner = ent;

	angles[0] = 0;
	angles[1] = rand() % 360;
	angles[2] = 0;

	AngleVectors (angles, forward, right, NULL);
	VectorCopy (spot->s.origin, ent->s.origin);
	ent->s.origin[2] += 16;
	VectorScale (forward, 100, ent->velocity);
	ent->velocity[2] = 300;

	ent->nextthink = level.time + SPEC_RESPAWN_TIME;
	ent->think = SpecThink;

	gi.linkentity (ent);
}

void SpawnSpecs(edict_t *ent)
{
	gitem_t *spec;
	edict_t *spot;
	int i;
	i = 0;

	while (tnames[i]) {
	if ((spec = FindItemByClassname(tnames[i])) != NULL &&
		(spot = FindSpecSpawn()) != NULL)
		SpawnSpec(spec, spot);
		i++;
	}
}


void SpecThink(edict_t *spec)
{
	edict_t *spot;

	if ((spot = FindSpecSpawn()) != NULL) {
		SpawnSpec(spec->item, spot);
		G_FreeEdict(spec);
	} else {
		spec->nextthink = level.time + SPEC_RESPAWN_TIME;
		spec->think = SpecThink;
	}
}


static void MakeTouchSpecThink (edict_t *ent)
{
	ent->touch = Touch_Item;

	if ( deathmatch->value && !teamplay->value && !allitem->value )
	{
		ent->nextthink = level.time + SPEC_RESPAWN_TIME - 1;
		ent->think = SpecThink;
	}
	else if ( teamplay->value && !allitem->value )
	{
		ent->nextthink = level.time + 60;
		ent->think = G_FreeEdict;
	}
	else // allitem->value is set
	{
		ent->nextthink = level.time + 1;
		ent->think = G_FreeEdict;
	}
}




void Drop_Spec(edict_t *ent, gitem_t *item)
{
	edict_t *spec;

	spec = Drop_Item(ent, item);
	//gi.cprintf(ent, PRINT_HIGH, "Dropping special item.\n");
	spec->nextthink = level.time + 1;
	spec->think = MakeTouchSpecThink;
	//zucc this and the one below should probably be -- not = 0, if
	// a server turns on multiple item pickup.
	ent->client->pers.inventory[ITEM_INDEX(item)]--;

	if (!Q_stricmp(spec->classname, "item_band"))
	{
		if (ent->client->flashlight)
		{
			gi.cprintf(ent, PRINT_HIGH, "Flashlight disabled.\n");
			ent->client->flashlight = 0;
		}
	}
}

void DeadDropSpec(edict_t *ent)
{
	gitem_t *spec;
	edict_t *dropped;
	int i;

	i = 0;
	while (tnames[i]) {
		if ((spec = FindItemByClassname(tnames[i])) != NULL &&
		ent->client->pers.inventory[ITEM_INDEX(spec)]) {
			dropped = Drop_Item(ent, spec);
			// hack the velocity to make it bounce random
			dropped->velocity[0] = (rand() % 600) - 300;
			dropped->velocity[1] = (rand() % 600) - 300;
			dropped->nextthink = level.time + 1;
			dropped->think = MakeTouchSpecThink;
			dropped->owner = NULL;
			ent->client->pers.inventory[ITEM_INDEX(spec)] = 0;
		}
		i++;
	}
}


// frees the passed edict!
void RespawnSpec(edict_t *ent)
{
    edict_t *spot;

    if ((spot = FindSpecSpawn()) != NULL)
        SpawnSpec(ent->item, spot);
    G_FreeEdict(ent);
}

void SetupSpecSpawn(void);

void SetupSpecSpawn(void)
{
    edict_t *ent;

    if (level.specspawn)
		return;

    //gi.bprintf (PRINT_HIGH, "got into the setup\n");

    ent = G_Spawn();
    ent->nextthink = level.time + 4;
    ent->think = SpawnSpecs;
    level.specspawn = 1;
}

/*

  new to axshun - flashlight ...
  we use the flashlight instead of the ir vision

*/

/*
Think_FlashLight
*/
void Think_LaserSight (edict_t *ent)
{
	edict_t *self = ent;

        vec3_t  start,forward,right,end;
        int laser_on = 0;
		edict_t *light;
        gitem_t *temp_item;
         vec3_t endp,offset;
        vec3_t up;
                vec3_t angles;
        trace_t tr;
                int height = 0;

                // zucc compensate for weapon ride up
            VectorAdd (self->client->v_angle, self->client->kick_angles, angles);
        AngleVectors (/*self->owner->client->v_angle*/angles, forward, right, up);
        
	if (self->client->pers.firing_style == ACTION_FIRING_CLASSIC)
			height = 8;


        VectorSet(offset,24 , 8, self->viewheight- height);
        
        P_ProjectSource (self->client, self->s.origin, offset, forward, right, start);
        VectorMA(start,8192,forward,end);
        
        PRETRACE();
        tr = gi.trace (start,NULL,NULL, end,self,CONTENTS_SOLID|CONTENTS_MONSTER|CONTENTS_DEADMONSTER);
        POSTTRACE();
        
        if (tr.fraction != 1) {
                VectorMA(tr.endpos,-4,forward,endp);
                VectorCopy(endp,tr.endpos);
        }
        
        temp_item = FindItem(LASER_NAME);
        if ( !(ent->client->pers.inventory[ITEM_INDEX(temp_item)]) )
			return;
        // zucc code to make it be used with the right weapons
        switch ( ent->client->curr_weap )
        {
			case MK23_NUM:
			case MP5_NUM:
			case M4_NUM:
			{
				laser_on = 1;
				break;
			}
			default:
			{
				laser_on = 0;
				break;
			}
        }

	// laser is on but we want it off
	if ( !laser_on ) {
		return;
	}
        
    AngleVectors (ent->client->v_angle, forward, right, NULL);
    
    VectorSet(end,100 , 0, 0);
    G_ProjectSource (ent->s.origin, end, forward, right, start);

	light = G_Spawn();
	VectorCopy ( tr.endpos, light->s.origin );
	vectoangles(tr.plane.normal,light->s.angles);

 	light->s.modelindex = gi.modelindex ("models/objects/flash/tris.mdx");
 	light->s.renderfx |= RF_FULLBRIGHT;
 	light->s.renderfx2 |= RF2_NOSHADOW;
 	light->nextthink = level.time + 0.1;
	light->think = G_FreeEdict;

	gi.linkentity (light);


}

void Think_FlashLight (edict_t *ent)
{

	trace_t tr;
	vec3_t	forward;
	vec3_t	end;
	vec3_t	mins, maxs;
	edict_t	*light;
	vec3_t	angles, origin;

	if (ent->health < 1)
		return;

	VectorCopy (ent->client->v_angle, angles);
	VectorCopy (ent->s.origin, origin);
	AngleVectors (angles, forward, NULL, NULL);
	VectorCopy (origin, end);
	VectorMA (end, 8194, forward, end);

	VectorSet (mins, -8, -8, -8 );
	VectorSet (maxs, 8, 8, 8);

	tr = gi.trace (ent->s.origin, mins, maxs, end, ent, MASK_SHOT);

	if (((tr.ent) && (tr.ent->s.renderfx2 & RF2_SURF_ALPHA)) || ((tr.contents & MASK_ALPHA))) 
	{
		vec3_t	start;
		VectorCopy (tr.endpos, start);
		VectorMA (start, 8, forward, start);
		tr = gi.trace (start, mins, maxs, end, ent, MASK_SHOT);
	}

	light = G_Spawn();
	VectorCopy ( tr.endpos, light->s.origin );

	light->s.renderfx |= RF_BEAM;
	light->s.effects |= EF_FLASHLIGHT;
	light->nextthink = level.time + 0.1;
	light->think = G_FreeEdict;
	gi.linkentity (light);


}