#include "g_local.h"

void CastSpawn (edict_t *ent, vec3_t origin, vec3_t angles);

edict_t *SelectRandomDeathmatchSpawnPointCast (void);

float	PlayersRangeFromSpot (edict_t *spot);

void Cmd_Cast_f (void);


void SP_cast_punk(edict_t *self);
void SP_cast_punkrl(edict_t *self);
void SP_cast_punkfg(edict_t *self);
void SP_cast_punkgl(edict_t *self);
void SP_cast_punkhmg(edict_t *self);
void SP_cast_punktg(edict_t *self);
void SP_cast_thug(edict_t *self);
void SP_cast_runt (edict_t *self);
void SP_cast_thug2(edict_t *self);
void SP_cast_bitch (edict_t *ent);
void SP_cast_dog (edict_t *ent);
void SP_cast_spider (edict_t *self);
void SP_eatshit(edict_t *ent);
void SP_cast_shorty (edict_t *ent);
void SP_cast_whore (edict_t *ent);
void SP_cast_bum_sit (edict_t *self);


/*
===========
CAST SPAWNING

Add Casts in DM
============
*/
/*
================
SelectRandomDeathmatchSpawnPoint

go to a random point, but NOT the two points closest
to other players
================
*/


edict_t *SelectRandomDeathmatchSpawnPointCast (void)
{
	edict_t	*spot, *spot1, *spot2;
	int		count = 0;
	int		selection;
	float	range, range1, range2;

	spot = NULL;
	range1 = range2 = 99999;
	spot1 = spot2 = NULL;

	while ((spot = G_Find (spot, FOFS(classname), "info_player_deathmatch")) != NULL)
	{
		count++;
		range = PlayersRangeFromSpot(spot);
		if (range < range1)
		{
			range1 = range;
			spot1 = spot;
		}
		else if (range < range2)
		{
			range2 = range;
			spot2 = spot;
		}
	}

	if (!count)
		return NULL;

	if (count <= 2)
	{
		spot1 = spot2 = NULL;
	}
	else
		count -= 2;

	selection = rand() % count;

	spot = NULL;
	do
	{
		spot = G_Find (spot, FOFS(classname), "info_player_deathmatch");
		if (spot == spot1 || spot == spot2)
			selection++;
	} while(selection--);

	return spot;
}





void CastSpawn (edict_t *ent, vec3_t origin, vec3_t angles)
{
	edict_t	*spot = NULL;

	spot = SelectRandomDeathmatchSpawnPointCast ();

	// find a single player start spot
	if (!spot)
	{
		while ((spot = G_Find (spot, FOFS(classname), "info_player_start")) != NULL)
		{
			if (!game.spawnpoint[0] && !spot->targetname)
				break;

			if (!game.spawnpoint[0] || !spot->targetname)
				continue;

			if (Q_stricmp(game.spawnpoint, spot->targetname) == 0)
				break;
		}

		if (!spot)
		{
			if (!game.spawnpoint[0])
			{	// there wasn't a spawnpoint without a target, so use any
				spot = G_Find (spot, FOFS(classname), "info_player_start");
			}
			if (!spot)
				gi.error ("Couldn't find spawn point %s\n", game.spawnpoint);
		}
	}

	VectorCopy (spot->s.origin, origin);
	origin[2] += 9;
	VectorCopy (spot->s.angles, angles);

	//add standard spawn shizt
	//KillBox(ent);

	gi.WriteByte (svc_muzzleflash);
	gi.WriteShort (spot-g_edicts);
	gi.WriteByte (MZ_LOGIN);
	gi.multicast (spot->s.origin, MULTICAST_PVS);

}



void Cmd_Cast_f (void)
{
	edict_t	*ent;
	char	*Cast;
//	int j;

	Cast = gi.argv(2);

//	if (!(deathmatch->value))
//	{
//		gi.cprintf (NULL, PRINT_HIGH, "Cannot spawn Casts in Coop or SP\n");
//		return;
//	}
	
//	deathmatch->value=0;

//	gi.cprintf (NULL, PRINT_HIGH, "\"%s\"\n", Cast);

	//START Cast SPAWN CODE...
	if (Q_strcasecmp(Cast, "cast_punk")==0)
	{
		ent = G_Spawn();
		ent->classname="cast_punk";
		CastSpawn (ent, ent->s.origin, ent->s.angles);
		VectorCopy(ent->s.origin,ent->s.old_origin);
		SP_cast_punk(ent);
		Cast="cast_punk";
		gi.cprintf (NULL, PRINT_HIGH, "Spawning %s\n", Cast);
	}
//	else if (Q_strcasecmp(Cast, "cast_punkrl")==0)
//	{
//		ent = G_Spawn();
//		ent->classname="cast_punkrl";
//		CastSpawn (ent, ent->s.origin, ent->s.angles);
//		VectorCopy(ent->s.origin,ent->s.old_origin);
//		SP_cast_punkrl(ent);
//		Cast="cast_punkrl";
//		gi.cprintf (NULL, PRINT_HIGH, "Spawning %s\n", Cast);
//	}
//	else if (Q_strcasecmp(Cast, "cast_punkfg")==0)
//	{
//		ent = G_Spawn();
//		ent->classname="cast_punkfg";
//		CastSpawn (ent, ent->s.origin, ent->s.angles);
//		VectorCopy(ent->s.origin,ent->s.old_origin);
//		SP_cast_punkfg(ent);
//		Cast="cast_punkfg";
//		gi.cprintf (NULL, PRINT_HIGH, "Spawning %s\n", Cast);
//	}

//	else if (Q_strcasecmp(Cast, "cast_spider")==0)
//	{
//		ent = G_Spawn();
//		ent->classname="cast_spider";
//		CastSpawn (ent, ent->s.origin, ent->s.angles);
//		VectorCopy(ent->s.origin,ent->s.old_origin);
//		SP_cast_spider(ent);
//		Cast="cast_spider";
//		gi.cprintf (NULL, PRINT_HIGH, "Spawning %s\n", Cast);
//	}
	
//	else if (Q_strcasecmp(Cast, "cast_punkgl")==0)
//	{
//		ent = G_Spawn();
//		ent->classname="cast_punkgl";
//		CastSpawn (ent, ent->s.origin, ent->s.angles);
//		VectorCopy(ent->s.origin,ent->s.old_origin);
//		SP_cast_punkgl(ent);
//		Cast="cast_punkgl";
//		gi.cprintf (NULL, PRINT_HIGH, "Spawning %s\n", Cast);
//	}
//	else if (Q_strcasecmp(Cast, "cast_punkhmg")==0)
//	{
//		ent = G_Spawn();
//		ent->classname="cast_punkhmg";
//		CastSpawn (ent, ent->s.origin, ent->s.angles);
//		VectorCopy(ent->s.origin,ent->s.old_origin);
//		SP_cast_punkhmg(ent);
//		Cast="cast_punkhmg";
//		gi.cprintf (NULL, PRINT_HIGH, "Spawning %s\n", Cast);
//	}
//	else if (Q_strcasecmp(Cast, "cast_punktg")==0)
//	{
//		ent = G_Spawn();
//		ent->classname="cast_punktg";
//		CastSpawn (ent, ent->s.origin, ent->s.angles);
//		VectorCopy(ent->s.origin,ent->s.old_origin);
//		SP_cast_punktg(ent);
//		Cast="cast_punktg";
//		gi.cprintf (NULL, PRINT_HIGH, "Spawning %s\n", Cast);
//	}
//	else if (Q_strcasecmp(Cast, "cast_thug")==0)
//	{
//		ent = G_Spawn();
//		ent->classname="cast_thug";
//		CastSpawn (ent, ent->s.origin, ent->s.angles);
//		VectorCopy(ent->s.origin,ent->s.old_origin);
//		SP_cast_thug(ent);
//		Cast="cast_thug";
//		gi.cprintf (NULL, PRINT_HIGH, "Spawning %s\n", Cast);
//	}
//	else if (Q_strcasecmp(Cast, "cast_bitch")==0)
//	{
//		ent = G_Spawn();
//		ent->classname="cast_bitch";
//		CastSpawn (ent, ent->s.origin, ent->s.angles);
//		VectorCopy(ent->s.origin,ent->s.old_origin);
//		SP_cast_bitch(ent);
//		Cast="cast_bitch";
//		gi.cprintf (NULL, PRINT_HIGH, "Spawning %s\n", Cast);
//	}
//	else if (Q_strcasecmp(Cast, "cast_dog")==0)
//	{
//		ent = G_Spawn();
//		ent->classname="cast_dog";
//		CastSpawn (ent, ent->s.origin, ent->s.angles);
//		VectorCopy(ent->s.origin,ent->s.old_origin);
//		SP_cast_dog(ent);
//		Cast="cast_dog";
//		gi.cprintf (NULL, PRINT_HIGH, "Spawning %s\n", Cast);
//	}
//	else if (Q_strcasecmp(Cast, "cast_runt")==0)
//	{
//		ent = G_Spawn();
//		ent->classname="cast_runt";
//		CastSpawn (ent, ent->s.origin, ent->s.angles);
//		VectorCopy(ent->s.origin,ent->s.old_origin);
//		SP_cast_runt(ent);
//		Cast="cast_runt";
//		gi.cprintf (NULL, PRINT_HIGH, "Spawning %s\n", Cast);
//	}
	
//	else if (Q_strcasecmp(Cast, "cast_bum_sit")==0)
//	{
//		ent = G_Spawn();
//		ent->classname="cast_bum_sit";
//		CastSpawn (ent, ent->s.origin, ent->s.angles);
//		VectorCopy(ent->s.origin,ent->s.old_origin);
//		SP_cast_bum_sit(ent);
//		Cast="cast_bum_sit";
//		gi.cprintf (NULL, PRINT_HIGH, "Spawning %s\n", Cast);
//	}
	
//	else if (Q_strcasecmp(Cast, "cast_shorty")==0)
//	{
//		ent = G_Spawn();
//		ent->classname="cast_shorty";
//		CastSpawn (ent, ent->s.origin, ent->s.angles);
//		VectorCopy(ent->s.origin,ent->s.old_origin);
//		SP_cast_shorty(ent);
//		Cast="cast_shorty";
//		gi.cprintf (NULL, PRINT_HIGH, "Spawning %s\n", Cast);
//	}
/*	
	else if (Q_strcasecmp(Cast, "cast_whore")==0)
	{
		ent = G_Spawn();
		ent->classname="cast_whore";
		CastSpawn (ent, ent->s.origin, ent->s.angles);
		VectorCopy(ent->s.origin,ent->s.old_origin);
		SP_cast_whore(ent);
		Cast="cast_whore";
		gi.cprintf (NULL, PRINT_HIGH, "Spawning %s\n", Cast);
	}
	
*/	
	
	
	
	
	else if ((Q_strcasecmp(Cast, "rand")==0)||
			 (Q_strcasecmp(Cast, "random")==0)||
			 (Q_strcasecmp(Cast, "")==0))
	{
		ent = G_Spawn();
		CastSpawn (ent, ent->s.origin, ent->s.angles);
		VectorCopy(ent->s.origin,ent->s.old_origin);
		if (random()>.8)
		{
			ent->classname="";
			Cast="Hover";
//			SP_Cast_hover(ent);
		}
		else if (random()>.85)
		{
			ent->classname="Cast_floater";
			Cast="Floater";
//			SP_Cast_floater(ent);
		}
		else if (random()>.85)
		{
			ent->classname="Cast_mutant";
			Cast="Mutant";
//			SP_Cast_mutant(ent);
		}
		else if (random()>.85)
		{
			ent->classname="Cast_chick";
			Cast="Chick";
//			SP_Cast_chick(ent);
		}
		else if (random()>.85)
		{
			ent->classname="Cast_soldier_ss";
			Cast="SMG Soldier";
//			SP_Cast_soldier_ss(ent);
		}
		else if (random()>.85)
		{
			ent->classname="Cast_soldier";
			Cast="Shotgun Soldier";
//			SP_Cast_soldier(ent);
		}
		else if (random()>.85)
		{
			ent->classname="Cast_soldier_light";
			Cast="Blaster Soldier";
//			SP_Cast_soldier_light(ent);
		}
		else if (random()>.85)
		{
			ent->classname="Cast_infantry";
			Cast="Infantry";
//			SP_Cast_infantry(ent);
		}
		else if (random()>.85)
		{
			ent->classname="Cast_gunner";
			Cast="Gunner";
//			SP_Cast_gunner(ent);
		}
		else
		{
			ent->classname="Cast_berserk";
			Cast="Berserk";
//			SP_Cast_berserk(ent);
		}
		gi.cprintf (NULL, PRINT_HIGH, "Spawning %s\n", Cast);
	}
	else
	{
		gi.cprintf (NULL, PRINT_HIGH, "Invalid Cast\n");
//		deathmatch->value=1;
		return;
	}
	//END Cast SPAWN CODE
	//clear spawn point

//	ent->target_ent = ent;
//	ent->CastFind = ent;
//	ent->enemy = ent;
//	ent->goalentity = ent;
//	ent->movetarget = ent;

//	deathmatch->value=1;
}
