/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	Blood Money is a product of Ernest Buffington (TheGhost) & Frank Petersen (Chief), 
//
//	This program MUST NOT be sold in ANY form. If you have paid for 
//	this product, you should contact Ernest Buffington or Frank Petersen

//
//	I, Ernest Buffington & Frank Petersen, hold no responsibility for any harm 
//  caused by the use of this source code, especially to small children and animals.
//  It is provided as-is with no implied warranty or support.
//
//  I also wish to thank and acknowledge the great work of others
//  that has helped me to develop this code.
//

//  {GT}Amber          - Design ideas and debug intervals. (My Daughter - She is great!)
//  {GT}Seb            - Design ideas and debug intervals. (My Son - He is 4 years old)
//  {GT}Krieg          - Design ideas and debug intervals. (My Son - He is the greatest)
//  {GT}PitBullet      - Design ideas and debug intervals.
//  {GT}Deeg           - Design ideas and debug intervals.
//  {GT}PsychoTaz      - Design ideas and debug intervals.
//  {GT}*Knight*       - For Model Design ideas and debug intervals.
//  {GT}SubZero        - Design ideas and debug intervals.
//  {GT}Freak          - For Model Design ideas and swapping code.
//  {GT}Sylacs         - For Model Design.
//  Chief              - For ideas and swapping code.
//  SNAP               - For ideas and swapping code.
//  TiCal              - For Model Design ideas and swapping code.
//  Scott Buffington   - Code Design. (This is my father, there is no other like my dear father)
//
//  And to all the other testers, pathers, and players and people
//  who I can't remember who the heck they were, but helped out.
//
/////////////////////////////////////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////////////////////////////////////
// This code requires g_items_placement.c file and was written so that
// folks could add positional audio sound on the fly.
//
// You can add speakers to a map level while playing in the game, you walk around in the map
// and type the word "pspeaker" and it will add a speaker at the location you are standing in.
// After you have added all the speakers you would like to have you would then type the word
// "savespeakers" and this will write all the speaker locations to a external text file. The mod
// knows what the files are for each level and will then load them each time those maps load 
// in the future.
//
// There are 33 song variables and soon will be configureable via
// a song .ini file that will reside in the speakerconfig directory.
/////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "g_local.h"

newitem_t   *newitem_head;
qboolean    erasing;
qboolean is_real;

qboolean spawnitembyclassname(vec3_t spot, char *classname, qboolean real)
{
    edict_t     *ent;
    gitem_t     *item;
    vec3_t      angles;
    newitem_t   *old_newitem_head;

	item = FindItemByClassname(classname);

    if (!item)
    {

         if (!real)
         {

	        ent = G_Spawn();
        	ent->is_real = true;

	        ent->classname=classname;

            VectorCopy (spot, ent->s.origin);
            ent->s.origin[2] += 16;
					
	        ent->item = item;
   	
	        gi.linkentity (ent);

	        ED_CallSpawn(ent);

	        gi.dprintf("Not Real -> %s at (%d,%d,%d)\n",ent->classname,(int)spot[0],(int)spot[1],(int)spot[2]);

            old_newitem_head = newitem_head;
            newitem_head = gi.TagMalloc(sizeof(newitem_t), TAG_LEVEL);
            memset(newitem_head, 0, sizeof(newitem_t));
            newitem_head->next = old_newitem_head;
            newitem_head->ent = ent;

	}
	
	return 1;
}	

	else

	{
	
	ent = G_Spawn();

    ent->classname=gi.TagMalloc(64*sizeof(char), TAG_LEVEL);
	
    if (!classname)
	{
		gi.dprintf ("ED_CallSpawn: NULL classname\n");
		return 0;
	}

//===============================================================
    if (!stricmp( ent->classname, "weapon_railgun" ))
    {
    if((convertq2weapons == 1) && (railgun == 1))
    ent->classname = G_CopyString( "weapon_heavymachinegun" );
    }
//===============================================================
    if (!stricmp( ent->classname, "ammo_slugs" ))
    {
    if(convertq2weapons == 1)
    ent->classname = G_CopyString( "ammo_308" );
    }
//===============================================================
    if (!stricmp( ent->classname, "weapon_chaingun" ))
    {
    if((convertq2weapons == 1) && (chaingun == 1))
    ent->classname = G_CopyString( "weapon_tommygun" );
    }
//===============================================================
    if (!stricmp( ent->classname, "weapon_supershotgun" ))
    {
    if((convertq2weapons == 1) && (supershotgun == 1))
    ent->classname = G_CopyString( "weapon_shotgun" );
    }

	//===============================================================
    if (!stricmp( ent->classname, "weapon_hyperblaster" ))
    {
    if((convertq2weapons == 1) && (hyperblaster == 1))
    ent->classname = G_CopyString( "weapon_flamethrower" );
    }
//===============================================================
    if (!stricmp( ent->classname, "ammo_cells" ))
    {
    if(convertq2weapons == 1)
    ent->classname = G_CopyString( "ammo_flametank" );
    }
//===============================================================
    if (!stricmp( ent->classname, "weapon_machinegun" ))
    {
    if((convertq2weapons == 1) && (machinegun == 1))
    ent->classname = G_CopyString( "weapon_tommygun" );
    }
//===============================================================


//****************************************************************
//================================================================
    if ((tommygun != 1) || (gamemode->value == 9))
    {
    	if (!Q_stricmp(classname, "weapon_tommygun" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
	    }
    }
//===============================================================
    if ((heavymachinegun != 1)  || (gamemode->value == 9))
    {
    	if (!Q_stricmp(classname, "weapon_heavymachinegun" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
        }
    	if (!Q_stricmp(classname, "ammo_308" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
        }
    }
//================================================================
   if ((railgun != 1)  || (gamemode->value == 9))
   {
    	if (!Q_stricmp(classname, "weapon_railgun" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}
    	if (!Q_stricmp(classname, "ammo_slugs" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}
   }
//================================================================
   if ((bfg != 1)  || (gamemode->value == 9))
   {
    	if (!Q_stricmp(classname, "weapon_bfg" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}
   }
//================================================================
   if ((machinegun != 1)  || (gamemode->value == 9))
   {
    	if (!Q_stricmp(classname, "weapon_machinegun" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}
   }
//================================================================
   if ( (supershotgun != 1) && (shotgun != 1)  || (gamemode->value == 9)) 
   {
    	if (!Q_stricmp(classname, "ammo_shells" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
        }

   }
//=================================================================
   if ((supershotgun != 1)  || (gamemode->value == 9))
   {
    	if (!Q_stricmp(classname, "weapon_supershotgun" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
        }
   }
//=================================================================
   if ( (chaingun != 1) && (tommygun != 1)  || (gamemode->value == 9) )
   {
    	if (!Q_stricmp(classname, "ammo_cylinder" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}
   }
//=================================================================
   if ((chaingun != 1)  || (gamemode->value == 9))
   {
    	if (!Q_stricmp(classname, "weapon_chaingun" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
     	}
   }
//=================================================================
   if ( (hyperblaster != 1) && (bfg != 1)  || (gamemode->value == 9) )
   {
    	if (!Q_stricmp(classname, "ammo_cells" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}
   }
//=================================================================
   if ((hyperblaster != 1)  || (gamemode->value == 9))
   {
    	if (!Q_stricmp(classname, "weapon_hyperblaster" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}
   }
//==================================================================
   if ((grenadelauncher != 1)  || (gamemode->value == 9))
   {
    	if (!Q_stricmp(classname, "weapon_grenadelauncher" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
        }
    	if (!Q_stricmp(classname, "ammo_grenades" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
        }

   }
//===================================================================
   if ((shard != 1)  || (gamemode->value == 9))
   {
    	if (!Q_stricmp(classname, "item_armor_shard" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
        }
   }
//====================================================================
   if ((combatarmor != 1)  || (gamemode->value == 9))
   {
    	if (!Q_stricmp(classname, "item_armor_combat" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
        }
   }
//====================================================================
   if ((bodyarmor != 1)  || (gamemode->value == 9))
   {
    	if (!Q_stricmp(classname, "item_armor_body" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
        }
   }
//====================================================================
   if ((bazooka != 1)  || (gamemode->value == 9))
   {
    	if (!Q_stricmp(classname, "weapon_bazooka" ))
        {
    	gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
        }
    	if (!Q_stricmp(classname, "ammo_rockets" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
        }
   }
//=====================================================================
   if ((flamethrower != 1)  || (gamemode->value == 9))
   {
    	if (!Q_stricmp(classname, "weapon_flamethrower" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
        }
    	if (!Q_stricmp(classname, "ammo_flametank" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
        }
}
//======================================================================
    if ((crowbar != 1)  || (gamemode->value == 9))
    {
	    if (!Q_stricmp(classname, "weapon_crowbar" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}
    }
//======================================================================
    if ( (pistol != 1) && (machinegun != 1)  || (gamemode->value == 9) )
    {
    	if (!Q_stricmp(classname, "ammo_bullets" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}

    }
//======================================================================
    if ((pistol != 1)  || (gamemode->value == 9))
    {
    	if (!Q_stricmp(classname, "weapon_pistol" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}
    }
//======================================================================
    if ((shotgun != 1)  || (gamemode->value == 9))
    {
	    if (!Q_stricmp(classname, "weapon_shotgun" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}
    }

    if (gamemode->value == 9)
	{
	    if (!Q_stricmp(classname, "item_health_lg" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}

	    if (!Q_stricmp(classname, "item_health_sm" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}

	    if (!Q_stricmp(classname, "item_health" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}

	    if (!Q_stricmp(classname, "item_health_large" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}


	    if (!Q_stricmp(classname, "item_health_small" ))
        {
		gi.dprintf("Removing %s from Kingpin!\n",classname);
		sprintf(classname, "dm_G_Free" );
    	}

	}              
//======================================================================
	strcpy(ent->classname,classname);

	ent->item = item;
	 
	 if (real)
    {
        ent->s.effects = ent->item->world_model_flags;
        ent->s.renderfx = RF_GLOW;
        ent->touch = Touch_Item;
    }
    else
    {
        ent->s.effects = ent->item->world_model_flags|EF_COLOR_SHELL;
        ent->s.renderfx = RF_GLOW|RF_SHELL_RED;
        ent->touch = Touch_NewItem;
    }
    
	
	VectorSet (ent->mins, -15, -15, -15);
    VectorSet (ent->maxs, 15, 15, 15);

    gi.setmodel (ent, ent->item->world_model);

    ent->solid = SOLID_TRIGGER;

    if (!strcmp(ent->classname, "dm_cashspawn"))
    ent->movetype = MOVETYPE_NONE;
    else
    ent->movetype = MOVETYPE_BOUNCE;  
    ent->owner = ent;
    
    angles[0] = 0;
    angles[1] = rand() % 360;
    angles[2] = 0;
    
    VectorCopy (spot, ent->s.origin);

    ent->s.origin[2] += 16;

    gi.linkentity (ent);

    if (!strcmp(ent->classname, "dm_G_Free"))
    G_FreeEdict(ent);


    if (!real)
    {
        old_newitem_head = newitem_head;
        newitem_head = gi.TagMalloc(sizeof(newitem_t), TAG_LEVEL);
        memset(newitem_head, 0, sizeof(newitem_t));
        newitem_head->next = old_newitem_head;
        newitem_head->ent = ent;
    }

    return 1;

	}
}


void Cmd_Clearitems_f(edict_t *ent)
{
    newitem_t   *old_newitem_head;
    
    if (newitem_head)
    {
        while (newitem_head)
        {
            G_FreeEdict(newitem_head->ent);
            old_newitem_head=newitem_head;
            newitem_head=newitem_head->next;
            gi.TagFree(old_newitem_head);
        }
        
        safe_cprintf(ent, PRINT_HIGH, "All new item data cleared\n");
    }
    else
    {
        safe_cprintf(ent, PRINT_HIGH, "There is no new item data stored\n");
    }
}


void Cmd_Undoitem_f(edict_t *ent)
{
    newitem_t   *old_newitem_head;
    
    if (newitem_head)
    {
        safe_cprintf(ent, PRINT_HIGH, "%s was removed\n",newitem_head->ent->classname);
        G_FreeEdict(newitem_head->ent);
        old_newitem_head=newitem_head;
        newitem_head=newitem_head->next;
        gi.TagFree(old_newitem_head);
    }
    else
    {
        safe_cprintf(ent, PRINT_HIGH, "There is no new item data stored\n");
    }
}


void Touch_NewItem(edict_t *ent, edict_t *other, cplane_t *plane, csurface_t *surf)
{
    newitem_t   *old_newitem_head;
    newitem_t   *old_old_newitem_head;
    
    if (!erasing)
        return;

    if (!other->client)
        return;

    if (other->health<=0)
        return;

    // flash the screen
    other->client->bonus_alpha = 0.25;  
    
    old_newitem_head=newitem_head;
    old_old_newitem_head=old_newitem_head;
    
    while (old_newitem_head)
    {
        if (old_newitem_head->ent==ent)
        {
            if (old_newitem_head==newitem_head)
                newitem_head=newitem_head->next;
            
            old_old_newitem_head->next=old_newitem_head->next;
            
            safe_cprintf(other, PRINT_HIGH, "%s was removed\n",old_newitem_head->ent->classname);
            G_FreeEdict(old_newitem_head->ent);
            gi.TagFree(old_newitem_head);
            return;
        }
        else
        {
            old_old_newitem_head=old_newitem_head;
            old_newitem_head=old_newitem_head->next;
        }
    }
}


void Cmd_Listitems_f(edict_t *ent)
{
    newitem_t   *other_newitem_head;
    
    if (newitem_head)
    {
        safe_cprintf(ent, PRINT_HIGH, "New item list, starting with the most recent...\n");
        
        other_newitem_head=newitem_head;
        
        while (other_newitem_head)
        {
            safe_cprintf(ent, PRINT_HIGH, "(%d,%d,%d): %s\n",(int)other_newitem_head->ent->s.origin[0],(int)other_newitem_head->ent->s.origin[1],(int)other_newitem_head->ent->s.origin[2],other_newitem_head->ent->classname);
            other_newitem_head=other_newitem_head->next;
        }
        
    }
    else
    {
        safe_cprintf(ent, PRINT_HIGH, "There is no new item data stored\n");
    }
}

void Cmd_Saveitems_f(edict_t *ent)
{
    safe_cprintf(ent, PRINT_HIGH, "Saving new item data for this level... ");
    if (saveitemdata(ent))
        safe_cprintf(ent, PRINT_HIGH, "OK\n");
    else
        safe_cprintf(ent, PRINT_HIGH, "ERROR! No new items?\n");
}



qboolean saveitemdata(edict_t *ent)
{
    FILE        *fp;
    int         i;
    char        filename[256];
    cvar_t      *game_dir,*mapname;
    newitem_t   *other_newitem_head;

    game_dir = gi.cvar ("game", "", 0);
    mapname = gi.cvar ("mapname", "", 0);

#ifdef  _WIN32
    i =  sprintf(filename, ".\\");
    i += sprintf(filename + i, game_dir->string);
    i += sprintf(filename + i, "\\mapconfig\\");
    i += sprintf(filename + i, level.mapname);
    i += sprintf(filename + i, ".ent"); // change .ent to the file extension you want
#else
    strcpy(filename, "./");
    strcat(filename, game_dir->string);
    strcat(filename, "/mapconfig/");
    strcat(filename, level.mapname);
    strcat(filename, ".ent"); // change .ent to the file extension you want
#endif

    if (!newitem_head)
    {
        if (fp = fopen (filename, "rt")) // checks to see if the file exists
        {
	    fclose(fp);
            safe_cprintf(ent,PRINT_HIGH,"ERASING NEW ITEMS DATA... ");
            if (remove(filename)==0)
                return 1;
        }
        
        return 0;
    }

    fp = fopen (filename, "wt");
    if (!fp)
        return 0;
    
    fprintf(fp,"# ADDED ITEMS DATA FILE\n");
    fprintf(fp,"# Warning: Modifying this file may cause errors in the game\n");
    fprintf(fp,"\n");
    fprintf(fp,"[ItemData]\n");
    
    // Surf the linked list :)
    other_newitem_head=newitem_head;

    while (other_newitem_head)
    {
        fprintf(fp,"%d %d %d %s\n",(int)other_newitem_head->ent->s.origin[0],(int)other_newitem_head->ent->s.origin[1],(int)other_newitem_head->ent->s.origin[2],other_newitem_head->ent->classname);
        other_newitem_head=other_newitem_head->next;
    }

    fclose(fp);
    
    return 1;

}

int GetLineFromFile(FILE *in, char s[])
{
	int i, c;

	// This reads characters from in into s until MAX_LINE_SIZE-1 is reached,
	// a newline character is reached, or an EOF is reached.
	for (i = 0; i < 254 && (c = fgetc(in)) != '\n' && c != EOF; i++)
		s[i] = c;
	// Add a '\0' to the end of s
	s[i] = '\0';
	return i;
}

////////////////////////////////////////////////////////////////////////////////////////
qboolean loaditemdata(void)
{
    FILE        *fp;
    char        filename[256],classname[64],buffer[256];
    cvar_t      *game_dir;
    vec3_t      spot;
    long        line;
    int         i,a,b,c;
    qboolean    inkey=0;
    
    game_dir = gi.cvar ("game", "", 0);

    i =  sprintf(filename, ".\\");
    i += sprintf(filename + i, game_dir->string);
    i += sprintf(filename + i, "\\mapconfig\\");
    i += sprintf(filename + i, level.mapname);
    i += sprintf(filename + i, ".ent"); // change file extension here


    fp = fopen (filename, "rt");
    if (!fp){
		if (gamemode->value == 9)
	    gi.dprintf ("[%s.ent] File Not found! (No External Weapons To Remove)\n",level.mapname);
		else
	    gi.dprintf ("[%s.ent] File Not found! (No External Weapons To Load)\n",level.mapname);

        return 0;
}
    
    line=0;
    while (!feof(fp))
    {
        line++;
	GetLineFromFile(fp,buffer);        // modification in this codeblock to not use trimstring
        if (buffer[0]=='\0' || buffer[0]=='#')
            continue;
        if (!inkey)
        {
            // Search for [ItemData] key
            if (Q_stricmp(buffer,"[ItemData]")!=0)
                continue;
            inkey=1;
        }
        else
        {
            classname[0]='\0';
            sscanf(buffer,"%d %d %d %63s",&a,&b,&c,classname);
            spot[0]=(float)a;
            spot[1]=(float)b;
            spot[2]=(float)c;
                    
            if (strlen(classname)==0 || !FindItemByClassname(classname))
            {
                
				    edict_t *ent;
				
					ent = G_Spawn();

					ent->is_real = false;
                    ent->is_entload = true;

            		ent->classname=classname;

//					if (!strcmp(ent->classname, "junior"))
//                    ent->is_junior = true;

					VectorCopy (spot, ent->s.origin);
                    ent->s.origin[2] += 16;
					
                   	gi.linkentity (ent);
		
					ED_CallSpawn(ent);

                    if (CustMessage == 1)
					gi.dprintf("[Entity Creator Added -> %s] at (%d,%d,%d)\n",ent->classname,(int)spot[0],(int)spot[1],(int)spot[2]);
				
            }

            else 
				
				
				if (deathmatch->value || coop->value)
            {
					
				    spawnitembyclassname(spot,classname,1);
				    //gi.dprintf("Added %s at (%d,%d,%d)\n",classname,(int)spot[0],(int)spot[1],(int)spot[2]);
			}
		
				
             else
			 {


                spawnitembyclassname(spot,classname,0);
                //gi.dprintf("Loaded %s at (%d,%d,%d)\n",classname,(int)spot[0],(int)spot[1],(int)spot[2]);
				
				
			}
        
		}
    }

    fclose(fp);
    
    return 1;
}
////////////////////////////////////////////////////////////////////////////////////////
//THEGHOST END - 1 added for item placement on the fly

