/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	Blood Money is a product of Ernest Buffington (TheGhost) 
//  and is available over at The Scorpion Network, at http://www.und3rgr0und.com
//
//	This program MUST NOT be sold in ANY form. If you have paid for 
//	this product, you should contact Ernest Buffington
//  immediately, via The Scorpion Network Homepage http://www.und3rgr0und.com
//
//	I, Ernest Buffington, hold no responsibility for any harm 
//  caused by the use of this source code, especially to small children and animals.
//  It is provided as-is with no implied warranty or support.
/////////////////////////////////////////////////////////////////////////////////////////////////////////////
#include "g_local.h"

void removespeakers(void)
{
  
   edict_t *nix;

   nix = NULL;

   while ((nix = G_Find (nix, FOFS(classname), "target_music")) != NULL)
   {
 	nix->think = G_FreeEdict;
	nix->nextthink = level.time + 1.0;
    level.num_speakers--;
   }

}

// addition to get the data from the file without needing trimstring which was used in the original.
qboolean savespeakerdata(edict_t *ent)
{
    FILE        *fp;
    int         i;
    char        filename[256];
    cvar_t      *game_dir,*mapname;
    newitem_t   *other_newitem_head;

    game_dir = gi.cvar ("game", "", 0);
    mapname = gi.cvar ("mapname", "", 0);

#ifdef  _WIN32
    i =  sprintf(filename, ".\\");
    i += sprintf(filename + i, game_dir->string);
    i += sprintf(filename + i, "\\speakerconfig\\");
    i += sprintf(filename + i, level.mapname);
    i += sprintf(filename + i, ".ent"); // change .ent to the file extension you want
#else
    strcpy(filename, "./");
    strcat(filename, game_dir->string);
    strcat(filename, "/speakerconfig/");
    strcat(filename, level.mapname);
    strcat(filename, ".ent"); // change .ent to the file extension you want
#endif

    if (!newitem_head)
    {
        if (fp = fopen (filename, "rt")) // checks to see if the file exists
        {
	    fclose(fp);
            safe_cprintf(ent,PRINT_HIGH,"ERASING NEW ITEMS DATA... ");
            if (remove(filename)==0)
                return 1;
        }
        
        return 0;
    }

    fp = fopen (filename, "wt");
    if (!fp)
        return 0;
    
    fprintf(fp,"# ADDED SPEAKERS DATA FILE\n");
    fprintf(fp,"# Warning: Modifying this file may cause errors in the game\n");
    fprintf(fp,"\n");
    fprintf(fp,"[ItemData]\n");
    
    // Surf the linked list :)
    other_newitem_head=newitem_head;

    while (other_newitem_head)
    {
        fprintf(fp,"%d %d %d %s\n",(int)other_newitem_head->ent->s.origin[0],(int)other_newitem_head->ent->s.origin[1],(int)other_newitem_head->ent->s.origin[2],other_newitem_head->ent->classname);
        other_newitem_head=other_newitem_head->next;
    }

    fclose(fp);
    
    return 1;

}



qboolean savelevel2data(edict_t *ent)
{
    FILE        *fp;
    int         i;
    char        filename[256];
    cvar_t      *game_dir,*mapname;
    newitem_t   *other_newitem_head;

    game_dir = gi.cvar ("game", "", 0);
    mapname = gi.cvar ("mapname", "", 0);

#ifdef  _WIN32
    i =  sprintf(filename, ".\\");
    i += sprintf(filename + i, game_dir->string);
    i += sprintf(filename + i, "\\mapconfig\\level2\\");
    i += sprintf(filename + i, level.mapname);
    i += sprintf(filename + i, ".ent"); // change .ent to the file extension you want
#else
    strcpy(filename, "./");
    strcat(filename, game_dir->string);
    strcat(filename, "/mapconfig/level2/");
    strcat(filename, level.mapname);
    strcat(filename, ".ent"); // change .ent to the file extension you want
#endif

    if (!newitem_head)
    {
        if (fp = fopen (filename, "rt")) // checks to see if the file exists
        {
	    fclose(fp);
            safe_cprintf(ent,PRINT_HIGH,"ERASING NEW LEVEL 2 ITEMS DATA... ");
            if (remove(filename)==0)
                return 1;
        }
        
        return 0;
    }

    fp = fopen (filename, "wt");
    if (!fp)
        return 0;
    
    fprintf(fp,"# ADDED LEVEL 2 DATA FILE\n");
    fprintf(fp,"# Warning: Modifying this file may cause errors in the game\n");
    fprintf(fp,"\n");
    fprintf(fp,"[ItemData]\n");
    
    // Surf the linked list :)
    other_newitem_head=newitem_head;

    while (other_newitem_head)
    {
        fprintf(fp,"%d %d %d %s\n",(int)other_newitem_head->ent->s.origin[0],(int)other_newitem_head->ent->s.origin[1],(int)other_newitem_head->ent->s.origin[2],other_newitem_head->ent->classname);
        other_newitem_head=other_newitem_head->next;
    }

    fclose(fp);
    
    return 1;

}


int GetLineFromSpeakerFile(FILE *in, char s[])
{
	int i, c;

	// This reads characters from in into s until MAX_LINE_SIZE-1 is reached,
	// a newline character is reached, or an EOF is reached.
	for (i = 0; i < 254 && (c = fgetc(in)) != '\n' && c != EOF; i++)
		s[i] = c;
	// Add a '\0' to the end of s
	s[i] = '\0';
	return i;
}
// end addition


int GetLineFromLevel2File(FILE *in, char s[])
{
	int i, c;

	// This reads characters from in into s until MAX_LINE_SIZE-1 is reached,
	// a newline character is reached, or an EOF is reached.
	for (i = 0; i < 254 && (c = fgetc(in)) != '\n' && c != EOF; i++)
		s[i] = c;
	// Add a '\0' to the end of s
	s[i] = '\0';
	return i;
}


qboolean loaditemdata2(void)
{
    FILE        *fp;
    char        filename[256],classname[64],buffer[256];
    cvar_t      *game_dir;
    vec3_t      spot;
    long        line;
    int         i,a,b,c;
    qboolean    inkey=0;
    
    game_dir = gi.cvar ("game", "", 0);

    i =  sprintf(filename, ".\\");
    i += sprintf(filename + i, game_dir->string);
    i += sprintf(filename + i, "\\speakerconfig\\");
    i += sprintf(filename + i, level.mapname);
    i += sprintf(filename + i, ".ent"); // change file extension here


    fp = fopen (filename, "rt");
    if (!fp){
	gi.dprintf ("No Speaker file found\n");	
        return 0;
}
    
    line=0;
    while (!feof(fp))
    {
        line++;
	GetLineFromSpeakerFile(fp,buffer);        // modification in this codeblock to not use trimstring
        if (buffer[0]=='\0' || buffer[0]=='#')
            continue;
        if (!inkey)
        {
            // Search for [ItemData] key
            if (Q_stricmp(buffer,"[ItemData]")!=0)
                continue;
            inkey=1;
        }
        else
        {
            classname[0]='\0';
            sscanf(buffer,"%d %d %d %63s",&a,&b,&c,classname);
            spot[0]=(float)a;
            spot[1]=(float)b;
            spot[2]=(float)c;
                    
            if (strlen(classname)==0 || !FindItemByClassname(classname))
            {
                
				    edict_t *ent;
				
					ent = G_Spawn();

					ent->is_real = false;

            		ent->classname=classname;

					VectorCopy (spot, ent->s.origin);
                    ent->s.origin[2] += 16;
					
                   	gi.linkentity (ent);
   
                  	ED_CallSpawn(ent);

                    if (CustMessage == 1)
					gi.dprintf("[Speaker Creator Added -> %s] at (%d,%d,%d)\n",ent->classname,(int)spot[0],(int)spot[1],(int)spot[2]);
				
            }

            else 
				
				
				if (deathmatch->value || coop->value)
            {
					
				    spawnitembyclassname(spot,classname,1);
				    //gi.dprintf("Added %s at (%d,%d,%d)\n",classname,(int)spot[0],(int)spot[1],(int)spot[2]);
			}
		
				
             else
			 {


                spawnitembyclassname(spot,classname,0);
                //gi.dprintf("Loaded %s at (%d,%d,%d)\n",classname,(int)spot[0],(int)spot[1],(int)spot[2]);
				
				
			}
        
		}
    }

    fclose(fp);
    
    return 1;
}


qboolean loaditemdata3(void)
{
    FILE        *fp;
    char        filename[256],classname[64],buffer[256];
    cvar_t      *game_dir;
    vec3_t      spot;
    long        line;
    int         i,a,b,c;
    qboolean    inkey=0;
    
    game_dir = gi.cvar ("game", "", 0);

    i =  sprintf(filename, ".\\");
    i += sprintf(filename + i, game_dir->string);
    i += sprintf(filename + i, "\\mapconfig\\level2\\");
    i += sprintf(filename + i, level.mapname);
    i += sprintf(filename + i, ".ent"); // change file extension here


    fp = fopen (filename, "rt");
    if (!fp){
	gi.dprintf ("No Level 2 mapconfig file found\n");	
        return 0;
}
    
    line=0;
    while (!feof(fp))
    {
        line++;
	GetLineFromLevel2File(fp,buffer);        // modification in this codeblock to not use trimstring
        if (buffer[0]=='\0' || buffer[0]=='#')
            continue;
        if (!inkey)
        {
            // Search for [ItemData] key
            if (Q_stricmp(buffer,"[ItemData]")!=0)
                continue;
            inkey=1;
        }
        else
        {
            classname[0]='\0';
            sscanf(buffer,"%d %d %d %63s",&a,&b,&c,classname);
            spot[0]=(float)a;
            spot[1]=(float)b;
            spot[2]=(float)c;
                    
            if (strlen(classname)==0 || !FindItemByClassname(classname))
            {
                
				    edict_t *ent;
				
					ent = G_Spawn();

					ent->is_real = false;

            		ent->classname=classname;

					VectorCopy (spot, ent->s.origin);
                    ent->s.origin[2] += 16;
					
                   	gi.linkentity (ent);
   
                  	ED_CallSpawn(ent);

                    if (CustMessage == 1)
					gi.dprintf("[Level 2 Item Creator Added -> %s] at (%d,%d,%d)\n",ent->classname,(int)spot[0],(int)spot[1],(int)spot[2]);
				
            }

            else 
				
				
				if (deathmatch->value || coop->value)
            {
					
				    spawnitembyclassname(spot,classname,1);
				    //gi.dprintf("Added %s at (%d,%d,%d)\n",classname,(int)spot[0],(int)spot[1],(int)spot[2]);
			}
		
				
             else
			 {


                spawnitembyclassname(spot,classname,0);
                //gi.dprintf("Loaded %s at (%d,%d,%d)\n",classname,(int)spot[0],(int)spot[1],(int)spot[2]);
				
				
			}
        
		}
    }

    fclose(fp);
    
    return 1;
}


void Cmd_Savespeakers_f(edict_t *ent)
{
    safe_cprintf(ent, PRINT_HIGH, "Saving new speaker data for this level... ");
    if (savespeakerdata(ent))
        safe_cprintf(ent, PRINT_HIGH, "OK\n");
    else
        safe_cprintf(ent, PRINT_HIGH, "ERROR! No new speakers?\n");
}


void Cmd_Savelevel2data_f(edict_t *ent)
{
    safe_cprintf(ent, PRINT_HIGH, "Saving new Level 2 data for this level... ");
    if (savelevel2data(ent))
        safe_cprintf(ent, PRINT_HIGH, "OK\n");
    else
        safe_cprintf(ent, PRINT_HIGH, "ERROR! No new Level 2 data?!?\n");
}