/////////////////////////////////////////////////////////////////
// p_coop_sp.c
//
// contains spawning code for cooperative games


/////////////////////////////////////////////////////////////////
// generic KP headers
#include "g_local.h"
#include "m_player.h"


edict_t *CoopSpawnPointRewrite (edict_t *self, int number)		// self is the info_player_start entity
{
	int distance = 0;					// the distance
	int row_space = 32;

	int r_lv;							// row loop variable
	int c_lv;							// col loop variable
	int z_lv;							// this is for the Z axis loop variable

	int failures = 0;					// keeps a tally of how many failed attempts we've had
	edict_t *cspc;						// cspc translates into Coop Spawn Point Cursor
	cspc = NULL;						// set equal to null so G_Find will work

	// fixes standalone cutscenes
	gi.dprintf("\n[%s]\n", level.mapname);
	if (stricmp(level.mapname,"kpcut1")	== 0 ||
		stricmp(level.mapname,"kpcut3") == 0 ||
		stricmp(level.mapname,"kpcut4") == 0 ||
		stricmp(level.mapname,"kpcut7") == 0 ||
		stricmp(level.mapname,"idiot")	== 0 ||
		stricmp(level.mapname,"bike")	== 0 )
	{
		return self;
	}

	// if the single player spot is free use it...period
	if ( ValidBoxAtLoc( self->s.origin, tv(-16, -16, -24), tv(16, 16, 50), NULL, MASK_PLAYERSOLID|CONTENTS_MONSTERCLIP ) )
	{
		return (self);
	}

	cspc = G_Spawn();

	// row generation
	for ( r_lv=-1 ; r_lv<=1 ; r_lv++ )
	{
		cspc->classname = "info_player_coop";			// classname
		cspc->targetname = self->targetname;			// set targetname (which level it comes from)

		cspc->s.origin[0] = self->s.origin[0];
		cspc->s.origin[1] = self->s.origin[1];
		//cspc->s.origin[2] = self->s.origin[2] + 9;

		cspc->s.angles[0] = self->s.angles[0];
		cspc->s.angles[1] = self->s.angles[1];
		cspc->s.angles[2] = self->s.angles[2];

		distance = 0;

		// column generation
		for ( c_lv=0 ; c_lv<64 ; c_lv++ )
		{
			///////////////////////////////////////////////////////////////
			// Setting (X,Y) Position
			if (	(cspc->s.angles[1] >= 315) ||										// east
					((cspc->s.angles[1] <= 45) && (cspc->s.angles[1] >= -45)) )			// east
			{
				cspc->s.origin[0] = self->s.origin[0] + distance;				// X
				cspc->s.origin[1] = self->s.origin[1] - (row_space*r_lv);		// Y
			}
			if (	(cspc->s.angles[1] >= 45) && (cspc->s.angles[1] <= 135) )			// north
			{
				cspc->s.origin[0] = self->s.origin[0] + (row_space*r_lv);		// X
				cspc->s.origin[1] = self->s.origin[1] + distance;				// Y
			}
			if (	((cspc->s.angles[1] >= 135) && (cspc->s.angles[1] <= 225)) ||		// west
					((cspc->s.angles[1] >= 135) || (cspc->s.angles[1] <= -135))		)	// west
			{
				cspc->s.origin[0] = self->s.origin[0] - distance;				// X
				cspc->s.origin[1] = self->s.origin[1] + (row_space*r_lv);		// Y
			}
			if (	((cspc->s.angles[1] >= 225) && (cspc->s.angles[1] <= 315)) ||		// south
					((cspc->s.angles[1] <= -45) && (cspc->s.angles[1] >= -135))		)	// south
			{
				cspc->s.origin[0] = self->s.origin[0] - (row_space*r_lv);		// X
				cspc->s.origin[1] = self->s.origin[1] - distance;				// Y
			}
			// Setting (X,Y) Position
			///////////////////////////////////////////////////////////////


			for ( z_lv=9 ; z_lv>-42 ; z_lv--)			// now go throught some Z stuff
			{
				cspc->s.origin[2] = self->s.origin[2] + z_lv;
				// if it's a valid place for a spot return the spot
				if (	ValidBoxAtLoc( cspc->s.origin, tv(-16, -16, -24), tv(16, 16, 50), NULL, MASK_PLAYERSOLID|CONTENTS_MONSTERCLIP )	)	 
				{
					gi.dprintf( "point generated after %d tries", failures );
					return cspc;
				}
			}

			// this was a failure, if something is fucked use the debug statement below
			//gi.dprintf( "Failed To Create Coop Spawn at: %i, %i, %i...cleansing\n", (int)cspc->s.origin[0], (int)cspc->s.origin[1], (int)cspc->s.origin[2] );
			failures += 1;
			distance += 8;
		}
		gi.dprintf( "%d Row", (r_lv + 2) );
	}

	// if we get here nothing other than the single player start will do, so return that
	G_FreeEdict(cspc);						// remove this from the game now
	return self;
}










///////////////////////////////////////////////////
// DisconnectKeys (HACK)
//
// maybe eventually creates list of keys that need
// to be constantly maintained in the world by
// giving them to all new players.
void DisconnectKeys (edict_t* ent, gitem_t * item)
{
}

